/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.Resolver;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolFileReaderInterface;
import org.jmol.util.CompoundDocument;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.util.ZipUtil;

public class SmarterJmolAdapter
extends JmolAdapter {
    public static final String PATH_KEY = ".PATH";
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");

    public SmarterJmolAdapter() {
        super("SmarterJmolAdapter");
    }

    public void finish(Object object) {
        ((AtomSetCollection)object).finish();
    }

    public String[] specialLoad(String string, String string2) {
        return Resolver.specialLoad(string, string2);
    }

    public Object openBufferedReader(String string, String string2, BufferedReader bufferedReader, Hashtable hashtable) {
        return SmarterJmolAdapter.staticOpenBufferedReader(string, string2, bufferedReader, hashtable);
    }

    private static Object staticOpenBufferedReader(String string, String string2, BufferedReader bufferedReader, Hashtable hashtable) {
        try {
            Object object = Resolver.resolve(string, string2, bufferedReader, hashtable);
            if (object instanceof String) {
                return object;
            }
            if (object instanceof AtomSetCollection) {
                AtomSetCollection atomSetCollection = (AtomSetCollection)object;
                if (atomSetCollection.errorMessage != null) {
                    return atomSetCollection.errorMessage;
                }
                return atomSetCollection;
            }
            return "unknown reader error";
        }
        catch (Exception exception) {
            Logger.error(null, exception);
            bufferedReader = null;
            return "" + exception;
        }
    }

    public Object openBufferedReaders(JmolFileReaderInterface jmolFileReaderInterface, String[] stringArray, String[] stringArray2, Hashtable[] hashtableArray) {
        return SmarterJmolAdapter.staticOpenBufferedReaders(jmolFileReaderInterface, stringArray, stringArray2, hashtableArray);
    }

    private static Object staticOpenBufferedReaders(JmolFileReaderInterface jmolFileReaderInterface, String[] stringArray, String[] stringArray2, Hashtable[] hashtableArray) {
        int n = stringArray.length;
        AtomSetCollection[] atomSetCollectionArray = new AtomSetCollection[n];
        for (int i = 0; i < n; ++i) {
            try {
                BufferedReader bufferedReader = jmolFileReaderInterface.getBufferedReader(i);
                if (bufferedReader == null) {
                    return null;
                }
                Object object = Resolver.resolve(stringArray[i], stringArray2 == null ? null : stringArray2[i], bufferedReader, hashtableArray == null ? null : hashtableArray[i]);
                if (object instanceof String) {
                    return object;
                }
                if (object instanceof AtomSetCollection) {
                    atomSetCollectionArray[i] = (AtomSetCollection)object;
                    if (atomSetCollectionArray[i].errorMessage == null) continue;
                    return atomSetCollectionArray[i].errorMessage;
                }
                return "unknown reader error";
            }
            catch (Exception exception) {
                Logger.error(null, exception);
                return "" + exception;
            }
        }
        AtomSetCollection atomSetCollection = new AtomSetCollection(atomSetCollectionArray);
        if (atomSetCollection.errorMessage != null) {
            return atomSetCollection.errorMessage;
        }
        return atomSetCollection;
    }

    public Object openZipFiles(InputStream inputStream, String string, String[] stringArray, Hashtable hashtable, boolean bl) {
        return SmarterJmolAdapter.staticOpenZipFiles(inputStream, string, stringArray, hashtable, 1, bl);
    }

    private static Object staticOpenZipFiles(InputStream inputStream, String string, String[] stringArray, Hashtable hashtable, int n, boolean bl) {
        int n2;
        boolean bl2;
        boolean bl3;
        String string2;
        int n3;
        String string3;
        boolean bl4 = n == 1;
        int[] nArray = hashtable == null ? null : (int[])hashtable.get("params");
        String[] stringArray2 = hashtable == null ? null : (String[])hashtable.get("subFileList");
        String string4 = string3 = stringArray2 == null || n >= stringArray2.length ? null : stringArray2[n];
        if (string3 != null && (string3.startsWith("/") || string3.startsWith("\\"))) {
            string3 = string3.substring(1);
        }
        int n4 = n3 = nArray == null ? 1 : nArray[0];
        if (n3 > 0 && bl4 && nArray != null) {
            nArray[0] = 0;
        }
        String string5 = string2 = hashtable == null ? null : (String)hashtable.get("manifest");
        if (string2 == null) {
            string2 = stringArray.length > 0 ? stringArray[0] : "";
        }
        boolean bl5 = bl3 = string2.length() > 0;
        if (bl3) {
            if (Logger.debugging) {
                Logger.info("manifest for  " + string + ":\n" + string2);
            }
            string2 = '|' + string2.replace('\r', '|').replace('\n', '|') + '|';
        }
        boolean bl6 = string2.indexOf("IGNORE_ERRORS") >= 0;
        boolean bl7 = string2.indexOf("IGNORE_MANIFEST") >= 0;
        boolean bl8 = bl2 = string2.indexOf("EXCEPT_FILES") >= 0;
        if (bl7 || string3 != null) {
            bl3 = false;
        }
        Vector<Object> vector = new Vector<Object>();
        Hashtable<Object, Object> hashtable2 = bl3 ? new Hashtable<Object, Object>() : null;
        boolean bl9 = false;
        for (n2 = 1; n2 < stringArray.length; ++n2) {
            if (stringArray[n2].indexOf("_spartandir") < 0) continue;
            bl9 = true;
            break;
        }
        n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl9) {
            stringBuffer = new StringBuffer();
            stringBuffer.append("Zip File Directory: ").append("\n").append(Escape.escape(stringArray)).append("\n");
        }
        ZipInputStream zipInputStream = inputStream instanceof ZipInputStream ? (ZipInputStream)inputStream : new ZipInputStream(new BufferedInputStream(inputStream));
        try {
            Object object;
            Object object2;
            Object object3;
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null && (n3 <= 0 || vector.size() < n3)) {
                Object object4;
                String[] stringArray3;
                if (zipEntry.isDirectory()) continue;
                object3 = ZipUtil.getZipEntryAsBytes(zipInputStream);
                object2 = zipEntry.getName();
                if (string3 != null && !((String)object2).equals(string3) || ((String)object2).equals("JmolManifest") || bl3 && bl2 == string2.indexOf("|" + (String)object2 + "|") >= 0) continue;
                if (bl9) {
                    stringBuffer.append("\nBEGIN Zip File Entry: ").append((String)object2).append("\n");
                    stringBuffer.append(new String((byte[])object3));
                    stringBuffer.append("\nEND Zip File Entry: ").append((String)object2).append("\n");
                    stringBuffer.append(zipEntry.getName()).append("/n");
                    continue;
                }
                if (ZipUtil.isZipFile(object3)) {
                    object = new BufferedInputStream(new ByteArrayInputStream((byte[])object3));
                    stringArray3 = ZipUtil.getZipDirectoryAndClose((InputStream)object, true);
                    object = new BufferedInputStream(new ByteArrayInputStream((byte[])object3));
                    object4 = SmarterJmolAdapter.staticOpenZipFiles((InputStream)object, string + "|" + (String)object2, stringArray3, hashtable, ++n, bl);
                    if (object4 instanceof String) {
                        if (bl6) continue;
                        return object4;
                    }
                    if (object4 instanceof AtomSetCollection || object4 instanceof Vector) {
                        if (bl3 && !bl2) {
                            hashtable2.put(object2, object4);
                            continue;
                        }
                        vector.addElement(object4);
                        continue;
                    }
                    if (object4 instanceof BufferedReader) {
                        if (bl4) {
                            zipInputStream.close();
                        }
                        return object4;
                    }
                    if (bl6) continue;
                    zipInputStream.close();
                    return "unknown zip reader error";
                }
                object = CompoundDocument.isCompoundDocument(object3) ? new CompoundDocument(new BufferedInputStream(new ByteArrayInputStream((byte[])object3))).getAllData().toString() : new String((byte[])object3);
                stringArray3 = new BufferedReader(new StringReader((String)object));
                if (bl) {
                    if (bl4) {
                        zipInputStream.close();
                    }
                    return stringArray3;
                }
                object4 = Resolver.resolve(string + "|" + zipEntry.getName(), null, (BufferedReader)stringArray3, hashtable);
                if (object4 instanceof AtomSetCollection) {
                    if (bl3 && !bl2) {
                        hashtable2.put(object2, object4);
                    } else {
                        vector.addElement(object4);
                    }
                    AtomSetCollection atomSetCollection = (AtomSetCollection)object4;
                    if (atomSetCollection.errorMessage == null || bl6) continue;
                    zipInputStream.close();
                    return atomSetCollection.errorMessage;
                }
                if (bl6) continue;
                zipInputStream.close();
                return "unknown reader error";
            }
            if (bl4) {
                zipInputStream.close();
            }
            if (bl9) {
                object3 = new BufferedReader(new StringReader(stringBuffer.toString()));
                if (bl) {
                    return object3;
                }
                object2 = Resolver.resolve(string, null, (BufferedReader)object3);
                if (object2 instanceof String) {
                    return object2;
                }
                if (object2 instanceof AtomSetCollection) {
                    object = (AtomSetCollection)object2;
                    if (object.errorMessage != null) {
                        if (bl6) {
                            return null;
                        }
                        return object.errorMessage;
                    }
                    return object;
                }
                if (bl6) {
                    return null;
                }
                return "unknown reader error";
            }
            if (bl3 && !bl2) {
                object3 = TextFormat.split(string2, '|');
                for (int i = 0; i < ((byte[])object3).length; ++i) {
                    object = object3[i];
                    if (object.length() == 0 || object.indexOf("#") == 0) continue;
                    if (hashtable2.containsKey(object)) {
                        vector.add(hashtable2.get(object));
                        continue;
                    }
                    if (!Logger.debugging) continue;
                    Logger.info("manifested file " + (String)object + " was not found in " + string);
                }
            }
            if (!bl4) {
                return vector;
            }
            object3 = new AtomSetCollection(vector);
            if (object3.errorMessage != null) {
                if (bl6) {
                    return null;
                }
                return object3.errorMessage;
            }
            if (n2 == 1) {
                n3 = 1;
            }
            if (n3 > 0 && n3 <= vector.size()) {
                return vector.elementAt(n3 - 1);
            }
            return object3;
        }
        catch (Exception exception) {
            if (bl6) {
                return null;
            }
            Logger.error(null, exception);
            return "" + exception;
        }
    }

    public Object openDOMReader(Object object) {
        return SmarterJmolAdapter.staticOpenDOMReader(object);
    }

    private static Object staticOpenDOMReader(Object object) {
        try {
            Object object2 = Resolver.DOMResolve(object);
            if (object2 instanceof String) {
                return object2;
            }
            if (object2 instanceof AtomSetCollection) {
                AtomSetCollection atomSetCollection = (AtomSetCollection)object2;
                if (atomSetCollection.errorMessage != null) {
                    return atomSetCollection.errorMessage;
                }
                return atomSetCollection;
            }
            return "unknown DOM reader error";
        }
        catch (Exception exception) {
            Logger.error(null, exception);
            return "" + exception;
        }
    }

    public String getFileTypeName(Object object) {
        return SmarterJmolAdapter.staticGetFileTypeName(object);
    }

    private static String staticGetFileTypeName(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof BufferedReader) {
            return Resolver.getFileType((BufferedReader)object);
        }
        if (object instanceof AtomSetCollection) {
            return ((AtomSetCollection)object).fileTypeName;
        }
        return null;
    }

    public String getAtomSetCollectionName(Object object) {
        return ((AtomSetCollection)object).collectionName;
    }

    public Properties getAtomSetCollectionProperties(Object object) {
        return ((AtomSetCollection)object).atomSetCollectionProperties;
    }

    public Hashtable getAtomSetCollectionAuxiliaryInfo(Object object) {
        return ((AtomSetCollection)object).atomSetCollectionAuxiliaryInfo;
    }

    public int getAtomSetCount(Object object) {
        return ((AtomSetCollection)object).atomSetCount;
    }

    public int getAtomSetNumber(Object object, int n) {
        return ((AtomSetCollection)object).getAtomSetNumber(n);
    }

    public String getAtomSetName(Object object, int n) {
        return ((AtomSetCollection)object).getAtomSetName(n);
    }

    public Properties getAtomSetProperties(Object object, int n) {
        return ((AtomSetCollection)object).getAtomSetProperties(n);
    }

    public Hashtable getAtomSetAuxiliaryInfo(Object object, int n) {
        return ((AtomSetCollection)object).getAtomSetAuxiliaryInfo(n);
    }

    public int getEstimatedAtomCount(Object object) {
        return ((AtomSetCollection)object).getAtomCount();
    }

    public boolean coordinatesAreFractional(Object object) {
        return ((AtomSetCollection)object).coordinatesAreFractional;
    }

    public float[] getNotionalUnitcell(Object object) {
        return ((AtomSetCollection)object).notionalUnitCell;
    }

    public float[] getPdbScaleMatrix(Object object) {
        float[] fArray = ((AtomSetCollection)object).notionalUnitCell;
        if (fArray.length < 22) {
            return null;
        }
        float[] fArray2 = new float[16];
        for (int i = 0; i < 16; ++i) {
            fArray2[i] = fArray[6 + i];
        }
        return fArray2;
    }

    public float[] getPdbScaleTranslate(Object object) {
        float[] fArray = ((AtomSetCollection)object).notionalUnitCell;
        if (fArray.length < 22) {
            return null;
        }
        float[] fArray2 = new float[]{fArray[9], fArray[13], fArray[17]};
        return fArray2;
    }

    public JmolAdapter.AtomIterator getAtomIterator(Object object) {
        return new AtomIterator((AtomSetCollection)object);
    }

    public JmolAdapter.BondIterator getBondIterator(Object object) {
        return new BondIterator((AtomSetCollection)object);
    }

    public JmolAdapter.StructureIterator getStructureIterator(Object object) {
        AtomSetCollection atomSetCollection = (AtomSetCollection)object;
        return atomSetCollection.structureCount == 0 ? null : new StructureIterator(atomSetCollection);
    }

    public class StructureIterator
    extends JmolAdapter.StructureIterator {
        int structureCount;
        Structure[] structures;
        Structure structure;
        int istructure;

        StructureIterator(AtomSetCollection atomSetCollection) {
            super(SmarterJmolAdapter.this);
            this.structureCount = atomSetCollection.structureCount;
            this.structures = atomSetCollection.structures;
            this.istructure = 0;
        }

        public boolean hasNext() {
            if (this.istructure == this.structureCount) {
                return false;
            }
            this.structure = this.structures[this.istructure++];
            return true;
        }

        public int getModelIndex() {
            return this.structure.modelIndex;
        }

        public String getStructureType() {
            return this.structure.structureType;
        }

        public char getStartChainID() {
            return JmolAdapter.canonizeChainID(this.structure.startChainID);
        }

        public int getStartSequenceNumber() {
            return this.structure.startSequenceNumber;
        }

        public char getStartInsertionCode() {
            return JmolAdapter.canonizeInsertionCode(this.structure.startInsertionCode);
        }

        public char getEndChainID() {
            return JmolAdapter.canonizeChainID(this.structure.endChainID);
        }

        public int getEndSequenceNumber() {
            return this.structure.endSequenceNumber;
        }

        public char getEndInsertionCode() {
            return this.structure.endInsertionCode;
        }
    }

    class BondIterator
    extends JmolAdapter.BondIterator {
        AtomSetCollection atomSetCollection;
        Bond[] bonds;
        int ibond;
        Bond bond;
        int bondCount;

        BondIterator(AtomSetCollection atomSetCollection) {
            super(SmarterJmolAdapter.this);
            this.atomSetCollection = atomSetCollection;
            this.bonds = atomSetCollection.bonds;
            this.bondCount = atomSetCollection.bondCount;
            this.ibond = 0;
        }

        public boolean hasNext() {
            if (this.ibond == this.bondCount) {
                return false;
            }
            this.bond = this.bonds[this.ibond++];
            return true;
        }

        public Object getAtomUniqueID1() {
            return new Integer(this.bond.atomIndex1);
        }

        public Object getAtomUniqueID2() {
            return new Integer(this.bond.atomIndex2);
        }

        public int getEncodedOrder() {
            return this.bond.order;
        }
    }

    class AtomIterator
    extends JmolAdapter.AtomIterator {
        AtomSetCollection atomSetCollection;
        int iatom;
        Atom atom;
        int atomCount;
        Atom[] atoms;

        AtomIterator(AtomSetCollection atomSetCollection) {
            super(SmarterJmolAdapter.this);
            this.atomSetCollection = atomSetCollection;
            this.atomCount = atomSetCollection.atomCount;
            this.atoms = atomSetCollection.atoms;
            this.iatom = 0;
        }

        public boolean hasNext() {
            if (this.iatom == this.atomCount) {
                return false;
            }
            this.atom = this.atoms[this.iatom++];
            return true;
        }

        public int getAtomSetIndex() {
            return this.atom.atomSetIndex;
        }

        public BitSet getAtomSymmetry() {
            return this.atom.bsSymmetry;
        }

        public int getAtomSite() {
            return this.atom.atomSite + 1;
        }

        public Object getUniqueID() {
            return new Integer(this.atom.atomIndex);
        }

        public String getElementSymbol() {
            if (this.atom.elementSymbol != null) {
                return this.atom.elementSymbol;
            }
            return this.atom.getElementSymbol();
        }

        public int getElementNumber() {
            return this.atom.elementNumber;
        }

        public String getAtomName() {
            return this.atom.atomName;
        }

        public int getFormalCharge() {
            return this.atom.formalCharge;
        }

        public float getPartialCharge() {
            return this.atom.partialCharge;
        }

        public Object[] getEllipsoid() {
            return this.atom.ellipsoid;
        }

        public float getRadius() {
            return this.atom.radius;
        }

        public float getX() {
            return this.atom.x;
        }

        public float getY() {
            return this.atom.y;
        }

        public float getZ() {
            return this.atom.z;
        }

        public float getVectorX() {
            return this.atom.vectorX;
        }

        public float getVectorY() {
            return this.atom.vectorY;
        }

        public float getVectorZ() {
            return this.atom.vectorZ;
        }

        public float getBfactor() {
            return Float.isNaN(this.atom.bfactor) && this.atom.anisoBorU != null ? this.atom.anisoBorU[7] * 100.0f : this.atom.bfactor;
        }

        public int getOccupancy() {
            return this.atom.occupancy;
        }

        public boolean getIsHetero() {
            return this.atom.isHetero;
        }

        public int getAtomSerial() {
            return this.atom.atomSerial;
        }

        public char getChainID() {
            return JmolAdapter.canonizeChainID(this.atom.chainID);
        }

        public char getAlternateLocationID() {
            return JmolAdapter.canonizeAlternateLocationID(this.atom.alternateLocationID);
        }

        public String getGroup3() {
            return this.atom.group3;
        }

        public int getSequenceNumber() {
            return this.atom.sequenceNumber;
        }

        public char getInsertionCode() {
            return JmolAdapter.canonizeInsertionCode(this.atom.insertionCode);
        }
    }
}

