/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import java.io.BufferedReader;
import java.util.HashMap;
import javax.vecmath.Point3f;
import netscape.javascript.JSObject;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Logger;
import org.xml.sax.XMLReader;

public class XmlOdysseyReader
extends XmlReader {
    String[] odysseyImplementedAttributes = new String[]{"id", "label", "xyz", "element", "hybrid", "a", "b", "order", "boundary"};
    String modelName = null;
    String formula = null;
    String phase = null;

    XmlOdysseyReader(XmlReader xmlReader, AtomSetCollection atomSetCollection, BufferedReader bufferedReader, XMLReader xMLReader) {
        this.parent = xmlReader;
        this.reader = bufferedReader;
        this.atomSetCollection = atomSetCollection;
        new OdysseyHandler(xMLReader);
        this.parseReaderXML(xMLReader);
    }

    XmlOdysseyReader(XmlReader xmlReader, AtomSetCollection atomSetCollection, JSObject jSObject) {
        this.parent = xmlReader;
        this.atomSetCollection = atomSetCollection;
        this.implementedAttributes = this.odysseyImplementedAttributes;
        new OdysseyHandler().walkDOMTree(jSObject);
    }

    protected void processStartElement(String string, String string2, String string3, HashMap hashMap) {
        if ("structure".equals(string2)) {
            this.atomSetCollection.newAtomSet();
            return;
        }
        if ("atom".equals(string2)) {
            this.atom = new Atom();
            this.atom.atomName = hashMap.containsKey("label") ? (String)hashMap.get("label") : (String)hashMap.get("id");
            if (hashMap.containsKey("xyz")) {
                String string4 = (String)hashMap.get("xyz");
                String[] stringArray = AtomSetCollectionReader.getTokens(string4);
                this.parent.setAtomCoord(this.atom, this.parseFloat(stringArray[0]), this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]));
            }
            if (hashMap.containsKey("element")) {
                this.atom.elementSymbol = (String)hashMap.get("element");
            }
            return;
        }
        if ("bond".equals(string2)) {
            String string5 = (String)hashMap.get("a");
            String string6 = (String)hashMap.get("b");
            int n = 1;
            if (hashMap.containsKey("order")) {
                n = this.parseBondToken((String)hashMap.get("order"));
            }
            this.atomSetCollection.addNewBond(string5, string6, n);
            return;
        }
        if ("boundary".equals(string2)) {
            String[] stringArray = AtomSetCollectionReader.getTokens((String)hashMap.get("box"));
            float f = this.parseFloat(stringArray[0]);
            float f2 = this.parseFloat(stringArray[1]);
            float f3 = this.parseFloat(stringArray[2]);
            this.parent.setUnitCellItem(0, f);
            this.parent.setUnitCellItem(1, f2);
            this.parent.setUnitCellItem(2, f3);
            this.parent.setUnitCellItem(3, 90.0f);
            this.parent.setUnitCellItem(4, 90.0f);
            this.parent.setUnitCellItem(5, 90.0f);
            Point3f point3f = new Point3f(-f / 2.0f, -f2 / 2.0f, -f3 / 2.0f);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("periodicOriginXyz", point3f);
            Atom[] atomArray = this.atomSetCollection.getAtoms();
            int n = this.atomSetCollection.getAtomCount();
            while (--n >= 0) {
                atomArray[n].sub(point3f);
                this.parent.setAtomCoord(atomArray[n]);
            }
            if (this.parent.latticeCells[0] == 0) {
                this.parent.latticeCells[2] = 1;
                this.parent.latticeCells[1] = 1;
                this.parent.latticeCells[0] = 1;
            }
            this.parent.setSymmetryOperator("x,y,z");
            this.parent.setSpaceGroupName("P1");
            this.applySymmetry();
            return;
        }
        if ("odyssey_simulation".equals(string2)) {
            if (this.modelName != null && this.phase != null) {
                this.modelName = this.modelName + " - " + this.phase;
            }
            if (this.modelName != null) {
                this.atomSetCollection.setAtomSetName(this.modelName);
            }
            if (this.formula != null) {
                this.atomSetCollection.setAtomSetAuxiliaryInfo("formula", this.formula);
            }
        }
        if ("title".equals(string2) || "formula".equals(string2) || "phase".equals(string2)) {
            this.keepChars = true;
        }
    }

    public void applySymmetry() {
        try {
            this.parent.applySymmetry();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Logger.error("applySymmetry failed: " + exception);
        }
    }

    int parseBondToken(String string) {
        if (string.length() >= 1) {
            switch (string.charAt(0)) {
                case 's': {
                    return 1;
                }
                case 'd': {
                    return 2;
                }
                case 't': {
                    return 3;
                }
                case 'a': {
                    return 515;
                }
            }
            return this.parseInt(string);
        }
        return 1;
    }

    protected void processEndElement(String string, String string2, String string3) {
        if ("atom".equals(string2)) {
            if (this.atom.elementSymbol != null && !Float.isNaN(this.atom.z)) {
                this.atomSetCollection.addAtomWithMappedName(this.atom);
            }
            this.atom = null;
            return;
        }
        if ("title".equals(string2)) {
            this.modelName = this.chars;
        }
        if ("formula".equals(string2)) {
            this.formula = this.chars;
        }
        if ("phase".equals(string2)) {
            this.phase = this.chars;
        }
        this.keepChars = false;
        this.chars = null;
    }

    class OdysseyHandler
    extends XmlReader.JmolXmlHandler {
        OdysseyHandler() {
            super(XmlOdysseyReader.this);
        }

        OdysseyHandler(XMLReader xMLReader) {
            super(XmlOdysseyReader.this);
            this.setHandler(xMLReader, this);
        }
    }
}

