/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class PsiReader
extends AtomSetCollectionReader {
    int shellCount = 0;
    int gaussianCount = 0;
    Hashtable moData = new Hashtable();
    Vector orbitals = new Vector();
    Vector atomNames = new Vector();
    Vector shellsByUniqueAtom = new Vector();
    Hashtable uniqueAtomMap = new Hashtable();

    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("psi");
        boolean bl = false;
        int n = 0;
        try {
            while (this.readLine() != null) {
                if (this.line.indexOf("-Geometry after Center-of-Mass shift and reorientation (a.u.):") >= 0) {
                    this.readAtoms(true);
                    bl = true;
                }
                if (this.line.indexOf("-Unique atoms in the canonical coordinate system (a.u.):") >= 0) {
                    this.readUniqueAtoms();
                }
                if (bl && this.line.indexOf("New Cartesian Geometry in a.u.") >= 0) {
                    this.readAtoms(false);
                } else if (bl && this.line.startsWith("  label        = ")) {
                    this.moData.put("calculationType", this.line.substring(17).trim());
                } else if (bl && this.line.startsWith("molecular orbitals for ")) {
                    this.moData.put("energyUnits", "");
                } else if (this.line.startsWith("  -BASIS SETS:")) {
                    this.readBasis();
                    this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", this.moData);
                } else if (bl && this.line.indexOf("Molecular Orbital Coefficients") >= 0) {
                    this.readMolecularOrbitals();
                    if (Logger.debugging) {
                        Logger.debug(this.orbitals.size() + " molecular orbitals read");
                    }
                    this.moData.put("mos", this.orbitals);
                    this.setMOData(this.moData);
                } else if (bl && this.line.indexOf("SCF total energy   =") >= 0) {
                    this.readSCFDone();
                }
                ++n;
            }
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        return this.atomSetCollection;
    }

    private void readSCFDone() throws Exception {
        this.atomSetCollection.setAtomSetName(this.line);
    }

    private void readAtoms(boolean bl) throws Exception {
        if (bl) {
            this.atomSetCollection.newAtomSet();
            this.atomSetCollection.setAtomSetName("");
            this.discardLinesUntilContains("----");
        }
        int n = 0;
        while (this.readLine() != null && this.line.length() > 0) {
            Atom atom;
            String[] stringArray = this.getTokens();
            Atom atom2 = atom = bl ? this.atomSetCollection.addNewAtom() : this.atomSetCollection.getAtom(n++);
            if (bl) {
                this.atomNames.addElement(stringArray[0]);
            } else {
                atom.elementNumber = (byte)this.parseInt(stringArray[0]);
            }
            if (atom.elementNumber < 0) {
                atom.elementNumber = 0;
            }
            atom.set(this.parseFloat(stringArray[1]), this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3]));
            atom.scale(0.5291772f);
        }
    }

    void readBasis() throws Exception {
        int n;
        String[] stringArray;
        Vector<String[]> vector = new Vector<String[]>();
        this.gaussianCount = 0;
        this.shellCount = 0;
        int[] nArray = null;
        Vector<int[]> vector2 = null;
        this.readLine();
        while (this.readLine() != null && this.line.startsWith("   -Basis set on")) {
            vector2 = new Vector<int[]>();
            int n2 = 0;
            while (this.readLine() != null && !this.line.startsWith("       )")) {
                this.line = this.line.replace('(', ' ').replace(')', ' ');
                stringArray = this.getTokens();
                n = 0;
                switch (stringArray.length) {
                    case 3: {
                        if (nArray != null) {
                            vector2.addElement(nArray);
                        }
                        n = 1;
                        nArray = new int[3];
                        nArray[0] = JmolAdapter.getQuantumShellTagID(stringArray[0]);
                        nArray[1] = this.gaussianCount;
                        ++this.shellCount;
                        break;
                    }
                }
                vector.addElement(new String[]{stringArray[n], stringArray[n + 1]});
                nArray[2] = ++n2;
            }
            if (nArray != null) {
                vector2.addElement(nArray);
            }
            this.shellsByUniqueAtom.addElement(vector2);
            this.gaussianCount += n2;
            this.readLine();
        }
        float[][] fArrayArray = new float[this.gaussianCount][];
        for (n = 0; n < this.gaussianCount; ++n) {
            stringArray = (String[])vector.get(n);
            fArrayArray[n] = new float[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                fArrayArray[n][i] = this.parseFloat(stringArray[i]);
            }
        }
        this.moData.put("gaussians", fArrayArray);
        if (Logger.debugging) {
            Logger.debug(this.shellCount + " slater shells read");
            Logger.debug(this.gaussianCount + " gaussian primitives read");
        }
    }

    private void readUniqueAtoms() throws Exception {
        Vector<int[]> vector = new Vector<int[]>();
        this.discardLinesUntilContains("----");
        int n = 0;
        while (this.readLine() != null && this.line.length() > 0) {
            String[] stringArray = this.getTokens();
            this.uniqueAtomMap.put(stringArray[0], new Integer(n++));
        }
        int n2 = this.atomNames.size();
        for (int i = 0; i < n2; ++i) {
            String string = (String)this.atomNames.elementAt(i);
            int n3 = (Integer)this.uniqueAtomMap.get(string);
            Vector vector2 = (Vector)this.shellsByUniqueAtom.elementAt(n3);
            if (vector2 == null) {
                Logger.error("slater for atom " + i + " atomType " + string + " was not found in listing. Ignoring molecular orbitals");
                return;
            }
            for (int j = 0; j < vector2.size(); ++j) {
                int[] nArray = (int[])vector2.elementAt(j);
                vector.addElement(new int[]{i, nArray[0], nArray[1], nArray[2]});
            }
        }
        this.moData.put("shells", vector);
    }

    void readMolecularOrbitals() throws Exception {
        Hashtable[] hashtableArray = new Hashtable[5];
        Vector[] vectorArray = new Vector[5];
        int n = 0;
        while (this.readLine() != null && this.line.toUpperCase().indexOf("DENS") < 0) {
            int n2;
            int n3;
            String[] stringArray = this.getTokens();
            int n4 = n3 = this.line.charAt(5) == ' ' ? 2 : 4;
            if (this.line.indexOf("                    ") == 0) {
                this.addMOData(n, vectorArray, hashtableArray);
                n = stringArray.length;
                stringArray = AtomSetCollectionReader.getTokens(this.readLine());
                for (n2 = 0; n2 < n; ++n2) {
                    hashtableArray[n2] = new Hashtable();
                    vectorArray[n2] = new Vector();
                    hashtableArray[n2].put("symmetry", stringArray[n2]);
                }
                stringArray = AtomSetCollectionReader.getStrings(this.readLine().substring(21), n, 10);
                for (n2 = 0; n2 < n; ++n2) {
                    hashtableArray[n2].put("energy", new Float(stringArray[n2]));
                }
                continue;
            }
            try {
                for (n2 = 0; n2 < n; ++n2) {
                    vectorArray[n2].addElement(stringArray[n2 + n3]);
                }
            }
            catch (Exception exception) {
                Logger.error("Error reading Psi3 file molecular orbitals at line: " + this.line);
                break;
            }
        }
        this.addMOData(n, vectorArray, hashtableArray);
    }

    void addMOData(int n, Vector[] vectorArray, Hashtable[] hashtableArray) {
        for (int i = 0; i < n; ++i) {
            float[] fArray = new float[vectorArray[i].size()];
            int n2 = fArray.length;
            while (--n2 >= 0) {
                fArray[n2] = this.parseFloat((String)vectorArray[i].get(n2));
            }
            hashtableArray[i].put("coefficients", fArray);
            this.orbitals.addElement(hashtableArray[i]);
        }
    }
}

