/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import org.jmol.adapter.readers.more.GamessReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class GamessUSReader
extends GamessReader {
    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("gamess");
        try {
            this.readLine();
            boolean bl = false;
            while (this.line != null) {
                if (this.line.indexOf("COORDINATES (BOHR)") >= 0 || this.line.indexOf("COORDINATES OF ALL ATOMS ARE (ANGS)") >= 0) {
                    if (++this.modelNumber != this.desiredModelNumber && this.desiredModelNumber > 0) {
                        if (!bl) {
                            this.readLine();
                            continue;
                        }
                        break;
                    }
                    if (this.line.indexOf("COORDINATES (BOHR)") >= 0) {
                        this.readAtomsInBohrCoordinates();
                    } else {
                        this.readAtomsInAngstromCoordinates();
                    }
                    bl = true;
                } else if (bl && this.line.indexOf("FREQUENCIES IN CM") >= 0) {
                    this.readFrequencies();
                } else {
                    if (bl && this.line.indexOf("ATOMIC BASIS SET") >= 0) {
                        this.readGaussianBasis("SHELL TYPE", "TOTAL");
                        continue;
                    }
                    if (bl && (this.line.indexOf("  EIGENVECTORS") >= 0 || this.line.indexOf("  MOLECULAR ORBITALS") >= 0)) {
                        this.readMolecularOrbitals();
                        continue;
                    }
                }
                this.readLine();
            }
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        return this.atomSetCollection;
    }

    protected void readAtomsInBohrCoordinates() throws Exception {
        String string;
        this.readLine();
        this.atomSetCollection.newAtomSet();
        int n = 0;
        while (this.readLine() != null && (string = this.parseToken(this.line, 1, 6)) != null) {
            float f = this.parseFloat(this.line, 17, 37);
            float f2 = this.parseFloat(this.line, 37, 57);
            float f3 = this.parseFloat(this.line, 57, 77);
            if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3)) break;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = string + ++n;
            atom.set(f, f2, f3);
            atom.scale(0.5291772f);
            this.atomNames.addElement(string);
        }
    }

    private void readAtomsInAngstromCoordinates() throws Exception {
        String string;
        this.readLine();
        this.readLine();
        this.atomSetCollection.newAtomSet();
        int n = 0;
        while (this.readLine() != null && (string = this.parseToken(this.line, 1, 6)) != null) {
            float f = this.parseFloat(this.line, 16, 31);
            float f2 = this.parseFloat(this.line, 31, 46);
            float f3 = this.parseFloat(this.line, 46, 61);
            if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3)) break;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = string + ++n;
            atom.set(f, f2, f3);
            this.atomNames.addElement(string);
        }
    }

    protected String fixShellTag(String string) {
        return string;
    }

    protected void getMOHeader(String[] stringArray, Hashtable[] hashtableArray, int n) throws Exception {
        int n2;
        stringArray = AtomSetCollectionReader.getTokens(this.readLine());
        for (n2 = 0; n2 < n; ++n2) {
            hashtableArray[n2].put("energy", new Float(stringArray[n2]));
        }
        stringArray = AtomSetCollectionReader.getTokens(this.readLine());
        for (n2 = 0; n2 < n; ++n2) {
            hashtableArray[n2].put("symmetry", stringArray[n2]);
        }
    }
}

