/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cifpdb;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class PdbReader
extends AtomSetCollectionReader {
    int lineLength;
    boolean isNMRdata;
    final Hashtable htFormul = new Hashtable();
    Hashtable htHetero = null;
    Hashtable htSites = null;
    protected String fileType = "pdb";
    String currentGroup3;
    String compnd;
    Hashtable htElementsInCurrentGroup;
    int maxSerial = 0;
    int[] chainAtomCounts;
    private static final String lineOptions = "ATOM    HETATM  MODEL   CONECT  HELIX   SHEET   TURN    HET     HETNAM  ANISOU  SITE    CRYST1  SCALE1  SCALE2  SCALE3  EXPDTA  FORMUL  REMARK  HEADER  COMPND  ";
    Vector biomolecules;
    Vector biomts;
    int atomCount;
    String lastAtomData;
    int lastAtomIndex;
    boolean haveMappedSerials;

    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection(this.fileType);
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("isPDB", Boolean.TRUE);
        this.setFractionalCoordinates(false);
        this.htFormul.clear();
        this.currentGroup3 = null;
        this.isNMRdata = false;
        boolean bl = false;
        boolean bl2 = false;
        StringBuffer stringBuffer = this.getHeader ? new StringBuffer() : null;
        try {
            block17: while (this.readLine() != null) {
                boolean bl3;
                this.lineLength = this.line.length();
                int n = (this.lineLength < 6 ? -1 : lineOptions.indexOf(this.line.substring(0, 6))) >> 3;
                boolean bl4 = n == 0 || n == 1;
                boolean bl5 = bl3 = n == 2;
                if (this.getHeader) {
                    if (bl4 || bl3) {
                        this.getHeader = false;
                    } else {
                        stringBuffer.append(this.line).append('\n');
                    }
                }
                if (bl3) {
                    this.getHeader = false;
                    bl2 = true;
                    if (++this.modelNumber != this.desiredModelNumber && this.desiredModelNumber > 0) {
                        if (!bl) continue;
                        break;
                    }
                    bl = true;
                    this.atomSetCollection.connectAll(this.maxSerial);
                    this.applySymmetry();
                    this.model();
                    continue;
                }
                if (bl2 && !bl) continue;
                if (bl4) {
                    this.getHeader = false;
                    this.atom();
                    continue;
                }
                switch (n) {
                    case 3: {
                        this.conect();
                        continue block17;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        this.structure();
                        continue block17;
                    }
                    case 7: {
                        this.het();
                        continue block17;
                    }
                    case 8: {
                        this.hetnam();
                        continue block17;
                    }
                    case 9: {
                        this.anisou();
                        continue block17;
                    }
                    case 10: {
                        this.site();
                        continue block17;
                    }
                    case 11: {
                        this.cryst1();
                        continue block17;
                    }
                    case 12: 
                    case 13: 
                    case 14: {
                        this.scale(n - 11);
                        continue block17;
                    }
                    case 15: {
                        this.expdta();
                        continue block17;
                    }
                    case 16: {
                        this.formul();
                        continue block17;
                    }
                    case 17: {
                        if (this.line.startsWith("REMARK 350 GENERATING THE BIOMOLECULE")) {
                            this.remark350();
                            continue block17;
                        }
                        this.checkLineForScript();
                        continue block17;
                    }
                    case 18: {
                        this.header();
                        continue block17;
                    }
                    case 19: {
                        this.compnd();
                        continue block17;
                    }
                }
            }
            this.atomSetCollection.connectAll(this.maxSerial);
            if (this.biomolecules != null && this.biomolecules.size() > 0) {
                this.atomSetCollection.setAtomSetAuxiliaryInfo("biomolecules", this.biomolecules);
                this.setBiomoleculeAtomCounts();
                if (this.biomts != null && this.filter != null && this.filter.toUpperCase().indexOf("NOSYMMETRY") < 0) {
                    this.atomSetCollection.applySymmetry(this.biomts, this.applySymmetryToBonds, this.filter);
                }
            }
            this.applySymmetry();
            if (this.htSites != null) {
                this.addSites(this.htSites);
            }
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        if (stringBuffer != null) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("fileHeader", stringBuffer.toString());
        }
        return this.atomSetCollection;
    }

    private void header() {
        if (this.lineLength >= 66) {
            this.atomSetCollection.setCollectionName(this.line.substring(62, 66));
        }
        if (this.lineLength > 50) {
            this.line = this.line.substring(0, 50);
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("CLASSIFICATION", this.line.substring(7).trim());
    }

    private void compnd() {
        this.compnd = this.compnd == null ? "" : this.compnd + " ";
        if (this.lineLength > 62) {
            this.line = this.line.substring(0, 62);
        }
        this.compnd = this.compnd + this.line.substring(10).trim();
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("COMPND", this.compnd);
    }

    private void setBiomoleculeAtomCounts() {
        int n = this.biomolecules.size();
        while (--n >= 0) {
            Hashtable hashtable = (Hashtable)this.biomolecules.elementAt(n);
            String string = (String)hashtable.get("chains");
            int n2 = ((Vector)hashtable.get("biomts")).size();
            int n3 = 0;
            int n4 = string.length() - 1;
            while (--n4 >= 0) {
                if (string.charAt(n4) != ':') continue;
                n3 += this.chainAtomCounts[string.charAt(n4 + 1)];
            }
            hashtable.put("atomCount", new Integer(n3 * n2));
        }
    }

    private void remark350() throws Exception {
        Vector<float[]> vector = null;
        this.biomolecules = new Vector();
        this.chainAtomCounts = new int[255];
        String string = "";
        String string2 = "";
        int n = 0;
        boolean bl = true;
        Hashtable<String, Object> hashtable = null;
        int n2 = 0;
        while (true) {
            if (bl) {
                this.readLine();
            } else {
                bl = true;
            }
            if (this.line == null || !this.line.startsWith("REMARK 350")) break;
            try {
                if (this.line.startsWith("REMARK 350 BIOMOLECULE:")) {
                    if (n2 > 0) {
                        Logger.info("biomolecule " + n + ": number of transforms: " + n2);
                    }
                    hashtable = new Hashtable<String, Object>();
                    vector = new Vector<float[]>();
                    n = this.parseInt(this.line.substring(this.line.indexOf(":") + 1));
                    string = this.line.trim();
                    hashtable.put("molecule", new Integer(n));
                    hashtable.put("title", string);
                    hashtable.put("chains", "");
                    hashtable.put("biomts", vector);
                    this.biomolecules.add(hashtable);
                    n2 = 0;
                }
                if (this.line.indexOf("APPLY THE FOLLOWING TO CHAINS:") >= 0) {
                    if (hashtable == null) {
                        bl = false;
                        this.line = "REMARK 350 BIOMOLECULE: 1  APPLY THE FOLLOWING TO CHAINS:";
                        continue;
                    }
                    string2 = ":" + this.line.substring(41).trim().replace(' ', ':');
                    bl = false;
                    while (this.readLine() != null && this.line.indexOf("BIOMT") < 0) {
                        string2 = string2 + ":" + this.line.substring(11).trim().replace(' ', ':');
                    }
                    if (this.filter != null && this.filter.toUpperCase().indexOf("BIOMOLECULE " + n + ";") >= 0) {
                        this.filter = this.filter + string2;
                        Logger.info("filter set to \"" + this.filter + "\"");
                        this.biomts = vector;
                    }
                    if (hashtable == null) {
                        return;
                    }
                    hashtable.put("chains", string2);
                    continue;
                }
                if (!this.line.startsWith("REMARK 350   BIOMT1 ")) continue;
                ++n2;
                float[] fArray = new float[16];
                int n3 = 0;
                while (n3 < 12) {
                    String[] stringArray = this.getTokens();
                    fArray[n3++] = this.parseFloat(stringArray[4]);
                    fArray[n3++] = this.parseFloat(stringArray[5]);
                    fArray[n3++] = this.parseFloat(stringArray[6]);
                    fArray[n3++] = this.parseFloat(stringArray[7]);
                    if (n3 != 4 && n3 != 8) continue;
                    this.readLine();
                }
                fArray[15] = 1.0f;
                vector.add(fArray);
            }
            catch (Exception exception) {
                this.biomts = null;
                this.biomolecules = null;
                return;
            }
        }
        if (n2 > 0) {
            Logger.info("biomolecule " + n + ": number of transforms: " + n2);
        }
    }

    void atom() {
        int n;
        boolean bl = this.line.startsWith("HETATM");
        char c = this.line.charAt(16);
        int n2 = this.parseInt(this.line, 6, 11);
        if (n2 > this.maxSerial) {
            this.maxSerial = n2;
        }
        this.lastAtomData = this.line.substring(6, 26);
        char c2 = this.line.charAt(21);
        if (this.chainAtomCounts != null) {
            char c3 = c2;
            this.chainAtomCounts[c3] = this.chainAtomCounts[c3] + 1;
        }
        int n3 = this.parseInt(this.line, 22, 26);
        char c4 = this.line.charAt(26);
        String string = this.parseToken(this.line, 17, 20);
        if (string == null) {
            this.currentGroup3 = null;
            this.htElementsInCurrentGroup = null;
        } else if (!string.equals(this.currentGroup3)) {
            this.currentGroup3 = string;
            this.htElementsInCurrentGroup = (Hashtable)this.htFormul.get(string);
        }
        String string2 = this.deduceElementSymbol(bl);
        String string3 = this.line.substring(12, 16);
        String string4 = string3.trim();
        int n4 = 0;
        if (this.lineLength >= 80) {
            int n5 = this.line.charAt(78);
            n = this.line.charAt(79);
            if (n >= 48 && n <= 55) {
                int n6 = n;
                n = n5;
                n5 = n6;
            }
            if ((n == 43 || n == 45 || n == 32) && n5 >= 48 && n5 <= 55) {
                n4 = n5 - 48;
                if (n == 45) {
                    n4 = -n4;
                }
            }
        }
        float f = this.readBFactor();
        n = this.readOccupancy();
        float f2 = this.readPartialCharge();
        float f3 = this.readRadius();
        float f4 = this.parseFloat(this.line, 30, 38);
        float f5 = this.parseFloat(this.line, 38, 46);
        float f6 = this.parseFloat(this.line, 46, 54);
        Atom atom = new Atom();
        atom.elementSymbol = string2;
        atom.atomName = string4;
        if (c != ' ') {
            atom.alternateLocationID = c;
        }
        atom.formalCharge = n4;
        if (f2 != Float.MAX_VALUE) {
            atom.partialCharge = f2;
        }
        atom.occupancy = n;
        atom.bfactor = f;
        this.setAtomCoord(atom, f4, f5, f6);
        atom.isHetero = bl;
        atom.chainID = c2;
        atom.atomSerial = n2;
        atom.group3 = this.currentGroup3;
        atom.sequenceNumber = n3;
        atom.insertionCode = JmolAdapter.canonizeInsertionCode(c4);
        atom.radius = f3;
        if (this.filter != null && !this.filterAtom(atom)) {
            return;
        }
        this.lastAtomIndex = this.atomSetCollection.getAtomCount();
        if (this.haveMappedSerials) {
            this.atomSetCollection.addAtomWithMappedSerialNumber(atom);
        } else {
            this.atomSetCollection.addAtom(atom);
        }
        if (this.atomCount++ == 0) {
            this.atomSetCollection.setAtomSetAuxiliaryInfo("isPDB", Boolean.TRUE);
        }
        if (bl && this.htHetero != null) {
            this.atomSetCollection.setAtomSetAuxiliaryInfo("hetNames", this.htHetero);
            this.htHetero = null;
        }
    }

    protected int readOccupancy() {
        int n = 100;
        float f = this.parseFloat(this.line, 54, 60);
        if (!Float.isNaN(f)) {
            n = (int)(f * 100.0f);
        }
        return n;
    }

    protected float readBFactor() {
        return this.parseFloat(this.line, 60, 66);
    }

    protected float readPartialCharge() {
        return Float.MAX_VALUE;
    }

    protected float readRadius() {
        return Float.NaN;
    }

    String deduceElementSymbol(boolean bl) {
        char c;
        char c2;
        if (this.lineLength >= 78) {
            c2 = this.line.charAt(76);
            c = this.line.charAt(77);
            if (c2 == ' ' && Atom.isValidElementSymbol(c)) {
                return "" + c;
            }
            if (Atom.isValidElementSymbolNoCaseSecondChar(c2, c)) {
                return "" + c2 + c;
            }
        }
        c2 = this.line.charAt(12);
        c = this.line.charAt(13);
        if ((this.htElementsInCurrentGroup == null || this.htElementsInCurrentGroup.get(this.line.substring(12, 14)) != null) && Atom.isValidElementSymbolNoCaseSecondChar(c2, c)) {
            return bl || c2 != 'H' ? "" + c2 + c : "H";
        }
        if ((this.htElementsInCurrentGroup == null || this.htElementsInCurrentGroup.get("" + c) != null) && Atom.isValidElementSymbol(c)) {
            return "" + c;
        }
        if ((this.htElementsInCurrentGroup == null || this.htElementsInCurrentGroup.get("" + c2) != null) && Atom.isValidElementSymbol(c2)) {
            return "" + c2;
        }
        return "Xx";
    }

    void conect() {
        int n = -1;
        n = this.parseInt(this.line, 6, 11);
        if (n < 0) {
            return;
        }
        for (int i = 0; i < 9; i += i == 5 ? 2 : 1) {
            int n2;
            int n3 = i * 5 + 11;
            int n4 = n3 + 5;
            int n5 = n2 = n4 <= this.lineLength ? this.parseInt(this.line, n3, n4) : -1;
            if (n2 < n) continue;
            this.atomSetCollection.addConnection(new int[]{n, n2, i < 4 ? 1 : 2048});
        }
    }

    void structure() {
        int n;
        int n2;
        int n3;
        int n4;
        String string = "none";
        if (this.line.startsWith("HELIX ")) {
            string = "helix";
            n4 = 19;
            n3 = 21;
            n2 = 31;
            n = 33;
        } else if (this.line.startsWith("SHEET ")) {
            string = "sheet";
            n4 = 21;
            n3 = 22;
            n2 = 32;
            n = 33;
        } else if (this.line.startsWith("TURN  ")) {
            string = "turn";
            n4 = 19;
            n3 = 20;
            n2 = 30;
            n = 31;
        } else {
            return;
        }
        if (this.lineLength < n + 4) {
            return;
        }
        char c = this.line.charAt(n4);
        int n5 = this.parseInt(this.line, n3, n3 + 4);
        char c2 = this.line.charAt(n3 + 4);
        char c3 = this.line.charAt(n2);
        int n6 = this.parseInt(this.line, n, n + 4);
        char c4 = ' ';
        if (this.lineLength > n + 4) {
            c4 = this.line.charAt(n + 4);
        }
        Structure structure = new Structure(-1, string, c, n5, c2, c3, n6, c4);
        this.atomSetCollection.addStructure(structure);
    }

    void model() {
        try {
            int n = 6;
            int n2 = 14;
            if (n2 > this.lineLength) {
                n2 = this.lineLength;
            }
            int n3 = this.parseInt(this.line, n, n2);
            this.haveMappedSerials = false;
            this.atomSetCollection.newAtomSet();
            this.atomSetCollection.setAtomSetAuxiliaryInfo("isPDB", Boolean.TRUE);
            this.atomSetCollection.setAtomSetNumber(n3);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    void cryst1() throws Exception {
        this.setUnitCell(this.getFloat(6, 9), this.getFloat(15, 9), this.getFloat(24, 9), this.getFloat(33, 7), this.getFloat(40, 7), this.getFloat(47, 7));
        this.setSpaceGroupName(AtomSetCollectionReader.parseTrimmed(this.line, 55, 66));
    }

    float getFloat(int n, int n2) throws Exception {
        return this.parseFloat(this.line, n, n + n2);
    }

    void scale(int n) throws Exception {
        int n2 = n * 4 + 2;
        this.setUnitCellItem(n2++, this.getFloat(10, 10));
        this.setUnitCellItem(n2++, this.getFloat(20, 10));
        this.setUnitCellItem(n2++, this.getFloat(30, 10));
        this.setUnitCellItem(n2++, this.getFloat(45, 10));
    }

    void expdta() {
        String string = AtomSetCollectionReader.parseTrimmed(this.line, 10).toLowerCase();
        if (string.regionMatches(true, 0, "nmr", 0, 3)) {
            this.isNMRdata = true;
        }
    }

    void formul() {
        String string;
        Hashtable<String, Boolean> hashtable;
        String string2 = this.parseToken(this.line, 12, 15);
        String string3 = AtomSetCollectionReader.parseTrimmed(this.line, 19, 70);
        int n = string3.indexOf(40);
        if (n >= 0) {
            int n2 = string3.indexOf(41);
            if (n2 < 0 || n >= n2 || n + 1 == n2) {
                return;
            }
            string3 = AtomSetCollectionReader.parseTrimmed(string3, n + 1, n2);
        }
        if ((hashtable = (Hashtable<String, Boolean>)this.htFormul.get(string2)) == null) {
            hashtable = new Hashtable<String, Boolean>();
            this.htFormul.put(string2, hashtable);
        }
        this.next[0] = 0;
        while ((string = this.parseTokenNext(string3)) != null) {
            char c;
            if (string.length() < 2) continue;
            char c2 = string.charAt(0);
            if (Atom.isValidElementSymbolNoCaseSecondChar(c2, c = string.charAt(1))) {
                hashtable.put("" + c2 + c, Boolean.TRUE);
                continue;
            }
            if (!Atom.isValidElementSymbol(c2)) continue;
            hashtable.put("" + c2, Boolean.TRUE);
        }
    }

    void het() {
        String string;
        if (this.line.length() < 30) {
            return;
        }
        if (this.htHetero == null) {
            this.htHetero = new Hashtable();
        }
        if (this.htHetero.contains(string = this.parseToken(this.line, 7, 10))) {
            return;
        }
        String string2 = AtomSetCollectionReader.parseTrimmed(this.line, 30, 70);
        this.htHetero.put(string, string2);
    }

    void hetnam() {
        if (this.htHetero == null) {
            this.htHetero = new Hashtable();
        }
        String string = this.parseToken(this.line, 11, 14);
        String string2 = AtomSetCollectionReader.parseTrimmed(this.line, 15, 70);
        if (string == null) {
            System.out.println("ERROR: HETNAM record does not contain a group name: " + this.line);
            return;
        }
        String string3 = (String)this.htHetero.get(string);
        if (string3 != null) {
            string2 = string3 + string2;
        }
        this.htHetero.put(string, string2);
    }

    void anisou() {
        int n;
        float[] fArray = new float[8];
        fArray[6] = 1.0f;
        int n2 = this.parseInt(this.line, 6, 11);
        if (this.line.substring(6, 26).equals(this.lastAtomData)) {
            n = this.lastAtomIndex;
        } else {
            if (!this.haveMappedSerials) {
                this.atomSetCollection.createAtomSerialMap();
            }
            n = this.atomSetCollection.getAtomSerialNumberIndex(n2);
            this.haveMappedSerials = true;
        }
        if (n < 0) {
            System.out.println("ERROR: ANISOU record does not correspond to known atom");
            return;
        }
        Atom atom = this.atomSetCollection.getAtom(n);
        int n3 = 28;
        int n4 = 0;
        while (n3 < 70) {
            fArray[n4] = this.parseFloat(this.line, n3, n3 + 7);
            n3 += 7;
            ++n4;
        }
        n3 = 0;
        while (n3 < 6) {
            if (Float.isNaN(fArray[n3])) {
                System.out.println("Bad ANISOU record: " + this.line);
                return;
            }
            int n5 = n3++;
            fArray[n5] = fArray[n5] / 10000.0f;
        }
        atom.anisoBorU = fArray;
    }

    private void site() {
        int n;
        String string;
        if (this.htSites == null) {
            this.htSites = new Hashtable();
        }
        int n2 = this.parseInt(this.line, 7, 10);
        int n3 = this.parseInt(this.line, 15, 17);
        String string2 = AtomSetCollectionReader.parseTrimmed(this.line, 11, 14);
        Hashtable<String, Object> hashtable = (Hashtable<String, Object>)this.htSites.get(string2);
        if (hashtable == null) {
            hashtable = new Hashtable<String, Object>();
            hashtable.put("seqNum", "site_" + n2);
            hashtable.put("nResidues", new Integer(n3));
            hashtable.put("groups", "");
            this.htSites.put(string2, hashtable);
        }
        String string3 = (String)hashtable.get("groups");
        for (int i = 0; i < 4 && (string = AtomSetCollectionReader.parseTrimmed(this.line, n = 18 + i * 11, n + 3)).length() != 0; ++i) {
            String string4 = AtomSetCollectionReader.parseTrimmed(this.line, n + 4, n + 5);
            String string5 = AtomSetCollectionReader.parseTrimmed(this.line, n + 5, n + 9);
            String string6 = AtomSetCollectionReader.parseTrimmed(this.line, n + 9, n + 10);
            string3 = string3 + (string3.length() == 0 ? "" : ",") + "[" + string + "]" + string5;
            if (string6.length() > 0) {
                string3 = string3 + "^" + string6;
            }
            if (string4.length() > 0) {
                string3 = string3 + ":" + string4;
            }
            hashtable.put("groups", string3);
        }
    }

    public void applySymmetry() throws Exception {
        if (this.needToApplySymmetry && !this.isNMRdata && this.spaceGroup.indexOf(":") < 0) {
            this.spaceGroup = this.spaceGroup + ":?";
        }
        this.atomSetCollection.setCheckSpecial(false);
        super.applySymmetry();
    }
}

