/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Bond;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.TextFormat;

public class Token {
    public int tok;
    public Object value;
    public int intValue = Integer.MAX_VALUE;
    static final int nada = 0;
    public static final int identifier = 1;
    static final int integer = 2;
    static final int decimal = 3;
    public static final int string = 4;
    static final int seqcode = 5;
    static final int list = 6;
    public static final int point3f = 7;
    public static final int point4f = 8;
    private static final int keyword = 9;
    static final String[] astrType = new String[]{"nada", "identifier", "integer", "decimal", "string", "seqcode", "list", "point", "plane", "keyword"};
    static final int command = 4096;
    static final int atomExpressionCommand = 12288;
    static final int implicitStringCommand = 20480;
    static final int mathExpressionCommand = 36864;
    static final int flowCommand = 102400;
    static final int noeval = 131072;
    static final int noArgs = 262144;
    static final int defaultON = 524288;
    static final int expression = 0x100000;
    static final int atomproperty = 0x300000;
    static final int mathproperty = 0x700000;
    static final int mathfunc = 0x900000;
    static final int mathop = 0x1100000;
    static final int predefinedset = 0x2100000;
    static final int misc = 0x4000000;
    static final int setparam = 0x8000000;
    static final int center = 12289;
    static final int define = 135278594;
    static final int delete = 12291;
    static final int display = 134230020;
    static final int hide = 12293;
    static final int restrict = 12294;
    static final int subset = 34615303;
    static final int zap = 12296;
    static final int print = 36865;
    static final int returncmd = 36866;
    static final int set = 36867;
    static final int var = 134385668;
    static final int echo = 134238209;
    static final int help = 20482;
    static final int hover = 544771;
    static final int message = 20484;
    static final int pause = 20485;
    static final int ifcmd = 102401;
    static final int elseif = 102402;
    static final int elsecmd = 364547;
    static final int endifcmd = 364548;
    static final int forcmd = 102405;
    static final int whilecmd = 102406;
    static final int breakcmd = 364551;
    static final int continuecmd = 364552;
    static final int end = 233481;
    static final int animation = 4097;
    static final int axes = 134746114;
    static final int backbone = 35131395;
    static final int background = 134221828;
    static final int bondorder = 4101;
    static final int calculate = 4102;
    static final int cartoon = 528391;
    static final int centerAt = 4104;
    static final int configuration = 4105;
    public static final int connect = 4106;
    static final int console = 528395;
    static final int delay = 528396;
    static final int depth = 528397;
    static final int dipole = 4110;
    static final int dots = 528399;
    static final int draw = 4112;
    static final int ellipsoid = 528401;
    static final int exit = 266258;
    static final int font = 4115;
    static final int frame = 4116;
    static final int frank = 134746133;
    static final int geosurface = 528406;
    static final int gotocmd = 4119;
    static final int halo = 528408;
    static final int hbond = 135794713;
    static final int history = 134221850;
    static final int initialize = 266267;
    static final int invertSelected = 4124;
    static final int isosurface = 4125;
    static final int lcaocartoon = 4126;
    static final int loop = 528415;
    static final int meshRibbon = 528416;
    static final int minimize = 4129;
    static final int mo = 4130;
    static final int monitor = 135794723;
    static final int move = 4132;
    static final int moveto = 4133;
    static final int navigate = 4134;
    static final int pmesh = 4135;
    static final int polyhedra = 4136;
    static final int quit = 266281;
    static final int ramachandran = 1052714;
    static final int refresh = 266283;
    static final int reset = 4140;
    static final int restore = 4141;
    static final int ribbon = 528430;
    static final int rocket = 528431;
    static final int rotate = 528432;
    static final int rotateSelected = 4145;
    static final int save = 4146;
    static final int selectionHalo = 134746163;
    static final int show = 4148;
    static final int slab = 528437;
    static final int spacefill = 528438;
    static final int spin = 134746167;
    static final int ssbond = 134746168;
    static final int star = 528441;
    static final int stereo = 528442;
    static final int strands = 134746171;
    static final int sync = 4156;
    static final int trace = 528445;
    static final int translate = 4158;
    static final int translateSelected = 4159;
    public static final int unitcell = 169349184;
    static final int vector = 4161;
    static final int vibration = 4162;
    static final int wireframe = 528451;
    static final int zoom = 4164;
    static final int zoomTo = 4165;
    static final int expressionBegin = 0x100001;
    static final int expressionEnd = 0x100002;
    static final int all = 0x100003;
    static final int altloc = 0x100004;
    public static final int branch = 0x100005;
    public static final int chain = 0x100006;
    static final int colon = 0x100007;
    static final int coord = 0x100008;
    static final int dollarsign = 0x100009;
    static final int dot = 0x10000A;
    public static final int group = 0x10000B;
    static final int insertion = 0x10000C;
    public static final int isaromatic = 0x10000D;
    static final int leftbrace = 0x10000E;
    static final int none = 0x10000F;
    static final int off = 0x100010;
    static final int on = 0x100011;
    static final int rightbrace = 0x100012;
    static final int semicolon = 0x100013;
    public static final int sequence = 0x100014;
    public static final int spec_alternate = 0x10001F;
    public static final int spec_atom = 0x100020;
    public static final int spec_chain = 0x100021;
    public static final int spec_model = 0x100022;
    static final int spec_model2 = 1048611;
    public static final int spec_name_pattern = 1048612;
    public static final int spec_resid = 1048613;
    public static final int spec_seqcode = 1048614;
    public static final int spec_seqcode_range = 1048615;
    static final int amino = 0x2100001;
    public static final int dna = 0x2100002;
    public static final int hetero = 168820739;
    public static final int hydrogen = 168820740;
    public static final int nucleic = 34603013;
    public static final int protein = 34603014;
    public static final int purine = 34603015;
    public static final int pyrimidine = 34603016;
    public static final int rna = 34603017;
    public static final int selected = 34603018;
    static final int solvent = 168820747;
    static final int sidechain = 34603020;
    static final int surface = 34603021;
    static final int thismodel = 34603022;
    public static final int carbohydrate = 34603029;
    static final int clickable = 34603030;
    static final int displayed = 34603031;
    static final int hidden = 34603032;
    public static final int specialposition = 34603033;
    public static final int symmetry = 34603034;
    static final int visible = 34603035;
    static final int comparator = 0x1100100;
    static final int leftparen = 0x1100000;
    static final int rightparen = 0x1100001;
    static final int comma = 0x1100010;
    static final int leftsquare = 0x1100020;
    static final int rightsquare = 0x1100021;
    static final int opOr = 0x1100030;
    static final int opXor = 0x1100031;
    static final int opToggle = 17825842;
    static final int opAnd = 0x1100040;
    static final int opNot = 0x1100050;
    static final int opGT = 0x1100160;
    static final int opGE = 0x1100161;
    static final int opLE = 17826146;
    static final int opLT = 17826147;
    public static final int opEQ = 17826148;
    static final int opNE = 17826149;
    static final int minus = 0x1100070;
    static final int plus = 0x1100071;
    static final int divide = 0x1100080;
    static final int times = 0x1100081;
    static final int percent = 17825922;
    static final int leftdivide = 17825923;
    static final int unaryMinus = 0x1100090;
    static final int propselector = 0x11000A1;
    static final int minmaxmask = 96;
    static final int min = 32;
    static final int max = 64;
    static final int comparefloatx100 = 128;
    static final int settable = 256;
    public static final int atoms = 0x700001;
    public static final int bonds = 141557762;
    static final int color = 141562115;
    static final int identify = 0x700004;
    static final int length = 0x700005;
    static final int lines = 0x700006;
    static final int size = 0x700007;
    static final int type = 0x700008;
    public static final int xyz = 7340297;
    public static final int fracXyz = 7340298;
    public static final int vibXyz = 7340299;
    static final int property = 141558028;
    public static final int boundbox = 142086157;
    public static final int adpmax = 0x70000E;
    public static final int adpmin = 0x70000F;
    public static final int atomno = 0x300001;
    static final int atomID = 0x300002;
    static final int bondcount = 0x300003;
    static final int atomIndex = 0x300004;
    public static final int cell = 0x300005;
    public static final int element = 0x300006;
    public static final int elemno = 0x300007;
    static final int file = 3149832;
    public static final int formalCharge = 137363721;
    static final int groupID = 0x30000A;
    public static final int model = 3149837;
    public static final int molecule = 0x30000E;
    public static final int occupancy = 3145999;
    static final int polymerLength = 0x300010;
    static final int radius = 137363473;
    static final int resno = 3145746;
    public static final int site = 0x300013;
    public static final int structure = 3149845;
    static final int symop = 3145750;
    public static final int vanderwaals = 3146007;
    public static final int valence = 3146008;
    public static final int atomX = 3146112;
    public static final int atomY = 3146113;
    public static final int atomZ = 3146114;
    public static final int fracX = 3146115;
    public static final int fracY = 3146116;
    public static final int fracZ = 3146117;
    public static final int partialCharge = 3146118;
    static final int phi = 3145863;
    static final int psi = 0x300088;
    public static final int straightness = 3145865;
    static final int surfacedistance = 3145866;
    public static final int temperature = 3146123;
    public static final int vibX = 3146124;
    public static final int vibY = 3146125;
    public static final int vibZ = 3146126;
    static final int function = 9670657;
    static final int array = 0x900001;
    static final int getproperty = 9441282;
    static final int write = 9441283;
    static final int load = 9441793;
    static final int substructure = 0x900202;
    static final int script = 9441795;
    static final int javascript = 9458180;
    static final int sin = 9437701;
    static final int cos = 9437702;
    static final int sqrt = 9437703;
    static final int split = 0xF00200;
    static final int join = 15729153;
    static final int trim = 0xF00202;
    static final int find = 15729155;
    static final int add = 15729156;
    static final int sub = 15729157;
    static final int mul = 15729158;
    static final int div = 15729159;
    static final int label = 150491656;
    static final int random = 9438209;
    static final int data = 9442306;
    static final int cross = 9438211;
    static final int distance = 15729665;
    static final int replace = 15729667;
    static final int select = 9451009;
    static final int angle = 9439233;
    static final int plane = 9439234;
    static final int point = 9439235;
    static final int quaternion = 9443332;
    static final int axisangle = 9439237;
    static final int within = 9439745;
    public static final int connected = 9439746;
    static final Point3f pt0 = new Point3f();
    static final int ambient = 0x8000001;
    static final int bondmode = 0x8000002;
    static final int fontsize = 0x8000003;
    static final int picking = 0x8000004;
    static final int specular = 0x8000005;
    static final int specpercent = 0x8000006;
    static final int specpower = 0x8000007;
    static final int specexponent = 0x8000008;
    static final int transparent = 0x8000009;
    static final int defaultColors = 0x800000A;
    static final int scale3d = 0x800000B;
    static final int diffuse = 0x800000C;
    static final int pickingStyle = 0x800000D;
    static final int absolute = 0x4000001;
    static final int average = 0x4000002;
    static final int babel = 0x4000004;
    static final int back = 0x4000005;
    static final int backlit = 0x4000006;
    public static final int bitset = 0x4000007;
    static final int bondset = 0x4000008;
    static final int bottom = 0x4000009;
    static final int clear = 0x400000A;
    static final int clipboard = 0x400000B;
    static final int constraint = 0x400000C;
    static final int direction = 0x400000D;
    static final int displacement = 0x400000E;
    static final int dotted = 0x400000F;
    static final int fill = 0x4000010;
    static final int fixedtemp = 0x4000011;
    static final int front = 67108882;
    static final int frontlit = 67108883;
    static final int frontonly = 0x4000014;
    static final int fullylit = 67108885;
    public static final int info = 67108985;
    static final int ionic = 67108886;
    static final int jmol = 67108887;
    static final int last = 67108888;
    static final int left = 67108889;
    static final int mep = 67108890;
    static final int mesh = 67108891;
    static final int mode = 67108892;
    static final int monomer = 67108893;
    static final int next = 67108894;
    static final int nodots = 67108895;
    static final int nofill = 0x4000020;
    static final int nomesh = 67108897;
    static final int normal = 0x4000022;
    static final int notfrontonly = 67108899;
    static final int notriangles = 0x4000024;
    static final int opaque = 67108901;
    static final int orientation = 67108902;
    static final int pdbheader = 67108903;
    static final int play = 67108904;
    static final int playrev = 67108905;
    static final int pointgroup = 67109275;
    static final int polymer = 67108906;
    static final int prev = 67108907;
    static final int range = 67108908;
    static final int rasmol = 67108909;
    public static final int residue = 67108910;
    static final int resume = 67108911;
    static final int rewind = 0x4000030;
    static final int right = 67108913;
    static final int rotation = 67108914;
    static final int rubberband = 0x4000033;
    static final int sasurface = 0x4000034;
    static final int shape = 67108917;
    static final int shapely = 67108918;
    static final int solid = 67108919;
    static final int spacegroup = 67108920;
    static final int state = 67108921;
    static final int top = 67108922;
    static final int torsion = 67108923;
    static final int transform = 67108924;
    static final int translation = 67108925;
    static final int translucent = 67108926;
    static final int triangles = 67108927;
    static final int url = 0x4000040;
    static final int user = 0x4000041;
    static final int qw = 0x4000042;
    static final Token tokenOn = new Token(0x100011, 1, "on");
    static final Token tokenOff = new Token(0x100010, 0, "off");
    static final Token tokenAll = new Token(0x100003, "all");
    public static final Token tokenAnd = new Token(0x1100040, "and");
    public static final Token tokenOr = new Token(0x1100030, "or");
    public static final Token tokenComma = new Token(0x1100010, ",");
    static final Token tokenPlus = new Token(0x1100071, "+");
    static final Token tokenMinus = new Token(0x1100070, "-");
    static final Token tokenTimes = new Token(0x1100081, "*");
    static final Token tokenDivide = new Token(0x1100080, "/");
    public static final Token tokenLeftParen = new Token(0x1100000, "(");
    public static final Token tokenRightParen = new Token(0x1100001, ")");
    static final Token tokenArraySelector = new Token(0x1100020, "[");
    public static final Token tokenExpressionBegin = new Token(0x100001, "expressionBegin");
    public static final Token tokenExpressionEnd = new Token(0x100002, "expressionEnd");
    static final Token tokenCoordinateBegin = new Token(0x10000E, "{");
    static final Token tokenCoordinateEnd = new Token(0x100012, "}");
    static final Token tokenSet = new Token(36867, 61, "");
    static final Token tokenSetArray = new Token(36867, 91, "");
    static final Token tokenSetProperty = new Token(36867, 46, "");
    static final Token tokenSetVar = new Token(36867, 61, "var");
    private static final Object[] arrayPairs = new Object[]{"animation", new Token(4097), "anim", null, "axes", new Token(134746114), "backbone", new Token(35131395), "background", new Token(134221828), "bondorder", new Token(4101), "boundbox", new Token(142086157), "break", new Token(364551), "calculate", new Token(4102), "cartoon", new Token(528391), "cartoons", null, "center", new Token(12289), "centre", null, "centerat", new Token(4104), "color", new Token(141562115), "colour", null, "configuration", new Token(4105), "conformation", null, "config", null, "connect", new Token(4106), "console", new Token(528395), "continue", new Token(364552), "data", new Token(9442306), "define", new Token(135278594), "@", null, "delay", new Token(528396), "delete", new Token(12291), "depth", new Token(528397), "dipole", new Token(4110), "dipoles", null, "display", new Token(134230020), "dots", new Token(528399), "draw", new Token(4112), "echo", new Token(134238209), "ellipsoid", new Token(528401), "ellipsoids", null, "else", new Token(364547), "elseif", new Token(102402), "end", new Token(233481), "endif", new Token(364548), "exit", new Token(266258), "file", new Token(3149832), "font", new Token(4115), "for", new Token(102405), "frame", new Token(4116), "frames", null, "frank", new Token(134746133), "function", new Token(9670657), "functions", null, "geosurface", new Token(528406), "getproperty", new Token(9441282), "goto", new Token(4119), "halo", new Token(528408), "halos", null, "hbond", new Token(135794713), "hbonds", null, "help", new Token(20482), "hide", new Token(12293), "history", new Token(134221850), "hover", new Token(544771), "if", new Token(102401), "initialize", new Token(266267), "invertSelected", new Token(4124), "isosurface", new Token(4125), "javascript", new Token(9458180), "label", new Token(150491656), "labels", null, "lcaocartoon", new Token(4126), "lcaocartoons", null, "load", new Token(9441793), "loop", new Token(528415), "measure", new Token(135794723), "measurement", null, "measurements", null, "measures", null, "monitor", null, "monitors", null, "meshribbon", new Token(528416), "meshribbons", null, "message", new Token(20484), "minimize", new Token(4129), "minimization", null, "mo", new Token(4130), "model", new Token(3149837), "models", null, "move", new Token(4132), "moveto", new Token(4133), "navigate", new Token(4134), "navigation", null, "pause", new Token(20485), "wait", null, "pmesh", new Token(4135), "polyhedra", new Token(4136), "print", new Token(36865), "quaternion", new Token(9443332), "quaternions", null, "quit", new Token(266281), "ramachandran", new Token(1052714), "rama", null, "refresh", new Token(266283), "reset", new Token(4140), "restore", new Token(4141), "restrict", new Token(12294), "return", new Token(36866), "ribbon", new Token(528430), "ribbons", null, "rocket", new Token(528431), "rockets", null, "rotate", new Token(528432), "rotateSelected", new Token(4145), "save", new Token(4146), "script", new Token(9441795), "source", null, "select", new Token(9451009), "selectionHalos", new Token(134746163), "selectionHalo", null, "set", new Token(36867), "show", new Token(4148), "slab", new Token(528437), "spacefill", new Token(528438), "cpk", null, "spin", new Token(134746167), "ssbond", new Token(134746168), "ssbonds", null, "star", new Token(528441), "stars", null, "stereo", new Token(528442), "strand", new Token(134746171), "strands", null, "structure", new Token(3149845), "_structure", null, "subset", new Token(34615303), "synchronize", new Token(4156), "sync", null, "trace", new Token(528445), "translate", new Token(4158), "translateSelected", new Token(4159), "unitcell", new Token(169349184), "var", new Token(134385668), "vector", new Token(4161), "vectors", null, "vibration", new Token(4162), "while", new Token(102406), "wireframe", new Token(528451), "write", new Token(9441283), "zap", new Token(12296), "zoom", new Token(4164), "zoomTo", new Token(4165), "bondmode", new Token(0x8000002), "bonds", new Token(141557762), "bond", null, "fontsize", new Token(0x8000003), "picking", new Token(0x8000004), "pickingStyle", new Token(0x800000D), "radius", new Token(137363473), "scale3D", new Token(0x800000B), "ambientPercent", new Token(0x8000001), "ambient", null, "diffusePercent", new Token(0x800000C), "diffuse", null, "specular", new Token(0x8000005), "specularPercent", new Token(0x8000006), "specularPower", new Token(0x8000007), "specpower", null, "specularExponent", new Token(0x8000008), "atom", new Token(0x700001), "atoms", null, "axisangle", new Token(9439237), "orientation", new Token(67108902), "pdbheader", new Token(67108903), "polymer", new Token(67108906), "polymers", null, "residue", new Token(67108910), "residues", null, "rotation", new Token(67108914), "sequence", new Token(0x100014), "shape", new Token(67108917), "state", new Token(67108921), "symmetry", new Token(34603034), "spaceGroup", new Token(67108920), "transform", new Token(67108924), "translation", new Token(67108925), "url", new Token(0x4000040), "(", tokenLeftParen, ")", tokenRightParen, "and", tokenAnd, "&", null, "&&", null, "or", tokenOr, "|", null, "||", null, ",", tokenComma, "not", new Token(0x1100050), "!", null, "xor", new Token(0x1100031), "tog", new Token(17825842), ",|", null, "<", new Token(17826147), "<=", new Token(17826146), ">=", new Token(0x1100161), ">", new Token(0x1100160), "=", new Token(17826148), "==", null, "!=", new Token(17826149), "<>", null, "/=", null, "within", new Token(9439745), ".", new Token(0x10000A), "[", new Token(0x1100020), "]", new Token(0x1100021), "{", new Token(0x10000E), "}", new Token(0x100012), "$", new Token(0x100009), "%", new Token(17825922), ":", new Token(0x100007), ";", new Token(0x100013), "+", tokenPlus, "-", tokenMinus, "*", tokenTimes, "/", tokenDivide, "\\", new Token(17825923), "absolute", new Token(0x4000001), "add", new Token(15729156), "adpmax", new Token(0x70000E), "adpmin", new Token(0x70000F), "all", tokenAll, "altloc", new Token(0x100004), "altlocs", null, "amino", new Token(0x2100001), "angle", new Token(9439233), "array", new Token(0x900001), "atomID", new Token(0x300002), "_atomID", null, "_a", null, "atomIndex", new Token(0x300004), "atomno", new Token(0x300001), "atomx", new Token(3146112), "atomy", new Token(3146113), "atomz", new Token(3146114), "average", new Token(0x4000002), "babel", new Token(0x4000004), "back", new Token(0x4000005), "backlit", new Token(0x4000006), "bondCount", new Token(0x300003), "bottom", new Token(0x4000009), "branch", new Token(0x100005), "carbohydrate", new Token(34603029), "cell", new Token(0x300005), "chain", new Token(0x100006), "chains", null, "clear", new Token(0x400000A), "clickable", new Token(34603030), "clipboard", new Token(0x400000B), "connected", new Token(9439746), "constraint", new Token(0x400000C), "coord", new Token(0x100008), "coordinates", null, "coords", null, "cos", new Token(9437702), "cross", new Token(9438211), "defaultColors", new Token(0x800000A), "direction", new Token(0x400000D), "displacement", new Token(0x400000E), "displayed", new Token(34603031), "distance", new Token(15729665), "div", new Token(15729159), "DNA", new Token(0x2100002), "dotted", new Token(0x400000F), "element", new Token(0x300006), "elemno", new Token(0x300007), "_e", null, "fill", new Token(0x4000010), "find", new Token(15729155), "fixedTemperature", new Token(0x4000011), "formalCharge", new Token(137363721), "charge", null, "front", new Token(67108882), "frontlit", new Token(67108883), "frontOnly", new Token(0x4000014), "fullylit", new Token(67108885), "fx", new Token(3146115), "fy", new Token(3146116), "fz", new Token(3146117), "fxyz", new Token(7340298), "group", new Token(0x10000B), "groups", null, "groupID", new Token(0x30000A), "_groupID", null, "_g", null, "hetero", new Token(168820739), "hidden", new Token(34603032), "hydrogen", new Token(168820740), "hydrogens", null, "identify", new Token(0x700004), "ident", null, "info", new Token(67108985), "insertion", new Token(0x10000C), "insertions", null, "ionic", new Token(67108886), "isaromatic", new Token(0x10000D), "Jmol", new Token(67108887), "join", new Token(15729153), "last", new Token(67108888), "left", new Token(67108889), "length", new Token(0x700005), "lines", new Token(0x700006), "list", new Token(6), "max", new Token(64), "mep", new Token(67108890), "mesh", new Token(67108891), "min", new Token(32), "mode", new Token(67108892), "molecule", new Token(0x30000E), "molecules", null, "monomer", new Token(67108893), "mul", new Token(15729158), "next", new Token(67108894), "noDots", new Token(67108895), "noFill", new Token(0x4000020), "noMesh", new Token(67108897), "none", new Token(0x10000F), "null", null, "inherit", null, "normal", new Token(0x4000022), "notFrontOnly", new Token(67108899), "noTriangles", new Token(0x4000024), "nucleic", new Token(34603013), "occupancy", new Token(3145999), "off", tokenOff, "false", null, "on", tokenOn, "true", null, "opaque", new Token(67108901), "partialCharge", new Token(3146118), "phi", new Token(3145863), "plane", new Token(9439234), "play", new Token(67108904), "playRev", new Token(67108905), "point", new Token(9439235), "pointGroup", new Token(67109275), "polymerLength", new Token(0x300010), "previous", new Token(67108907), "prev", null, "property", new Token(141558028), "protein", new Token(34603014), "psi", new Token(0x300088), "purine", new Token(34603015), "pyrimidine", new Token(34603016), "random", new Token(9438209), "range", new Token(67108908), "rasmol", new Token(67108909), "replace", new Token(15729667), "resno", new Token(3145746), "resume", new Token(67108911), "rewind", new Token(0x4000030), "right", new Token(67108913), "RNA", new Token(34603017), "rubberband", new Token(0x4000033), "saSurface", new Token(0x4000034), "selected", new Token(34603018), "shapely", new Token(67108918), "sidechain", new Token(34603020), "sin", new Token(9437701), "site", new Token(0x300013), "size", new Token(0x700007), "solid", new Token(67108919), "solvent", new Token(168820747), "specialPosition", new Token(34603033), "sqrt", new Token(9437703), "split", new Token(0xF00200), "straightness", new Token(3145865), "sub", new Token(15729157), "substructure", new Token(0x900202), "surface", new Token(34603021), "surfaceDistance", new Token(3145866), "symop", new Token(3145750), "temperature", new Token(3146123), "relativetemperature", null, "thisModel", new Token(34603022), "top", new Token(67108922), "torsion", new Token(67108923), "translucent", new Token(67108926), "triangles", new Token(67108927), "trim", new Token(0xF00202), "type", new Token(0x700008), "user", new Token(0x4000041), "valence", new Token(3146008), "vanderWaals", new Token(3146007), "vdw", null, "visible", new Token(34603035), "vx", new Token(3146124), "vy", new Token(3146125), "vz", new Token(3146126), "vxyz", new Token(7340299), "xyz", new Token(7340297)};
    private static Hashtable map = new Hashtable();

    public Token(int n, int n2, Object object) {
        this.tok = n;
        this.intValue = n2;
        this.value = object;
    }

    public static final Token intToken(int n) {
        return new Token(2, n);
    }

    public Token(int n) {
        this.tok = n;
    }

    public Token(int n, int n2) {
        this.tok = n;
        this.intValue = n2;
    }

    public Token(int n, Object object) {
        this.tok = n;
        this.value = object;
    }

    static int getPrecedence(int n) {
        return n >> 4 & 0xF;
    }

    static int getMaxMathParams(int n) {
        return n >> 9 & 7;
    }

    static Object oValue(Token token) {
        switch (token == null ? 0 : token.tok) {
            case 0x100011: {
                return Boolean.TRUE;
            }
            case 0: 
            case 0x100010: {
                return Boolean.FALSE;
            }
            case 2: {
                return new Integer(token.intValue);
            }
        }
        return token.value;
    }

    static Object nValue(Token token) {
        int n = 0;
        switch (token == null ? 0 : token.tok) {
            case 2: {
                n = token.intValue;
                break;
            }
            case 3: {
                return token.value;
            }
            case 4: {
                if (((String)token.value).indexOf(".") >= 0) {
                    return new Float(Token.fValue(token));
                }
                n = Token.iValue(token);
            }
        }
        return new Integer(n);
    }

    static boolean bValue(Token token) {
        switch (token == null ? 0 : token.tok) {
            case 0x100011: {
                return true;
            }
            case 0x100010: {
                return false;
            }
            case 2: {
                return token.intValue != 0;
            }
            case 3: 
            case 4: 
            case 6: {
                return Token.fValue(token) != 0.0f;
            }
            case 0x4000007: {
                return Token.iValue(token) != 0;
            }
            case 7: 
            case 8: {
                return Math.abs(Token.fValue(token)) > 1.0E-4f;
            }
        }
        return false;
    }

    static int iValue(Token token) {
        switch (token == null ? 0 : token.tok) {
            case 0x100011: {
                return 1;
            }
            case 0x100010: {
                return 0;
            }
            case 2: {
                return token.intValue;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                return (int)Token.fValue(token);
            }
            case 0x4000007: {
                return BitSetUtil.cardinalityOf((BitSet)Token.bsSelect(token));
            }
        }
        return 0;
    }

    static float fValue(Token token) {
        switch (token == null ? 0 : token.tok) {
            case 0x100011: {
                return 1.0f;
            }
            case 0x100010: {
                return 0.0f;
            }
            case 2: {
                return token.intValue;
            }
            case 3: {
                return ((Float)token.value).floatValue();
            }
            case 6: {
                int n = token.intValue;
                String[] stringArray = (String[])token.value;
                if (n == Integer.MAX_VALUE) {
                    return stringArray.length;
                }
            }
            case 4: {
                String string = Token.sValue(token);
                if (string.equalsIgnoreCase("true")) {
                    return 1.0f;
                }
                if (string.equalsIgnoreCase("false") || string.length() == 0) {
                    return 0.0f;
                }
                return Parser.parseFloatStrict((String)string);
            }
            case 0x4000007: {
                return Token.iValue(token);
            }
            case 7: {
                return ((Point3f)token.value).distance(pt0);
            }
            case 8: {
                return Graphics3D.distanceToPlane((Point4f)((Point4f)token.value), (Point3f)pt0);
            }
        }
        return 0.0f;
    }

    static String sValue(Token token) {
        if (token == null) {
            return "";
        }
        switch (token.tok) {
            case 0x100011: {
                return "true";
            }
            case 0x100010: {
                return "false";
            }
            case 2: {
                return "" + token.intValue;
            }
            case 7: {
                return Escape.escape((Tuple3f)((Point3f)token.value));
            }
            case 8: {
                return Escape.escape((Point4f)((Point4f)token.value));
            }
            case 0x4000007: {
                return Escape.escape((BitSet)Token.bsSelect(token), (!(token.value instanceof Bond.BondSet) ? 1 : 0) != 0);
            }
            case 6: {
                String[] stringArray = (String[])token.value;
                int n = token.intValue;
                if (n <= 0) {
                    n = stringArray.length - n;
                }
                if (n != Integer.MAX_VALUE) {
                    return n < 1 || n > stringArray.length ? "" : stringArray[n - 1];
                }
                StringBuffer stringBuffer = new StringBuffer();
                for (n = 0; n < stringArray.length; ++n) {
                    stringBuffer.append(stringArray[n]).append("\n");
                }
                return stringBuffer.toString();
            }
            case 4: {
                String string = (String)token.value;
                int n = token.intValue;
                if (n <= 0) {
                    n = string.length() - n;
                }
                if (n == Integer.MAX_VALUE) {
                    return string;
                }
                if (n < 1 || n > string.length()) {
                    return "";
                }
                return "" + string.charAt(n - 1);
            }
        }
        return "" + token.value;
    }

    static int sizeOf(Token token) {
        switch (token == null ? 0 : token.tok) {
            case 0x100010: 
            case 0x100011: {
                return -1;
            }
            case 2: {
                return -2;
            }
            case 3: {
                return -4;
            }
            case 7: {
                return -8;
            }
            case 8: {
                return -16;
            }
            case 4: {
                return ((String)token.value).length();
            }
            case 6: {
                return token.intValue == Integer.MAX_VALUE ? ((String[])token.value).length : Token.sizeOf(Token.selectItem(token));
            }
            case 0x4000007: {
                return BitSetUtil.cardinalityOf((BitSet)Token.bsSelect(token));
            }
        }
        return 0;
    }

    static String typeOf(Token token) {
        switch (token == null ? 0 : token.tok) {
            case 0x100010: 
            case 0x100011: {
                return "boolean";
            }
            case 2: {
                return "integer";
            }
            case 3: {
                return "decimal";
            }
            case 7: {
                return "point";
            }
            case 8: {
                return "plane";
            }
            case 4: {
                return "string";
            }
            case 6: {
                return "array";
            }
            case 0x4000007: {
                return "bitset";
            }
        }
        return "?";
    }

    static String[] concatList(Token token, Token token2) {
        int n;
        String[] stringArray = token.tok == 6 ? (String[])token.value : TextFormat.split((String)Token.sValue(token), (String)"\n");
        String[] stringArray2 = token2.tok == 6 ? (String[])token2.value : TextFormat.split((String)Token.sValue(token2), (String)"\n");
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        int n2 = 0;
        for (n = 0; n < stringArray.length; ++n) {
            stringArray3[n2++] = stringArray[n];
        }
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray3[n2++] = stringArray2[n];
        }
        return stringArray3;
    }

    static BitSet bsSelect(Token token) {
        token = Token.selectItem(token, Integer.MIN_VALUE);
        return (BitSet)token.value;
    }

    static BitSet bsSelect(Token token, int n) {
        token = Token.selectItem(token);
        token = Token.selectItem(token, 1);
        token = Token.selectItem(token, n);
        return (BitSet)token.value;
    }

    static Token selectItem(Token token) {
        return Token.selectItem(token, Integer.MIN_VALUE);
    }

    static Token selectItem(Token token, int n) {
        if (token.tok != 0x4000007 && token.tok != 6 && token.tok != 4) {
            return token;
        }
        BitSet bitSet = null;
        String[] stringArray = null;
        String string = null;
        int n2 = token.intValue;
        if (n2 == Integer.MAX_VALUE) {
            if (n == Integer.MIN_VALUE) {
                n = n2;
            }
            return new Token(token.tok, n, token.value);
        }
        int n3 = 0;
        Token token2 = new Token(token.tok, Integer.MAX_VALUE);
        switch (token.tok) {
            case 0x4000007: {
                if (token.value instanceof Bond.BondSet) {
                    token2.value = new Bond.BondSet((BitSet)token.value, ((Bond.BondSet)token.value).getAssociatedAtoms());
                    bitSet = (BitSet)token2.value;
                    n3 = BitSetUtil.cardinalityOf((BitSet)bitSet);
                    break;
                }
                bitSet = BitSetUtil.copy((BitSet)((BitSet)token.value));
                n3 = token instanceof Token2 ? 1 : BitSetUtil.cardinalityOf((BitSet)bitSet);
                token2.value = bitSet;
                break;
            }
            case 6: {
                stringArray = (String[])token.value;
                n3 = stringArray.length;
                break;
            }
            case 4: {
                string = (String)token.value;
                n3 = string.length();
            }
        }
        if (n2 <= 0) {
            n2 = n3 + n2;
        }
        if (n2 < 1) {
            n2 = 1;
        }
        if (n == 0) {
            n = n3;
        } else if (n < 0) {
            n = n3 + n;
        }
        if (n > n3) {
            n = n3;
        } else if (n < n2) {
            n = n2;
        }
        switch (token.tok) {
            case 0x4000007: {
                if (token instanceof Token2) {
                    if (n2 <= 1) break;
                    bitSet.clear();
                    break;
                }
                n3 = BitSetUtil.length((BitSet)bitSet);
                int n4 = 0;
                for (int i = 0; i < n3; ++i) {
                    if (!bitSet.get(i) || ++n4 >= n2 && n4 <= n) continue;
                    bitSet.clear(i);
                }
                break;
            }
            case 4: {
                if (n2 < 1 || n2 > n3) {
                    token2.value = "";
                    break;
                }
                token2.value = string.substring(n2 - 1, n);
                break;
            }
            case 6: {
                if (n2 < 1 || n2 > n3 || n > n3) {
                    return new Token(4, "");
                }
                if (n == n2) {
                    return Token.tValue(stringArray[n2 - 1]);
                }
                String[] stringArray2 = new String[n - n2 + 1];
                for (int i = 0; i < stringArray2.length; ++i) {
                    stringArray2[i] = stringArray[i + n2 - 1];
                }
                token2.value = stringArray2;
            }
        }
        return token2;
    }

    static Token tValue(String string) {
        Object object = Token.unescapePointOrBitsetAsToken(string);
        if (!(object instanceof String)) {
            return (Token)object;
        }
        String string2 = (String)object;
        if (string2.toLowerCase() == "true") {
            return tokenOn;
        }
        if (string2.toLowerCase() == "false") {
            return tokenOff;
        }
        float f = Parser.parseFloatStrict((String)string2);
        if (!Float.isNaN(f)) {
            return f == (float)((int)f) && string2.indexOf(".") < 0 ? Token.intToken((int)f) : new Token(3, new Float(f));
        }
        return new Token(4, object);
    }

    public static Object unescapePointOrBitsetAsToken(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        Object object = string;
        if (string.charAt(0) == '{') {
            object = Escape.unescapePoint((String)string);
        } else if (string.indexOf("({") == 0 && string.indexOf("({") == string.lastIndexOf("({")) {
            object = Escape.unescapeBitset((String)string);
        } else if (string.indexOf("[{") == 0) {
            object = new Bond.BondSet(Escape.unescapeBitset((String)string));
        }
        if (object instanceof Point3f) {
            return new Token(7, object);
        }
        if (object instanceof Point4f) {
            return new Token(8, object);
        }
        if (object instanceof BitSet) {
            return new Token(0x4000007, object);
        }
        return string;
    }

    public static void addToken(String string, Token token) {
        map.put(string, token);
    }

    public static Token getTokenFromName(String string) {
        return (Token)map.get(string);
    }

    public static String nameOf(int n) {
        Enumeration enumeration = map.elements();
        while (enumeration.hasMoreElements()) {
            Token token = (Token)enumeration.nextElement();
            if (token.tok != n) continue;
            return "" + token.value;
        }
        return "0x" + Integer.toHexString(n);
    }

    public String toString() {
        return "Token[" + astrType[this.tok <= 9 ? this.tok : 9] + "(" + this.tok % 512 + "/0x" + Integer.toHexString(this.tok) + ")" + (this.intValue == Integer.MAX_VALUE ? "" : " intValue=" + this.intValue + "(0x" + Integer.toHexString(this.intValue) + ")") + (this.value == null ? "" : (this.value instanceof String ? " value=\"" + this.value + "\"" : " value=" + this.value)) + "]";
    }

    public static String getCommandSet(String string) {
        String string2;
        String string3 = "";
        Hashtable<String, Boolean> hashtable = new Hashtable<String, Boolean>();
        int n = 0;
        String string4 = string == null || string.length() == 0 ? null : string.toLowerCase();
        boolean bl = string4 != null && string4.length() > 1;
        Enumeration enumeration = map.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            Token token = (Token)map.get(string2);
            if ((token.tok & 0x1000) == 0 || string4 != null && string2.indexOf(string4) != 0 || !bl && !((String)token.value).equals(string2)) continue;
            hashtable.put(string2, Boolean.TRUE);
        }
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            if (string2.charAt(string2.length() - 1) == 's' && hashtable.containsKey(string2.substring(0, string2.length() - 1))) continue;
            string3 = string3 + (n++ == 0 ? "" : ";") + string2;
        }
        return string3;
    }

    static {
        Token token = null;
        int n = 0;
        while (n + 1 < arrayPairs.length) {
            String string = (String)arrayPairs[n];
            String string2 = string.toLowerCase();
            Token token2 = (Token)arrayPairs[n + 1];
            if (token2 == null) {
                token2 = token;
            }
            if (token2.value == null) {
                token2.value = string;
            }
            if (map.get(string2) != null) {
                Logger.error((String)("duplicate token definition:" + string2));
            }
            map.put(string2, token2);
            token = token2;
            n += 2;
        }
    }

    public static class Token2
    extends Token {
        int intValue2;

        Token2(int n, int n2, Object object) {
            super(n, object);
            this.intValue2 = n2;
        }

        public static int bsItem2(Object object) {
            return object instanceof Token2 ? ((Token2)object).intValue2 : -1;
        }
    }
}

