/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.api.JmolStatusListener;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Viewer;

class StatusManager {
    boolean allowStatusReporting = true;
    Viewer viewer;
    JmolStatusListener jmolStatusListener;
    String statusList = "";
    Hashtable messageQueue = new Hashtable();
    int statusPtr = 0;
    static int MAXIMUM_QUEUE_LENGTH = 16;
    Hashtable htCallbacks = new Hashtable();
    int minSyncRepeatMs = 100;
    boolean drivingSync = false;
    boolean isSynced = false;
    boolean syncDisabled = false;
    static final int SYNC_OFF = 0;
    static final int SYNC_DRIVER = 1;
    static final int SYNC_SLAVE = 2;
    static final int SYNC_DISABLE = 3;
    static final int SYNC_ENABLE = 4;

    void setAllowStatusReporting(boolean bl) {
        this.allowStatusReporting = bl;
    }

    StatusManager(Viewer viewer) {
        this.viewer = viewer;
    }

    void clear() {
        this.setStatusFileLoaded(null, null, null, null, 0);
    }

    synchronized boolean resetMessageQueue(String string) {
        boolean bl = string.length() > 0 && string.charAt(0) == '-';
        boolean bl2 = string.length() > 0 && string.charAt(0) == '+';
        String string2 = this.statusList;
        if (bl) {
            this.statusList = TextFormat.simpleReplace((String)string2, (String)string.substring(1, string.length()), (String)"");
            this.messageQueue = new Hashtable();
            this.statusPtr = 0;
            return true;
        }
        if (string2.equals(string = TextFormat.simpleReplace((String)string, (String)"+", (String)"")) || bl2 && string2.indexOf(string) >= 0) {
            return false;
        }
        if (!bl2) {
            this.messageQueue = new Hashtable();
            this.statusPtr = 0;
            this.statusList = "";
        }
        this.statusList = this.statusList + string;
        if (Logger.debugging) {
            Logger.debug((String)(string2 + "\nmessageQueue = " + this.statusList));
        }
        return true;
    }

    synchronized void setJmolStatusListener(JmolStatusListener jmolStatusListener) {
        this.jmolStatusListener = jmolStatusListener;
    }

    synchronized boolean setStatusList(String string) {
        return this.resetMessageQueue(string);
    }

    synchronized void setCallbackFunction(String string, String string2) {
        if (string2 == null) {
            this.htCallbacks.remove(string.toLowerCase());
        } else if (string2.toLowerCase().indexOf("script:") == 0) {
            this.htCallbacks.put(string.toLowerCase(), string2.substring(7));
        } else if (string2.toLowerCase().indexOf("jmolscript:") == 0) {
            this.htCallbacks.put(string.toLowerCase(), string2.substring(11));
        }
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.setCallbackFunction(string, string2);
        }
    }

    String getCallbackScript(String string) {
        return (String)this.htCallbacks.get(string);
    }

    boolean notifyEnabled(int n) {
        return this.jmolStatusListener != null && this.jmolStatusListener.notifyEnabled(n);
    }

    synchronized void setStatusAtomPicked(int n, String string) {
        if (n == -1) {
            return;
        }
        Logger.info((String)("setStatusAtomPicked(" + n + "," + string + ")"));
        this.setStatusChanged("atomPicked", n, string, false);
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.notifyCallback(8, new Object[]{"", string, new Integer(n)});
        }
    }

    synchronized void setStatusResized(int n, int n2) {
        if (this.jmolStatusListener != null && this.jmolStatusListener.notifyEnabled(9)) {
            this.jmolStatusListener.notifyCallback(9, new Object[]{"", new Integer(n), new Integer(n2)});
        }
    }

    synchronized void setStatusAtomHovered(int n, String string) {
        if (this.notifyEnabled(3)) {
            this.jmolStatusListener.notifyCallback(3, new Object[]{"", string, new Integer(n)});
        }
    }

    synchronized void setStatusFileLoaded(String string, String string2, String string3, String string4, int n) {
        this.setStatusChanged("fileLoaded", n, string, false);
        if (string4 != null) {
            this.setStatusChanged("fileLoadError", n, string4, false);
        }
        if (this.jmolStatusListener != null && (n <= 0 || n == 3)) {
            this.jmolStatusListener.notifyCallback(4, new Object[]{"", string, string2, string3, string4});
        }
    }

    synchronized void setStatusFrameChanged(int n, int n2, int n3, int n4, int n5) {
        if (this.viewer.getModelSet() == null) {
            return;
        }
        boolean bl = n <= -2;
        int n6 = n;
        if (bl) {
            n6 = -2 - n6;
        }
        this.setStatusChanged("frameChanged", n, n6 >= 0 ? this.viewer.getModelNumberDotted(n6) : "", false);
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.notifyCallback(0, new Object[]{"", new int[]{n, n2, n3, n4, n5}});
        }
    }

    synchronized void setScriptEcho(String string, boolean bl) {
        if (string == null) {
            return;
        }
        this.setStatusChanged("scriptEcho", 0, string, false);
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.notifyCallback(1, new Object[]{"", string, new Integer(bl ? 1 : 0)});
        }
    }

    synchronized void setStatusMeasurePicked(int n, String string) {
        this.setStatusChanged("measurePicked", n, string, false);
        Logger.info((String)("measurePicked " + n + " " + string));
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.notifyCallback(5, new Object[]{"", string, new Integer(n)});
        }
    }

    synchronized void setStatusMeasuring(String string, int n, String string2) {
        this.setStatusChanged(string, n, string2, false);
        if (string.equals("measureCompleted")) {
            Logger.info((String)("measurement[" + n + "] = " + string2));
        }
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.notifyCallback(5, new Object[]{"", string2, new Integer(n), string});
        }
    }

    synchronized void notifyMinimizationStatus() {
        if (this.jmolStatusListener == null || !this.jmolStatusListener.notifyEnabled(7)) {
            return;
        }
        this.jmolStatusListener.notifyCallback(7, new Object[]{"", this.viewer.getParameter("_minimizationStatus"), this.viewer.getParameter("_minimizationSteps"), this.viewer.getParameter("_minimizationEnergy"), this.viewer.getParameter("_minimizationEnergyDiff")});
    }

    synchronized void setStatusScriptStarted(int n, String string) {
        this.setStatusChanged("scriptStarted", n, string, false);
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.notifyCallback(10, new Object[]{"", "script " + n + " started", string, new Integer(-2)});
        }
    }

    synchronized void setScriptStatus(String string, String string2, int n) {
        boolean bl;
        if (string == null) {
            return;
        }
        boolean bl2 = string.indexOf("ERROR:") >= 0;
        this.setStatusChanged(bl2 ? "scriptError" : "scriptStatus", 0, string, false);
        boolean bl3 = bl = string == "Script completed";
        if (bl2 || bl) {
            this.setStatusChanged("scriptTerminated", 1, "Jmol script terminated" + (bl2 ? " unsuccessfully: " + string : " successfully"), false);
        }
        if (this.jmolStatusListener != null) {
            if (bl && this.viewer.getMessageStyleChime() && this.viewer.getDebugScript()) {
                this.jmolStatusListener.notifyCallback(10, new Object[]{"", "script <exiting>", string2, new Integer(-1)});
                string = "Chime script completed.";
            }
            this.jmolStatusListener.notifyCallback(10, new Object[]{"", string, string2, new Integer(bl ? -1 : n)});
        }
    }

    synchronized void setStatusViewerRefreshed(int n, String string, boolean bl, boolean bl2) {
        if (!this.isSynced || !this.drivingSync || this.syncDisabled) {
            return;
        }
        if (bl) {
            if (n == 2) {
                this.syncSend(string, null);
            }
        } else if (bl2) {
            this.syncSend("!" + this.viewer.getMoveToText((float)this.minSyncRepeatMs / 1000.0f), null);
        }
    }

    synchronized void popupMenu(int n, int n2) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.handlePopupMenu(n, n2);
        }
    }

    void setSyncDriver(int n) {
        switch (n) {
            case 4: {
                if (!this.syncDisabled) {
                    return;
                }
                this.syncDisabled = false;
                break;
            }
            case 3: {
                this.syncDisabled = true;
                break;
            }
            case 1: {
                this.drivingSync = true;
                this.isSynced = true;
                break;
            }
            case 2: {
                this.drivingSync = false;
                this.isSynced = true;
                break;
            }
            default: {
                this.drivingSync = false;
                this.isSynced = false;
            }
        }
        if (Logger.debugging) {
            Logger.debug((String)(this.viewer.getHtmlName() + " sync mode=" + n + "; synced? " + this.isSynced + "; driving? " + this.drivingSync + "; disabled? " + this.syncDisabled));
        }
    }

    void syncSend(String string, String string2) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.notifyCallback(11, new Object[]{"", string, string2});
        }
    }

    int getSyncMode() {
        return !this.isSynced ? 0 : (this.drivingSync ? 1 : 2);
    }

    synchronized void showUrl(String string) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.showUrl(string);
        }
    }

    synchronized void clearConsole() {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.notifyCallback(6, null);
        }
    }

    synchronized void showConsole(boolean bl) {
        if (this.jmolStatusListener != null) {
            this.jmolStatusListener.showConsole(bl);
        }
    }

    synchronized void setStatusChanged(String string, int n, Object object, boolean bl) {
        Vector vector;
        if (!this.allowStatusReporting || this.statusList.length() == 0 || this.statusList != "all" && this.statusList.indexOf(string) < 0) {
            return;
        }
        ++this.statusPtr;
        Vector<Object> vector2 = new Vector<Object>();
        vector2.addElement(new Integer(this.statusPtr));
        vector2.addElement(string);
        vector2.addElement(new Integer(n));
        vector2.addElement(object);
        if (bl && this.messageQueue.containsKey(string)) {
            this.messageQueue.remove(string);
        }
        if ((vector = this.messageQueue.containsKey(string) ? (Vector)this.messageQueue.remove(string) : new Vector()).size() == MAXIMUM_QUEUE_LENGTH) {
            vector.removeElementAt(0);
        }
        vector.addElement(vector2);
        this.messageQueue.put(string, vector);
    }

    synchronized Vector getStatusChanged(String string) {
        Vector vector = new Vector();
        if (this.setStatusList(string)) {
            return vector;
        }
        Enumeration enumeration = this.messageQueue.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            vector.addElement(this.messageQueue.remove(string2));
            ++n;
        }
        return vector;
    }

    float[][] functionXY(String string, int n, int n2) {
        return this.jmolStatusListener == null ? new float[Math.abs(n)][Math.abs(n2)] : this.jmolStatusListener.functionXY(string, n, n2);
    }

    String eval(String string) {
        return this.jmolStatusListener == null ? "" : this.jmolStatusListener.eval(string);
    }

    void createImage(String string, Object object, int n) {
        if (this.jmolStatusListener == null) {
            return;
        }
        this.jmolStatusListener.createImage(string, object, n);
    }

    public Hashtable getRegistryInfo() {
        return this.jmolStatusListener == null ? null : this.jmolStatusListener.getRegistryInfo();
    }
}

