/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.modelset.Bond;
import org.jmol.modelset.ModelSet;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Token;
import org.jmol.viewer.Viewer;

public class StateManager {
    public static final int OBJ_BACKGROUND = 0;
    public static final int OBJ_AXIS1 = 1;
    public static final int OBJ_AXIS2 = 2;
    public static final int OBJ_AXIS3 = 3;
    public static final int OBJ_BOUNDBOX = 4;
    public static final int OBJ_UNITCELL = 5;
    public static final int OBJ_FRANK = 6;
    public static final int OBJ_MAX = 7;
    private static final String objectNameList = "background axis1      axis2      axis3      boundbox   unitcell   frank      ";
    Viewer viewer;
    Hashtable saved = new Hashtable();
    String lastOrientation = "";
    String lastConnections = "";
    String lastSelected = "";
    String lastState = "";
    String lastShape = "";
    String lastCoordinates = "";

    static int getObjectIdFromName(String string) {
        if (string == null) {
            return -1;
        }
        int n = objectNameList.indexOf(string.toLowerCase());
        return n < 0 ? n : n / 11;
    }

    static String getObjectNameFromId(int n) {
        if (n < 0 || n >= 7) {
            return null;
        }
        return objectNameList.substring(n * 11, n * 11 + 11).trim();
    }

    StateManager(Viewer viewer) {
        this.viewer = viewer;
    }

    GlobalSettings getGlobalSettings(GlobalSettings globalSettings) {
        GlobalSettings globalSettings2 = new GlobalSettings();
        globalSettings2.registerAllValues(globalSettings);
        return globalSettings2;
    }

    void clear() {
        this.viewer.setShowAxes(false);
        this.viewer.setShowBbcage(false);
        this.viewer.setShowUnitCell(false);
    }

    void setCrystallographicDefaults() {
        this.viewer.setAxesModeUnitCell(true);
        this.viewer.setShowAxes(true);
        this.viewer.setShowUnitCell(true);
        this.viewer.setBooleanProperty("perspectiveDepth", false);
    }

    private void setCommonDefaults() {
        this.viewer.setBooleanProperty("perspectiveDepth", true);
        this.viewer.setFloatProperty("bondTolerance", 0.45f);
        this.viewer.setFloatProperty("minBondDistance", 0.4f);
    }

    void setJmolDefaults() {
        this.setCommonDefaults();
        this.viewer.setStringProperty("defaultColorScheme", "Jmol");
        this.viewer.setBooleanProperty("axesOrientationRasmol", false);
        this.viewer.setBooleanProperty("zeroBasedXyzRasmol", false);
        this.viewer.setIntProperty("percentVdwAtom", 20);
        this.viewer.setIntProperty("bondRadiusMilliAngstroms", 150);
        this.viewer.setDefaultVdw("Jmol");
    }

    void setRasMolDefaults() {
        this.setCommonDefaults();
        this.viewer.setStringProperty("defaultColorScheme", "RasMol");
        this.viewer.setBooleanProperty("axesOrientationRasmol", true);
        this.viewer.setBooleanProperty("zeroBasedXyzRasmol", true);
        this.viewer.setIntProperty("percentVdwAtom", 0);
        this.viewer.setIntProperty("bondRadiusMilliAngstroms", 1);
        this.viewer.setDefaultVdw("Rasmol");
    }

    String getStandardLabelFormat() {
        int n = this.viewer.getModelCount();
        String string = this.viewer.getChainCount() > n ? "[%n]%r:%c.%a" : (this.viewer.getGroupCount() <= n ? "%e%i" : "[%n]%r.%a");
        if (this.viewer.getModelCount() > 1) {
            string = string + "/%M";
        }
        return string;
    }

    String listSavedStates() {
        String string = "";
        Enumeration enumeration = this.saved.keys();
        while (enumeration.hasMoreElements()) {
            string = string + "\n" + enumeration.nextElement();
        }
        return string;
    }

    void saveSelection(String string, BitSet bitSet) {
        string = this.lastSelected = "Selected_" + string;
        this.saved.put(string, BitSetUtil.copy((BitSet)bitSet));
    }

    boolean restoreSelection(String string) {
        String string2 = string.length() > 0 ? "Selected_" + string : this.lastSelected;
        BitSet bitSet = (BitSet)this.saved.get(string2);
        if (bitSet == null) {
            this.viewer.select(new BitSet(), false);
            return false;
        }
        this.viewer.select(bitSet, false);
        return true;
    }

    void saveState(String string) {
        string = this.lastState = "State_" + string;
        this.saved.put(string, this.viewer.getStateInfo());
    }

    String getSavedState(String string) {
        String string2 = string.length() > 0 ? "State_" + string : this.lastState;
        String string3 = (String)this.saved.get(string2);
        return string3 == null ? "" : string3;
    }

    void saveStructure(String string) {
        string = this.lastShape = "Shape_" + string;
        this.saved.put(string, this.viewer.getStructureState());
    }

    String getSavedStructure(String string) {
        String string2 = string.length() > 0 ? "Shape_" + string : this.lastShape;
        String string3 = (String)this.saved.get(string2);
        return string3 == null ? "" : string3;
    }

    void saveCoordinates(String string, BitSet bitSet) {
        string = this.lastCoordinates = "Coordinates_" + string;
        this.saved.put(string, this.viewer.getCoordinateState(bitSet));
    }

    String getSavedCoordinates(String string) {
        String string2 = string.length() > 0 ? "Coordinates_" + string : this.lastCoordinates;
        String string3 = (String)this.saved.get(string2);
        return string3 == null ? "" : string3;
    }

    Orientation getOrientation() {
        return new Orientation();
    }

    void saveOrientation(String string) {
        Orientation orientation = new Orientation();
        orientation.saveName = this.lastOrientation = "Orientation_" + string;
        this.saved.put(orientation.saveName, orientation);
    }

    boolean restoreOrientation(String string, float f, boolean bl) {
        String string2 = string.length() > 0 ? "Orientation_" + string : this.lastOrientation;
        Orientation orientation = (Orientation)this.saved.get(string2);
        if (orientation == null) {
            return false;
        }
        orientation.restore(f, bl);
        return true;
    }

    void saveBonds(String string) {
        Connections connections = new Connections();
        connections.saveName = this.lastConnections = "Bonds_" + string;
        this.saved.put(connections.saveName, connections);
    }

    boolean restoreBonds(String string) {
        String string2 = string.length() > 0 ? "Bonds_" + string : this.lastConnections;
        Connections connections = (Connections)this.saved.get(string2);
        if (connections == null) {
            return false;
        }
        connections.restore();
        return true;
    }

    static boolean isMeasurementUnit(String string) {
        return Parser.isOneOf((String)string.toLowerCase(), (String)"angstroms;au;bohr;nanometers;nm;picometers;pm");
    }

    public static void setStateInfo(Hashtable hashtable, int n, int n2, String string) {
        BitSet bitSet;
        if (hashtable.containsKey(string)) {
            bitSet = (BitSet)hashtable.get(string);
        } else {
            bitSet = new BitSet();
            hashtable.put(string, bitSet);
        }
        for (int i = n; i <= n2; ++i) {
            bitSet.set(i);
        }
    }

    public static String getCommands(Hashtable hashtable) {
        return StateManager.getCommands(hashtable, null, -1, "select");
    }

    public static String getCommands(Hashtable hashtable, Hashtable hashtable2, int n) {
        return StateManager.getCommands(hashtable, hashtable2, n, "select");
    }

    public static String getCommands(Hashtable hashtable, Hashtable hashtable2, int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = StateManager.getCommands(hashtable, stringBuffer, null, n, string);
        if (hashtable2 != null) {
            StateManager.getCommands(hashtable2, stringBuffer, string2, n, "select");
        }
        return stringBuffer.toString();
    }

    public static String getCommands(Hashtable hashtable, StringBuffer stringBuffer, String string, int n, String string2) {
        if (hashtable == null) {
            return "";
        }
        String string3 = "({0:" + (n - 1) + "})";
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            String string5 = Escape.escape((BitSet)((BitSet)hashtable.get(string4)));
            if (string5.length() < 5) continue;
            StringBuffer stringBuffer2 = new StringBuffer().append(string2).append(" ");
            if (string5.equals(string3)) {
                // empty if block
            }
            if (!(string5 = stringBuffer2.append(string5).toString()).equals(string)) {
                StateManager.appendCmd(stringBuffer, string5);
            }
            string = string5;
            if (string4.indexOf("-") == 0) continue;
            StateManager.appendCmd(stringBuffer, string4);
        }
        return string;
    }

    public static void appendCmd(StringBuffer stringBuffer, String string) {
        if (string.length() == 0) {
            return;
        }
        stringBuffer.append("  ").append(string).append(";\n");
    }

    class GlobalSettings {
        Hashtable listVariables = new Hashtable();
        int ambientPercent = 45;
        int diffusePercent = 84;
        boolean specular = true;
        int specularExponent = 6;
        int specularPercent = 22;
        int specularPower = 40;
        boolean allowEmbeddedScripts = true;
        boolean appendNew = true;
        String appletProxy = "";
        boolean applySymmetryToBonds = false;
        boolean autoBond = true;
        short bondRadiusMilliAngstroms = (short)150;
        float bondTolerance = 0.45f;
        String defaultLoadScript = "";
        String defaultDirectory = "";
        boolean forceAutoBond = false;
        char inlineNewlineChar = (char)124;
        String loadFormat = "http://www.rcsb.org/pdb/files/%FILE.pdb";
        float minBondDistance = 0.4f;
        boolean pdbGetHeader = false;
        boolean pdbSequential = false;
        int percentVdwAtom = 20;
        boolean smartAromatic = true;
        boolean zeroBasedXyzRasmol = false;
        private final Point3f ptDefaultLattice = new Point3f();
        boolean allowRotateSelected = false;
        boolean perspectiveDepth = true;
        int stereoDegrees = 5;
        float visualRange = 5.0f;
        boolean solventOn = false;
        String defaultAngleLabel = "%VALUE %UNITS";
        String defaultDistanceLabel = "%VALUE %UNITS";
        String defaultTorsionLabel = "%VALUE %UNITS";
        boolean justifyMeasurements = false;
        boolean measureAllModels = false;
        int minimizationSteps = 100;
        boolean minimizationRefresh = true;
        float minimizationCriterion = 0.001f;
        boolean antialiasDisplay = false;
        boolean antialiasImages = true;
        boolean antialiasTranslucent = true;
        boolean displayCellParameters = true;
        boolean dotsSelectedOnly = false;
        boolean dotSurface = true;
        boolean dynamicMeasurements = false;
        boolean greyscaleRendering = false;
        boolean isosurfacePropertySmoothing = true;
        boolean showHiddenSelectionHalos = false;
        boolean showMeasurements = true;
        boolean zoomLarge = true;
        boolean zShade = false;
        boolean bondModeOr = false;
        boolean hbondsBackbone = false;
        boolean hbondsSolid = false;
        byte modeMultipleBond = (byte)2;
        boolean showHydrogens = true;
        boolean showMultipleBonds = true;
        boolean ssbondsBackbone = false;
        boolean cartoonRockets = false;
        boolean chainCaseSensitive = false;
        int hermiteLevel = 0;
        boolean highResolutionFlag = false;
        boolean rangeSelected = false;
        boolean rasmolHydrogenSetting = true;
        boolean rasmolHeteroSetting = true;
        int ribbonAspectRatio = 16;
        boolean ribbonBorder = false;
        boolean rocketBarrels = false;
        float sheetSmoothing = 1.0f;
        boolean traceAlpha = true;
        int animationFps = 10;
        boolean autoFps = false;
        boolean axesOrientationRasmol = false;
        int axesMode = 0;
        float axesScale = 2.0f;
        float cameraDepth = 3.0f;
        String dataSeparator = "~~~";
        boolean debugScript = false;
        float defaultDrawArrowScale = 0.5f;
        float defaultTranslucent = 0.5f;
        int delayMaximumMs = 0;
        float dipoleScale = 1.0f;
        boolean disablePopupMenu = false;
        boolean drawPicking = false;
        String helpPath = "http://www.stolaf.edu/academics/chemapps/jmol/docs/index.htm";
        boolean fontScaling = false;
        boolean hideNameInPopup = false;
        int hoverDelayMs = 500;
        boolean measurementLabels = true;
        boolean messageStyleChime = false;
        int pickingSpinRate = 10;
        String pickLabel = "";
        String propertyColorScheme = "roygb";
        String quaternionFrame = "c";
        float solventProbeRadius = 1.2f;
        int scriptDelay = 0;
        boolean statusReporting = true;
        int strandCountForStrands = 5;
        int strandCountForMeshRibbon = 7;
        boolean useNumberLocalization = true;
        float vectorScale = 1.0f;
        float vibrationPeriod = 1.0f;
        float vibrationScale = 1.0f;
        boolean wireframeRotation = false;
        boolean hideNavigationPoint = false;
        boolean navigationMode = false;
        boolean navigationPeriodic = false;
        float navigationSpeed = 5.0f;
        boolean showNavigationPointAlways = false;
        String stereoState = null;
        int[] objColors = new int[7];
        boolean[] objStateOn = new boolean[7];
        int[] objMad = new int[7];
        boolean ellipsoidAxes = false;
        boolean ellipsoidDots = false;
        boolean ellipsoidArcs = false;
        boolean ellipsoidFill = false;
        boolean ellipsoidBall = true;
        int ellipsoidDotCount = 200;
        float ellipsoidAxisDiameter = 0.02f;
        boolean testFlag1 = false;
        boolean testFlag2 = false;
        boolean testFlag3 = false;
        boolean testFlag4 = false;
        private String measureDistanceUnits = "nanometers";
        Hashtable htParameterValues;
        Hashtable htPropertyFlags;
        Hashtable htPropertyFlagsRemoved;
        static final String unreportedProperties = ";ambientpercent;animationfps;antialiasdisplay;antialiasimages;antialiastranslucent;appendnew;axescolor;axesposition;axesmolecular;axesorientationrasmol;axesunitcell;axeswindow;axis1color;axis2color;axis3color;backgroundcolor;backgroundmodel;bondsymmetryatoms;boundboxcolor;cameradepth;debugscript;defaultlatttice;defaults;diffusepercent;exportdrivers;fontscaling;language;loglevel;measureStyleChime;minimizationsteps;minimizationrefresh;minimizationcriterion;navigationmode;perspectivedepth;visualrange;perspectivemodel;refreshing;rotationradius;showaxes;showaxis1;showaxis2;showaxis3;showboundbox;showfrank;showunitcell;slabenabled;specular;specularexponent;specularpercent;specularpower;stateversion;statusreporting;stereo;stereostate;unitcellcolor;windowcentered;zerobasedxyzrasmol;zoomenabled;;scriptqueue;scriptreportinglevel;syncscript;syncmouse;ambient;bonds;colorrasmol;diffuse;frank;hetero;hidenotselected;hoverlabel;hydrogen;languagetranslation;measurementunits;navigationdepth;navigationslab;picking;pickingstyle;propertycolorschemeoverload;radius;rgbblue;rgbgreen;rgbred;scaleangstromsperinch;selectionhalos;showscript;showselections;solvent;strandcount;spinx;spiny;spinz;spinfps;animframecallback;echocallback;evalcallback;loadstructcallback;measurecallback;messagecallback;minimizationcallback;hovercallback;resizecallback;pickcallback;scriptcallback;synccallback;undo;";
        Hashtable htUserVariables = new Hashtable();

        GlobalSettings() {
        }

        void clear() {
            Enumeration enumeration = this.htUserVariables.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (string.charAt(0) != '@' && !string.startsWith("site_")) continue;
                this.htUserVariables.remove(string);
            }
            this.setParameterValue("_atompicked", -1);
            this.setParameterValue("_atomhovered", -1);
            this.setParameterValue("_pickinfo", "");
            this.setParameterValue("selectionhalos", false);
            this.setParameterValue("hidenotselected", false);
            this.measurementLabels = true;
            this.setParameterValue("measurementlabels", true);
        }

        void setListVariable(String string, Token token) {
            string = string.toLowerCase();
            if (token == null) {
                this.listVariables.remove(string);
            } else {
                this.listVariables.put(string, token);
            }
        }

        Object getListVariable(String string, Object object) {
            if (string == null) {
                return object;
            }
            return this.listVariables.containsKey(string = string.toLowerCase()) ? this.listVariables.get(string) : object;
        }

        String getLoadState() {
            StringBuffer stringBuffer = new StringBuffer();
            StateManager.appendCmd(stringBuffer, "set allowEmbeddedScripts false");
            if (this.allowEmbeddedScripts) {
                this.setParameterValue("allowEmbeddedScripts", true);
            }
            StateManager.appendCmd(stringBuffer, "set autoBond " + this.autoBond);
            StateManager.appendCmd(stringBuffer, "set appendNew " + this.appendNew);
            StateManager.appendCmd(stringBuffer, "set appletProxy " + Escape.escape((String)this.appletProxy));
            StateManager.appendCmd(stringBuffer, "set applySymmetryToBonds " + this.applySymmetryToBonds);
            if (this.axesOrientationRasmol) {
                StateManager.appendCmd(stringBuffer, "set axesOrientationRasmol true");
            }
            StateManager.appendCmd(stringBuffer, "set bondRadiusMilliAngstroms " + this.bondRadiusMilliAngstroms);
            StateManager.appendCmd(stringBuffer, "set bondTolerance " + this.bondTolerance);
            StateManager.appendCmd(stringBuffer, "set defaultDirectory " + Escape.escape((String)this.defaultDirectory));
            StateManager.appendCmd(stringBuffer, "set defaultLattice " + Escape.escape((Tuple3f)this.ptDefaultLattice));
            StateManager.appendCmd(stringBuffer, "set defaultLoadScript \"\"");
            if (this.defaultLoadScript.length() > 0) {
                this.setParameterValue("defaultLoadScript", this.defaultLoadScript);
            }
            String string = StateManager.this.viewer.getDefaultVdw(Integer.MIN_VALUE);
            StateManager.appendCmd(stringBuffer, "set defaultVDW " + string);
            if (string.equals("User")) {
                StateManager.appendCmd(stringBuffer, StateManager.this.viewer.getDefaultVdw(Integer.MAX_VALUE));
            }
            StateManager.appendCmd(stringBuffer, "set forceAutoBond " + this.forceAutoBond);
            StateManager.appendCmd(stringBuffer, "set loadFormat " + Escape.escape((String)this.loadFormat));
            StateManager.appendCmd(stringBuffer, "set minBondDistance " + this.minBondDistance);
            StateManager.appendCmd(stringBuffer, "set pdbSequential " + this.pdbSequential);
            StateManager.appendCmd(stringBuffer, "set pdbGetHeader " + this.pdbGetHeader);
            StateManager.appendCmd(stringBuffer, "set percentVdwAtom " + this.percentVdwAtom);
            StateManager.appendCmd(stringBuffer, "set smartAromatic " + this.smartAromatic);
            if (this.zeroBasedXyzRasmol) {
                StateManager.appendCmd(stringBuffer, "set zeroBasedXyzRasmol true");
            }
            return stringBuffer.toString();
        }

        void setDefaultLattice(Point3f point3f) {
            this.ptDefaultLattice.set((Tuple3f)point3f);
        }

        Point3f getDefaultLatticePoint() {
            return this.ptDefaultLattice;
        }

        int[] getDefaultLatticeArray() {
            int[] nArray = new int[4];
            nArray[1] = (int)this.ptDefaultLattice.x;
            nArray[2] = (int)this.ptDefaultLattice.y;
            nArray[3] = (int)this.ptDefaultLattice.z;
            return nArray;
        }

        String getWindowState(StringBuffer stringBuffer) {
            StringBuffer stringBuffer2 = new StringBuffer();
            if (stringBuffer != null) {
                stringBuffer.append("  initialize;\n  set refreshing false;\n  _setWindowState;\n");
                stringBuffer2.append("\nfunction _setWindowState();\n");
            }
            stringBuffer2.append("# height " + StateManager.this.viewer.getScreenHeight() + ";\n# width " + StateManager.this.viewer.getScreenWidth() + ";\n");
            StateManager.appendCmd(stringBuffer2, "stateVersion = " + this.getParameter("_version"));
            for (int i = 0; i < 7; ++i) {
                if (this.objColors[i] == 0) continue;
                StateManager.appendCmd(stringBuffer2, StateManager.getObjectNameFromId(i) + "Color = \"" + Escape.escapeColor((int)this.objColors[i]) + '\"');
            }
            stringBuffer2.append(this.getSpecularState());
            if (this.stereoState != null) {
                StateManager.appendCmd(stringBuffer2, "stereo" + this.stereoState);
            }
            StateManager.appendCmd(stringBuffer2, "statusReporting  = " + this.statusReporting);
            if (stringBuffer != null) {
                stringBuffer2.append("end function;\n\n");
            }
            return stringBuffer2.toString();
        }

        String getSpecularState() {
            StringBuffer stringBuffer = new StringBuffer("");
            StateManager.appendCmd(stringBuffer, "ambientPercent = " + Graphics3D.getAmbientPercent());
            StateManager.appendCmd(stringBuffer, "diffusePercent = " + Graphics3D.getDiffusePercent());
            StateManager.appendCmd(stringBuffer, "specular = " + Graphics3D.getSpecular());
            StateManager.appendCmd(stringBuffer, "specularPercent = " + Graphics3D.getSpecularPercent());
            StateManager.appendCmd(stringBuffer, "specularPower = " + Graphics3D.getSpecularPower());
            StateManager.appendCmd(stringBuffer, "specularExponent = " + Graphics3D.getSpecularExponent());
            return stringBuffer.toString();
        }

        void setMeasureDistanceUnits(String string) {
            if (string.equalsIgnoreCase("angstroms")) {
                this.measureDistanceUnits = "angstroms";
            } else if (string.equalsIgnoreCase("nanometers") || string.equalsIgnoreCase("nm")) {
                this.measureDistanceUnits = "nanometers";
            } else if (string.equalsIgnoreCase("picometers") || string.equalsIgnoreCase("pm")) {
                this.measureDistanceUnits = "picometers";
            } else if (string.equalsIgnoreCase("bohr") || string.equalsIgnoreCase("au")) {
                this.measureDistanceUnits = "au";
            }
            this.setParameterValue("measurementUnits", this.measureDistanceUnits);
        }

        String getMeasureDistanceUnits() {
            return this.measureDistanceUnits;
        }

        boolean isJmolVariable(String string) {
            return string.charAt(0) == '_' || this.htParameterValues.containsKey(string = string.toLowerCase()) || this.htPropertyFlags.containsKey(string) || unreportedProperties.indexOf(";" + string + ";") >= 0;
        }

        private void resetParameterStringValue(String string, GlobalSettings globalSettings) {
            this.setParameterValue(string, globalSettings == null ? "" : (String)globalSettings.getParameter(string));
        }

        void setParameterValue(String string, boolean bl) {
            if (this.htParameterValues.containsKey(string = string.toLowerCase())) {
                return;
            }
            this.htPropertyFlags.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
        }

        void setParameterValue(String string, int n) {
            if (this.htPropertyFlags.containsKey(string = string.toLowerCase())) {
                return;
            }
            this.htParameterValues.put(string, new Integer(n));
        }

        void setParameterValue(String string, float f) {
            string = string.toLowerCase();
            if (Float.isNaN(f)) {
                this.htParameterValues.remove(string);
                this.htPropertyFlags.remove(string);
                return;
            }
            if (this.htPropertyFlags.containsKey(string)) {
                return;
            }
            this.htParameterValues.put(string, new Float(f));
        }

        void setParameterValue(String string, String string2) {
            string = string.toLowerCase();
            if (string2 == null || this.htPropertyFlags.containsKey(string)) {
                return;
            }
            this.htParameterValues.put(string, string2);
        }

        void removeJmolParameter(String string) {
            if (this.htPropertyFlags.containsKey(string)) {
                this.htPropertyFlags.remove(string);
                if (!this.htPropertyFlagsRemoved.containsKey(string)) {
                    this.htPropertyFlagsRemoved.put(string, Boolean.FALSE);
                }
                return;
            }
            if (this.htParameterValues.containsKey(string)) {
                this.htParameterValues.remove(string);
            }
        }

        void setUserVariable(String string, Token token) {
            string = string.toLowerCase();
            if (token == null) {
                if (string.equals("all") || string.equals("variables")) {
                    this.htUserVariables.clear();
                    Logger.info((String)"all user-defined variables deleted");
                } else if (this.htUserVariables.containsKey(string)) {
                    Logger.info((String)("variable " + string + " deleted"));
                    this.htUserVariables.remove(string);
                }
                return;
            }
            this.htUserVariables.put(string, token);
        }

        void removeUserVariable(String string) {
            this.htUserVariables.remove(string);
        }

        Object getUserParameterValue(String string) {
            return this.htUserVariables.get(string);
        }

        String getParameterEscaped(String string, int n) {
            if (this.htParameterValues.containsKey(string = string.toLowerCase())) {
                Object v = this.htParameterValues.get(string);
                String string2 = this.escapeVariable(string, v);
                if (n > 0 && string2.length() > n) {
                    string2 = string2.substring(0, n) + "\n#...(" + string2.length() + " bytes -- use SHOW " + string + " or MESSAGE @" + string + " to view)";
                }
                return string2;
            }
            if (this.htPropertyFlags.containsKey(string)) {
                return this.htPropertyFlags.get(string).toString();
            }
            if (this.htUserVariables.containsKey(string)) {
                return this.escapeUserVariable(string);
            }
            if (this.htPropertyFlagsRemoved.containsKey(string)) {
                return "false";
            }
            return "<not set>";
        }

        private String escapeUserVariable(String string) {
            Token token = (Token)this.htUserVariables.get(string);
            switch (token.tok) {
                case 0x100011: {
                    return "true";
                }
                case 0x100010: {
                    return "false";
                }
                case 2: {
                    return "" + token.intValue;
                }
            }
            return this.escapeVariable(string, token.value);
        }

        Object getParameter(String string) {
            if ((string = string.toLowerCase()).equals("_memory")) {
                Runtime runtime = Runtime.getRuntime();
                float f = (float)runtime.totalMemory() / 1000000.0f;
                float f2 = (float)runtime.freeMemory() / 1000000.0f;
                String string2 = TextFormat.formatDecimal((float)(f - f2), (int)1) + "/" + TextFormat.formatDecimal((float)f, (int)1);
                this.htParameterValues.put("_memory", string2);
            }
            if (this.htParameterValues.containsKey(string)) {
                return this.htParameterValues.get(string);
            }
            if (this.htPropertyFlags.containsKey(string)) {
                return this.htPropertyFlags.get(string);
            }
            if (this.htPropertyFlagsRemoved.containsKey(string)) {
                return Boolean.FALSE;
            }
            if (this.htUserVariables.containsKey(string)) {
                return Token.oValue((Token)this.htUserVariables.get(string));
            }
            return "";
        }

        String getAllSettings(String string) {
            String string2;
            StringBuffer stringBuffer = new StringBuffer("");
            Object[] objectArray = new String[this.htPropertyFlags.size() + this.htParameterValues.size()];
            int n = 0;
            String string3 = "_" + string;
            Enumeration enumeration = this.htPropertyFlags.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                if (string != null && string2.indexOf(string) != 0 && string2.indexOf(string3) != 0) continue;
                objectArray[n++] = (string2.indexOf("_") == 0 ? string2 + " = " : "set " + string2 + " ") + this.htPropertyFlags.get(string2);
            }
            enumeration = this.htParameterValues.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                if (string2.charAt(0) == '@' || string != null && string2.indexOf(string) != 0 && string2.indexOf(string3) != 0) continue;
                Object object = this.htParameterValues.get(string2);
                if (object instanceof String) {
                    object = Escape.escape((String)((String)object));
                }
                objectArray[n++] = (string2.indexOf("_") == 0 ? string2 + " = " : "set " + string2 + " ") + object;
            }
            Arrays.sort(objectArray, 0, n);
            for (int i = 0; i < n; ++i) {
                if (objectArray[i] == null) continue;
                StateManager.appendCmd(stringBuffer, (String)objectArray[i]);
            }
            stringBuffer.append("\n");
            return stringBuffer.toString();
        }

        String getState(StringBuffer stringBuffer) {
            int n;
            String string;
            int n2 = 0;
            Object[] objectArray = new String[this.htPropertyFlags.size() + this.htParameterValues.size()];
            StringBuffer stringBuffer2 = new StringBuffer();
            if (stringBuffer != null) {
                stringBuffer.append("  _setVariableState;\n");
                stringBuffer2.append("function _setVariableState();\n\n");
            }
            Enumeration enumeration = this.htPropertyFlags.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (!this.doReportProperty(string)) continue;
                objectArray[n2++] = "set " + string + " " + this.htPropertyFlags.get(string);
            }
            enumeration = this.htParameterValues.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = string = (String)enumeration.nextElement();
                if (string.charAt(0) == '@' || !this.doReportProperty(string)) continue;
                Object object = this.htParameterValues.get(string);
                if (string.charAt(0) == '=') {
                    string = string.substring(1);
                } else {
                    string = string.indexOf("default") == 0 ? " set " + string : "set " + string;
                    object = this.escapeVariable(string2, object);
                }
                objectArray[n2++] = string + " " + object;
            }
            switch (this.axesMode) {
                case 2: {
                    objectArray[n2++] = "set axes unitcell";
                    break;
                }
                case 0: {
                    objectArray[n2++] = "set axes window";
                    break;
                }
                default: {
                    objectArray[n2++] = "set axes molecular";
                }
            }
            enumeration = this.htParameterValues.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (string.charAt(0) != '@') continue;
                objectArray[n2++] = string + " " + this.htParameterValues.get(string);
            }
            Arrays.sort(objectArray, 0, n2);
            for (n = 0; n < n2; ++n) {
                if (objectArray[n] == null) continue;
                StateManager.appendCmd(stringBuffer2, (String)objectArray[n]);
            }
            stringBuffer2.append("\n#user-defined variables; \n");
            enumeration = this.htUserVariables.keys();
            n2 = 0;
            objectArray = new String[this.htUserVariables.size()];
            while (enumeration.hasMoreElements()) {
                int n3 = n2++;
                string = (String)enumeration.nextElement();
                objectArray[n3] = string + (string.charAt(0) == '@' ? " " + Token.sValue((Token)this.htUserVariables.get(string)) : " = " + this.escapeUserVariable(string));
            }
            Arrays.sort(objectArray, 0, n2);
            for (n = 0; n < n2; ++n) {
                if (objectArray[n] == null) continue;
                StateManager.appendCmd(stringBuffer2, (String)objectArray[n]);
            }
            if (n2 == 0) {
                stringBuffer2.append("# --none--;\n");
            }
            StateManager.this.viewer.loadShape(4);
            stringBuffer2.append(StateManager.this.viewer.getShapeProperty(4, "defaultState"));
            if (stringBuffer != null) {
                stringBuffer2.append("\nend function;\n\n");
            }
            return stringBuffer2.toString();
        }

        private boolean doReportProperty(String string) {
            return string.charAt(0) != '_' && unreportedProperties.indexOf(";" + string + ";") < 0;
        }

        private String escapeVariable(String string, Object object) {
            if (!(object instanceof String)) {
                return Escape.escape((Object)object);
            }
            Token token = (Token)this.getListVariable(string, null);
            if (token == null) {
                return Escape.escape((Object)object);
            }
            return Escape.escape((String[])((String[])token.value));
        }

        void registerAllValues(GlobalSettings globalSettings) {
            this.htParameterValues = new Hashtable();
            this.htPropertyFlags = new Hashtable();
            this.htPropertyFlagsRemoved = new Hashtable();
            if (globalSettings != null) {
                this.debugScript = globalSettings.debugScript;
                this.messageStyleChime = globalSettings.messageStyleChime;
            }
            this.resetParameterStringValue("animFrameCallback", globalSettings);
            this.resetParameterStringValue("echoCallback", globalSettings);
            this.resetParameterStringValue("evalCallback", globalSettings);
            this.resetParameterStringValue("hoverCallback", globalSettings);
            this.resetParameterStringValue("loadStructCallback", globalSettings);
            this.resetParameterStringValue("measureCallback", globalSettings);
            this.resetParameterStringValue("messageCallback", globalSettings);
            this.resetParameterStringValue("minimizationCallback", globalSettings);
            this.resetParameterStringValue("pickCallback", globalSettings);
            this.resetParameterStringValue("resizeCallback", globalSettings);
            this.resetParameterStringValue("scriptCallback", globalSettings);
            this.resetParameterStringValue("syncCallback", globalSettings);
            this.setParameterValue("hoverLabel", "");
            this.setParameterValue("rotationRadius", 0);
            this.setParameterValue("scriptqueue", true);
            this.setParameterValue("_version", 0);
            this.setParameterValue("stateversion", 0);
            this.setParameterValue("allowEmbeddedScripts", this.allowEmbeddedScripts);
            this.setParameterValue("allowRotateSelected", this.allowRotateSelected);
            this.setParameterValue("ambientPercent", this.ambientPercent);
            this.setParameterValue("animationFps", this.animationFps);
            this.setParameterValue("antialiasImages", this.antialiasImages);
            this.setParameterValue("antialiasDisplay", this.antialiasDisplay);
            this.setParameterValue("antialiasTranslucent", this.antialiasTranslucent);
            this.setParameterValue("appendNew", this.appendNew);
            this.setParameterValue("appletProxy", this.appletProxy);
            this.setParameterValue("applySymmetryToBonds", this.applySymmetryToBonds);
            this.setParameterValue("autoBond", this.autoBond);
            this.setParameterValue("autoFps", this.autoFps);
            this.setParameterValue("axesMode", this.axesMode);
            this.setParameterValue("axesScale", this.axesScale);
            this.setParameterValue("axesWindow", true);
            this.setParameterValue("axesMolecular", false);
            this.setParameterValue("axesPosition", false);
            this.setParameterValue("axesUnitcell", false);
            this.setParameterValue("axesOrientationRasmol", this.axesOrientationRasmol);
            this.setParameterValue("backgroundModel", 0);
            this.setParameterValue("bondModeOr", this.bondModeOr);
            this.setParameterValue("bondRadiusMilliAngstroms", this.bondRadiusMilliAngstroms);
            this.setParameterValue("bondTolerance", this.bondTolerance);
            this.setParameterValue("cameraDepth", this.cameraDepth);
            this.setParameterValue("cartoonRockets", this.cartoonRockets);
            this.setParameterValue("chainCaseSensitive", this.chainCaseSensitive);
            this.setParameterValue("colorRasmol", false);
            this.setParameterValue("dataSeparator", this.dataSeparator);
            this.setParameterValue("debugScript", this.debugScript);
            this.setParameterValue("defaultLattice", "{0 0 0}");
            this.setParameterValue("defaultAngleLabel", this.defaultAngleLabel);
            this.setParameterValue("defaultColorScheme", "Jmol");
            this.setParameterValue("defaultDrawArrowScale", this.defaultDrawArrowScale);
            this.setParameterValue("defaultDirectory", this.defaultDirectory);
            this.setParameterValue("defaultDistanceLabel", this.defaultDistanceLabel);
            this.setParameterValue("defaultLoadScript", this.defaultLoadScript);
            this.setParameterValue("defaults", "Jmol");
            this.setParameterValue("defaultVDW", "Jmol");
            this.setParameterValue("defaultTorsionLabel", this.defaultTorsionLabel);
            this.setParameterValue("defaultTranslucent", this.defaultTranslucent);
            this.setParameterValue("delayMaximumMs", this.delayMaximumMs);
            this.setParameterValue("diffusePercent", this.diffusePercent);
            this.setParameterValue("dipoleScale", this.dipoleScale);
            this.setParameterValue("disablePopupMenu", this.disablePopupMenu);
            this.setParameterValue("displayCellParameters", this.displayCellParameters);
            this.setParameterValue("dotsSelectedOnly", this.dotsSelectedOnly);
            this.setParameterValue("dotSurface", this.dotSurface);
            this.setParameterValue("drawHover", false);
            this.setParameterValue("drawPicking", this.drawPicking);
            this.setParameterValue("dynamicMeasurements", this.dynamicMeasurements);
            this.setParameterValue("ellipsoidArcs", this.ellipsoidArcs);
            this.setParameterValue("ellipsoidAxes", this.ellipsoidAxes);
            this.setParameterValue("ellipsoidAxisDiameter", this.ellipsoidAxisDiameter);
            this.setParameterValue("ellipsoidBall", this.ellipsoidBall);
            this.setParameterValue("ellipsoidDotCount", this.ellipsoidDotCount);
            this.setParameterValue("ellipsoidDots", this.ellipsoidDots);
            this.setParameterValue("ellipsoidFill", this.ellipsoidFill);
            this.setParameterValue("exportDrivers", "Maya;Vrml;Povray");
            this.setParameterValue("fontScaling", this.fontScaling);
            this.setParameterValue("forceAutoBond", this.forceAutoBond);
            this.setParameterValue("greyscaleRendering", this.greyscaleRendering);
            this.setParameterValue("hbondsBackbone", this.hbondsBackbone);
            this.setParameterValue("hbondsSolid", this.hbondsSolid);
            this.setParameterValue("helpPath", this.helpPath);
            this.setParameterValue("hermiteLevel", this.hermiteLevel);
            this.setParameterValue("hideNameInPopup", this.hideNameInPopup);
            this.setParameterValue("hideNavigationPoint", this.hideNavigationPoint);
            this.setParameterValue("hideNotSelected", false);
            this.setParameterValue("highResolution", this.highResolutionFlag);
            this.setParameterValue("historyLevel", 0);
            this.setParameterValue("hoverDelay", (float)this.hoverDelayMs / 1000.0f);
            this.setParameterValue("isosurfacePropertySmoothing", this.isosurfacePropertySmoothing);
            this.setParameterValue("justifyMeasurements", this.justifyMeasurements);
            this.setParameterValue("loadFormat", this.loadFormat);
            this.setParameterValue("measureAllModels", this.measureAllModels);
            this.measurementLabels = true;
            this.setParameterValue("measurementLabels", true);
            this.setParameterValue("measurementUnits", this.measureDistanceUnits);
            this.setParameterValue("messageStyleChime", this.messageStyleChime);
            this.setParameterValue("minBondDistance", this.minBondDistance);
            this.setParameterValue("minimizationSteps", this.minimizationSteps);
            this.setParameterValue("minimizationRefresh", this.minimizationRefresh);
            this.setParameterValue("minimizationCriterion", this.minimizationCriterion);
            this.setParameterValue("navigationMode", this.navigationMode);
            this.setParameterValue("navigationPeriodic", this.navigationPeriodic);
            this.setParameterValue("navigationDepth", 0);
            this.setParameterValue("navigationSlab", 0);
            this.setParameterValue("navigationSpeed", this.navigationSpeed);
            this.setParameterValue("pdbGetHeader", this.pdbGetHeader);
            this.setParameterValue("pdbSequential", this.pdbSequential);
            this.setParameterValue("perspectiveModel", 11);
            this.setParameterValue("perspectiveDepth", this.perspectiveDepth);
            this.setParameterValue("percentVdwAtom", this.percentVdwAtom);
            this.setParameterValue("picking", "ident");
            this.setParameterValue("pickingSpinRate", this.pickingSpinRate);
            this.setParameterValue("pickingStyle", "toggle");
            this.setParameterValue("pickLabel", this.pickLabel);
            this.setParameterValue("propertyColorScheme", this.propertyColorScheme);
            this.setParameterValue("propertyDataField", 0);
            this.setParameterValue("propertyAtomNumberField", 0);
            this.setParameterValue("quaternionFrame", this.quaternionFrame);
            this.setParameterValue("rangeSelected", this.rangeSelected);
            this.setParameterValue("refreshing", true);
            this.setParameterValue("ribbonAspectRatio", this.ribbonAspectRatio);
            this.setParameterValue("ribbonBorder", this.ribbonBorder);
            this.setParameterValue("rocketBarrels", this.rocketBarrels);
            this.setParameterValue("scaleAngstromsPerInch", 0);
            this.setParameterValue("scriptReportingLevel", 0);
            this.setParameterValue("selectionHalos", false);
            this.setParameterValue("selectHetero", this.rasmolHeteroSetting);
            this.setParameterValue("selectHydrogen", this.rasmolHydrogenSetting);
            this.setParameterValue("sheetSmoothing", this.sheetSmoothing);
            this.setParameterValue("showaxes", false);
            this.setParameterValue("showboundbox", false);
            this.setParameterValue("showfrank", false);
            this.setParameterValue("showHiddenSelectionHalos", this.showHiddenSelectionHalos);
            this.setParameterValue("showHydrogens", this.showHydrogens);
            this.setParameterValue("showMeasurements", this.showMeasurements);
            this.setParameterValue("showMultipleBonds", this.showMultipleBonds);
            this.setParameterValue("showNavigationPointAlways", this.showNavigationPointAlways);
            this.setParameterValue("showScript", this.scriptDelay);
            this.setParameterValue("showUnitcell", false);
            this.setParameterValue("slabEnabled", false);
            this.setParameterValue("smartAromatic", this.smartAromatic);
            this.setParameterValue("solventProbe", this.solventOn);
            this.setParameterValue("solventProbeRadius", this.solventProbeRadius);
            this.setParameterValue("specular", this.specular);
            this.setParameterValue("specularExponent", this.specularExponent);
            this.setParameterValue("specularPercent", this.specularPercent);
            this.setParameterValue("specularPower", this.specularPower);
            this.setParameterValue("spinX", 0);
            this.setParameterValue("spinY", 30);
            this.setParameterValue("spinZ", 0);
            this.setParameterValue("spinFps", 30);
            this.setParameterValue("ssbondsBackbone", this.ssbondsBackbone);
            this.setParameterValue("stereoDegrees", this.stereoDegrees);
            this.setParameterValue("statusReporting", this.statusReporting);
            this.setParameterValue("strandCount", this.strandCountForStrands);
            this.setParameterValue("strandCountForStrands", this.strandCountForStrands);
            this.setParameterValue("strandCountForMeshRibbon", this.strandCountForMeshRibbon);
            this.setParameterValue("syncMouse", false);
            this.setParameterValue("syncScript", false);
            this.setParameterValue("testFlag1", this.testFlag1);
            this.setParameterValue("testFlag2", this.testFlag2);
            this.setParameterValue("testFlag3", this.testFlag3);
            this.setParameterValue("testFlag4", this.testFlag4);
            this.setParameterValue("traceAlpha", this.traceAlpha);
            this.setParameterValue("undo", true);
            this.setParameterValue("useNumberLocalization", this.useNumberLocalization);
            this.setParameterValue("vectorScale", this.vectorScale);
            this.setParameterValue("vibrationPeriod", this.vibrationPeriod);
            this.setParameterValue("vibrationScale", this.vibrationScale);
            this.setParameterValue("visualRange", this.visualRange);
            this.setParameterValue("windowCentered", true);
            this.setParameterValue("wireframeRotation", this.wireframeRotation);
            this.setParameterValue("zoomEnabled", true);
            this.setParameterValue("zoomLarge", this.zoomLarge);
            this.setParameterValue("zShade", this.zShade);
            this.setParameterValue("zeroBasedXyzRasmol", this.zeroBasedXyzRasmol);
        }
    }

    static class Connection {
        int atomIndex1;
        int atomIndex2;
        short mad;
        short colix;
        short order;
        int shapeVisibilityFlags;

        Connection(int n, int n2, short s, short s2, short s3, int n3) {
            this.atomIndex1 = n;
            this.atomIndex2 = n2;
            this.mad = s;
            this.colix = s2;
            this.order = s3;
            this.shapeVisibilityFlags = n3;
        }
    }

    class Connections {
        String saveName;
        int bondCount;
        Connection[] connections;

        Connections() {
            ModelSet modelSet = StateManager.this.viewer.getModelSet();
            if (modelSet == null) {
                return;
            }
            this.bondCount = modelSet.getBondCount();
            this.connections = new Connection[this.bondCount + 1];
            Bond[] bondArray = modelSet.getBonds();
            int n = this.bondCount;
            while (--n >= 0) {
                Bond bond = bondArray[n];
                this.connections[n] = new Connection(bond.getAtomIndex1(), bond.getAtomIndex2(), bond.getMad(), bond.getColix(), bond.getOrder(), bond.getShapeVisibilityFlags());
            }
        }

        void restore() {
            ModelSet modelSet = StateManager.this.viewer.getModelSet();
            if (modelSet == null) {
                return;
            }
            modelSet.deleteAllBonds();
            int n = this.bondCount;
            while (--n >= 0) {
                Connection connection = this.connections[n];
                int n2 = modelSet.getAtomCount();
                if (connection.atomIndex1 >= n2 || connection.atomIndex2 >= n2) continue;
                Bond bond = modelSet.bondAtoms(modelSet.atoms[connection.atomIndex1], modelSet.atoms[connection.atomIndex2], connection.order, connection.mad, null);
                bond.setColix(connection.colix);
                bond.setShapeVisibilityFlags(connection.shapeVisibilityFlags);
            }
            n = this.bondCount;
            while (--n >= 0) {
                modelSet.getBondAt(n).setIndex(n);
            }
            StateManager.this.viewer.setShapeProperty(1, "reportAll", null);
        }
    }

    public class Orientation {
        String saveName;
        Matrix3f rotationMatrix = new Matrix3f();
        float xTrans;
        float yTrans;
        float zoom;
        float rotationRadius;
        Point3f center = new Point3f();
        Point3f navCenter = new Point3f();
        float xNav = Float.NaN;
        float yNav = Float.NaN;
        float navDepth = Float.NaN;
        boolean windowCenteredFlag;
        boolean navigationMode;
        String moveToText;

        Orientation() {
            StateManager.this.viewer.getRotation(this.rotationMatrix);
            this.xTrans = StateManager.this.viewer.getTranslationXPercent();
            this.yTrans = StateManager.this.viewer.getTranslationYPercent();
            this.zoom = StateManager.this.viewer.getZoomSetting();
            this.center.set((Tuple3f)StateManager.this.viewer.getRotationCenter());
            this.windowCenteredFlag = StateManager.this.viewer.isWindowCentered();
            this.rotationRadius = StateManager.this.viewer.getRotationRadius();
            this.navigationMode = StateManager.this.viewer.getNavigationMode();
            this.moveToText = StateManager.this.viewer.getMoveToText(-1.0f);
            if (this.navigationMode) {
                this.navCenter = StateManager.this.viewer.getNavigationOffset();
                this.xNav = StateManager.this.viewer.getNavigationOffsetPercent('X');
                this.yNav = StateManager.this.viewer.getNavigationOffsetPercent('Y');
                this.navDepth = StateManager.this.viewer.getNavigationDepthPercent();
                this.navCenter = StateManager.this.viewer.getNavigationCenter();
            }
        }

        public String getMoveToText() {
            return this.moveToText;
        }

        void restore(float f, boolean bl) {
            if (!bl) {
                StateManager.this.viewer.moveTo(f, this.rotationMatrix, null, Float.NaN, Float.NaN, Float.NaN, Float.NaN, null, Float.NaN, Float.NaN, Float.NaN);
                return;
            }
            StateManager.this.viewer.setBooleanProperty("windowCentered", this.windowCenteredFlag);
            StateManager.this.viewer.setBooleanProperty("navigationMode", this.navigationMode);
            StateManager.this.viewer.moveTo(f, this.rotationMatrix, this.center, this.zoom, this.xTrans, this.yTrans, this.rotationRadius, this.navCenter, this.xNav, this.yNav, this.navDepth);
        }
    }
}

