/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.api.MinimizerInterface;
import org.jmol.api.SmilesMatcherInterface;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.i18n.GT;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomCollection;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BoxInfo;
import org.jmol.modelset.Group;
import org.jmol.modelset.ModelCollection;
import org.jmol.modelset.ModelSet;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.Parser;
import org.jmol.util.Quaternion;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Compiler;
import org.jmol.viewer.Function;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.PropertyManager;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Token;
import org.jmol.viewer.Viewer;

class Eval {
    private static final int scriptLevelMax = 10;
    private Compiler compiler;
    private int scriptLevel;
    private int scriptReportingLevel = 0;
    private Context[] stack = new Context[10];
    private String filename;
    private String functionName;
    private String script;
    private Hashtable contextVariables;
    private boolean isStateScript;
    private String thisCommand;
    private String fullCommand;
    private short[] lineNumbers;
    private int[] lineIndices;
    private Token[][] aatoken;
    private int pc;
    private int lineEnd;
    private int pcEnd;
    private long timeBeginExecution;
    private long timeEndExecution;
    private boolean error;
    private String errorMessage;
    private Token[] statement;
    private int statementLength;
    private BitSet bsSubset;
    boolean isScriptCheck;
    private boolean historyDisabled;
    private boolean tQuiet;
    private boolean debugScript = false;
    private boolean fileOpenCheck = true;
    boolean logMessages;
    boolean isSyntaxCheck;
    Viewer viewer;
    int iToken;
    private Hashtable variables;
    private StringBuffer outputBuffer;
    private static final String EXPRESSION_KEY = "e_x_p_r_e_s_s_i_o_n";
    private Boolean interruptExecution = Boolean.FALSE;
    private Boolean executionPaused = Boolean.FALSE;
    private boolean isExecuting = false;
    private Thread currentThread = null;
    private int commandHistoryLevelMax = 0;
    boolean isForCheck = false;
    private final StringBuffer strbufLog = new StringBuffer(80);
    private Token[] tempStatement;
    private boolean isBondSet;
    private Object expressionResult;
    private boolean coordinatesAreFractional;
    private int theTok;
    private Token theToken;
    private Object[] data;
    private int lastMoNumber = 0;
    private boolean ignoreError;
    static final int ERROR_axisExpected = 0;
    static final int ERROR_badArgumentCount = 1;
    static final int ERROR_badMillerIndices = 2;
    static final int ERROR_badRGBColor = 3;
    static final int ERROR_booleanExpected = 4;
    static final int ERROR_booleanOrNumberExpected = 5;
    static final int ERROR_booleanOrWhateverExpected = 6;
    static final int ERROR_colorExpected = 7;
    static final int ERROR_colorOrPaletteRequired = 8;
    static final int ERROR_coordinateOrNameOrExpressionRequired = 9;
    static final int ERROR_drawObjectNotDefined = 10;
    static final int ERROR_endOfStatementUnexpected = 11;
    static final int ERROR_expressionExpected = 12;
    static final int ERROR_expressionOrIntegerExpected = 13;
    static final int ERROR_filenameExpected = 14;
    static final int ERROR_fileNotFoundException = 15;
    static final int ERROR_incompatibleArguments = 16;
    static final int ERROR_insufficientArguments = 17;
    static final int ERROR_integerExpected = 18;
    static final int ERROR_integerOutOfRange = 19;
    static final int ERROR_invalidArgument = 20;
    static final int ERROR_invalidParameterOrder = 21;
    static final int ERROR_keywordExpected = 22;
    static final int ERROR_multipleModelsNotOK = 23;
    static final int ERROR_noUnitCell = 24;
    static final int ERROR_numberExpected = 25;
    static final int ERROR_numberMustBe = 26;
    static final int ERROR_numberOutOfRange = 27;
    static final int ERROR_objectNameExpected = 28;
    static final int ERROR_propertyNameExpected = 29;
    static final int ERROR_spaceGroupNotFound = 30;
    static final int ERROR_stringExpected = 31;
    static final int ERROR_stringOrIdentifierExpected = 32;
    static final int ERROR_tooManyScriptLevels = 33;
    static final int ERROR_unrecognizedAtomProperty = 34;
    static final int ERROR_unrecognizedBondProperty = 35;
    static final int ERROR_unrecognizedCommand = 36;
    static final int ERROR_unrecognizedExpression = 37;
    static final int ERROR_unrecognizedObject = 38;
    static final int ERROR_unrecognizedParameter = 39;
    static final int ERROR_unrecognizedParameterWarning = 40;
    static final int ERROR_unrecognizedShowParameter = 41;
    static final int ERROR_what = 42;
    static final String[] errors = new String[]{GT._((String)"x y z axis expected"), GT._((String)"bad argument count"), GT._((String)"Miller indices cannot all be zero."), GT._((String)"bad [R,G,B] color"), GT._((String)"boolean expected"), GT._((String)"boolean or number expected"), GT._((String)"boolean, number, or {0} expected"), GT._((String)"color expected"), GT._((String)"a color or palette name (Jmol, Rasmol) is required"), GT._((String)" {x y z} or $name or (atom expression) required"), GT._((String)"draw object not defined"), GT._((String)"unexpected end of script command"), GT._((String)"valid (atom expression) expected"), GT._((String)"(atom expression) or integer expected"), GT._((String)"filename expected"), GT._((String)"file not found"), GT._((String)"incompatible arguments"), GT._((String)"insufficient arguments"), GT._((String)"integer expected"), GT._((String)"integer out of range ({0} - {1})"), GT._((String)"invalid argument"), GT._((String)"invalid parameter order"), GT._((String)"keyword expected"), GT._((String)"{0} require that only one model be displayed"), GT._((String)"No unit cell"), GT._((String)"number expected"), GT._((String)"number must be ({0} or {1})"), GT._((String)"decimal number out of range ({0} - {1})"), GT._((String)"object name expected after '$'"), GT._((String)"property name expected"), GT._((String)"space group {0} was not found."), GT._((String)"quoted string expected"), GT._((String)"quoted string or identifier expected"), GT._((String)"too many script levels"), GT._((String)"unrecognized atom property"), GT._((String)"unrecognized bond property"), GT._((String)"unrecognized command"), GT._((String)"runtime unrecognized expression"), GT._((String)"unrecognized object"), GT._((String)"unrecognized {0} parameter"), GT._((String)"unrecognized {0} parameter in Jmol state script (set anyway)"), GT._((String)"unrecognized SHOW parameter --  use {0}"), "{0}"};
    static final String SCRIPT_COMPLETED = "Script completed";

    String getScript() {
        return this.script;
    }

    Eval(Viewer viewer) {
        this.compiler = viewer.getCompiler();
        this.viewer = viewer;
        this.variables = viewer.getEvalVariables();
        if (this.variables.isEmpty()) {
            this.clearDefinitionsAndLoadPredefined();
        }
    }

    private Object getParameter(String string, boolean bl) {
        Token token = this.getContextVariableAsToken(string);
        return token == null ? this.viewer.getParameter(string) : (bl ? token : Token.oValue(token));
    }

    private Object getNumericParameter(String string) {
        Token token = this.getContextVariableAsToken(string);
        if (token == null) {
            Object object = this.viewer.getParameter(string);
            if (!(object instanceof String)) {
                return object;
            }
            token = new Token(4, object);
        }
        return Token.nValue(token);
    }

    private Token getContextVariableAsToken(String string) {
        if (string.equals("expressionBegin")) {
            return null;
        }
        if (this.contextVariables != null && this.contextVariables.containsKey(string)) {
            return (Token)this.contextVariables.get(string);
        }
        int n = this.scriptLevel;
        while (--n >= 0) {
            if (this.stack[n].contextVariables == null || !this.stack[n].contextVariables.containsKey(string)) continue;
            return (Token)this.stack[n].contextVariables.get(string);
        }
        return null;
    }

    private String getParameterEscaped(String string) {
        Token token = this.getContextVariableAsToken(string);
        return token == null ? "" + this.viewer.getParameterEscaped(string) : Escape.escape((Object)token.value);
    }

    String getState() {
        return this.getFunctionCalls("");
    }

    static Object evaluateExpression(Viewer viewer, Object object) {
        Eval eval = new Eval(viewer);
        try {
            if (object instanceof String) {
                if (eval.loadScript(null, "e_x_p_r_e_s_s_i_o_n = " + object, false)) {
                    eval.setStatement(0);
                    return eval.parameterExpression(2, 0, "", false);
                }
            } else if (object instanceof Token[]) {
                return eval.expression((Token[])object, 0, 0, true, false, true, false);
            }
        }
        catch (Exception exception) {
            Logger.error((String)("Error evaluating: " + object + "\n" + exception));
        }
        return "ERROR";
    }

    static BitSet getAtomBitSet(Eval eval, Viewer viewer, Object object) {
        if (object instanceof BitSet) {
            return (BitSet)object;
        }
        if (eval == null) {
            eval = new Eval(viewer);
        }
        BitSet bitSet = new BitSet();
        try {
            eval.pushContext(null);
            String string = "select (" + object + ")";
            string = TextFormat.replaceAllCharacters((String)string, (String)"\n\r", (String)"),(");
            string = TextFormat.simpleReplace((String)string, (String)"()", (String)"(none)");
            if (eval.loadScript(null, string, false)) {
                eval.statement = eval.aatoken[0];
                bitSet = eval.expression(eval.statement, 1, 0, false, false, true, true);
            }
            eval.popContext();
        }
        catch (Exception exception) {
            Logger.error((String)("getAtomBitSet " + object + "\n" + exception));
        }
        return bitSet;
    }

    static Vector getAtomBitSetVector(Eval eval, Viewer viewer, Object object) {
        Vector<Integer> vector = new Vector<Integer>();
        BitSet bitSet = Eval.getAtomBitSet(eval, viewer, object);
        int n = viewer.getAtomCount();
        for (int i = 0; i < n; ++i) {
            if (!bitSet.get(i)) continue;
            vector.addElement(new Integer(i));
        }
        return vector;
    }

    void haltExecution() {
        this.resumePausedExecution();
        this.interruptExecution = Boolean.TRUE;
    }

    boolean isScriptExecuting() {
        return this.isExecuting && this.interruptExecution == false;
    }

    void runEval(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        boolean bl5 = this.fileOpenCheck;
        this.fileOpenCheck = bl2;
        this.viewer.pushHoldRepaint();
        this.interruptExecution = Boolean.FALSE;
        this.executionPaused = Boolean.FALSE;
        this.isExecuting = true;
        this.currentThread = Thread.currentThread();
        this.isSyntaxCheck = this.isScriptCheck = bl;
        this.timeBeginExecution = System.currentTimeMillis();
        this.historyDisabled = bl3;
        try {
            this.instructionDispatchLoop(bl4);
            String string = this.viewer.getInterruptScript();
            if (string != "") {
                this.runScript(string, null);
            }
        }
        catch (ScriptException scriptException) {
            if (this.error) {
                this.error = true;
            }
            this.setErrorMessage(scriptException.toString());
            this.scriptStatus(this.errorMessage);
        }
        this.timeEndExecution = System.currentTimeMillis();
        this.fileOpenCheck = bl5;
        if (this.errorMessage == null && this.interruptExecution.booleanValue()) {
            this.errorMessage = "execution interrupted";
        } else if (!this.tQuiet && !this.isSyntaxCheck) {
            this.viewer.scriptStatus(SCRIPT_COMPLETED);
        }
        bl3 = false;
        this.isScriptCheck = false;
        this.isSyntaxCheck = false;
        this.isExecuting = false;
        this.viewer.setTainted(true);
        this.viewer.popHoldRepaint();
    }

    String getErrorMessage() {
        return this.errorMessage;
    }

    private void setErrorMessage(String string) {
        if (this.errorMessage == null) {
            this.errorMessage = GT._((String)"script ERROR: ");
        }
        this.errorMessage = this.errorMessage + string;
    }

    int getExecutionWalltime() {
        return (int)(this.timeEndExecution - this.timeBeginExecution);
    }

    private void runScript(String string) throws ScriptException {
        this.runScript(string, null);
    }

    void runScript(String string, StringBuffer stringBuffer) throws ScriptException {
        this.pushContext(null);
        if (stringBuffer != null) {
            this.outputBuffer = stringBuffer;
        }
        if (this.loadScript(null, string, false)) {
            this.instructionDispatchLoop(false);
        }
        this.popContext();
    }

    private void pushContext(Function function) throws ScriptException {
        if (this.scriptLevel == 10) {
            this.error(33);
        }
        Context context = new Context();
        context.filename = this.filename;
        context.functionName = this.functionName;
        context.script = this.script;
        context.lineNumbers = this.lineNumbers;
        context.lineIndices = this.lineIndices;
        context.aatoken = this.aatoken;
        context.statement = this.statement;
        context.statementLength = this.statementLength;
        context.pc = this.pc;
        context.lineEnd = this.lineEnd;
        context.pcEnd = this.pcEnd;
        context.iToken = this.iToken;
        context.outputBuffer = this.outputBuffer;
        context.contextVariables = this.contextVariables;
        context.isStateScript = this.isStateScript;
        this.stack[this.scriptLevel++] = context;
        if (this.isScriptCheck) {
            Logger.info((String)("-->>-------------".substring(0, this.scriptLevel + 5) + this.filename));
        }
    }

    private void popContext() {
        if (this.isScriptCheck) {
            Logger.info((String)("--<<-------------".substring(0, this.scriptLevel + 5) + this.filename));
        }
        if (this.scriptLevel == 0) {
            return;
        }
        Context context = this.stack[--this.scriptLevel];
        this.stack[this.scriptLevel] = null;
        this.filename = context.filename;
        this.functionName = context.functionName;
        this.script = context.script;
        this.lineNumbers = context.lineNumbers;
        this.lineIndices = context.lineIndices;
        this.aatoken = context.aatoken;
        this.statement = context.statement;
        this.statementLength = context.statementLength;
        this.pc = context.pc;
        this.lineEnd = context.lineEnd;
        this.pcEnd = context.pcEnd;
        this.iToken = context.iToken;
        this.outputBuffer = context.outputBuffer;
        this.contextVariables = context.contextVariables;
        this.isStateScript = context.isStateScript;
    }

    private boolean loadScript(String string, String string2, boolean bl) {
        this.filename = string;
        if (!this.compiler.compile(string, string2, false, false, bl, false)) {
            this.error = true;
            this.errorMessage = this.compiler.getErrorMessage();
            return false;
        }
        this.script = this.compiler.getScript();
        this.pc = 0;
        this.aatoken = this.compiler.getAatokenCompiled();
        this.lineNumbers = this.compiler.getLineNumbers();
        this.lineIndices = this.compiler.getLineIndices();
        this.contextVariables = this.compiler.getContextVariables();
        this.isStateScript = string2.indexOf("# Jmol state version ") >= 0;
        return true;
    }

    private Function getFunction(String string) {
        if (string == null) {
            return null;
        }
        Function function = (Function)(string.indexOf("_") == 0 ? this.compiler.localFunctions : Compiler.globalFunctions).get(string);
        return function == null || function.aatoken == null ? null : function;
    }

    private boolean loadFunction(String string, Vector vector) {
        Function function = this.getFunction(string);
        if (function == null) {
            return false;
        }
        this.aatoken = function.aatoken;
        this.lineNumbers = function.lineNumbers;
        this.lineIndices = function.lineIndices;
        this.script = function.script;
        this.pc = 0;
        if (function.names != null) {
            this.contextVariables = new Hashtable();
            function.setVariables(this.contextVariables, vector);
        }
        this.functionName = string;
        return true;
    }

    Token getFunctionReturn(String string, Vector vector) throws ScriptException {
        this.pushContext(null);
        this.loadFunction(string, vector);
        this.instructionDispatchLoop(false);
        Token token = this.getContextVariableAsToken("_retval");
        this.popContext();
        return token;
    }

    Object checkScriptSilent(String string) {
        if (!this.compiler.compile(null, string, false, true, false, true)) {
            return this.compiler.getErrorMessage();
        }
        this.isSyntaxCheck = true;
        this.isScriptCheck = false;
        this.errorMessage = null;
        this.script = this.compiler.getScript();
        this.pc = 0;
        this.aatoken = this.compiler.getAatokenCompiled();
        this.lineNumbers = this.compiler.getLineNumbers();
        this.lineIndices = this.compiler.getLineIndices();
        this.contextVariables = this.compiler.getContextVariables();
        try {
            this.instructionDispatchLoop(false);
        }
        catch (ScriptException scriptException) {
            this.setErrorMessage(scriptException.toString());
        }
        this.isSyntaxCheck = false;
        if (this.errorMessage != null) {
            return this.errorMessage;
        }
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(this.compiler.getScript());
        vector.addElement(this.compiler.getAatokenCompiled());
        vector.addElement(this.compiler.getLineNumbers());
        vector.addElement(this.compiler.getLineIndices());
        return vector;
    }

    private void clearState(boolean bl) {
        int n = 10;
        while (--n >= 0) {
            this.stack[n] = null;
        }
        this.scriptLevel = 0;
        this.error = false;
        this.errorMessage = null;
        this.tQuiet = bl;
    }

    boolean loadScriptString(String string, boolean bl) {
        this.clearState(bl);
        return this.loadScript(null, string, this.debugScript);
    }

    boolean loadScriptFile(String string, boolean bl) {
        this.clearState(bl);
        return this.loadScriptFileInternal(string);
    }

    private boolean loadScriptFileInternal(String string) {
        if (string.toLowerCase().indexOf("javascript:") == 0) {
            return this.loadScript(string, this.viewer.eval(string.substring(11)), this.debugScript);
        }
        Object object = this.viewer.getBufferedReaderOrErrorMessageFromName(string, null, false);
        if (!(object instanceof BufferedReader)) {
            return this.loadError((String)object);
        }
        BufferedReader bufferedReader = (BufferedReader)object;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuffer.append(string2);
                stringBuffer.append("\n");
            }
        }
        catch (IOException iOException) {
            try {
                bufferedReader.close();
                bufferedReader = null;
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            return this.ioError(string);
        }
        try {
            bufferedReader.close();
            bufferedReader = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.loadScript(string, stringBuffer.toString(), this.debugScript);
    }

    private boolean loadError(String string) {
        this.error = true;
        this.errorMessage = string;
        return false;
    }

    private boolean ioError(String string) {
        return this.loadError("io error reading:" + string);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Eval\n pc:");
        stringBuffer.append(this.pc);
        stringBuffer.append("\n");
        stringBuffer.append(this.aatoken.length);
        stringBuffer.append(" statements\n");
        for (int i = 0; i < this.aatoken.length; ++i) {
            stringBuffer.append("----\n");
            Token[] tokenArray = this.aatoken[i];
            for (int j = 0; j < tokenArray.length; ++j) {
                stringBuffer.append(tokenArray[j]);
                stringBuffer.append('\n');
            }
            stringBuffer.append('\n');
        }
        stringBuffer.append("END\n");
        return stringBuffer.toString();
    }

    private void clearPredefined(String[] stringArray) {
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            this.predefine(stringArray[i]);
        }
    }

    void clearDefinitionsAndLoadPredefined() {
        String string;
        this.variables.clear();
        this.bsSubset = null;
        this.viewer.setSelectionSubset(null);
        if (this.viewer.getModelSet() == null || this.viewer.getAtomCount() == 0) {
            return;
        }
        this.clearPredefined(JmolConstants.predefinedStatic);
        this.clearPredefined(JmolConstants.predefinedVariable);
        int n = 4;
        int n2 = JmolConstants.elementNumberMax;
        while (--n2 >= 0) {
            string = "@" + JmolConstants.elementNameFromNumber(n2) + " _e=" + n2;
            this.predefine(string);
        }
        n2 = JmolConstants.elementNumberMax;
        while (--n2 >= 0) {
            string = "@_" + JmolConstants.elementSymbolFromNumber(n2) + " " + JmolConstants.elementNameFromNumber(n2);
            this.predefine(string);
        }
        n2 = n;
        while (--n2 >= 0) {
            string = "@" + JmolConstants.altElementNameFromIndex(n2) + " _e=" + JmolConstants.altElementNumberFromIndex(n2);
            this.predefine(string);
        }
        n2 = JmolConstants.altElementMax;
        while (--n2 >= n) {
            string = " element=" + JmolConstants.altElementNumberFromIndex(n2);
            String string2 = "@_" + JmolConstants.altElementSymbolFromIndex(n2);
            this.predefine(string2 + string);
            string2 = "@_" + JmolConstants.altIsotopeSymbolFromIndex(n2);
            this.predefine(string2 + string);
            string2 = "@" + JmolConstants.altElementNameFromIndex(n2);
            if (string2.length() <= 1) continue;
            this.predefine(string2 + string);
        }
    }

    private void predefine(String string) {
        if (!this.compiler.compile("#predefine", string, true, false, false, false)) {
            this.viewer.scriptStatus("JmolConstants.java ERROR: predefined set compile error:" + string + "\ncompile error:" + this.compiler.getErrorMessage());
            return;
        }
        Token[][] tokenArray = this.compiler.getAatokenCompiled();
        if (tokenArray.length != 1) {
            this.viewer.scriptStatus("JmolConstants.java ERROR: predefinition does not have exactly 1 command:" + string);
            return;
        }
        Token[] tokenArray2 = tokenArray[0];
        if (tokenArray2.length <= 2) {
            this.viewer.scriptStatus("JmolConstants.java ERROR: bad predefinition length:" + string);
            return;
        }
        this.iToken = 1;
        int n = tokenArray2[1].tok;
        if (n != 1 && !Compiler.tokAttr(n, 0x2100000)) {
            this.viewer.scriptStatus("JmolConstants.java ERROR: invalid variable name:" + string);
            return;
        }
        String string2 = (String)tokenArray2[1].value;
        this.variables.put(string2, tokenArray2);
    }

    private void setShapeProperty(int n, String string, Object object) {
        if (!this.isSyntaxCheck) {
            this.viewer.setShapeProperty(n, string, object);
        }
    }

    private void setShapeSize(int n, int n2) {
        if (!this.isSyntaxCheck) {
            this.viewer.setShapeSize(n, n2);
        }
    }

    private void setBooleanProperty(String string, boolean bl) {
        if (!this.isSyntaxCheck) {
            this.viewer.setBooleanProperty(string, bl);
        }
    }

    private boolean setIntProperty(String string, int n) {
        if (!this.isSyntaxCheck) {
            this.viewer.setIntProperty(string, n);
        }
        return true;
    }

    private boolean setFloatProperty(String string, float f) {
        if (!this.isSyntaxCheck) {
            this.viewer.setFloatProperty(string, f);
        }
        return true;
    }

    private void setStringProperty(String string, String string2) {
        if (!this.isSyntaxCheck || string.equalsIgnoreCase("defaultdirectory")) {
            this.viewer.setStringProperty(string, string2);
        }
    }

    void pauseExecution() {
        if (this.isSyntaxCheck) {
            return;
        }
        this.delay(-100L);
        this.viewer.popHoldRepaint();
        this.executionPaused = Boolean.TRUE;
    }

    boolean isExecutionPaused() {
        return this.executionPaused;
    }

    void resumePausedExecution() {
        this.executionPaused = Boolean.FALSE;
    }

    private boolean checkContinue() {
        if (!this.interruptExecution.booleanValue()) {
            if (!this.executionPaused.booleanValue()) {
                return true;
            }
            if (Logger.debugging) {
                Logger.debug((String)("script execution paused at this command: " + this.thisCommand));
            }
            try {
                while (this.executionPaused.booleanValue()) {
                    Thread.sleep(100L);
                    String string = this.viewer.getInterruptScript();
                    if (string == "") continue;
                    this.resumePausedExecution();
                    this.error = false;
                    --this.pc;
                    try {
                        this.runScript(string);
                    }
                    catch (Exception exception) {
                        this.error = true;
                        this.errorMessage = exception.toString();
                    }
                    ++this.pc;
                    if (this.error) {
                        this.scriptStatus(this.errorMessage);
                    }
                    this.pauseExecution();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Logger.debug((String)"script execution resumed");
        }
        return this.interruptExecution == false;
    }

    private boolean setStatement(int n) throws ScriptException {
        int n2;
        this.statement = this.aatoken[n];
        this.statementLength = this.statement.length;
        if (this.statementLength == 0) {
            return true;
        }
        for (n2 = 1; n2 < this.statementLength && this.statement[n2].tok != 135278594; ++n2) {
        }
        if (n2 == this.statementLength) {
            return n2 == this.statementLength;
        }
        Token[] tokenArray = new Token[this.statementLength];
        tokenArray[0] = this.statement[0];
        boolean bl = false;
        int n3 = 1;
        for (n2 = 1; n2 < this.statementLength; ++n2) {
            int n4 = this.statement[n2].tok;
            switch (n4) {
                case 135278594: {
                    Object object;
                    Vector vector;
                    boolean bl2;
                    String string = this.parameterAsString(++n2);
                    boolean bl3 = bl2 = this.tokAt(n2) == 0x100001;
                    if (bl2) {
                        if ((vector = (Vector)this.parameterExpression(++n2, 0, "_var", true)) == null || vector.size() == 0) {
                            this.error(20);
                        }
                        n2 = this.iToken;
                        Token token = (Token)vector.elementAt(0);
                        object = token.tok == 6 ? token : Token.oValue(token);
                    } else {
                        object = this.getParameter(string, false);
                    }
                    if (object instanceof Token) {
                        tokenArray[n3] = (Token)object;
                        if (bl && tokenArray[n3].tok == 6) {
                            tokenArray[n3] = new Token(0x4000007, Eval.getAtomBitSet(this, this.viewer, Token.sValue(tokenArray[n3])));
                        }
                    } else if (object instanceof Boolean) {
                        tokenArray[n3] = (Boolean)object != false ? Token.tokenOn : Token.tokenOff;
                    } else if (object instanceof Integer) {
                        tokenArray[n3] = new Token(2, (Integer)object, object);
                    } else if (object instanceof Float) {
                        tokenArray[n3] = new Token(3, Compiler.modelValue("" + object), object);
                    } else if (object instanceof String) {
                        if ((object = this.getStringObjectAsToken((String)object, null)) instanceof Token) {
                            tokenArray[n3] = (Token)object;
                        } else {
                            String string2 = (String)object;
                            if (bl) {
                                object = Eval.getAtomBitSet(this, this.viewer, string2);
                            } else {
                                n4 = bl2 ? 4 : (string2.indexOf(".") >= 0 || string2.indexOf("=") >= 0 || string2.indexOf("[") >= 0 || string2.indexOf("{") >= 0 ? 4 : 1);
                            }
                            tokenArray[n3] = new Token(n4, object);
                        }
                    } else if (object instanceof BitSet) {
                        tokenArray[n3] = new Token(0x4000007, object);
                    } else if (object instanceof Point3f) {
                        tokenArray[n3] = new Token(7, object);
                    } else if (object instanceof Point4f) {
                        tokenArray[n3] = new Token(8, object);
                    } else {
                        vector = this.getDrawObjectCenter(string);
                        if (vector == null) {
                            this.error(20);
                        }
                        tokenArray[n3] = new Token(7, vector);
                    }
                    if (n3 != 1 || this.statement[0].tok != 36867 || tokenArray[n3].tok == 1) break;
                    this.error(20);
                    break;
                }
                case 0x100001: 
                case 0x100002: {
                    bl = n4 == 0x100001;
                    tokenArray[n3] = this.statement[n2];
                    break;
                }
                default: {
                    tokenArray[n3] = this.statement[n2];
                }
            }
            ++n3;
        }
        this.statement = tokenArray;
        this.statementLength = n3;
        return true;
    }

    private Object getStringObjectAsToken(String string, String string2) {
        if (string == null || string.length() == 0) {
            return string;
        }
        Object object = Token.unescapePointOrBitsetAsToken(string);
        if (object instanceof String && string2 != null) {
            return this.viewer.getListVariable(string2, object);
        }
        return object;
    }

    private void instructionDispatchLoop(boolean bl) throws ScriptException {
        long l = 0L;
        this.isForCheck = false;
        this.debugScript = !this.isSyntaxCheck && this.viewer.getDebugScript();
        boolean bl2 = this.logMessages = this.debugScript && Logger.debugging;
        if (this.logMessages) {
            l = System.currentTimeMillis();
            this.viewer.scriptStatus("Eval.instructionDispatchLoop():" + l);
            this.viewer.scriptStatus(this.script);
        }
        if (!(this.historyDisabled || this.isSyntaxCheck || this.scriptLevel > this.commandHistoryLevelMax || this.tQuiet)) {
            this.viewer.addCommand(this.script);
        }
        if (this.pcEnd == 0) {
            this.pcEnd = Integer.MAX_VALUE;
        }
        if (this.lineEnd == 0) {
            this.lineEnd = Integer.MAX_VALUE;
        }
        while (this.pc < this.aatoken.length && this.pc < this.pcEnd && this.checkContinue()) {
            block118: {
                Token token;
                block120: {
                    block119: {
                        block117: {
                            Token token2 = token = this.aatoken[this.pc].length == 0 ? null : this.aatoken[this.pc][0];
                            if (this.setStatement(this.pc)) break block117;
                            Logger.info((String)(this.getCommand(this.pc) + " -- STATEMENT CONTAINING @{} SKIPPED"));
                            break block118;
                        }
                        if (this.lineNumbers[this.pc] > this.lineEnd) break;
                        this.thisCommand = this.getCommand(this.pc);
                        this.fullCommand = this.thisCommand + this.getNextComment();
                        this.iToken = 0;
                        String string = this.viewer.getInterruptScript();
                        if (string != "") {
                            this.runScript(string);
                        }
                        if (bl || !this.isSyntaxCheck) {
                            int n = this.viewer.getScriptDelay();
                            if (bl || n > 0 && this.scriptLevel > 0) {
                                if (n > 0) {
                                    this.delay(-((long)n));
                                }
                                this.viewer.scriptEcho("$[" + this.scriptLevel + "." + this.lineNumbers[this.pc] + "." + (this.pc + 1) + "] " + this.thisCommand);
                            }
                        }
                        if (!this.isSyntaxCheck) break block119;
                        if (this.isScriptCheck) {
                            Logger.info((String)this.thisCommand);
                        }
                        if (this.statementLength != 1 || this.statement[0].tok == 9670657) break block120;
                        break block118;
                    }
                    if (this.debugScript) {
                        this.logDebugScript(0);
                    }
                    if (this.logMessages && token != null) {
                        Logger.debug((String)token.toString());
                    }
                }
                if (token != null) {
                    switch (token.tok) {
                        case 102401: 
                        case 102402: 
                        case 102405: 
                        case 102406: 
                        case 233481: 
                        case 364547: 
                        case 364548: 
                        case 364551: 
                        case 364552: {
                            this.flowControl(token.tok);
                            break;
                        }
                        case 35131395: {
                            this.proteinShape(7);
                            break;
                        }
                        case 134221828: {
                            this.background(1);
                            break;
                        }
                        case 12289: {
                            this.center(1);
                            break;
                        }
                        case 141562115: {
                            this.color();
                            break;
                        }
                        case 9442306: {
                            this.data();
                            break;
                        }
                        case 135278594: {
                            this.define();
                            break;
                        }
                        case 134238209: {
                            this.echo(1);
                            break;
                        }
                        case 20484: {
                            this.message();
                            break;
                        }
                        case 67108911: {
                            break;
                        }
                        case 266258: {
                            if (!this.isSyntaxCheck && this.pc > 0) {
                                this.viewer.clearScriptQueue();
                            }
                        }
                        case 266281: {
                            if (this.isSyntaxCheck) break;
                            this.interruptExecution = this.pc > 0 || !this.viewer.usingScriptQueue() ? Boolean.TRUE : Boolean.FALSE;
                            break;
                        }
                        case 150491656: {
                            this.label(1);
                            break;
                        }
                        case 544771: {
                            this.hover();
                            break;
                        }
                        case 9441793: {
                            this.load();
                            break;
                        }
                        case 135794723: {
                            this.monitor();
                            break;
                        }
                        case 266283: {
                            this.refresh();
                            break;
                        }
                        case 266267: {
                            this.viewer.initialize();
                            break;
                        }
                        case 4140: {
                            this.reset();
                            break;
                        }
                        case 528432: {
                            this.rotate(false, false);
                            break;
                        }
                        case 9441795: 
                        case 9458180: {
                            this.script(token.tok == 9458180);
                            break;
                        }
                        case 9670657: {
                            this.function();
                            break;
                        }
                        case 4156: {
                            this.sync();
                            break;
                        }
                        case 134221850: {
                            this.history(1);
                            break;
                        }
                        case 12291: {
                            this.delete();
                            break;
                        }
                        case 4129: {
                            this.minimize();
                            break;
                        }
                        case 9451009: {
                            this.select();
                            break;
                        }
                        case 4158: {
                            this.translate();
                            break;
                        }
                        case 4124: {
                            this.invertSelected();
                            break;
                        }
                        case 4145: {
                            this.rotate(false, true);
                            break;
                        }
                        case 4159: {
                            this.translateSelected();
                            break;
                        }
                        case 12296: {
                            this.zap(true);
                            break;
                        }
                        case 4164: {
                            this.zoom(false);
                            break;
                        }
                        case 4165: {
                            this.zoom(true);
                            break;
                        }
                        case 528396: {
                            this.delay();
                            break;
                        }
                        case 528415: {
                            this.delay();
                            if (this.isSyntaxCheck) break;
                            this.pc = -1;
                            break;
                        }
                        case 4119: {
                            this.gotocmd();
                            break;
                        }
                        case 4132: {
                            this.move();
                            break;
                        }
                        case 134230020: {
                            this.display(true);
                            break;
                        }
                        case 12293: {
                            this.display(false);
                            break;
                        }
                        case 12294: {
                            this.restrict();
                            break;
                        }
                        case 34615303: {
                            this.subset();
                            break;
                        }
                        case 134746163: {
                            this.selectionHalo(1);
                            break;
                        }
                        case 36867: {
                            this.set();
                            break;
                        }
                        case 528437: {
                            this.slab(false);
                            break;
                        }
                        case 528397: {
                            this.slab(true);
                            break;
                        }
                        case 528401: {
                            this.ellipsoid();
                            break;
                        }
                        case 528441: {
                            this.setAtomShapeSize(14, -100);
                            break;
                        }
                        case 3149845: {
                            this.structure();
                            break;
                        }
                        case 528408: {
                            this.setAtomShapeSize(15, -20);
                            break;
                        }
                        case 528438: {
                            this.setAtomShapeSize(0, -100);
                            break;
                        }
                        case 528451: {
                            this.wireframe();
                            break;
                        }
                        case 4161: {
                            this.vector();
                            break;
                        }
                        case 4110: {
                            this.dipole();
                            break;
                        }
                        case 4097: {
                            this.animation();
                            break;
                        }
                        case 4162: {
                            this.vibration();
                            break;
                        }
                        case 4102: {
                            this.calculate();
                            break;
                        }
                        case 528399: {
                            this.dots(6);
                            break;
                        }
                        case 134746171: {
                            this.proteinShape(10);
                            break;
                        }
                        case 528416: {
                            this.proteinShape(11);
                            break;
                        }
                        case 528430: {
                            this.proteinShape(12);
                            break;
                        }
                        case 528445: {
                            this.proteinShape(8);
                            break;
                        }
                        case 528391: {
                            this.proteinShape(9);
                            break;
                        }
                        case 528431: {
                            this.proteinShape(13);
                            break;
                        }
                        case 134746167: {
                            this.rotate(true, false);
                            break;
                        }
                        case 134746168: {
                            this.ssbond();
                            break;
                        }
                        case 135794713: {
                            this.hbond(true);
                            break;
                        }
                        case 4148: {
                            this.show();
                            break;
                        }
                        case 3149832: {
                            this.file();
                            break;
                        }
                        case 4116: 
                        case 3149837: {
                            this.frame(1);
                            break;
                        }
                        case 4115: {
                            this.font(-1, 0.0f);
                            break;
                        }
                        case 4133: {
                            this.moveto();
                            break;
                        }
                        case 4134: {
                            this.navigate();
                            break;
                        }
                        case 4101: {
                            this.bondorder();
                            break;
                        }
                        case 528395: {
                            this.console();
                            break;
                        }
                        case 4135: {
                            this.pmesh();
                            break;
                        }
                        case 4112: {
                            this.draw();
                            break;
                        }
                        case 4136: {
                            this.polyhedra();
                            break;
                        }
                        case 528406: {
                            this.dots(18);
                            break;
                        }
                        case 4104: {
                            this.centerAt();
                            break;
                        }
                        case 4125: {
                            this.isosurface(22);
                            break;
                        }
                        case 4126: {
                            this.lcaoCartoon();
                            break;
                        }
                        case 4130: {
                            this.mo(false);
                            break;
                        }
                        case 528442: {
                            this.stereo();
                            break;
                        }
                        case 4106: {
                            this.connect();
                            break;
                        }
                        case 9441282: {
                            this.getProperty();
                            break;
                        }
                        case 4105: {
                            this.configuration();
                            break;
                        }
                        case 134746114: {
                            this.axes(1);
                            break;
                        }
                        case 142086157: {
                            this.boundbox(1);
                            break;
                        }
                        case 169349184: {
                            this.unitcell(1);
                            break;
                        }
                        case 134746133: {
                            this.frank(1);
                            break;
                        }
                        case 20482: {
                            this.help();
                            break;
                        }
                        case 4146: {
                            this.save();
                            break;
                        }
                        case 4141: {
                            this.restore();
                            break;
                        }
                        case 1052714: {
                            this.dataFrame(0);
                            break;
                        }
                        case 9443332: {
                            this.dataFrame(1);
                            break;
                        }
                        case 9441283: {
                            this.write(null);
                            break;
                        }
                        case 36865: {
                            this.print();
                            break;
                        }
                        case 36866: {
                            this.returnCmd();
                            break;
                        }
                        case 20485: {
                            this.pause();
                            break;
                        }
                        default: {
                            this.error(36);
                        }
                    }
                    if (!this.isSyntaxCheck) {
                        this.viewer.setCursor(0);
                    }
                }
            }
            ++this.pc;
        }
    }

    private void flowControl(int n) throws ScriptException {
        int n2 = this.statement[0].intValue;
        boolean bl = n2 < 0 && !this.isSyntaxCheck;
        boolean bl2 = true;
        int n3 = 0;
        switch (n) {
            case 102401: 
            case 102402: {
                boolean bl3 = bl2 = !bl && this.ifCmd();
                if (this.isSyntaxCheck) break;
                n3 = Math.abs(this.aatoken[Math.abs((int)n2)][0].intValue);
                this.aatoken[Math.abs((int)n2)][0].intValue = n3 = bl || bl2 ? -n3 : n3;
                break;
            }
            case 364547: {
                this.checkLength(1);
                if (n2 >= 0 || this.isSyntaxCheck) break;
                this.pc = -n2 - 1;
                break;
            }
            case 364548: {
                this.checkLength(1);
                break;
            }
            case 233481: {
                this.checkLength(2);
                this.isForCheck = this.tokAt(1) == 102405;
                bl2 = this.tokAt(1) == 102401;
                break;
            }
            case 102406: {
                this.isForCheck = false;
                if (this.ifCmd() || this.isSyntaxCheck) break;
                this.pc = n2;
                break;
            }
            case 364551: {
                if (!this.isSyntaxCheck) {
                    this.pc = this.aatoken[n2][0].intValue;
                }
                if (this.statementLength <= 1) break;
                this.checkLength(2);
                this.intParameter(1);
                break;
            }
            case 364552: {
                this.isForCheck = true;
                if (!this.isSyntaxCheck) {
                    this.pc = n2 - 1;
                }
                if (this.statementLength <= 1) break;
                this.checkLength(2);
                this.intParameter(1);
                break;
            }
            case 102405: {
                int[] nArray = new int[2];
                int n4 = 0;
                int n5 = 0;
                block14: for (int i = 1; i < this.statementLength && n4 < 2; ++i) {
                    switch (this.tokAt(i)) {
                        case 0x100013: {
                            if (n5 > 0) {
                                --n5;
                                continue block14;
                            }
                            nArray[n4++] = i;
                            continue block14;
                        }
                        case 9451009: {
                            n5 += 2;
                        }
                    }
                }
                if (this.isForCheck) {
                    n4 = nArray[1] + 1;
                    this.isForCheck = false;
                } else {
                    n4 = 2;
                    if (this.tokAt(n4) == 134385668) {
                        ++n4;
                    }
                }
                if (this.tokAt(n4) == 1) {
                    String string = this.parameterAsString(n4);
                    if (this.getToken((int)(++n4)).tok != 17826148) {
                        this.error(20);
                    }
                    this.setVariable(++n4, this.statementLength - 1, string, false);
                }
                bl2 = (Boolean)this.parameterExpression(nArray[0] + 1, nArray[1], null, false);
                ++n2;
            }
        }
        if (!bl2 && !this.isSyntaxCheck) {
            this.pc = Math.abs(n2) - 1;
        }
    }

    private boolean ifCmd() throws ScriptException {
        return (Boolean)this.parameterExpression(1, 0, null, false);
    }

    private int getLinenumber() {
        return this.lineNumbers[this.pc];
    }

    private String getCommand(int n) {
        if (n >= this.lineIndices.length) {
            return "";
        }
        int n2 = this.lineIndices[n];
        int n3 = n + 1 == this.lineIndices.length || this.lineIndices[n + 1] == 0 ? this.script.length() : this.lineIndices[n + 1];
        String string = "";
        try {
            int n4;
            string = this.script.substring(n2, n3);
            if (string.indexOf("\\\n") >= 0) {
                string = TextFormat.simpleReplace((String)string, (String)"\\\n", (String)"  ");
            }
            if (string.indexOf("\\\r") >= 0) {
                string = TextFormat.simpleReplace((String)string, (String)"\\\r", (String)"  ");
            }
            if ((n4 = string.indexOf("\n")) >= 0) {
                string = string.substring(0, n4);
            }
            if ((n4 = string.indexOf("\r")) >= 0) {
                string = string.substring(0, n4);
            }
            if (!string.endsWith(";")) {
                string = string + ";";
            }
        }
        catch (Exception exception) {
            Logger.error((String)("darn problem in Eval getCommand: ichBegin=" + n2 + " ichEnd=" + n3 + " len = " + this.script.length() + " script = " + this.script + "\n" + exception));
        }
        return string;
    }

    private void logDebugScript(int n) {
        this.strbufLog.setLength(0);
        if (this.logMessages) {
            if (this.statement.length > 0) {
                Logger.debug((String)this.statement[0].toString());
            }
            for (int i = 1; i < this.statementLength; ++i) {
                Logger.debug((String)this.statement[i].toString());
            }
        }
        this.iToken = -2;
        if (this.logMessages) {
            String string = n > 0 ? "                          ".substring(0, n * 2) : "";
            this.strbufLog.append(string).append(this.statementAsString());
            this.viewer.scriptStatus(this.strbufLog.toString());
        } else {
            String string = this.getCommand(this.pc);
            if (string.length() > 0 && string.lastIndexOf(";") == string.length() - 1) {
                string = string.substring(0, string.length() - 1);
            }
            this.viewer.scriptStatus(string);
        }
    }

    private BitSet expression(int n) throws ScriptException {
        if (!this.checkToken(n)) {
            this.error(1);
        }
        return this.expression(this.statement, n, 0, true, false, true, true);
    }

    private BitSet expression(Token[] tokenArray, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws ScriptException {
        Object object;
        this.isBondSet = false;
        if (tokenArray != this.statement) {
            this.tempStatement = this.statement;
            this.statement = tokenArray;
        }
        Rpn rpn = new Rpn(64, false, false);
        int n3 = Integer.MAX_VALUE;
        boolean bl5 = false;
        this.iToken = 1000;
        boolean bl6 = n < 0;
        boolean bl7 = false;
        int n4 = this.viewer.getAtomCount();
        if (bl6) {
            n = -n;
        }
        bl6 |= this.isSyntaxCheck;
        if (n2 == 0) {
            n2 = n + 1;
        }
        block35: for (int i = n; i < n2; ++i) {
            this.iToken = i;
            object = tokenArray[i];
            if (object == null) break;
            Object object2 = ((Token)object).value;
            switch (((Token)object).tok) {
                case 0x100001: {
                    n = i;
                    n2 = tokenArray.length;
                    continue block35;
                }
                case 0x100002: {
                    break block35;
                }
                case 0x10000E: {
                    Point3f point3f;
                    if (!this.isPoint3f(i) || (point3f = this.getPoint3f(i, true)) == null) continue block35;
                    rpn.addX(point3f);
                    i = this.iToken;
                    continue block35;
                }
                case 0x100012: {
                    continue block35;
                }
                case 0x1100020: {
                    bl7 = true;
                    rpn.addOp((Token)object);
                    continue block35;
                }
                case 0x1100021: {
                    bl7 = false;
                    rpn.addOp((Token)object);
                    continue block35;
                }
                case 1: {
                    Object object3 = this.getParameter((String)object2, true);
                    if (object3 instanceof String) {
                        object3 = this.getStringObjectAsToken((String)object3, null);
                    }
                    if (object3 instanceof String) {
                        object3 = this.lookupIdentifierValue((String)object2);
                    }
                    rpn.addX(object3);
                    continue block35;
                }
                case 135278594: {
                    rpn.addX(Eval.getAtomBitSet(this, this.viewer, (String)object2));
                    continue block35;
                }
                case 9439234: {
                    rpn.addX((Token)object);
                    rpn.addX(new Token(8, this.planeParameter(i + 2)));
                    i = this.iToken;
                    continue block35;
                }
                case 0x100008: {
                    rpn.addX((Token)object);
                    rpn.addX(this.getPoint3f(i + 2, true));
                    i = this.iToken;
                    continue block35;
                }
                case 4: {
                    rpn.addX((Token)object);
                    if (!((String)object2).equals("hkl")) continue block35;
                    rpn.addX(new Token(8, this.hklParameter(i + 2)));
                    i = this.iToken;
                    continue block35;
                }
                case 0x900202: 
                case 9439745: 
                case 9439746: 
                case 0x1100010: {
                    rpn.addOp((Token)object);
                    continue block35;
                }
                case 0x100003: {
                    rpn.addX(this.viewer.getModelAtomBitSet(-1, true));
                    continue block35;
                }
                case 0x10000F: {
                    rpn.addX(new BitSet());
                    continue block35;
                }
                case 0x100010: 
                case 0x100011: {
                    rpn.addX(((Token)object).tok == 0x100011);
                    continue block35;
                }
                case 34603018: {
                    rpn.addX(BitSetUtil.copy((BitSet)this.viewer.getSelectionSet()));
                    continue block35;
                }
                case 34615303: {
                    rpn.addX(this.bsSubset == null ? this.viewer.getModelAtomBitSet(-1, true) : BitSetUtil.copy((BitSet)this.bsSubset));
                    continue block35;
                }
                case 34603032: {
                    rpn.addX(BitSetUtil.copy((BitSet)this.viewer.getHiddenSet()));
                    continue block35;
                }
                case 34603031: {
                    rpn.addX(BitSetUtil.copyInvert((BitSet)this.viewer.getHiddenSet(), (int)n4));
                    continue block35;
                }
                case 34603035: {
                    if (!this.isSyntaxCheck && !bl5) {
                        this.viewer.setModelVisibility();
                    }
                    bl5 = true;
                    rpn.addX(this.viewer.getVisibleSet());
                    continue block35;
                }
                case 34603030: {
                    if (!this.isSyntaxCheck && bl) {
                        this.refresh();
                    }
                    rpn.addX(this.viewer.getClickableSet());
                    continue block35;
                }
                case 0x10000D: 
                case 0x2100002: 
                case 34603013: 
                case 34603014: 
                case 34603015: 
                case 34603016: 
                case 34603017: 
                case 34603029: 
                case 34603033: 
                case 34603034: 
                case 168820739: 
                case 168820740: 
                case 169349184: {
                    rpn.addX(this.getAtomBits(((Token)object).tok, null));
                    continue block35;
                }
                case 0x10001F: 
                case 0x100020: 
                case 1048612: {
                    rpn.addX(this.viewer.getAtomBits(((Token)object).tok, (String)object2));
                    continue block35;
                }
                case 0x100022: 
                case 1048611: {
                    int n5 = ((Token)object).intValue;
                    if (n5 == Integer.MAX_VALUE && object2 instanceof Integer) {
                        n5 = (Integer)object2;
                        if (!this.viewer.haveFileSet()) {
                            rpn.addX(this.getAtomBits(0x100022, new Integer(n5)));
                            continue block35;
                        }
                        n5 = n5 < 1000 ? (n5 *= 1000000) : n5 / 1000 * 1000000 + n5 % 1000;
                    }
                    rpn.addX(this.bitSetForModelFileNumber(n5));
                    continue block35;
                }
                case 0x100021: 
                case 1048613: {
                    rpn.addX(this.getAtomBits(((Token)object).tok, new Integer(((Token)object).intValue)));
                    continue block35;
                }
                case 1048614: {
                    if (bl7) {
                        rpn.addX(((Token)object).intValue);
                        continue block35;
                    }
                    rpn.addX(this.getAtomBits(1048614, new Integer(Eval.getSeqCode((Token)object))));
                    continue block35;
                }
                case 1048615: {
                    if (bl7) {
                        rpn.addX(((Token)object).intValue);
                        rpn.addX(Token.tokenMinus);
                        rpn.addX(tokenArray[++i].intValue);
                        continue block35;
                    }
                    int n6 = i + 3 < tokenArray.length && tokenArray[i + 2].tok == 0x1100040 && tokenArray[i + 3].tok == 0x100021 ? tokenArray[i + 3].intValue : 9;
                    rpn.addX(this.getAtomBits(1048615, new int[]{Eval.getSeqCode((Token)object), Eval.getSeqCode(tokenArray[++i]), n6}));
                    if (n6 == 9) continue block35;
                    i += 2;
                    continue block35;
                }
                case 0x300005: {
                    Point3f point3f = (Point3f)object2;
                    rpn.addX(this.getAtomBits(0x300005, new int[]{(int)(point3f.x * 1000.0f), (int)(point3f.y * 1000.0f), (int)(point3f.z * 1000.0f)}));
                    continue block35;
                }
                case 34603022: {
                    rpn.addX(this.viewer.getModelAtomBitSet(this.viewer.getCurrentModelIndex(), true));
                    continue block35;
                }
                case 0x2100001: 
                case 34603020: 
                case 34603021: 
                case 35131395: 
                case 168820747: {
                    rpn.addX(this.lookupIdentifierValue((String)object2));
                    continue block35;
                }
                case 0x1100160: 
                case 0x1100161: 
                case 17826146: 
                case 17826147: 
                case 17826148: 
                case 17826149: {
                    String string;
                    Object object3 = tokenArray[++i].value;
                    int n7 = ((Token)object).tok;
                    int n8 = ((Token)object).intValue;
                    String string2 = string = n8 == 141558028 ? (String)object3 : null;
                    if (string != null) {
                        object3 = tokenArray[++i].value;
                    }
                    if (this.isSyntaxCheck) {
                        rpn.addX(new BitSet());
                        continue block35;
                    }
                    boolean bl8 = n8 == 3149837;
                    boolean bl9 = n8 == 137363473;
                    int n9 = tokenArray[i].tok;
                    n3 = tokenArray[i].intValue;
                    float f = Float.NaN;
                    if (object3 instanceof String) {
                        if (n9 == 1) {
                            object3 = this.getNumericParameter((String)object3);
                        }
                        if (object3 instanceof String) {
                            object3 = Token.nValue(tokenArray[i]);
                        }
                        if (object3 instanceof Integer) {
                            n3 = (Integer)object3;
                            f = n3;
                        } else if (object3 instanceof Float && bl8) {
                            n3 = ModelCollection.modelFileNumberFromFloat(((Float)object3).floatValue());
                        }
                    }
                    if (object3 instanceof Integer || n9 == 2) {
                        f = n3 *= Compiler.tokAttr(n8, 128) ? 100 : 1;
                        if (bl8 && this.viewer.haveFileSet() && n3 >= 1000 && n3 < 1000000) {
                            n3 = n3 / 1000 * 1000000 + n3 % 1000;
                            n8 = -3149837;
                        }
                    } else if (object3 instanceof Float) {
                        if (bl8) {
                            n8 = -3149837;
                        } else {
                            f = ((Float)object3).floatValue();
                            n3 = (int)(f * (bl9 ? 250.0f : 100.0f));
                        }
                    } else {
                        ++this.iToken;
                        this.error(20);
                    }
                    if (bl8 && n3 >= 1000000 && n3 % 1000000 == 0) {
                        n3 /= 1000000;
                        n8 = 3149832;
                        bl8 = false;
                    }
                    if (n8 == -3149837 && n7 == 17826148) {
                        rpn.addX(this.bitSetForModelFileNumber(n3));
                        continue block35;
                    }
                    if (object2 != null && ((String)object2).indexOf("-") >= 0) {
                        if (!Float.isNaN(f)) {
                            f = -f;
                        }
                        n3 = -n3;
                    }
                    float[] fArray = n8 == 141558028 ? this.viewer.getDataFloat(string) : null;
                    rpn.addX(this.comparatorInstruction(n8, fArray, n7, n3, f));
                    continue block35;
                }
                case 3: 
                case 7: 
                case 8: 
                case 0x4000007: {
                    rpn.addX(object2);
                    continue block35;
                }
                case 2: {
                    rpn.addX(((Token)object).intValue);
                    continue block35;
                }
                default: {
                    if (Compiler.tokAttr(((Token)object).tok, 0x1100000)) {
                        rpn.addOp((Token)object);
                        continue block35;
                    }
                    this.error(37);
                }
            }
        }
        this.expressionResult = rpn.getResult(bl2, null);
        if (this.expressionResult == null) {
            if (bl2) {
                return null;
            }
            if (!this.isSyntaxCheck) {
                rpn.dumpStacks();
            }
            this.error(11);
        }
        this.expressionResult = ((Token)this.expressionResult).value;
        if (this.expressionResult instanceof String && (bl3 || ((String)this.expressionResult).startsWith("({"))) {
            Object object4 = this.expressionResult = this.isScriptCheck ? new BitSet() : Eval.getAtomBitSet(this, this.viewer, (String)this.expressionResult);
        }
        if (!bl3 && !(this.expressionResult instanceof BitSet)) {
            return null;
        }
        BitSet bitSet = this.expressionResult instanceof BitSet ? (BitSet)this.expressionResult : new BitSet();
        this.isBondSet = this.expressionResult instanceof Bond.BondSet;
        object = this.viewer.getDeletedAtoms();
        if (!this.isBondSet && object != null) {
            BitSetUtil.andNot((BitSet)bitSet, (BitSet)object);
        }
        if (!bl6 && this.bsSubset != null && !this.isBondSet) {
            bitSet.and(this.bsSubset);
        }
        if (this.tempStatement != null) {
            this.statement = this.tempStatement;
            this.tempStatement = null;
        }
        return bitSet;
    }

    private static int getSeqCode(Token token) {
        return token.intValue != Integer.MAX_VALUE ? Group.getSeqcode(token.intValue, ' ') : (Integer)token.value;
    }

    private BitSet lookupIdentifierValue(String string) throws ScriptException {
        BitSet bitSet = this.lookupValue(string, false);
        if (bitSet != null) {
            return BitSetUtil.copy((BitSet)bitSet);
        }
        bitSet = this.getAtomBits(1, string);
        return bitSet == null ? new BitSet() : bitSet;
    }

    private BitSet getAtomBits(int n, Object object) {
        if (this.isSyntaxCheck) {
            return new BitSet();
        }
        return this.viewer.getAtomBits(n, object);
    }

    void deleteAtomsInVariables(BitSet bitSet) {
        Enumeration enumeration = this.variables.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Object v = this.variables.get(string);
            if (!(v instanceof BitSet)) continue;
            BitSetUtil.deleteBits((BitSet)((BitSet)v), (BitSet)bitSet);
        }
    }

    private BitSet lookupValue(String string, boolean bl) throws ScriptException {
        if (this.isSyntaxCheck) {
            return new BitSet();
        }
        Object v = this.variables.get(string);
        boolean bl2 = false;
        if (v == null) {
            v = this.variables.get("!" + string);
            boolean bl3 = bl2 = v != null;
        }
        if (v instanceof BitSet) {
            return (BitSet)v;
        }
        if (v instanceof Token[]) {
            this.pushContext(null);
            BitSet bitSet = this.expression((Token[])v, -2, 0, true, false, true, true);
            this.popContext();
            if (!bl2) {
                this.variables.put(string, bitSet);
            }
            return bitSet;
        }
        if (bl) {
            return null;
        }
        int n = string.length();
        if (n < 5) {
            return null;
        }
        if (string.charAt(n - 1) != 's') {
            return null;
        }
        string = string.endsWith("ies") ? string.substring(0, n - 3) + 'y' : string.substring(0, n - 1);
        return this.lookupValue(string, true);
    }

    private BitSet comparatorInstruction(int n, float[] fArray, int n2, int n3, float f) throws ScriptException {
        BitSet bitSet = new BitSet();
        int n4 = Integer.MAX_VALUE;
        BitSet bitSet2 = null;
        int n5 = n2;
        int n6 = n3;
        int n7 = this.viewer.getAtomCount();
        ModelSet modelSet = this.viewer.getModelSet();
        Atom[] atomArray = modelSet.atoms;
        int n8 = -1;
        int n9 = 0;
        int n10 = -1;
        int[] nArray = null;
        int n11 = 0;
        float f2 = 0.0f;
        block28: for (int i = 0; i < n7; ++i) {
            int n12;
            boolean bl = false;
            Atom atom = atomArray[i];
            switch (n) {
                default: {
                    n4 = (int)this.atomProperty(atom, n, true);
                    if (n4 != Integer.MAX_VALUE) break;
                    continue block28;
                }
                case 141558028: {
                    if (fArray == null || fArray.length <= i) continue block28;
                    f2 = fArray[i];
                    switch (n2) {
                        case 17826147: {
                            bl = f2 < f;
                            break;
                        }
                        case 17826146: {
                            bl = f2 <= f;
                            break;
                        }
                        case 0x1100161: {
                            bl = f2 >= f;
                            break;
                        }
                        case 0x1100160: {
                            bl = f2 > f;
                            break;
                        }
                        case 17826148: {
                            bl = f2 == f;
                            break;
                        }
                        case 17826149: {
                            boolean bl2 = bl = f2 != f;
                        }
                    }
                    if (!bl) continue block28;
                    bitSet.set(i);
                    continue block28;
                }
                case 3145750: {
                    bitSet2 = atom.getAtomSymmetry();
                    if (atom.getModelIndex() != n10) {
                        n10 = atom.getModelIndex();
                        nArray = modelSet.getModelCellRange(n10);
                        n8 = n11 = modelSet.getModelSymmetryCount(n10);
                    }
                    if (n6 >= 200) {
                        if (nArray == null) continue block28;
                        n3 = n6 % 1000;
                        n12 = n6 / 1000 - 1;
                        if (n12 < 0) {
                            bl = true;
                        } else if (n11 == 0 || n12 >= 0 && !(bl = bitSet2.get(n12))) continue block28;
                        n5 = 0x10000F;
                        if (n12 < 0) {
                            n4 = atom.getCellTranslation(n3, nArray, n11);
                            break;
                        }
                        n4 = atom.getSymmetryTranslation(n12, nArray, n11);
                        break;
                    }
                    if (n11 <= 0) break;
                    if (n3 > n11 && n5 != 17826147 && n5 != 17826146) continue block28;
                    if (n5 != 17826149) break;
                    if (n3 <= 0 || n3 > n11 || bitSet2.get(n3)) continue block28;
                    bitSet.set(i);
                    continue block28;
                }
            }
            if (bitSet2 != null) {
                switch (n5) {
                    case 17826147: {
                        n8 = n3 - 1;
                        n9 = 0;
                        break;
                    }
                    case 17826146: {
                        n8 = n3;
                        n9 = 0;
                        break;
                    }
                    case 0x1100161: {
                        if (n8 < 0) {
                            n8 = bitSet2.size();
                        }
                        n9 = n3 - 1;
                        break;
                    }
                    case 0x1100160: {
                        if (n8 < 0) {
                            n8 = bitSet2.size();
                        }
                        n9 = n3;
                        break;
                    }
                    case 17826148: {
                        n8 = n3;
                        n9 = n3 - 1;
                        break;
                    }
                    case 17826149: {
                        boolean bl3 = bl = !bitSet2.get(n3);
                    }
                }
                if (n9 < 0) {
                    n9 = 0;
                }
                if (n8 > bitSet2.size()) {
                    n8 = bitSet2.size();
                }
                for (n12 = n9; n12 < n8; ++n12) {
                    if (!bitSet2.get(n12)) continue;
                    bl = true;
                    break;
                }
                if (!bl || n4 == Integer.MAX_VALUE) {
                    n2 = 0x10000F;
                }
            }
            switch (n2) {
                case 17826147: {
                    bl = n4 < n3;
                    break;
                }
                case 17826146: {
                    bl = n4 <= n3;
                    break;
                }
                case 0x1100161: {
                    bl = n4 >= n3;
                    break;
                }
                case 0x1100160: {
                    bl = n4 > n3;
                    break;
                }
                case 17826148: {
                    bl = n4 == n3;
                    break;
                }
                case 17826149: {
                    boolean bl4 = bl = n4 != n3;
                }
            }
            if (!bl) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    private float atomProperty(Atom atom, int n, boolean bl) throws ScriptException {
        float f = 0.0f;
        switch (n) {
            case 0x70000E: {
                return atom.getADPMinMax(true);
            }
            case 0x70000F: {
                return atom.getADPMinMax(false);
            }
            case 0x300001: {
                return atom.getAtomNumber();
            }
            case 0x300004: {
                return atom.getAtomIndex();
            }
            case 0x300007: {
                return atom.getElementNumber();
            }
            case 0x300006: {
                return atom.getAtomicAndIsotopeNumber();
            }
            case 137363721: {
                return atom.getFormalCharge();
            }
            case 3146118: {
                f = atom.getPartialCharge();
                return bl ? f * 100.0f : f;
            }
            case 0x300013: {
                return atom.getAtomSite();
            }
            case 0x30000E: {
                return atom.getMoleculeNumber();
            }
            case 3146123: {
                f = atom.getBfactor100();
                return f < 0.0f ? 2.1474836E9f : (bl ? f : f / 100.0f);
            }
            case 3145865: {
                f = atom.getStraightness();
                return bl ? f * 100.0f : f;
            }
            case 3145866: {
                this.viewer.getSurfaceDistanceMax();
                f = atom.getSurfaceDistance100();
                return bl ? f : f / 100.0f;
            }
            case 3145999: {
                return atom.getOccupancy();
            }
            case 0x300010: {
                return atom.getPolymerLength();
            }
            case 3145746: {
                return atom.getResno();
            }
            case 0x30000A: {
                f = atom.getGroupID();
                return f < 0.0f ? 2.1474836E9f : f;
            }
            case 0x300002: {
                return atom.getSpecialAtomID();
            }
            case 3149845: {
                return atom.getProteinStructureType();
            }
            case 137363473: {
                return atom.getRasMolRadius();
            }
            case 3146007: {
                return (float)(bl ? 100 : 1) * atom.getVanderwaalsRadiusFloat();
            }
            case 0x300088: {
                f = atom.getGroupPsi();
                return bl ? f * 100.0f : f;
            }
            case 3145863: {
                f = atom.getGroupPhi();
                return bl ? f * 100.0f : f;
            }
            case 0x300003: {
                return atom.getCovalentBondCount();
            }
            case 3146008: {
                return atom.getValence();
            }
            case 3149832: {
                return atom.getModelFileIndex() + 1;
            }
            case 3149837: {
                return atom.getModelNumber();
            }
            case -3149837: {
                return atom.getModelFileNumber();
            }
            case 3146112: {
                f = ((Tuple3f)atom).x;
                return bl ? f * 100.0f : f;
            }
            case 3146113: {
                f = ((Tuple3f)atom).y;
                return bl ? f * 100.0f : f;
            }
            case 3146114: {
                f = ((Tuple3f)atom).z;
                return bl ? f * 100.0f : f;
            }
            case 3146115: {
                f = atom.getFractionalCoord('X');
                return bl ? f * 100.0f : f;
            }
            case 3146116: {
                f = atom.getFractionalCoord('Y');
                return bl ? f * 100.0f : f;
            }
            case 3146117: {
                f = atom.getFractionalCoord('Z');
                return bl ? f * 100.0f : f;
            }
        }
        this.error(34, Token.nameOf(n));
        return 0.0f;
    }

    private void checkLength(int n) throws ScriptException {
        if (n >= 0) {
            this.checkLength(n, 0);
            return;
        }
        if (this.statementLength <= -n) {
            return;
        }
        this.iToken = -n;
        this.error(1);
    }

    private void checkLength(int n, int n2) throws ScriptException {
        if (this.statementLength == n) {
            return;
        }
        this.iToken = n2 > 0 ? n2 : this.statementLength;
        this.error(n2 > 0 ? 20 : 1);
    }

    private int checkLength23() throws ScriptException {
        this.iToken = this.statementLength;
        if (this.statementLength < 2 || this.statementLength > 3) {
            this.error(1);
        }
        return this.statementLength;
    }

    private void checkLength34() throws ScriptException {
        this.iToken = this.statementLength;
        if (this.statementLength < 3 || this.statementLength > 4) {
            this.error(1);
        }
    }

    private int modelNumberParameter(int n) throws ScriptException {
        int n2 = 0;
        boolean bl = false;
        switch (this.tokAt(n)) {
            case 2: {
                bl = true;
            }
            case 3: {
                n2 = this.getToken((int)n).intValue;
                break;
            }
            default: {
                this.error(20);
            }
        }
        return this.viewer.getModelNumberIndex(n2, bl, true);
    }

    private String optParameterAsString(int n) throws ScriptException {
        if (n >= this.statementLength) {
            return "";
        }
        return this.parameterAsString(n);
    }

    private String parameterAsString(int n) throws ScriptException {
        this.getToken(n);
        if (this.theToken == null) {
            this.error(11);
        }
        return this.theTok == 2 ? "" + this.theToken.intValue : "" + this.theToken.value;
    }

    private int intParameter(int n) throws ScriptException {
        if (this.checkToken(n) && this.getToken((int)n).tok == 2) {
            return this.theToken.intValue;
        }
        this.error(18);
        return 0;
    }

    private int intParameter(int n, int n2, int n3) throws ScriptException {
        int n4 = this.intParameter(n);
        if (n4 < n2 || n4 > n3) {
            this.integerOutOfRange(n2, n3);
        }
        return n4;
    }

    private boolean isFloatParameter(int n) {
        switch (this.tokAt(n)) {
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    private float floatParameter(int n, float f, float f2) throws ScriptException {
        float f3 = this.floatParameter(n);
        if (f3 < f || f3 > f2) {
            this.numberOutOfRange(f, f2);
        }
        return f3;
    }

    private float floatParameter(int n) throws ScriptException {
        if (this.checkToken(n)) {
            this.getToken(n);
            switch (this.theTok) {
                case 2: 
                case 1048614: {
                    return this.theToken.intValue;
                }
                case 3: 
                case 1048611: {
                    return ((Float)this.theToken.value).floatValue();
                }
            }
        }
        this.error(25);
        return 0.0f;
    }

    private int floatParameterSet(int n, float[] fArray) throws ScriptException {
        if (this.tokAt(n) == 0x10000E) {
            ++n;
        }
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = this.floatParameter(n++);
        }
        if (this.tokAt(n) == 0x100012) {
            ++n;
        }
        return n;
    }

    private String stringParameter(int n) throws ScriptException {
        if (!this.checkToken(n) || this.getToken((int)n).tok != 4) {
            this.error(31);
        }
        return (String)this.theToken.value;
    }

    private String objectNameParameter(int n) throws ScriptException {
        if (!this.checkToken(n)) {
            this.error(28);
        }
        return this.parameterAsString(n);
    }

    private float radiusParameter(int n, float f) throws ScriptException {
        boolean bl;
        if (!this.checkToken(n)) {
            if (Float.isNaN(f)) {
                this.error(25);
            }
            return f;
        }
        this.getToken(n);
        float f2 = Float.NaN;
        boolean bl2 = bl = this.theTok == 0x1100071;
        if (bl) {
            ++n;
        }
        boolean bl3 = this.tokAt(n + 1) == 17825922;
        switch (this.tokAt(n)) {
            case 2: {
                f2 = this.intParameter(n);
            }
            case 3: {
                if (Float.isNaN(f2)) {
                    f2 = this.floatParameter(n);
                }
                if (!(f2 < 0.0f)) break;
                bl = true;
                break;
            }
            default: {
                f2 = f;
                --n;
            }
        }
        this.iToken = n + (bl3 ? 1 : 0);
        if (Float.isNaN(f2)) {
            this.error(25);
        }
        if (f2 == 0.0f) {
            return 0.0f;
        }
        if (bl3) {
            if (f2 <= -100.0f) {
                this.error(20);
            }
            f2 += (float)(bl ? 200 : 100);
        } else if (!bl) {
            if (f2 < 0.0f || f2 > 10.0f) {
                this.numberOutOfRange(0.0f, 10.0f);
            }
            f2 += 10.0f;
        }
        return f2;
    }

    private int setShapeByNameParameter(int n) throws ScriptException {
        String string = this.objectNameParameter(n);
        int n2 = this.viewer.getShapeIdFromObjectName(string);
        if (!this.isSyntaxCheck && n2 < 0) {
            this.error(28);
        }
        this.setShapeProperty(n2, "thisID", string);
        return n2;
    }

    private boolean booleanParameter(int n) throws ScriptException {
        if (this.statementLength == n) {
            return true;
        }
        this.checkLength(n + 1);
        switch (this.getToken((int)n).tok) {
            case 0x100011: {
                return true;
            }
            case 0x100010: {
                return false;
            }
        }
        this.error(4);
        return false;
    }

    private Point3f atomCenterOrCoordinateParameter(int n) throws ScriptException {
        switch (this.getToken((int)n).tok) {
            case 0x100001: 
            case 0x4000007: {
                BitSet bitSet = this.expression(this.statement, n, 0, true, false, false, true);
                if (bitSet != null) {
                    return this.viewer.getAtomSetCenter(bitSet);
                }
                if (this.expressionResult instanceof Point3f) {
                    return (Point3f)this.expressionResult;
                }
                this.error(20);
            }
            case 7: 
            case 0x10000E: {
                return this.getPoint3f(n, true);
            }
        }
        this.error(20);
        return null;
    }

    private boolean isCenterParameter(int n) {
        int n2 = this.tokAt(n);
        return n2 == 0x100009 || n2 == 0x10000E || n2 == 0x100001 || n2 == 7 || n2 == 0x4000007;
    }

    private Point3f centerParameter(int n) throws ScriptException {
        Point3f point3f = null;
        if (this.checkToken(n)) {
            switch (this.getToken((int)n).tok) {
                case 0x100009: {
                    String string = this.objectNameParameter(++n);
                    if (this.tokAt(n + 1) == 0x1100020) {
                        string = string + "[" + this.intParameter(n + 2) + "]";
                        if (this.getToken((int)(n + 3)).tok != 0x1100021) {
                            this.error(20);
                        }
                    }
                    if (this.isSyntaxCheck) {
                        return new Point3f();
                    }
                    point3f = this.getDrawObjectCenter(string);
                    if (point3f != null) break;
                    this.error(10, string);
                    break;
                }
                case 7: 
                case 0x100001: 
                case 0x10000E: 
                case 0x4000007: {
                    point3f = this.atomCenterOrCoordinateParameter(n);
                }
            }
        }
        if (point3f == null) {
            this.error(9);
        }
        return point3f;
    }

    private Point4f planeParameter(int n) throws ScriptException {
        block26: {
            Vector3f vector3f = new Vector3f();
            Vector3f vector3f2 = new Vector3f();
            if (n >= this.statementLength) break block26;
            switch (this.getToken((int)n).tok) {
                case 8: {
                    return (Point4f)this.theToken.value;
                }
                case 0x100009: {
                    String string = this.objectNameParameter(++n);
                    if (this.isSyntaxCheck) {
                        return new Point4f();
                    }
                    int n2 = this.viewer.getShapeIdFromObjectName(string);
                    switch (n2) {
                        case 21: {
                            this.setShapeProperty(21, "thisID", string);
                            Point3f[] point3fArray = (Point3f[])this.viewer.getShapeProperty(21, "vertices");
                            if (point3fArray != null) {
                                if (point3fArray.length < 3) break;
                                Vector3f vector3f3 = new Vector3f();
                                float f = Graphics3D.getNormalThroughPoints((Point3f)point3fArray[0], (Point3f)point3fArray[1], (Point3f)point3fArray[2], (Vector3f)vector3f3, (Vector3f)vector3f, (Vector3f)vector3f2);
                                return new Point4f(vector3f3.x, vector3f3.y, vector3f3.z, f);
                            }
                            break block26;
                        }
                        case 22: {
                            this.setShapeProperty(22, "thisID", string);
                            Point4f point4f = (Point4f)this.viewer.getShapeProperty(22, "plane");
                            if (point4f != null) {
                                return point4f;
                            } else {
                                break;
                            }
                        }
                    }
                    break;
                }
                case 1: 
                case 4: {
                    String string = this.parameterAsString(n);
                    if (string.equalsIgnoreCase("xy")) {
                        return new Point4f(0.0f, 0.0f, 1.0f, 0.0f);
                    }
                    if (string.equalsIgnoreCase("xz")) {
                        return new Point4f(0.0f, 1.0f, 0.0f, 0.0f);
                    }
                    if (string.equalsIgnoreCase("yz")) {
                        return new Point4f(1.0f, 0.0f, 0.0f, 0.0f);
                    }
                    this.iToken += 2;
                    if (string.equalsIgnoreCase("x")) {
                        if (!this.checkToken(++n) || this.getToken((int)n++).tok != 17826148) {
                            this.evalError("x=?");
                        }
                        return new Point4f(1.0f, 0.0f, 0.0f, -this.floatParameter(n));
                    }
                    if (string.equalsIgnoreCase("y")) {
                        if (!this.checkToken(++n) || this.getToken((int)n++).tok != 17826148) {
                            this.evalError("y=?");
                        }
                        return new Point4f(0.0f, 1.0f, 0.0f, -this.floatParameter(n));
                    }
                    if (!string.equalsIgnoreCase("z")) break;
                    if (!this.checkToken(++n) || this.getToken((int)n++).tok != 17826148) {
                        this.evalError("z=?");
                    }
                    return new Point4f(0.0f, 0.0f, 1.0f, -this.floatParameter(n));
                }
                case 0x10000E: {
                    if (!this.isPoint3f(n)) {
                        return this.getPoint4f(n);
                    }
                }
                case 0x100001: 
                case 0x4000007: {
                    Point3f point3f = this.atomCenterOrCoordinateParameter(n);
                    if (this.getToken((int)(++this.iToken)).tok == 0x1100010) {
                        ++this.iToken;
                    }
                    Point3f point3f2 = this.atomCenterOrCoordinateParameter(this.iToken);
                    if (this.getToken((int)(++this.iToken)).tok == 0x1100010) {
                        ++this.iToken;
                    }
                    Point3f point3f3 = this.atomCenterOrCoordinateParameter(this.iToken);
                    n = this.iToken;
                    Vector3f vector3f4 = new Vector3f();
                    float f = Graphics3D.getNormalThroughPoints((Point3f)point3f, (Point3f)point3f2, (Point3f)point3f3, (Vector3f)vector3f4, (Vector3f)vector3f, (Vector3f)vector3f2);
                    Point4f point4f = new Point4f(vector3f4.x, vector3f4.y, vector3f4.z, f);
                    if (!this.isSyntaxCheck && Logger.debugging) {
                        Logger.debug((String)("points: " + point3f + point3f2 + point3f3 + " defined plane: " + point4f));
                    }
                    return point4f;
                }
            }
        }
        this.planeExpected();
        return null;
    }

    private Point4f hklParameter(int n) throws ScriptException {
        Point3f point3f = this.viewer.getCurrentUnitCellOffset();
        if (point3f == null) {
            if (this.isSyntaxCheck) {
                point3f = new Point3f();
            } else {
                this.error(24);
            }
        }
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Point3f point3f2 = (Point3f)this.getPointOrPlane(n, false, true, false, true, 3, 3);
        Point3f point3f3 = new Point3f(point3f2.x == 0.0f ? 1.0f : 1.0f / point3f2.x, 0.0f, 0.0f);
        Point3f point3f4 = new Point3f(0.0f, point3f2.y == 0.0f ? 1.0f : 1.0f / point3f2.y, 0.0f);
        Point3f point3f5 = new Point3f(0.0f, 0.0f, point3f2.z == 0.0f ? 1.0f : 1.0f / point3f2.z);
        if (point3f2.x == 0.0f && point3f2.y == 0.0f && point3f2.z == 0.0f) {
            this.error(2);
        } else if (point3f2.x == 0.0f && point3f2.y == 0.0f) {
            point3f3.set(1.0f, 0.0f, point3f5.z);
            point3f4.set(0.0f, 1.0f, point3f5.z);
        } else if (point3f2.y == 0.0f && point3f2.z == 0.0f) {
            point3f4.set(point3f3.x, 0.0f, 1.0f);
            point3f5.set(point3f3.x, 1.0f, 0.0f);
        } else if (point3f2.z == 0.0f && point3f2.x == 0.0f) {
            point3f5.set(0.0f, point3f4.y, 1.0f);
            point3f3.set(1.0f, point3f4.y, 0.0f);
        } else if (point3f2.x == 0.0f) {
            point3f3.set(1.0f, point3f4.y, 0.0f);
        } else if (point3f2.y == 0.0f) {
            point3f4.set(0.0f, 1.0f, point3f5.z);
        } else if (point3f2.z == 0.0f) {
            point3f5.set(point3f3.x, 0.0f, 1.0f);
        }
        this.viewer.toCartesian(point3f3);
        this.viewer.toCartesian(point3f4);
        this.viewer.toCartesian(point3f5);
        point3f3.add((Tuple3f)point3f);
        point3f4.add((Tuple3f)point3f);
        point3f5.add((Tuple3f)point3f);
        Vector3f vector3f3 = new Vector3f();
        float f = Graphics3D.getNormalThroughPoints((Point3f)point3f3, (Point3f)point3f4, (Point3f)point3f5, (Vector3f)vector3f3, (Vector3f)vector3f, (Vector3f)vector3f2);
        Point4f point4f = new Point4f(vector3f3.x, vector3f3.y, vector3f3.z, f);
        if (!this.isSyntaxCheck && Logger.debugging) {
            Logger.info((String)("defined plane: " + point4f));
        }
        return point4f;
    }

    private int getMadParameter() throws ScriptException {
        int n = 1;
        switch (this.getToken((int)1).tok) {
            case 0x100011: {
                break;
            }
            case 0x100010: {
                n = 0;
                break;
            }
            case 2: {
                int n2 = this.intParameter(1, 0, 750);
                n = n2 * 4 * 2;
                break;
            }
            case 3: {
                n = (int)(this.floatParameter(1, 0.0f, 3.0f) * 1000.0f * 2.0f);
                break;
            }
            default: {
                this.error(5);
            }
        }
        return n;
    }

    private int getSetAxesTypeMad(int n) throws ScriptException {
        if (n == this.statementLength) {
            return 1;
        }
        this.checkLength(n + 1);
        switch (this.getToken((int)n).tok) {
            case 0x100011: {
                return 1;
            }
            case 0x100010: {
                return 0;
            }
            case 0x400000F: {
                return -1;
            }
            case 2: {
                return this.intParameter(n, -1, 19);
            }
            case 3: {
                float f = this.floatParameter(n, 0.0f, 2.0f);
                return (int)(f * 1000.0f * 2.0f);
            }
        }
        this.error(6, "\"DOTTED\"");
        return 0;
    }

    private boolean isColorParam(int n) {
        int n2 = this.tokAt(n);
        return n2 == 0x1100020 || n2 == 7 || this.isPoint3f(n) || (n2 == 4 || n2 == 1) && Graphics3D.getArgbFromString((String)((String)this.statement[n].value)) != 0;
    }

    private int getArgbParam(int n) throws ScriptException {
        return this.getArgbParam(n, false);
    }

    private int getArgbParamLast(int n, boolean bl) throws ScriptException {
        int n2 = this.getArgbParam(n, bl);
        this.checkLength(this.iToken + 1);
        return n2;
    }

    private int getArgbParam(int n, boolean bl) throws ScriptException {
        Point3f point3f = null;
        if (this.checkToken(n)) {
            switch (this.getToken((int)n).tok) {
                case 1: 
                case 4: {
                    return Graphics3D.getArgbFromString((String)this.parameterAsString(n));
                }
                case 0x1100020: {
                    return this.getColorTriad(++n);
                }
                case 7: {
                    point3f = (Point3f)this.theToken.value;
                    break;
                }
                case 0x10000E: {
                    point3f = this.getPoint3f(n, false);
                    break;
                }
                case 0x10000F: {
                    if (!bl) break;
                    return 0;
                }
            }
        }
        if (point3f == null) {
            this.error(7);
        }
        return Eval.colorPtToInt(point3f);
    }

    static int colorPtToInt(Point3f point3f) {
        return 0xFF000000 | ((int)point3f.x & 0xFF) << 16 | ((int)point3f.y & 0xFF) << 8 | (int)point3f.z & 0xFF;
    }

    private int getColorTriad(int n) throws ScriptException {
        int[] nArray = new int[3];
        int n2 = 0;
        String string = "";
        this.getToken(n);
        Point3f point3f = null;
        block0 : switch (this.theTok) {
            case 2: 
            case 1048614: {
                while (n < this.statementLength) {
                    this.getToken(n);
                    switch (this.theTok) {
                        case 0x1100010: {
                            break;
                        }
                        case 1: {
                            if (n2 != 1 || nArray[0] != 0) {
                                this.error(3);
                            }
                            string = "0" + this.parameterAsString(n);
                            break block0;
                        }
                        case 2: {
                            if (n2 > 2) {
                                this.error(3);
                            }
                            nArray[n2++] = this.theToken.intValue;
                            break;
                        }
                        case 1048614: {
                            if (n2 > 2) {
                                this.error(3);
                            }
                            nArray[n2++] = (Integer)this.theToken.value % 256;
                            break;
                        }
                        case 0x1100021: {
                            if (n2 == 3) {
                                return Eval.colorPtToInt(new Point3f((float)nArray[0], (float)nArray[1], (float)nArray[2]));
                            }
                        }
                        default: {
                            this.error(3);
                        }
                    }
                    ++n;
                }
                this.error(3);
            }
            case 7: {
                point3f = (Point3f)this.theToken.value;
                break;
            }
            case 1: {
                string = this.parameterAsString(n);
                break;
            }
            default: {
                this.error(3);
            }
        }
        if (this.getToken((int)(++n)).tok != 0x1100021) {
            this.error(3);
        }
        if (point3f != null) {
            return Eval.colorPtToInt(point3f);
        }
        n2 = Graphics3D.getArgbFromString((String)("[" + string + "]"));
        if (n2 == 0) {
            this.error(3);
        }
        return n2;
    }

    private boolean isPoint3f(int n) {
        boolean bl = this.tokAt(n) == 7;
        if (bl || this.tokAt(n) == 8 || this.isFloatParameter(n + 1) && this.isFloatParameter(n + 2) && this.isFloatParameter(n + 3) && this.isFloatParameter(n + 4)) {
            return bl;
        }
        this.ignoreError = true;
        int n2 = this.iToken;
        bl = true;
        try {
            this.getPoint3f(n, true);
        }
        catch (Exception exception) {
            bl = false;
        }
        this.ignoreError = false;
        this.iToken = n2;
        return bl;
    }

    private Point3f getPoint3f(int n, boolean bl) throws ScriptException {
        return (Point3f)this.getPointOrPlane(n, false, bl, true, false, 3, 3);
    }

    private Point4f getPoint4f(int n) throws ScriptException {
        return (Point4f)this.getPointOrPlane(n, false, false, false, false, 4, 4);
    }

    private Object getPointOrPlane(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2, int n3) throws ScriptException {
        float[] fArray = new float[6];
        int n4 = 0;
        this.coordinatesAreFractional = bl4;
        if (this.tokAt(n) == 7) {
            if (n2 <= 3 && n3 >= 3) {
                return (Point3f)this.getToken((int)n).value;
            }
            this.error(20);
        }
        if (this.tokAt(n) == 8) {
            if (n2 <= 4 && n3 >= 4) {
                return (Point4f)this.getToken((int)n).value;
            }
            this.error(20);
        }
        int n5 = 1;
        block10: for (int i = n; i < this.statement.length; ++i) {
            switch (this.getToken((int)i).tok) {
                case 0x10000E: 
                case 0x1100010: 
                case 0x1100040: {
                    continue block10;
                }
                case 0x100012: {
                    break block10;
                }
                case 0x1100070: {
                    n5 = -1;
                    continue block10;
                }
                case 1048615: {
                    if (n4 == 6) {
                        this.error(20);
                    }
                    fArray[n4++] = this.theToken.intValue;
                    n5 = -1;
                    continue block10;
                }
                case 2: 
                case 1048614: {
                    if (n4 == 6) {
                        this.error(20);
                    }
                    fArray[n4++] = this.theToken.intValue * n5;
                    n5 = 1;
                    continue block10;
                }
                case 0x1100080: {
                    this.getToken(++i);
                }
                case 0x100022: {
                    if (--n4 < 0 || bl) {
                        this.error(20);
                    }
                    if (this.theToken.value instanceof Integer || this.theTok == 2) {
                        int n6 = n4++;
                        fArray[n6] = fArray[n6] / (float)(this.theToken.intValue == Integer.MAX_VALUE ? (Integer)this.theToken.value : this.theToken.intValue);
                    } else {
                        int n7 = n4++;
                        fArray[n7] = fArray[n7] / ((Float)this.theToken.value).floatValue();
                    }
                    this.coordinatesAreFractional = true;
                    continue block10;
                }
                case 3: 
                case 1048611: {
                    if (bl) {
                        this.error(20);
                    }
                    if (n4 == 6) {
                        this.error(20);
                    }
                    fArray[n4++] = ((Float)this.theToken.value).floatValue();
                    continue block10;
                }
                default: {
                    this.error(20);
                }
            }
        }
        if (n4 < n2 || n4 > n3) {
            this.error(20);
        }
        if (n4 == 3) {
            Point3f point3f = new Point3f(fArray[0], fArray[1], fArray[2]);
            if (this.coordinatesAreFractional && bl3 && !this.isSyntaxCheck) {
                this.viewer.toCartesian(point3f);
            }
            return point3f;
        }
        if (n4 == 4) {
            if (this.coordinatesAreFractional) {
                this.error(20);
            }
            Point4f point4f = new Point4f(fArray[0], fArray[1], fArray[2], fArray[3]);
            return point4f;
        }
        return fArray;
    }

    private Point3f xypParameter(int n) throws ScriptException {
        boolean bl;
        if (this.tokAt(n) != 0x1100020 || !this.isFloatParameter(++n)) {
            return null;
        }
        Point3f point3f = new Point3f();
        point3f.x = this.floatParameter(n);
        if (this.tokAt(++n) == 0x1100010) {
            ++n;
        }
        if (!this.isFloatParameter(n)) {
            return null;
        }
        point3f.y = this.floatParameter(n);
        boolean bl2 = bl = this.tokAt(++n) == 17825922;
        if (bl) {
            ++n;
        }
        if (this.tokAt(n) != 0x1100021) {
            return null;
        }
        this.iToken = n;
        point3f.z = (float)(bl ? -1 : 1) * Float.MAX_VALUE;
        return point3f;
    }

    private Token getToken(int n) throws ScriptException {
        if (!this.checkToken(n)) {
            this.error(11);
        }
        this.theToken = this.statement[n];
        this.theTok = this.theToken.tok;
        return this.theToken;
    }

    private int tokAt(int n) {
        return n < this.statementLength ? this.statement[n].tok : 0;
    }

    private int tokAt(int n, Token[] tokenArray) {
        return n < tokenArray.length ? tokenArray[n].tok : 0;
    }

    private Token tokenAt(int n, Token[] tokenArray) {
        return n < tokenArray.length ? tokenArray[n] : null;
    }

    private boolean checkToken(int n) {
        this.iToken = n;
        return this.iToken < this.statementLength;
    }

    private void help() throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String string = this.statementLength == 1 ? "" : this.parameterAsString(1);
        Token token = Token.getTokenFromName(string);
        if (token != null && (token.tok & 0x1000) != 0) {
            string = "?command=" + string;
        }
        this.viewer.getHelp(string);
    }

    private void move() throws ScriptException {
        int n;
        if (this.statementLength > 11) {
            this.error(1);
        }
        Vector3f vector3f = new Vector3f(this.floatParameter(1), this.floatParameter(2), this.floatParameter(3));
        float f = this.floatParameter(4);
        Vector3f vector3f2 = new Vector3f((float)this.intParameter(5), (float)this.intParameter(6), (float)this.intParameter(7));
        float f2 = this.floatParameter(8);
        float f3 = this.floatParameter(9);
        int n2 = n = this.statementLength == 11 ? this.intParameter(10) : 30;
        if (this.isSyntaxCheck) {
            return;
        }
        this.refresh();
        this.viewer.move(vector3f, f, vector3f2, f2, f3, n);
    }

    private void moveto() throws ScriptException {
        float f;
        float f2;
        if (this.statementLength == 2 && this.isFloatParameter(1)) {
            float f3 = this.floatParameter(1);
            if (this.isSyntaxCheck) {
                return;
            }
            if (f3 > 0.0f) {
                this.refresh();
            }
            this.viewer.moveTo(f3, null, new Point3f(0.0f, 0.0f, 1.0f), 0.0f, 100.0f, 0.0f, 0.0f, 0.0f, null, Float.NaN, Float.NaN, Float.NaN);
            return;
        }
        Point3f point3f = new Point3f();
        Point3f point3f2 = null;
        int n = 1;
        float f4 = this.isFloatParameter(n) ? this.floatParameter(n++) : 2.0f;
        float f5 = Float.NaN;
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = 90.0f;
        switch (this.getToken((int)n).tok) {
            case 7: 
            case 0x10000E: {
                if (this.isPoint3f(n)) {
                    point3f = this.getPoint3f(n, true);
                    n = this.iToken + 1;
                    f8 = this.floatParameter(n++);
                    break;
                }
                Point4f point4f = this.getPoint4f(n);
                n = this.iToken + 1;
                point3f.set(point4f.x, point4f.y, point4f.z);
                f8 = point4f.w;
                break;
            }
            case 67108882: {
                point3f.set(1.0f, 0.0f, 0.0f);
                f8 = 0.0f;
                ++n;
                break;
            }
            case 0x4000005: {
                point3f.set(0.0f, 1.0f, 0.0f);
                f8 = 180.0f;
                ++n;
                break;
            }
            case 67108889: {
                point3f.set(0.0f, 1.0f, 0.0f);
                ++n;
                break;
            }
            case 67108913: {
                point3f.set(0.0f, -1.0f, 0.0f);
                this.checkLength(++n);
                break;
            }
            case 67108922: {
                point3f.set(1.0f, 0.0f, 0.0f);
                this.checkLength(++n);
                break;
            }
            case 0x4000009: {
                point3f.set(-1.0f, 0.0f, 0.0f);
                this.checkLength(++n);
                break;
            }
            default: {
                point3f = new Point3f(this.floatParameter(n++), this.floatParameter(n++), this.floatParameter(n++));
                f8 = this.floatParameter(n++);
            }
        }
        boolean bl = !this.viewer.isInPosition(point3f, f8);
        float f9 = this.viewer.getZoomSetting();
        if (n != this.statementLength && !this.isCenterParameter(n)) {
            f5 = this.floatParameter(n++);
        }
        if (n != this.statementLength && !this.isCenterParameter(n)) {
            f6 = this.floatParameter(n++);
            f7 = this.floatParameter(n++);
            if (!bl && Math.abs(f6 - this.viewer.getTranslationXPercent()) >= 1.0f) {
                bl = true;
            }
            if (!bl && Math.abs(f7 - this.viewer.getTranslationYPercent()) >= 1.0f) {
                bl = true;
            }
        }
        float f10 = Float.NaN;
        if (n != this.statementLength) {
            int n2 = n;
            point3f2 = this.centerParameter(n);
            if (!bl && (double)point3f2.distance(this.viewer.getRotationCenter()) >= 0.1) {
                bl = true;
            }
            if (this.isFloatParameter(n = this.iToken + 1)) {
                f10 = this.floatParameter(n++);
            }
            f2 = this.viewer.getRotationRadius();
            if (!this.isCenterParameter(n)) {
                if ((f10 == 0.0f || Float.isNaN(f10)) && (f5 == 0.0f || Float.isNaN(f5))) {
                    f = Math.abs(this.getZoomFactor(n, n2, f2, f9));
                    n = this.iToken + 1;
                    if (Float.isNaN(f)) {
                        this.error(20);
                    }
                    f5 = f;
                } else if (!bl && (double)Math.abs(f10 - this.viewer.getRotationRadius()) >= 0.1) {
                    bl = true;
                }
            }
        }
        if (f5 == 0.0f || Float.isNaN(f5)) {
            f5 = 100.0f;
        }
        if (Float.isNaN(f10)) {
            f10 = 0.0f;
        }
        if (!bl && Math.abs(f5 - f9) >= 1.0f) {
            bl = true;
        }
        Point3f point3f3 = null;
        f2 = Float.NaN;
        f = Float.NaN;
        float f11 = Float.NaN;
        if (n != this.statementLength) {
            point3f3 = this.centerParameter(n);
            n = this.iToken + 1;
            if (n != this.statementLength) {
                f2 = this.floatParameter(n++);
                f = this.floatParameter(n++);
            }
            if (n != this.statementLength) {
                f11 = this.floatParameter(n++);
            }
        }
        if (n != this.statementLength) {
            this.error(1);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (!bl) {
            f4 = 0.0f;
        }
        if (f4 > 0.0f) {
            this.refresh();
        }
        this.viewer.moveTo(f4, point3f2, point3f, f8, f5, f6, f7, f10, point3f3, f2, f, f11);
    }

    private void navigate() throws ScriptException {
        if (this.statementLength == 1) {
            this.setBooleanProperty("navigationMode", true);
            return;
        }
        Vector3f vector3f = new Vector3f(0.0f, 1.0f, 0.0f);
        if (this.statementLength == 2) {
            switch (this.getToken((int)1).tok) {
                case 0x100010: 
                case 0x100011: {
                    this.setBooleanProperty("navigationMode", this.theTok == 0x100011);
                }
            }
            this.error(20);
            return;
        }
        if (!this.viewer.getNavigationMode()) {
            this.setBooleanProperty("navigationMode", true);
        }
        block16: for (int i = 1; i < this.statementLength; ++i) {
            float f;
            float f2 = f = this.isFloatParameter(i) ? this.floatParameter(i++) : 2.0f;
            if (f < 0.0f) {
                this.error(20);
            }
            if (!this.isSyntaxCheck && f > 0.0f) {
                this.refresh();
            }
            switch (this.getToken((int)i).tok) {
                case 528397: {
                    float f3 = this.floatParameter(++i);
                    if (this.isSyntaxCheck) continue block16;
                    this.viewer.setNavigationDepthPercent(f, f3);
                    continue block16;
                }
                case 12289: {
                    Point3f point3f = this.centerParameter(++i);
                    i = this.iToken;
                    if (this.isSyntaxCheck) continue block16;
                    this.viewer.navigate(f, point3f);
                    continue block16;
                }
                case 528432: {
                    switch (this.getToken((int)(++i)).tok) {
                        case 1: {
                            String string = this.parameterAsString(i++);
                            if (string.equalsIgnoreCase("x")) {
                                vector3f.set(1.0f, 0.0f, 0.0f);
                                break;
                            }
                            if (string.equalsIgnoreCase("y")) {
                                vector3f.set(0.0f, 1.0f, 0.0f);
                                break;
                            }
                            if (string.equalsIgnoreCase("z")) {
                                vector3f.set(0.0f, 0.0f, 1.0f);
                                break;
                            }
                            this.error(20);
                        }
                        case 7: 
                        case 0x10000E: {
                            vector3f.set((Tuple3f)this.getPoint3f(i, true));
                            i = this.iToken + 1;
                        }
                    }
                    float f4 = this.floatParameter(i);
                    if (this.isSyntaxCheck) continue block16;
                    this.viewer.navigate(f, vector3f, f4);
                    continue block16;
                }
                case 4158: {
                    Point3f[][] point3fArrayArray;
                    Point3f point3f;
                    float f5 = Float.NaN;
                    float f6 = Float.NaN;
                    if (this.isFloatParameter(++i)) {
                        f5 = this.floatParameter(i);
                        f6 = this.floatParameter(++i);
                    } else if (this.getToken((int)i).tok == 1) {
                        point3fArrayArray = this.parameterAsString(i);
                        if (point3fArrayArray.equalsIgnoreCase("x")) {
                            f5 = this.floatParameter(++i);
                        } else if (point3fArrayArray.equalsIgnoreCase("y")) {
                            f6 = this.floatParameter(++i);
                        } else {
                            this.error(20);
                        }
                    } else {
                        point3f = this.centerParameter(i);
                        i = this.iToken;
                        if (this.isSyntaxCheck) continue block16;
                        this.viewer.navTranslate(f, point3f);
                        continue block16;
                    }
                    if (this.isSyntaxCheck) continue block16;
                    this.viewer.navTranslatePercent(f, f5, f6);
                    continue block16;
                }
                case 0x1100080: {
                    continue block16;
                }
                case 528445: {
                    Vector vector = new Vector();
                    BitSet bitSet = this.expression(++i);
                    i = this.iToken;
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.getPolymerPointsAndVectors(bitSet, vector);
                    int n = vector.size();
                    if (n <= 0) continue block16;
                    Point3f[][] point3fArrayArray = new Point3f[n][];
                    for (int j = 0; j < n; ++j) {
                        point3fArrayArray[j] = (Point3f[])vector.get(j);
                    }
                    this.viewer.navigate(f, point3fArrayArray);
                    continue block16;
                }
                case 1: {
                    float[] fArray = null;
                    String string = this.parameterAsString(i);
                    if (string.equalsIgnoreCase("path")) {
                        int n;
                        Object object;
                        if (this.getToken((int)(i + 1)).tok == 0x100009) {
                            ++i;
                            object = this.objectNameParameter(++i);
                            if (this.isSyntaxCheck) {
                                return;
                            }
                            this.setShapeProperty(21, "thisID", object);
                            Point3f[] point3fArray = (Point3f[])this.viewer.getShapeProperty(21, "vertices");
                            this.refresh();
                            if (point3fArray == null) {
                                this.error(20);
                            }
                            n = (int)(this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 0.0f);
                            int n2 = (int)(this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 2.1474836E9f);
                            if (this.isSyntaxCheck) continue block16;
                            this.viewer.navigate(f, point3fArray, fArray, n, n2);
                            continue block16;
                        }
                        object = new Vector();
                        while (this.isCenterParameter(i + 1)) {
                            ((Vector)object).addElement(this.centerParameter(++i));
                            i = this.iToken;
                        }
                        if (((Vector)object).size() > 0) {
                            Point3f[] point3fArray = new Point3f[((Vector)object).size()];
                            for (n = 0; n < ((Vector)object).size(); ++n) {
                                point3fArray[n] = (Point3f)((Vector)object).get(n);
                            }
                            if (this.isSyntaxCheck) continue block16;
                            this.viewer.navigate(f, point3fArray, fArray, 0, Integer.MAX_VALUE);
                            continue block16;
                        }
                    }
                }
                default: {
                    this.error(20);
                }
            }
        }
    }

    private void bondorder() throws ScriptException {
        this.checkLength(-3);
        short s = 0;
        switch (this.getToken((int)1).tok) {
            case 2: 
            case 3: {
                s = JmolConstants.getBondOrderFromFloat(this.floatParameter(1));
                if (s != Short.MAX_VALUE) break;
                this.error(20);
                break;
            }
            default: {
                s = JmolConstants.getBondOrderFromString(this.parameterAsString(1));
                if (s == Short.MAX_VALUE) {
                    this.error(20);
                }
                if (s != 33 || this.tokAt(2) != 3) break;
                s = JmolConstants.getPartialBondOrderFromInteger(this.statement[2].intValue);
            }
        }
        this.setShapeProperty(1, "bondOrder", new Short(s));
    }

    private void console() throws ScriptException {
        switch (this.getToken((int)1).tok) {
            case 0x100010: {
                if (this.isSyntaxCheck) break;
                this.viewer.showConsole(false);
                break;
            }
            case 0x100011: {
                if (this.isSyntaxCheck) break;
                this.viewer.showConsole(true);
                this.viewer.clearConsole();
                break;
            }
            default: {
                this.error(20);
            }
        }
    }

    private void centerAt() throws ScriptException {
        String string = null;
        switch (this.getToken((int)1).tok) {
            case 0x4000001: {
                string = "absolute";
                break;
            }
            case 0x4000002: {
                string = "average";
                break;
            }
            case 142086157: {
                string = "boundbox";
                break;
            }
            default: {
                this.error(20);
            }
        }
        Point3f point3f = new Point3f(0.0f, 0.0f, 0.0f);
        if (this.statementLength == 5) {
            point3f.x = this.floatParameter(2);
            point3f.y = this.floatParameter(3);
            point3f.z = this.floatParameter(4);
        } else if (this.isCenterParameter(2)) {
            point3f = this.centerParameter(2);
            this.checkLength(this.iToken + 1);
        } else {
            this.checkLength(2);
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setCenterAt(string, point3f);
        }
    }

    private void stereo() throws ScriptException {
        int n = 1;
        float f = -5.0f;
        boolean bl = false;
        int[] nArray = new int[2];
        int n2 = 0;
        String string = "";
        block6: for (int i = 1; i < this.statementLength; ++i) {
            if (this.isColorParam(i)) {
                if (n2 > 1) {
                    this.error(1);
                }
                if (!bl) {
                    f = 3.0f;
                }
                nArray[n2++] = this.getArgbParam(i);
                i = this.iToken;
                if (n2 == 1) {
                    nArray[n2] = ~nArray[0];
                }
                string = string + " " + Escape.escapeColor((int)nArray[n2 - 1]);
                continue;
            }
            switch (this.getToken((int)i).tok) {
                case 0x100011: {
                    this.checkLength(2);
                    this.iToken = 1;
                    string = " on";
                    continue block6;
                }
                case 0x100010: {
                    this.checkLength(2);
                    this.iToken = 1;
                    n = 0;
                    string = " off";
                    continue block6;
                }
                case 2: 
                case 3: {
                    f = this.floatParameter(i);
                    bl = true;
                    string = string + " " + f;
                    continue block6;
                }
                case 1: {
                    String string2 = this.parameterAsString(i);
                    string = string + " " + string2;
                    if (!bl) {
                        f = 3.0f;
                    }
                    if (string2.equalsIgnoreCase("redblue")) {
                        n = 3;
                        continue block6;
                    }
                    if (string2.equalsIgnoreCase("redcyan")) {
                        n = 2;
                        continue block6;
                    }
                    if (string2.equalsIgnoreCase("redgreen")) {
                        n = 4;
                        continue block6;
                    }
                }
                default: {
                    this.error(20);
                }
            }
        }
        this.setFloatProperty("stereoDegrees", f);
        this.checkLength(this.iToken + 1);
        if (this.isSyntaxCheck) {
            return;
        }
        if (n2 > 0) {
            this.viewer.setStereoMode(nArray, string);
        } else {
            this.viewer.setStereoMode(n, string);
        }
    }

    private void connect() throws ScriptException {
        int n;
        int n2;
        float[] fArray = new float[2];
        BitSet[] bitSetArray = new BitSet[2];
        bitSetArray[0] = bitSetArray[1] = this.viewer.getSelectionSet();
        float f = Float.NaN;
        int n3 = Integer.MIN_VALUE;
        int n4 = 0;
        short s = Short.MAX_VALUE;
        int n5 = 3;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = null;
        float f2 = Float.MAX_VALUE;
        boolean bl4 = false;
        int n6 = 0;
        int n7 = 0;
        BitSet bitSet = new BitSet();
        boolean bl5 = false;
        int n8 = 0;
        if (this.statementLength == 1) {
            this.viewer.rebond();
            return;
        }
        block13: for (n2 = 1; n2 < this.statementLength; ++n2) {
            if (this.isColorParam(n2)) {
                n3 = this.getArgbParam(n2);
                n2 = this.iToken;
                bl4 = true;
                continue;
            }
            switch (this.getToken((int)n2).tok) {
                case 0x100010: 
                case 0x100011: {
                    this.checkLength(2);
                    if (!this.isSyntaxCheck) {
                        this.viewer.rebond();
                    }
                    return;
                }
                case 2: 
                case 3: {
                    short s2;
                    if (n6 > 0) {
                        if (bl2 || bl4) {
                            this.error(21);
                        }
                        if ((s2 = JmolConstants.getBondOrderFromFloat(this.floatParameter(n2))) == Short.MAX_VALUE) {
                            this.error(20);
                        }
                        s = s2;
                        bl2 = true;
                        continue block13;
                    }
                    if (++n7 > 2) {
                        this.error(1);
                    }
                    fArray[n4++] = this.floatParameter(n2);
                    continue block13;
                }
                case 0x100001: 
                case 0x4000007: {
                    int n9;
                    if (n6 > 2 || bl5 && n6 > 0) {
                        this.error(1);
                    }
                    if (bl2 || bl4) {
                        this.error(21);
                    }
                    bitSetArray[n6++] = this.expression(n2);
                    bl5 = this.isBondSet;
                    if (n6 == 2) {
                        n = this.iToken;
                        for (n9 = n2; n9 < n; ++n9) {
                            if (this.tokAt(n9) != 1 || !this.parameterAsString(n9).equals("_1")) continue;
                            n8 = n2;
                            break;
                        }
                        this.iToken = n;
                    }
                    n2 = this.iToken;
                    continue block13;
                }
                case 1: 
                case 135794713: {
                    int n9;
                    String string2 = this.parameterAsString(n2);
                    if (string2.equalsIgnoreCase("pdb")) {
                        n9 = this.optParameterAsString(2).equalsIgnoreCase("auto");
                        if (n9 != 0) {
                            this.checkLength(3);
                        } else {
                            this.checkLength(2);
                        }
                        if (this.isSyntaxCheck) {
                            return;
                        }
                        this.viewer.setPdbConectBonding(n9 != 0);
                        return;
                    }
                    short s2 = JmolConstants.getBondOrderFromString(string2);
                    if (s2 == Short.MAX_VALUE) {
                        bl3 = true;
                        if (++n2 != this.statementLength) {
                            this.error(21);
                        }
                        if ((n5 = JmolConstants.connectOperationFromString(string2)) < 0) {
                            this.error(20);
                        }
                        if (n5 != 4 || s == Short.MAX_VALUE || s == 2048 || s == 515) continue block13;
                        this.error(20);
                        continue block13;
                    }
                    if (bl2) {
                        this.error(16);
                    }
                    bl2 = true;
                    if (s2 == 33) {
                        switch (this.tokAt(n2 + 1)) {
                            case 3: {
                                s2 = JmolConstants.getPartialBondOrderFromInteger(this.statement[++n2].intValue);
                                break;
                            }
                            case 2: {
                                s2 = (short)this.intParameter(++n2);
                            }
                        }
                    }
                    s = s2;
                    continue block13;
                }
                case 67108901: 
                case 67108926: {
                    if (string != null) {
                        this.error(20);
                    }
                    bl4 = true;
                    string = this.parameterAsString(n2);
                    if (this.theTok != 67108926 || !this.isFloatParameter(n2 + 1)) continue block13;
                    f2 = this.floatParameter(++n2);
                    continue block13;
                }
                case 137363473: {
                    f = this.floatParameter(++n2);
                    bl4 = true;
                    continue block13;
                }
                case 12291: 
                case 0x10000F: {
                    if (++n2 != this.statementLength) {
                        this.error(21);
                    }
                    n5 = 0;
                    if (bl4) {
                        this.error(20);
                    }
                    bl = true;
                    continue block13;
                }
                default: {
                    this.error(20);
                }
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (n4 < 2) {
            if (n4 == 0) {
                fArray[0] = 1.0E8f;
            }
            fArray[1] = fArray[0];
            fArray[0] = 0.1f;
        }
        if (string != null || !Float.isNaN(f) || n3 != Integer.MIN_VALUE) {
            if (!bl2) {
                s = 16383;
            }
            if (!bl3) {
                n5 = 1;
            }
        }
        n2 = 0;
        n = 0;
        if (n8 > 0) {
            BitSet bitSet2 = new BitSet();
            this.variables.put("_1", bitSet2);
            for (int i = bitSetArray[0].size(); i >= 0; --i) {
                if (!bitSetArray[0].get(i)) continue;
                bitSet2.set(i);
                int[] nArray = this.viewer.makeConnections(fArray[0], fArray[1], s, n5, bitSet2, this.expression(n8), bitSet, bl5);
                n2 += nArray[0];
                n += nArray[1];
                bitSet2.clear(i);
            }
        } else {
            int[] nArray = this.viewer.makeConnections(fArray[0], fArray[1], s, n5, bitSetArray[0], bitSetArray[1], bitSet, bl5);
            n2 += nArray[0];
            n += nArray[1];
        }
        if (bl) {
            if (!this.tQuiet && this.scriptLevel <= this.scriptReportingLevel) {
                this.scriptStatus(GT._((String)"{0} connections deleted", (int)n));
            }
            return;
        }
        if (bl4) {
            this.viewer.selectBonds(bitSet);
            if (!Float.isNaN(f)) {
                this.viewer.setShapeSize(1, (int)(f * 2000.0f), bitSet);
            }
            if (n3 != Integer.MIN_VALUE) {
                this.viewer.setShapeProperty(1, "color", new Integer(n3), bitSet);
            }
            if (string != null) {
                if (f2 == Float.MAX_VALUE) {
                    f2 = this.viewer.getDefaultTranslucent();
                }
                this.viewer.setShapeProperty(1, "translucentLevel", new Float(f2));
                this.viewer.setShapeProperty(1, "translucency", string, bitSet);
            }
        }
        if (!this.tQuiet && this.scriptLevel <= this.scriptReportingLevel) {
            this.scriptStatus(GT._((String)"{0} new bonds; {1} modified", (Object[])new Object[]{new Integer(n2), new Integer(n)}));
        }
    }

    private void getProperty() throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String string = "";
        String string2 = this.optParameterAsString(1);
        String string3 = this.optParameterAsString(2);
        int n = this.tokAt(2);
        BitSet bitSet = n == 0x100001 || n == 0x4000007 ? this.expression(2) : null;
        int n2 = PropertyManager.getPropertyNumber(string2);
        if (string2.length() > 0 && n2 < 0) {
            string2 = "";
            string3 = "";
        } else if (n2 >= 0 && this.statementLength < 3) {
            string3 = PropertyManager.getDefaultParam(n2);
            if (string3.equals("(visible)")) {
                this.viewer.setModelVisibility();
                bitSet = this.viewer.getVisibleSet();
            }
        } else if (n2 == 3) {
            for (int i = 3; i < this.statementLength; ++i) {
                string3 = string3 + this.parameterAsString(i);
            }
        }
        string = (String)this.viewer.getProperty("readable", string2, bitSet == null ? string3 : bitSet);
        this.showString(string);
    }

    private void background(int n) throws ScriptException {
        this.getToken(n);
        if (this.isColorParam(n) || this.theTok == 0x10000F) {
            int n2 = this.getArgbParamLast(n, true);
            if (!this.isSyntaxCheck) {
                this.viewer.setObjectArgb("background", n2);
            }
            return;
        }
        int n3 = this.getShapeType(this.theTok);
        this.colorShape(n3, n + 1, true);
    }

    private void center(int n) throws ScriptException {
        if (this.statementLength == 1) {
            this.viewer.setNewRotationCenter(null);
            return;
        }
        Point3f point3f = this.centerParameter(n);
        if (point3f == null) {
            this.error(20);
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setNewRotationCenter(point3f);
        }
    }

    private void color() throws ScriptException {
        int n = 0;
        if (this.isColorParam(1)) {
            this.colorObject(0x700001, 1);
            return;
        }
        switch (this.getToken((int)1).tok) {
            case 0x100009: {
                this.colorShape(this.setShapeByNameParameter(2), 3, false);
                return;
            }
            case 528438: 
            case 0x100004: 
            case 0x100006: 
            case 0x10000B: 
            case 0x10000C: 
            case 0x10000F: 
            case 0x30000E: 
            case 3145750: 
            case 3145865: 
            case 3145866: 
            case 3146007: 
            case 3146118: 
            case 3146123: 
            case 3149845: 
            case 0x2100001: 
            case 0x4000011: 
            case 67108887: 
            case 67108893: 
            case 67108901: 
            case 67108909: 
            case 67108918: 
            case 67108926: 
            case 0x4000041: 
            case 137363721: 
            case 141558028: {
                this.colorObject(0x700001, 1);
                return;
            }
            case 4: {
                String string = this.stringParameter(1);
                this.setStringProperty("propertyColorSchemeOverLoad", string);
                if (this.tokAt(2) == 67108908 || this.tokAt(2) == 0x4000001) {
                    float f = this.floatParameter(3);
                    float f2 = this.floatParameter(4);
                    if (!this.isSyntaxCheck) {
                        this.viewer.setCurrentColorRange(f, f2);
                    }
                }
                return;
            }
            case 0x4000001: 
            case 67108908: {
                this.checkLength(4);
                float f = this.floatParameter(2);
                float f3 = this.floatParameter(3);
                if (!this.isSyntaxCheck) {
                    this.viewer.setCurrentColorRange(f, f3);
                }
                return;
            }
            case 134221828: {
                n = this.getArgbParamLast(2, true);
                if (!this.isSyntaxCheck) {
                    this.viewer.setObjectArgb("background", n);
                }
                return;
            }
            case 0x100001: 
            case 0x4000007: {
                this.colorObject(0x700001, -1);
                return;
            }
            case 0x4000033: {
                n = this.getArgbParamLast(2, false);
                if (!this.isSyntaxCheck) {
                    this.viewer.setRubberbandArgb(n);
                }
                return;
            }
            case 134746163: {
                int n2 = 2;
                if (this.tokAt(2) == 67108901) {
                    ++n2;
                }
                n = this.getArgbParamLast(n2, true);
                if (this.isSyntaxCheck) {
                    return;
                }
                this.viewer.loadShape(15);
                this.setShapeProperty(15, "argbSelection", new Integer(n));
                return;
            }
            case 1: 
            case 134746114: 
            case 142086157: 
            case 168820740: 
            case 169349184: {
                String string = this.parameterAsString(1);
                if (this.checkToken(2)) {
                    switch (this.getToken((int)2).tok) {
                        case 67108909: {
                            n = 67108909;
                            break;
                        }
                        case 0x10000F: 
                        case 67108887: {
                            n = 67108887;
                            break;
                        }
                        default: {
                            n = this.getArgbParam(2);
                        }
                    }
                }
                if (n == 0) {
                    this.error(8);
                }
                this.checkLength(this.iToken + 1);
                if (string.equalsIgnoreCase("axes")) {
                    this.setStringProperty("axesColor", Escape.escapeColor((int)n));
                    return;
                }
                if (StateManager.getObjectIdFromName(string) >= 0) {
                    if (!this.isSyntaxCheck) {
                        this.viewer.setObjectArgb(string, n);
                    }
                    return;
                }
                if (this.changeElementColor(string, n)) {
                    return;
                }
                this.error(20);
            }
            case 4125: {
                this.setShapeProperty(22, "thisID", "+PREVIOUS_MESH+");
            }
        }
        this.colorObject(this.theTok, 2);
    }

    private boolean changeElementColor(String string, int n) {
        int n2 = JmolConstants.elementNumberMax;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase(JmolConstants.elementNameFromNumber(n2))) continue;
            if (!this.isSyntaxCheck) {
                this.viewer.setElementArgb(n2, n);
            }
            return true;
        }
        n2 = JmolConstants.altElementMax;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase(JmolConstants.altElementNameFromIndex(n2))) continue;
            if (!this.isSyntaxCheck) {
                this.viewer.setElementArgb(JmolConstants.altElementNumberFromIndex(n2), n);
            }
            return true;
        }
        if (string.charAt(0) != '_') {
            return false;
        }
        n2 = JmolConstants.elementNumberMax;
        while (--n2 >= 0) {
            if (!string.equalsIgnoreCase("_" + JmolConstants.elementSymbolFromNumber(n2))) continue;
            if (!this.isSyntaxCheck) {
                this.viewer.setElementArgb(n2, n);
            }
            return true;
        }
        n2 = JmolConstants.altElementMax;
        while (--n2 >= 4) {
            if (string.equalsIgnoreCase("_" + JmolConstants.altElementSymbolFromIndex(n2))) {
                if (!this.isSyntaxCheck) {
                    this.viewer.setElementArgb(JmolConstants.altElementNumberFromIndex(n2), n);
                }
                return true;
            }
            if (!string.equalsIgnoreCase("_" + JmolConstants.altIsotopeSymbolFromIndex(n2))) continue;
            if (!this.isSyntaxCheck) {
                this.viewer.setElementArgb(JmolConstants.altElementNumberFromIndex(n2), n);
            }
            return true;
        }
        return false;
    }

    private void colorObject(int n, int n2) throws ScriptException {
        this.colorShape(this.getShapeType(n), n2, false);
    }

    private void colorShape(int n, int n2, boolean bl) throws ScriptException {
        String string = null;
        Number number = null;
        BitSet bitSet = null;
        String string2 = "";
        boolean bl2 = false;
        int n3 = 0;
        float f = Float.MAX_VALUE;
        if (n2 < 0) {
            bitSet = this.expression(-n2);
            n2 = this.iToken + 1;
            if (this.isBondSet) {
                n = 1;
            }
        }
        if (bl) {
            this.getToken(n2);
        } else {
            bl = this.getToken((int)n2).tok == 134221828;
            if (bl) {
                this.getToken(++n2);
            }
        }
        if (bl) {
            string2 = "bg";
        }
        if (!this.isSyntaxCheck && n == 24 && !this.mo(true)) {
            return;
        }
        if (this.theTok == 67108926 || this.theTok == 67108901) {
            string = this.parameterAsString(n2++);
            if (this.theTok == 67108926 && this.isFloatParameter(n2)) {
                f = this.floatParameter(n2++);
            }
        }
        if (n2 < this.statementLength && this.tokAt(n2) != 0x100011 && this.tokAt(n2) != 0x100010) {
            bl2 = true;
            int n4 = this.getToken((int)n2).tok;
            if (this.isColorParam(n2)) {
                int n5 = this.getArgbParam(n2, false);
                Integer n6 = number = n5 == 0 ? null : new Integer(n5);
                if (string == null && this.tokAt(n2 = this.iToken + 1) != 0) {
                    this.getToken(n2);
                    if (string == null && (this.theTok == 67108926 || this.theTok == 67108901)) {
                        string = this.parameterAsString(n2);
                        if (this.theTok == 67108926 && this.isFloatParameter(n2 + 1)) {
                            f = this.floatParameter(++n2);
                        }
                    }
                }
            } else if (n == 23) {
                --this.iToken;
            } else {
                int n7;
                boolean bl3;
                String string3 = this.parameterAsString(n2).toLowerCase();
                boolean bl4 = string3.indexOf("byelement") == 0;
                boolean bl5 = bl3 = bl4 || string3.indexOf("byresidue") == 0;
                int n8 = bl3 || n == 22 ? 83 : (n7 = n4 == 528438 ? 1 : (int)JmolConstants.getPaletteID(string3));
                if (n7 == -1 || n7 == 18 && n != 2) {
                    this.error(20);
                }
                Object object = null;
                if (n7 == 83) {
                    if (bl3) {
                        if (!this.isSyntaxCheck) {
                            object = this.getBitsetProperty(null, (bl4 ? 0x300007 : 0x30000A) | 0x60, null, null, null, null, false, -1);
                        }
                    } else {
                        if (!bl3 && n != 22) {
                            ++n2;
                        }
                        if (string3.equals("property") && Compiler.tokAttr(this.getToken((int)n2).tok, 0x300000) && !this.isSyntaxCheck && !((object = (Object)this.getBitsetProperty(null, this.getToken((int)n2++).tok | 0x60, null, null, null, null, false, -1)) instanceof float[])) {
                            this.error(20);
                        }
                    }
                } else if (n7 == 84) {
                    int n9 = ++n2;
                    ++n2;
                    string3 = this.parameterAsString(n9);
                    object = new float[this.viewer.getAtomCount()];
                    Parser.parseFloatArray((String)("" + this.getParameter(string3, false)), null, (float[])object);
                    n7 = 83;
                }
                if (n7 == 83) {
                    String string4;
                    String string5 = string4 = this.tokAt(n2) == 4 ? this.parameterAsString(n2++).toLowerCase() : null;
                    if (string4 != null) {
                        this.setStringProperty("propertyColorScheme", string4);
                        bl3 = string4.indexOf("byelement") == 0 || string4.indexOf("byresidue") == 0;
                    }
                    float f2 = 0.0f;
                    float f3 = Float.MAX_VALUE;
                    if (!(bl3 || this.tokAt(n2) != 0x4000001 && this.tokAt(n2) != 67108908)) {
                        f2 = this.floatParameter(n2 + 1);
                        f3 = this.floatParameter(n2 + 2);
                        n2 += 3;
                        if (f2 == f3 && n == 22) {
                            float[] fArray = (float[])this.viewer.getShapeProperty(n, "dataRange");
                            if (fArray != null) {
                                f2 = fArray[0];
                                f3 = fArray[1];
                            }
                        } else if (f2 == f3) {
                            f3 = Float.MAX_VALUE;
                        }
                    }
                    if (!this.isSyntaxCheck) {
                        if (n != 22 && f3 != -3.4028235E38f) {
                            if (object == null) {
                                this.viewer.setCurrentColorRange(string3);
                            } else {
                                this.viewer.setCurrentColorRange((float[])object, null);
                            }
                        }
                        if (f3 != Float.MAX_VALUE) {
                            this.viewer.setCurrentColorRange(f2, f3);
                        }
                    }
                    if (n == 22) {
                        string2 = "remap";
                    }
                } else {
                    ++n2;
                }
                number = new Byte((byte)n7);
                this.checkLength(n2);
            }
            if (this.isSyntaxCheck || n < 0) {
                return;
            }
            switch (n4) {
                case 3145866: {
                    this.viewer.getSurfaceDistanceMax();
                    break;
                }
                case 3146123: {
                    if (!this.viewer.isRangeSelected()) break;
                    this.viewer.clearBfactorRange();
                    break;
                }
                case 0x10000B: {
                    this.viewer.calcSelectedGroupsCount();
                    break;
                }
                case 67108893: {
                    this.viewer.calcSelectedMonomersCount();
                    break;
                }
                case 0x30000E: {
                    this.viewer.calcSelectedMoleculesCount();
                }
            }
        }
        int n10 = n == 2 ? 30720 : (n == 3 ? 256 : (n3 = n == 1 ? 1023 : 0));
        if (n3 == 0) {
            this.viewer.loadShape(n);
            if (n == 4) {
                this.setShapeProperty(4, "setDefaults", this.viewer.getNoneSelected());
            }
        } else {
            if (bitSet != null) {
                this.viewer.selectBonds(bitSet);
                bitSet = null;
            }
            n = 1;
            this.setShapeProperty(n, "type", new Integer(n3));
        }
        if (bl2) {
            if (bitSet != null) {
                this.viewer.setShapeProperty(n, string2 + "color", number, bitSet);
            } else {
                this.viewer.setShapeProperty(n, string2 + "color", number);
            }
        }
        if (string != null) {
            this.setShapeTranslucency(n, string2, string, f);
        }
        if (n3 != 0) {
            this.viewer.setShapeProperty(1, "type", new Integer(1023));
        }
    }

    private void setShapeTranslucency(int n, String string, String string2, float f) {
        if (f == Float.MAX_VALUE) {
            f = this.viewer.getDefaultTranslucent();
        }
        this.setShapeProperty(n, "translucentLevel", new Float(f));
        if (string != null) {
            this.setShapeProperty(n, string + "translucency", string2);
        }
    }

    private void data() throws ScriptException {
        boolean bl;
        String string = null;
        String string2 = null;
        boolean bl2 = false;
        this.iToken = this.statementLength;
        switch (this.iToken) {
            case 5: {
                string = this.parameterAsString(2);
            }
            case 2: 
            case 4: {
                string2 = this.parameterAsString(1);
                if (string2.equalsIgnoreCase("clear")) {
                    if (!this.isSyntaxCheck) {
                        this.viewer.setData(null, null, 0, 0, 0);
                    }
                    return;
                }
                int n = string2.indexOf("@");
                if (n >= 0) {
                    string = "" + this.getParameter(string2.substring(n + 1), false);
                    string2 = string2.substring(0, n).trim();
                    break;
                }
                if (string != null || (n = string2.indexOf(" ")) < 0) break;
                string = string2.substring(n + 1).trim();
                string2 = string2.substring(0, n).trim();
                bl2 = true;
                break;
            }
            default: {
                this.error(1);
            }
        }
        string2 = string2.toLowerCase();
        String string3 = string2 + " ";
        string3 = string3.substring(0, string3.indexOf(" "));
        boolean bl3 = string3.equals("model");
        boolean bl4 = string3.equals("append");
        boolean bl5 = bl = (bl3 || bl4) && (!this.isSyntaxCheck || this.isScriptCheck && this.fileOpenCheck);
        if ((bl3 || bl4) && string == null) {
            this.error(20);
        }
        int n = -1;
        if (!this.isSyntaxCheck || bl) {
            this.data = new Object[3];
            if (string3.equals("element_vdw")) {
                this.data[0] = string3;
                this.data[1] = string.replace(';', '\n');
                int n2 = JmolConstants.elementNumberMax;
                int[] nArray = new int[n2 + 1];
                for (int i = 1; i <= n2; ++i) {
                    nArray[i] = i;
                }
                this.data[2] = nArray;
                this.viewer.setData("element_vdw", this.data, n2, 0, 0);
                return;
            }
            if (string3.indexOf("data2d_") == 0) {
                this.data[0] = string2;
                this.data[1] = Parser.parseFloatArray2d((String)string);
                this.viewer.setData(string2, this.data, 0, 0, 0);
                return;
            }
            String[] stringArray = Parser.getTokens((String)string2);
            if (!(string3.indexOf("property_") != 0 || stringArray.length == 2 && stringArray[1].equals("set"))) {
                int n3;
                BitSet bitSet = this.viewer.getSelectionSet();
                this.data[0] = string3;
                int n4 = bl2 ? 0 : (Integer)this.viewer.getParameter("propertyAtomNumberField");
                int n5 = n3 = bl2 ? Integer.MIN_VALUE : (Integer)this.viewer.getParameter("propertyDataField");
                if (!bl2 && string2.indexOf(" ") >= 0 && stringArray.length == 3) {
                    string2 = stringArray[0];
                    n4 = Parser.parseInt((String)stringArray[1]);
                    n3 = Parser.parseInt((String)stringArray[2]);
                    if (n4 < 0) {
                        n4 = 0;
                    }
                    if (n3 < 0) {
                        n3 = 0;
                    }
                }
                int n6 = this.viewer.getAtomCount();
                int[] nArray = null;
                BitSet bitSet2 = new BitSet(n6);
                if (n4 > 0) {
                    int n7;
                    nArray = new int[n6 + 2];
                    for (n7 = 0; n7 <= n6; ++n7) {
                        nArray[n7] = -1;
                    }
                    for (n7 = 0; n7 < n6; ++n7) {
                        int n8;
                        if (!bitSet.get(n7) || (n8 = this.viewer.getAtomNumber(n7)) > n6 + 1 || n8 < 0 || bitSet2.get(n8)) continue;
                        bitSet2.set(n8);
                        nArray[n8] = n7;
                    }
                    this.data[2] = nArray;
                } else {
                    this.data[2] = bitSet;
                }
                this.data[1] = string;
                this.viewer.setData(string3, this.data, n6, n4, n3);
                n = Integer.MAX_VALUE;
            } else {
                this.data[0] = string2;
                this.data[1] = string;
                this.viewer.setData(string3, this.data, 0, 0, 0);
            }
        }
        if (bl) {
            char c = this.viewer.getInlineChar();
            if (string.length() > 0 && string.charAt(0) != c) {
                c = '\u0000';
            }
            this.viewer.loadInline(string, c, bl4);
            return;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (n < 0) {
            n = AtomCollection.getUserSettableType(string3);
        }
        if (n >= 0 && n <= 8) {
            this.viewer.loadData(n, string3, string);
        }
    }

    private void define() throws ScriptException {
        boolean bl;
        String string = (String)this.getToken((int)1).value;
        BitSet bitSet = this.expression(2);
        if (this.isSyntaxCheck) {
            return;
        }
        boolean bl2 = bl = string.indexOf("dynamic_") == 0;
        if (bl) {
            Token[] tokenArray = new Token[this.statementLength];
            int n = this.statementLength;
            while (--n >= 0) {
                tokenArray[n] = this.statement[n];
            }
            this.variables.put("!" + string.substring(8), tokenArray);
            this.viewer.addStateScript(this.thisCommand, false, true);
        } else {
            this.assignBitsetVariable(string, bitSet);
        }
    }

    private void echo(int n) throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String string = this.optParameterAsString(n);
        if (this.viewer.getEchoStateActive()) {
            this.setShapeProperty(29, "text", string);
        }
        if (this.viewer.getRefreshing()) {
            this.showString(this.viewer.formatText(string));
        }
    }

    private void message() throws ScriptException {
        this.checkLength(2);
        String string = this.parameterAsString(1);
        if (this.isSyntaxCheck) {
            return;
        }
        String string2 = this.viewer.formatText(string);
        if (this.outputBuffer == null) {
            Logger.warn((String)string2);
        }
        if (!string2.startsWith("_")) {
            this.scriptStatus(string2);
        }
    }

    private void scriptStatus(String string) {
        if (this.outputBuffer != null) {
            this.outputBuffer.append(string).append('\n');
            return;
        }
        this.viewer.scriptStatus(string);
    }

    private void pause() throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        this.pauseExecution();
        String string = this.optParameterAsString(1);
        string = string.length() == 0 ? ": RESUME to continue." : ": " + this.viewer.formatText(string);
        this.viewer.scriptStatus("script execution paused" + string);
    }

    private void label(int n) throws ScriptException {
        String string;
        if (this.isSyntaxCheck) {
            return;
        }
        if ((string = this.parameterAsString(n++)).equalsIgnoreCase("on")) {
            string = this.viewer.getStandardLabelFormat();
        } else if (string.equalsIgnoreCase("off")) {
            string = null;
        }
        this.viewer.loadShape(4);
        this.viewer.setLabel(string);
    }

    private void hover() throws ScriptException {
        if (this.isSyntaxCheck) {
            return;
        }
        String string = this.parameterAsString(1);
        if (string.equalsIgnoreCase("on")) {
            string = "%U";
        } else if (string.equalsIgnoreCase("off")) {
            string = null;
        }
        this.viewer.loadShape(30);
        this.setShapeProperty(30, "label", string);
    }

    private void load() throws ScriptException {
        Object object;
        String string;
        boolean bl = false;
        int n = this.viewer.getModelCount() - (this.viewer.getFileName().equals("zapped") ? 1 : 0);
        boolean bl2 = this.viewer.getAppendNew();
        StringBuffer stringBuffer = new StringBuffer("load");
        Object object2 = new int[4];
        int n2 = 1;
        Point3f point3f = this.viewer.getDefaultLattice();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (this.viewer.getApplySymmetryToBonds()) {
            hashtable.put("applySymmetryToBonds", Boolean.TRUE);
        }
        hashtable.put("params", object2);
        if (this.viewer.getPdbLoadInfo(2)) {
            hashtable.put("getHeader", Boolean.TRUE);
        }
        object2[1] = (int)point3f.x;
        object2[2] = (int)point3f.y;
        object2[3] = (int)point3f.z;
        int n3 = 1;
        String string2 = "fileset";
        if (this.statementLength == 1) {
            n3 = 0;
        } else {
            if (this.tokAt(1) == 1 || this.parameterAsString(1).equals("fileset")) {
                string2 = this.parameterAsString(1);
                if (string2.equals("menu")) {
                    this.checkLength(3);
                    if (!this.isSyntaxCheck) {
                        this.viewer.setMenu(this.parameterAsString(2), true);
                    }
                    return;
                }
                n3 = 2;
                stringBuffer.append(" " + string2);
                bl = string2.equalsIgnoreCase("append");
                if (string2.equalsIgnoreCase("trajectory")) {
                    object2[0] = -1;
                }
            }
            if (this.getToken((int)n3).tok != 4) {
                this.error(14);
            }
        }
        if (this.statementLength == n3 + 1) {
            String string3;
            if (n3 == 0 || (string3 = this.parameterAsString(n3)).length() == 0) {
                string3 = this.viewer.getFullPathName();
            }
            if (string3 == null) {
                this.zap(false);
                return;
            }
            if (string3.equals("string[]")) {
                return;
            }
            if (!this.isSyntaxCheck || this.isScriptCheck && this.fileOpenCheck) {
                this.viewer.openFile(string3, hashtable, null, bl);
                stringBuffer.append(" ");
                if (!string3.equals("string") && !string3.equals("string[]")) {
                    stringBuffer.append("/*file*/");
                }
                string2 = (String)hashtable.get("fullPathName");
                stringBuffer.append(Escape.escape((String)string2));
            }
        } else if (this.getToken((int)(n3 + 1)).tok == 0x10000E || this.theTok == 7 || this.theTok == 2 || this.theTok == 1) {
            String string4;
            if ((string4 = this.parameterAsString(n3++)).length() == 0) {
                string4 = this.viewer.getFullPathName();
            }
            if (string4 == null) {
                this.zap(false);
                return;
            }
            if (string4.equals("string[]")) {
                return;
            }
            String string5 = "";
            int n4 = this.tokAt(n3);
            if (n4 == 1 && this.parameterAsString(n3).equalsIgnoreCase("manifest")) {
                string = this.stringParameter(++n3);
                hashtable.put("manifest", string);
                string5 = string5 + " MANIFEST " + Escape.escape((String)string);
                n4 = this.tokAt(++n3);
            }
            if (n4 == 2) {
                object2[0] = this.intParameter(n3);
                string5 = string5 + " " + object2[0];
                n4 = this.tokAt(++n3);
            }
            if (n4 == 0x10000E || n4 == 7) {
                int n5;
                point3f = this.getPoint3f(n3, false);
                n3 = this.iToken + 1;
                object2[1] = (int)point3f.x;
                object2[2] = (int)point3f.y;
                object2[3] = (int)point3f.z;
                string5 = string5 + " " + Escape.escape((Tuple3f)point3f);
                int n6 = -1;
                float f = 0.0f;
                if (this.tokAt(n3) == 67108908) {
                    int n7 = ++n3;
                    ++n3;
                    f = this.floatParameter(n7);
                    string5 = string5 + " range " + f;
                }
                hashtable.put("symmetryRange", new Float(f));
                if (this.tokAt(n3) == 67108920) {
                    int n8 = ++n3;
                    ++n3;
                    String string6 = TextFormat.simpleReplace((String)this.parameterAsString(n8), (String)"''", (String)"\"");
                    string5 = string5 + " spacegroup " + Escape.escape((String)string6);
                    if (string6.equalsIgnoreCase("ignoreOperators")) {
                        n6 = -999;
                    } else {
                        if (string6.indexOf(",") >= 0 && point3f.x < 9.0f && point3f.y < 9.0f && point3f.z == 0.0f) {
                            string6 = string6 + "#doNormalize=0";
                        }
                        if ((n6 = SpaceGroup.determineSpaceGroupIndex((String)string6)) == -1) {
                            this.error(30, string6);
                        }
                    }
                    object = new int[5];
                    for (n5 = 0; n5 < 4; ++n5) {
                        object[n5] = object2[n5];
                    }
                    object[4] = n6;
                    object2 = object;
                    hashtable.put("params", object2);
                }
                if (this.tokAt(n3) == 169349184) {
                    ++n3;
                    object = new int[11];
                    for (int i = 0; i < ((int[])object2).length; ++i) {
                        object[i] = object2[i];
                    }
                    object[4] = n6;
                    float[] fArray = new float[6];
                    n3 = this.floatParameterSet(n3, fArray);
                    string5 = string5 + " unitcell {";
                    for (n5 = 0; n5 < 6; ++n5) {
                        object[5 + n5] = (int)(fArray[n5] * 10000.0f);
                        string5 = string5 + (n5 == 0 ? "" : " ") + (int)object[5 + n5];
                    }
                    string5 = string5 + "}";
                    object2 = object;
                    hashtable.put("params", object2);
                }
            }
            if (this.tokAt(n3) == 1 && this.parameterAsString(n3).equalsIgnoreCase("filter")) {
                string = this.stringParameter(++n3);
                hashtable.put("filter", string);
                string5 = string5 + " FILTER " + Escape.escape((String)string);
            }
            if (!this.isSyntaxCheck || this.isScriptCheck && this.fileOpenCheck) {
                this.viewer.openFile(string4, hashtable, null, bl);
                stringBuffer.append(" ");
                if (!string4.equals("string") && !string4.equals("string[]")) {
                    stringBuffer.append("/*file*/");
                }
                string2 = (String)hashtable.get("fullPathName");
                stringBuffer.append(Escape.escape((String)string2));
                stringBuffer.append(string5);
            }
        } else {
            if (n3 != 2) {
                string2 = this.parameterAsString(n3++);
                stringBuffer.append(" ").append(Escape.escape((String)string2));
            }
            String[] stringArray = new String[this.statementLength - n3];
            int n9 = 0;
            while (n3 < this.statementLength) {
                String string7 = this.parameterAsString(n3);
                stringArray[n9++] = string7;
                ++n3;
            }
            n2 = stringArray.length;
            if (!this.isSyntaxCheck || this.isScriptCheck && this.fileOpenCheck) {
                this.viewer.openFiles(string2, stringArray, null, bl);
                for (n3 = 0; n3 < n2; ++n3) {
                    stringBuffer.append(" /*file*/").append(Escape.escape((String)stringArray[n3]));
                }
            }
        }
        if (!(!this.isSyntaxCheck || this.isScriptCheck && this.fileOpenCheck)) {
            return;
        }
        this.viewer.addLoadScript(stringBuffer.toString());
        String string8 = this.viewer.getOpenFileError(bl);
        if (string8 != null && !this.isScriptCheck) {
            if (string8.indexOf("file recognized as a script file:") >= 0) {
                this.viewer.addLoadScript("-");
                this.script(false);
                return;
            }
            this.evalError(string8);
        }
        if (bl && (bl2 || n2 > 1)) {
            this.viewer.setAnimationRange(-1, -1);
            this.viewer.setCurrentModelIndex(n);
        }
        if (this.logMessages) {
            this.scriptStatus("Successfully loaded:" + string2);
        }
        String string9 = this.viewer.getDefaultLoadScript();
        string = "";
        if (string9.length() > 0) {
            string = string + "\nUsing defaultLoadScript: " + string9;
        }
        if ((object = this.viewer.getModelSetProperty("jmolscript")) != null && this.viewer.getAllowEmbeddedScripts()) {
            string = string + "\nAdding embedded #jmolscript: " + (String)object;
            string9 = string9 + ";" + (String)object;
            string9 = "allowEmbeddedScripts = false;" + string9 + ";allowEmbeddedScripts = true;";
        }
        if (string.length() > 0) {
            Logger.info((String)string);
        }
        if (string9.length() > 0 && !this.isScriptCheck) {
            this.runScript(string9);
        }
    }

    private String getFullPathName() throws ScriptException {
        String string;
        String string2 = string = !this.isSyntaxCheck || this.isScriptCheck && this.fileOpenCheck ? this.viewer.getFullPathName() : "test.xyz";
        if (string == null) {
            this.error(20);
        }
        return string;
    }

    private void dataFrame(int n) throws ScriptException {
        String string;
        boolean bl = false;
        boolean bl2 = this.tokAt(0) == 4112;
        int n2 = bl2 ? 1 : 0;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n3 = this.statementLength - 1;
        String string2 = this.optParameterAsString(n3).toLowerCase();
        switch (n) {
            case 0: {
                if (string2.equalsIgnoreCase("draw")) {
                    bl2 = true;
                    string2 = this.optParameterAsString(--n3).toLowerCase();
                }
                bl5 = n3 > n2 && string2.startsWith("r");
                string2 = "ramachandran" + (bl5 ? " r" : "") + (bl2 ? " draw" : "");
                break;
            }
            case 1: {
                bl = true;
                if (string2.equalsIgnoreCase("draw")) {
                    bl2 = true;
                    string2 = this.optParameterAsString(--n3).toLowerCase();
                }
                bl3 = string2.startsWith("deriv") || string2.startsWith("diff");
                boolean bl6 = bl4 = bl3 && string2.indexOf("2") > 0;
                if (bl3) {
                    --n3;
                }
                if ((string2 = ((n3 <= n2 ? "" : this.optParameterAsString(n3)) + "w").substring(0, 1)) == "a" || string2 == "r") {
                    bl3 = true;
                }
                if (!Parser.isOneOf((String)string2, (String)"w;x;y;z;r;a")) {
                    this.evalError("QUATERNION [w,x,y,z,a,r] [difference][2]");
                }
                string2 = "quaternion " + string2 + (bl3 ? " difference" : "") + (bl4 ? "2" : "") + (bl2 ? " draw" : "");
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        int n4 = this.viewer.getCurrentModelIndex();
        if (n4 < 0) {
            this.error(23, string2);
        }
        n4 = this.viewer.getJmolDataSourceFrame(n4);
        if (bl2) {
            this.runScript(this.viewer.getPdbData(n4, string2));
            return;
        }
        int n5 = this.viewer.getJmolDataFrameIndex(n4, string2);
        if (bl && n5 < 0 && this.statementLength == 1) {
            n5 = this.viewer.getJmolDataFrameIndex(n4, "quaternion");
        }
        if (n5 > 0) {
            this.viewer.setCurrentModelIndex(n5, true);
            return;
        }
        this.viewer.addStateScript(string2, true, false);
        String[] stringArray = this.viewer.getFileInfo();
        boolean bl7 = this.viewer.getAppendNew();
        this.viewer.setAppendNew(true);
        String string3 = this.viewer.getPdbData(n4, string2);
        boolean bl8 = string3 != null && this.viewer.loadInline(string3, '\n', true);
        this.viewer.setAppendNew(bl7);
        this.viewer.setFileInfo(stringArray);
        if (!bl8) {
            return;
        }
        int n6 = this.viewer.getModelCount();
        this.viewer.setJmolDataFrame(string2, n4, n6 - 1);
        switch (n) {
            default: {
                this.viewer.setFrameTitle(n6 - 1, string2 + " plot for model " + this.viewer.getModelNumberDotted(n4));
                string = "frame 0.0; frame last; reset;select visible; color structure; spacefill 3.0; wireframe 0;draw ramaAxisX" + n6 + " {200 0 0} {-200 0 0} \"phi\";" + "draw ramaAxisY" + n6 + " {0 200 0} {0 -200 0} \"psi\";";
                break;
            }
            case 1: {
                this.viewer.setFrameTitle(n6 - 1, string2 + " for model " + this.viewer.getModelNumberDotted(n4));
                string = "frame 0.0; frame last; reset;select visible; wireframe 0; isosurface quatSphere" + n6 + " resolution 1.0 sphere 10.0 mesh nofill translucent 0.8;" + "draw quatAxis" + n6 + "X {10 0 0} {-10 0 0} color red \"x\";" + "draw quatAxis" + n6 + "Y {0 10 0} {0 -10 0} color green \"y\";" + "draw quatAxis" + n6 + "Z {0 0 10} {0 0 -10} color blue \"z\";" + "color structure";
            }
        }
        this.runScript(string);
        this.viewer.loadShape(29);
        this.showString("frame " + this.viewer.getModelNumberDotted(n6 - 1) + " created: " + string2);
    }

    private void monitor() throws ScriptException {
        if (this.statementLength == 1) {
            this.viewer.hideMeasurements(false);
            return;
        }
        switch (this.statementLength) {
            case 2: {
                switch (this.getToken((int)1).tok) {
                    case 0x100011: {
                        if (!this.isSyntaxCheck) {
                            this.viewer.hideMeasurements(false);
                        }
                        return;
                    }
                    case 0x100010: {
                        if (!this.isSyntaxCheck) {
                            this.viewer.hideMeasurements(true);
                        }
                        return;
                    }
                    case 12291: {
                        if (!this.isSyntaxCheck) {
                            this.viewer.clearAllMeasurements();
                        }
                        return;
                    }
                    case 4: {
                        if (!this.isSyntaxCheck) {
                            this.viewer.setMeasurementFormats(this.stringParameter(1));
                        }
                        return;
                    }
                }
                this.error(22, "ON, OFF, DELETE");
            }
            case 3: {
                if (this.getToken((int)1).tok != 12291) break;
                if (this.getToken((int)2).tok == 0x100003) {
                    if (!this.isSyntaxCheck) {
                        this.viewer.clearAllMeasurements();
                    }
                } else {
                    int n = this.intParameter(2) - 1;
                    if (!this.isSyntaxCheck) {
                        this.viewer.deleteMeasurement(n);
                    }
                }
                return;
            }
        }
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        int[] nArray = new int[5];
        float[] fArray = new float[]{Float.MAX_VALUE, Float.MAX_VALUE};
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        boolean bl5 = false;
        boolean bl6 = false;
        String string = null;
        Vector<Point3f> vector = new Vector<Point3f>();
        BitSet bitSet = new BitSet();
        Object object = null;
        block22: for (int i = 1; i < this.statementLength; ++i) {
            switch (this.getToken((int)i).tok) {
                default: {
                    this.error(13);
                }
                case 0x100011: {
                    if (bl5 || bl6 || bl3) {
                        this.error(20);
                    }
                    bl5 = true;
                    continue block22;
                }
                case 0x100010: {
                    if (bl5 || bl6 || bl3) {
                        this.error(20);
                    }
                    bl6 = true;
                    continue block22;
                }
                case 12291: {
                    if (bl5 || bl6 || bl3) {
                        this.error(20);
                    }
                    bl3 = true;
                    continue block22;
                }
                case 67108908: {
                    bl = true;
                    bl4 = true;
                    n3 = -1;
                    continue block22;
                }
                case 1: {
                    if (!this.parameterAsString(i).equalsIgnoreCase("ALLCONNECTED")) {
                        this.error(22, "ALL, ALLCONNECTED, DELETE");
                    }
                    bl2 = true;
                }
                case 0x100003: {
                    n3 = -1;
                    bl = true;
                    continue block22;
                }
                case 4: {
                    string = this.stringParameter(i);
                    continue block22;
                }
                case 3: {
                    bl = true;
                    bl4 = true;
                    n4 = (n4 + 1) % 2;
                    fArray[n4] = this.floatParameter(i);
                    continue block22;
                }
                case 2: {
                    int n5 = this.intParameter(i);
                    if (bl) {
                        bl4 = true;
                        n4 = (n4 + 1) % 2;
                        fArray[n4] = n5;
                        continue block22;
                    }
                    n3 = this.viewer.getAtomIndexFromAtomNumber(n5);
                    if (!this.isSyntaxCheck && n3 < 0) {
                        return;
                    }
                    if (object != null) {
                        this.error(20);
                    }
                    if ((nArray[0] = ++n) > 4) {
                        this.error(1);
                    }
                    nArray[n] = n3;
                    continue block22;
                }
                case 7: 
                case 0x100001: 
                case 0x100009: 
                case 0x10000E: 
                case 0x4000007: {
                    if (n3 >= 0) {
                        this.error(20);
                    }
                    this.expressionResult = Boolean.FALSE;
                    object = this.centerParameter(i);
                    if (this.expressionResult instanceof BitSet) {
                        bitSet = (BitSet)this.expressionResult;
                        object = bitSet;
                        if (!this.isSyntaxCheck && BitSetUtil.firstSetBit((BitSet)bitSet) < 0) {
                            return;
                        }
                    }
                    if ((n = ++n2) > 4) {
                        this.error(1);
                    }
                    vector.addElement((Point3f)object);
                    i = this.iToken;
                    continue block22;
                }
            }
        }
        if (n < 2) {
            this.error(1);
        }
        if (string != null && string.indexOf(n + ":") != 0) {
            string = n + ":" + string;
        }
        if (bl4 && fArray[1] < fArray[0]) {
            fArray[1] = fArray[0];
            float f = fArray[0] = fArray[1] == Float.MAX_VALUE ? Float.MAX_VALUE : -200.0f;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (object != null) {
            this.viewer.defineMeasurement(vector, fArray, bl3, bl, bl2, bl5, bl6, string);
            return;
        }
        if (bl3) {
            this.viewer.deleteMeasurement(nArray);
        } else if (bl5) {
            this.viewer.showMeasurement(nArray, true);
        } else if (bl6) {
            this.viewer.showMeasurement(nArray, false);
        } else {
            this.viewer.toggleMeasurement(nArray, string);
        }
    }

    private void refresh() {
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.setTainted(true);
        this.viewer.requestRepaintAndWait();
    }

    private void reset() throws ScriptException {
        this.checkLength(-2);
        if (this.isSyntaxCheck) {
            return;
        }
        if (this.statementLength == 1) {
            this.viewer.reset();
            return;
        }
        if (this.tokAt(1) == 9670657) {
            Compiler.globalFunctions.clear();
            this.compiler.localFunctions.clear();
            return;
        }
        if (this.tokAt(1) == 3146007) {
            this.viewer.setData("element_vdw", new Object[]{null, ""}, 0, 0, 0);
            return;
        }
        String string = this.parameterAsString(1);
        if (string.charAt(0) == '_') {
            this.error(20);
        }
        if (string.equalsIgnoreCase("aromatic")) {
            this.viewer.resetAromatic();
        } else {
            this.viewer.unsetProperty(string);
        }
    }

    private void restrict() throws ScriptException {
        this.select();
        if (this.isSyntaxCheck) {
            return;
        }
        BitSet bitSet = BitSetUtil.copy((BitSet)this.viewer.getSelectionSet());
        this.viewer.invertSelection();
        if (this.bsSubset != null) {
            bitSet = BitSetUtil.copy((BitSet)this.viewer.getSelectionSet());
            bitSet.and(this.bsSubset);
            this.viewer.setSelectionSet(bitSet);
            BitSetUtil.invertInPlace((BitSet)bitSet, (int)this.viewer.getAtomCount());
            bitSet.and(this.bsSubset);
        }
        BitSetUtil.andNot((BitSet)bitSet, (BitSet)this.viewer.getDeletedAtoms());
        boolean bl = this.viewer.getBondSelectionModeOr();
        this.setBooleanProperty("bondModeOr", true);
        this.setShapeSize(1, 0);
        int n = 20;
        while (--n >= 0) {
            if (n == 5) continue;
            this.setShapeSize(n, 0);
        }
        this.setShapeProperty(20, "delete", null);
        this.viewer.setLabel(null);
        this.setBooleanProperty("bondModeOr", bl);
        this.viewer.setSelectionSet(bitSet);
    }

    private void rotate(boolean bl, boolean bl2) throws ScriptException {
        if (this.statementLength == 2) {
            switch (this.getToken((int)1).tok) {
                case 0x100011: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.setSpinOn(true);
                    }
                    return;
                }
                case 0x100010: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.setSpinOn(false);
                    }
                    return;
                }
            }
        }
        BitSet bitSet = null;
        float f = Float.MIN_VALUE;
        int n = 0;
        float f2 = Float.MAX_VALUE;
        boolean bl3 = false;
        Point3f[] point3fArray = new Point3f[2];
        Vector3f vector3f = new Vector3f(0.0f, 1.0f, 0.0f);
        int n2 = 1;
        boolean bl4 = this.viewer.getAxesOrientationRasmol();
        block16: for (int i = 1; i < this.statementLength; ++i) {
            int n3 = this.getToken((int)i).tok;
            switch (n3) {
                case 134746167: {
                    bl = true;
                    continue block16;
                }
                case 0x1100070: {
                    n2 = -1;
                    continue block16;
                }
                case 9443332: {
                    ++i;
                }
                case 8: {
                    Quaternion quaternion = new Quaternion(this.getPoint4f(i));
                    vector3f.set((Tuple3f)quaternion.getNormal());
                    f = quaternion.getTheta();
                    break;
                }
                case 9439237: {
                    if (this.isPoint3f(++i)) {
                        vector3f.set((Tuple3f)this.centerParameter(i));
                        break;
                    }
                    Point4f point4f = this.getPoint4f(i);
                    vector3f.set(point4f.x, point4f.y, point4f.z);
                    f = point4f.w;
                    break;
                }
                case 1: {
                    String string = this.parameterAsString(i);
                    if (string.equalsIgnoreCase("x")) {
                        vector3f.set((float)n2, 0.0f, 0.0f);
                        continue block16;
                    }
                    if (string.equalsIgnoreCase("y")) {
                        vector3f.set(0.0f, (float)(bl4 && !bl3 ? -n2 : n2), 0.0f);
                        continue block16;
                    }
                    if (string.equalsIgnoreCase("z")) {
                        vector3f.set(0.0f, 0.0f, (float)n2);
                        continue block16;
                    }
                    if (string.equalsIgnoreCase("internal") || string.equalsIgnoreCase("molecular")) {
                        bl3 = true;
                        continue block16;
                    }
                    this.error(20);
                }
                case 0x100005: {
                    int n4 = BitSetUtil.firstSetBit((BitSet)this.expression(++i));
                    int n5 = BitSetUtil.firstSetBit((BitSet)this.expression(++this.iToken));
                    if (n4 < 0 || n5 < 0) {
                        return;
                    }
                    bitSet = this.viewer.getBranchBitSet(n5, n4);
                    bl3 = true;
                    point3fArray[0] = this.viewer.getAtomPoint3f(n5);
                    point3fArray[1] = this.viewer.getAtomPoint3f(n4);
                    n = 2;
                    i = this.iToken;
                    break;
                }
                case 7: 
                case 0x100001: 
                case 0x100009: 
                case 0x10000E: 
                case 0x4000007: {
                    if (n == 2) {
                        this.evalError(GT._((String)"too many rotation points were specified"));
                    }
                    Point3f point3f = this.centerParameter(i);
                    if (!this.isSyntaxCheck && n3 == 0x100009 && this.tokAt(i + 2) != 0x1100020) {
                        vector3f = this.getDrawObjectAxis(this.objectNameParameter(++i));
                    }
                    point3fArray[n++] = point3f;
                    break;
                }
                case 0x1100010: {
                    continue block16;
                }
                case 2: 
                case 3: {
                    if (f == Float.MIN_VALUE) {
                        f = this.floatParameter(i);
                        continue block16;
                    }
                    f2 = f;
                    f = this.floatParameter(i);
                    bl = true;
                    continue block16;
                }
                default: {
                    this.error(20);
                }
            }
            i = this.iToken;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (f == Float.MIN_VALUE) {
            f = 10.0f;
        }
        if (bl2 && bitSet == null) {
            bitSet = this.viewer.getSelectionSet();
        }
        if (n < 2) {
            if (!bl3) {
                this.viewer.rotateAxisAngleAtCenter(point3fArray[0], vector3f, f, f2, bl, bitSet);
                return;
            }
            if (n == 0) {
                point3fArray[0] = new Point3f();
            }
            point3fArray[1] = new Point3f(point3fArray[0]);
            point3fArray[1].sub((Tuple3f)vector3f);
        }
        if (point3fArray[0].distance(point3fArray[1]) == 0.0f) {
            point3fArray[1] = new Point3f(point3fArray[0]);
            point3fArray[1].y = (float)((double)point3fArray[1].y - 1.0);
        }
        this.viewer.rotateAboutPointsInternal(point3fArray[0], point3fArray[1], f, f2, bl, bitSet);
    }

    private Point3f getDrawObjectCenter(String string) {
        return (Point3f)this.viewer.getShapeProperty(21, "getSpinCenter:" + string);
    }

    private Vector3f getDrawObjectAxis(String string) {
        return (Vector3f)this.viewer.getShapeProperty(21, "getSpinAxis:" + string);
    }

    private void script(boolean bl) throws ScriptException {
        if (bl) {
            this.checkLength(2);
            if (!this.isSyntaxCheck) {
                this.viewer.eval(this.parameterAsString(1));
            }
            return;
        }
        if (this.getToken((int)1).tok != 4) {
            this.error(14);
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 2;
        String string = this.parameterAsString(1);
        String string2 = null;
        if (string.equalsIgnoreCase("inline")) {
            string2 = this.parameterExpression(2, 0, "_script", false).toString();
            n5 = this.iToken + 1;
        }
        boolean bl2 = true;
        boolean bl3 = false;
        String string3 = this.optParameterAsString(n5);
        if (string3.equalsIgnoreCase("check")) {
            bl3 = true;
            string3 = this.optParameterAsString(++n5);
        }
        if (string3.equalsIgnoreCase("noload")) {
            bl2 = false;
            string3 = this.optParameterAsString(++n5);
        }
        if (string3.equalsIgnoreCase("line") || string3.equalsIgnoreCase("lines")) {
            int n6 = ++n5;
            n3 = n = Math.max(this.intParameter(n6), 0);
            if (this.checkToken(++n5)) {
                if (this.getToken((int)n5++).tok == 0x1100070) {
                    n3 = this.checkToken(n5) ? this.intParameter(n5++) : 0;
                } else {
                    this.error(20);
                }
            }
        } else if (string3.equalsIgnoreCase("command") || string3.equalsIgnoreCase("commands")) {
            int n7 = ++n5;
            n2 = Math.max(this.intParameter(n7) - 1, 0);
            n4 = n2 + 1;
            if (this.checkToken(++n5)) {
                if (this.getToken((int)n5++).tok == 0x1100070) {
                    n4 = this.checkToken(n5) ? this.intParameter(n5++) : 0;
                } else {
                    this.error(20);
                }
            }
        }
        this.checkLength(n5);
        if (this.isSyntaxCheck && !this.isScriptCheck) {
            return;
        }
        if (this.isScriptCheck) {
            bl3 = true;
        }
        boolean bl4 = this.isSyntaxCheck;
        boolean bl5 = this.isScriptCheck;
        if (bl3) {
            this.isScriptCheck = true;
            this.isSyntaxCheck = true;
        }
        this.pushContext(null);
        boolean bl6 = string2 != null ? this.loadScript(null, string2, false) : this.loadScriptFileInternal(string);
        if (bl6) {
            this.pcEnd = n4;
            this.lineEnd = n3;
            while (n2 < this.lineNumbers.length && this.lineNumbers[n2] < n) {
                ++n2;
            }
            this.pc = n2;
            boolean bl7 = this.fileOpenCheck;
            this.fileOpenCheck = this.fileOpenCheck && bl2;
            this.instructionDispatchLoop(bl3);
            if (this.debugScript && this.viewer.getMessageStyleChime()) {
                this.viewer.scriptStatus("script <exiting>");
            }
            this.fileOpenCheck = bl7;
            this.popContext();
        } else {
            Logger.error((String)(GT._((String)"script ERROR: ") + this.errorMessage));
            this.popContext();
            if (bl5) {
                this.error = false;
                this.errorMessage = null;
            } else {
                this.evalError(null);
            }
        }
        this.isSyntaxCheck = bl4;
        this.isScriptCheck = bl5;
    }

    private void function() throws ScriptException {
        Vector vector;
        if (this.isSyntaxCheck && !this.isScriptCheck) {
            return;
        }
        String string = (String)this.getToken((int)0).value;
        if (this.getFunction(string) == null) {
            this.evalError(GT._((String)"command expected"));
        }
        Vector vector2 = vector = this.statementLength == 1 || this.statementLength == 3 && this.tokAt(1) == 0x1100000 && this.tokAt(2) == 0x1100001 ? null : (Vector)this.parameterExpression(1, 0, null, true);
        if (this.isSyntaxCheck) {
            return;
        }
        this.pushContext(null);
        this.loadFunction(string, vector);
        this.instructionDispatchLoop(false);
        this.popContext();
    }

    private void sync() throws ScriptException {
        this.checkLength(-3);
        String string = "";
        String string2 = "";
        switch (this.statementLength) {
            case 1: {
                string2 = "*";
                string = "ON";
                break;
            }
            case 2: {
                string2 = this.parameterAsString(1);
                if (string2.indexOf("jmolApplet") == 0 || Parser.isOneOf((String)string2, (String)"*;.;^")) {
                    string = "ON";
                    if (!this.isSyntaxCheck) {
                        this.viewer.syncScript(string, string2);
                    }
                    string2 = ".";
                    break;
                }
                string = string2;
                string2 = "*";
                break;
            }
            case 3: {
                string2 = this.parameterAsString(1);
                string = this.parameterAsString(2);
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.syncScript(string, string2);
    }

    private void history(int n) throws ScriptException {
        if (this.statementLength == 1) {
            this.showString(this.viewer.getSetHistory(Integer.MAX_VALUE));
            return;
        }
        if (n == 2) {
            this.checkLength(3);
            int n2 = this.intParameter(2);
            if (n2 < 0) {
                this.error(20);
            }
            if (!this.isSyntaxCheck) {
                this.viewer.getSetHistory(n2 == 0 ? 0 : -2 - n2);
            }
            return;
        }
        this.checkLength(2);
        switch (this.getToken((int)1).tok) {
            case 0x100011: 
            case 0x400000A: {
                if (!this.isSyntaxCheck) {
                    this.viewer.getSetHistory(Integer.MIN_VALUE);
                }
                return;
            }
            case 0x100010: {
                if (this.isSyntaxCheck) break;
                this.viewer.getSetHistory(0);
                break;
            }
            default: {
                this.error(22, "ON, OFF, CLEAR");
            }
        }
    }

    private void display(boolean bl) throws ScriptException {
        BitSet bitSet;
        BitSet bitSet2 = bitSet = this.statementLength == 1 ? null : this.expression(1);
        if (this.isSyntaxCheck) {
            return;
        }
        if (bl) {
            this.viewer.display(this.viewer.getModelAtomBitSet(-1, false), bitSet, this.tQuiet);
        } else {
            this.viewer.hide(bitSet, this.tQuiet);
        }
    }

    private void delete() throws ScriptException {
        if (this.statementLength == 1) {
            this.zap(true);
            return;
        }
        BitSet bitSet = this.expression(this.statement, 1, 0, true, false, true, false);
        if (this.isSyntaxCheck) {
            return;
        }
        int n = this.viewer.deleteAtoms(bitSet, false);
        if (!this.tQuiet && this.scriptLevel <= this.scriptReportingLevel) {
            this.scriptStatus(GT._((String)"{0} atoms deleted", (int)n));
        }
    }

    private void minimize() throws ScriptException {
        int n;
        BitSet bitSet = null;
        int n2 = Integer.MAX_VALUE;
        float f = 0.0f;
        MinimizerInterface minimizerInterface = this.viewer.getMinimizer();
        block8: for (n = 1; n < this.statementLength; ++n) {
            switch (this.tokAt(n)) {
                case 0x400000A: {
                    this.checkLength(2);
                    if (this.isSyntaxCheck || minimizerInterface == null) {
                        return;
                    }
                    minimizerInterface.setProperty("clear", null);
                    return;
                }
                case 0x400000C: {
                    if (n != 1) {
                        this.error(20);
                    }
                    int n3 = 0;
                    float f2 = 0.0f;
                    int[] nArray = new int[5];
                    if (this.tokAt(++n) == 0x400000A) {
                        this.checkLength(2);
                    } else {
                        while (n3 < 4 && !this.isFloatParameter(n)) {
                            nArray[++n3] = BitSetUtil.firstSetBit((BitSet)this.expression(n));
                            n = this.iToken + 1;
                        }
                        nArray[0] = n3;
                        f2 = this.floatParameter(n++);
                        this.checkLength(n);
                    }
                    if (!this.isSyntaxCheck) {
                        this.getMinimizer().setProperty("constraint", (Object)new Object[]{nArray, new int[n3], new Float(f2)});
                    }
                    return;
                }
                case 1: 
                case 4: {
                    String string = this.parameterAsString(n).toLowerCase();
                    if (string.equals("stop") || string.equals("cancel")) {
                        this.checkLength(2);
                        if (this.isSyntaxCheck || minimizerInterface == null) {
                            return;
                        }
                        minimizerInterface.setProperty(string, null);
                        return;
                    }
                    if (string.equals("fix")) {
                        BitSet bitSet2;
                        if (n != 1) {
                            this.error(20);
                        }
                        if (BitSetUtil.firstSetBit((BitSet)(bitSet2 = this.expression(++n))) < 0) {
                            bitSet2 = null;
                        }
                        this.checkLength(this.iToken + 1, 1);
                        if (!this.isSyntaxCheck) {
                            this.getMinimizer().setProperty("fixed", (Object)bitSet2);
                        }
                        return;
                    }
                    if (string.equals("energy")) {
                        n2 = 0;
                        continue block8;
                    }
                    if (string.equals("criterion")) {
                        f = this.floatParameter(++n);
                        continue block8;
                    }
                    if (string.equals("steps")) {
                        n2 = this.intParameter(++n);
                        continue block8;
                    }
                    this.error(20);
                }
                case 9451009: {
                    bitSet = this.expression(++n);
                    n = this.iToken;
                    continue block8;
                }
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (bitSet == null) {
            n = BitSetUtil.firstSetBit((BitSet)this.viewer.getVisibleFramesBitSet());
            bitSet = this.viewer.getModelAtomBitSet(n, false);
        }
        minimizerInterface = this.getMinimizer();
        try {
            minimizerInterface.minimize(n2, (double)f, bitSet);
        }
        catch (Exception exception) {
            this.evalError(exception.getMessage());
        }
    }

    private MinimizerInterface getMinimizer() throws ScriptException {
        MinimizerInterface minimizerInterface = this.viewer.getMinimizer();
        if (minimizerInterface != null) {
            return minimizerInterface;
        }
        try {
            String string = "org.jmol.minimize.Minimizer";
            minimizerInterface = (MinimizerInterface)Class.forName(string).newInstance();
            this.viewer.setMinimizer(minimizerInterface);
        }
        catch (Exception exception) {
            this.evalError(exception.getMessage());
        }
        return minimizerInterface;
    }

    private void select() throws ScriptException {
        if (this.statementLength == 1) {
            this.viewer.select(null, this.tQuiet || this.scriptLevel > this.scriptReportingLevel);
            return;
        }
        this.viewer.setNoneSelected(this.statementLength == 4 && this.tokAt(2) == 0x10000F);
        if (this.tokAt(2) == 0x4000007 && this.getToken((int)2).value instanceof Bond.BondSet || this.getToken((int)2).tok == 141557762 && this.getToken((int)3).tok == 0x4000007) {
            if (this.statementLength == this.iToken + 2) {
                if (!this.isSyntaxCheck) {
                    this.viewer.selectBonds((BitSet)this.theToken.value);
                }
                return;
            }
            this.error(20);
        }
        if (this.getToken((int)2).tok == 135794723) {
            if (this.statementLength == 5 && this.getToken((int)3).tok == 0x4000007) {
                if (!this.isSyntaxCheck) {
                    this.setShapeProperty(5, "select", this.theToken.value);
                }
                return;
            }
            this.error(20);
        }
        BitSet bitSet = null;
        if (this.getToken((int)1).intValue == 0) {
            Object object = this.tokenSetting((int)0).value;
            if (!(object instanceof BitSet)) {
                this.error(20);
            }
            this.checkLength(++this.iToken);
            bitSet = (BitSet)object;
        } else {
            bitSet = this.expression(1);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (this.isBondSet) {
            this.viewer.selectBonds(bitSet);
        } else {
            this.viewer.select(bitSet, this.tQuiet || this.scriptLevel > this.scriptReportingLevel);
        }
    }

    private void subset() throws ScriptException {
        BitSet bitSet;
        BitSet bitSet2 = bitSet = this.statementLength == 1 ? null : this.expression(-1);
        if (this.isSyntaxCheck) {
            return;
        }
        this.bsSubset = bitSet;
        this.viewer.setSelectionSubset(this.bsSubset);
    }

    private void invertSelected() throws ScriptException {
        Point3f point3f = null;
        Point4f point4f = null;
        if (this.statementLength == 1) {
            if (this.isSyntaxCheck) {
                return;
            }
            BitSet bitSet = this.viewer.getSelectionSet();
            point3f = this.viewer.getAtomSetCenter(bitSet);
            this.viewer.invertSelected(point3f, bitSet);
            return;
        }
        String string = this.parameterAsString(1);
        if (string.equalsIgnoreCase("point")) {
            point3f = this.centerParameter(2);
        } else if (string.equalsIgnoreCase("plane")) {
            point4f = this.planeParameter(2);
        } else if (string.equalsIgnoreCase("hkl")) {
            point4f = this.hklParameter(2);
        }
        this.checkLength(this.iToken + 1, 1);
        if (point4f == null && point3f == null) {
            this.error(20);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        this.viewer.invertSelected(point3f, point4f);
    }

    private void translateSelected() throws ScriptException {
        Point3f point3f = this.getPoint3f(1, true);
        if (!this.isSyntaxCheck) {
            this.viewer.setAtomCoordRelative(point3f);
        }
    }

    private void translate() throws ScriptException {
        this.checkLength(3);
        float f = this.floatParameter(2, -100.0f, 100.0f);
        if (this.getToken((int)1).tok == 1) {
            String string = this.parameterAsString(1);
            if (string.equalsIgnoreCase("x")) {
                if (!this.isSyntaxCheck) {
                    this.viewer.translateToXPercent(f);
                }
                return;
            }
            if (string.equalsIgnoreCase("y")) {
                if (!this.isSyntaxCheck) {
                    this.viewer.translateToYPercent(f);
                }
                return;
            }
            if (string.equalsIgnoreCase("z")) {
                if (!this.isSyntaxCheck) {
                    this.viewer.translateToZPercent(f);
                }
                return;
            }
        }
        this.error(0);
    }

    private void zap(boolean bl) throws ScriptException {
        boolean bl2;
        if (this.statementLength == 1 || !bl) {
            this.viewer.zap(true, bl && !this.isStateScript);
            this.refresh();
            return;
        }
        BitSet bitSet = this.expression(1);
        if (this.isSyntaxCheck) {
            return;
        }
        int n = this.viewer.deleteAtoms(bitSet, true);
        boolean bl3 = bl2 = this.tQuiet || this.scriptLevel > this.scriptReportingLevel;
        if (!bl2) {
            this.scriptStatus(GT._((String)"{0} atoms deleted", (int)n));
        }
        this.viewer.select(null, bl2);
    }

    private void zoom(boolean bl) throws ScriptException {
        float f;
        if (!bl) {
            int n = this.statementLength > 1 ? this.getToken((int)1).tok : 0x100011;
            switch (n) {
                case 0x100010: 
                case 0x100011: {
                    if (this.statementLength > 2) {
                        this.error(1);
                    }
                    if (!this.isSyntaxCheck) {
                        this.setBooleanProperty("zoomEnabled", n == 0x100011);
                    }
                    return;
                }
            }
        }
        float f2 = this.viewer.getZoomSetting();
        float f3 = this.viewer.getRotationRadius();
        Point3f point3f = null;
        Point3f point3f2 = this.viewer.getRotationCenter();
        int n = 1;
        float f4 = bl ? (this.isFloatParameter(n) ? this.floatParameter(n++) : 2.0f) : (f = 0.0f);
        if (f < 0.0f) {
            this.error(20);
        }
        int n2 = 0;
        if (this.isCenterParameter(n)) {
            n2 = n;
            point3f = this.centerParameter(n);
            n = this.iToken + 1;
        }
        boolean bl2 = false;
        float f5 = this.getZoomFactor(n, n2, f3, f2);
        if (f5 < 0.0f) {
            f5 = -f5;
            if (bl) {
                if (this.statementLength == 1 || bl2) {
                    f5 *= 2.0f;
                } else if (point3f == null) {
                    f5 /= 2.0f;
                }
            }
        }
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = this.viewer.getMaxZoomPercent();
        if (f5 < 5.0f || f5 > f8) {
            this.numberOutOfRange(5.0f, f8);
        }
        if (!this.viewer.isWindowCentered()) {
            if (point3f != null) {
                BitSet bitSet = this.expression(n2);
                if (!this.isSyntaxCheck) {
                    this.viewer.setCenterBitSet(bitSet, false);
                }
            }
            point3f = this.viewer.getRotationCenter();
            f6 = this.viewer.getTranslationXPercent();
            f7 = this.viewer.getTranslationYPercent();
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (bl2 && Math.abs(f2 - f5) < 1.0f) {
            f = 0.0f;
        }
        this.viewer.moveTo(f, point3f, new Point3f(0.0f, 0.0f, 0.0f), Float.NaN, f5, f6, f7, f3, null, Float.NaN, Float.NaN, Float.NaN);
    }

    private float getZoomFactor(int n, int n2, float f, float f2) throws ScriptException {
        float f3;
        float f4;
        BitSet bitSet = null;
        float f5 = f4 = this.isFloatParameter(n) ? this.floatParameter(n) : Float.NaN;
        if (f4 == 0.0f) {
            switch (this.statement[n2].tok) {
                case 0x100001: 
                case 0x4000007: {
                    bitSet = this.expression(this.statement, n2, 0, true, false, false, true);
                }
            }
            if (bitSet == null) {
                this.error(20);
            }
            f3 = this.viewer.calcRotationRadius(bitSet);
            f2 = f / f3 * 100.0f;
            f4 = Float.NaN;
            ++n;
        }
        if (f4 < 0.0f) {
            f4 += f2;
        } else if (Float.isNaN(f4)) {
            f4 = f2;
            if (this.isFloatParameter(n + 1)) {
                f3 = this.floatParameter(n + 1);
                switch (this.getToken((int)n++).tok) {
                    case 0x1100080: {
                        f4 /= f3;
                        break;
                    }
                    case 0x1100081: {
                        f4 *= f3;
                        break;
                    }
                    case 0x1100071: {
                        f4 += f3;
                        break;
                    }
                    default: {
                        this.error(20);
                        break;
                    }
                }
            } else {
                if (bitSet == null) {
                    f4 = -f4;
                }
                --n;
            }
        }
        this.iToken = n;
        return f4;
    }

    private void gotocmd() throws ScriptException {
        this.checkLength(2);
        String string = null;
        string = this.parameterAsString(1);
        int n = -1;
        for (int i = 0; i < this.aatoken.length; ++i) {
            Token[] tokenArray = this.aatoken[i];
            if (tokenArray[0].tok != 20484 || !tokenArray[1].value.toString().equalsIgnoreCase(string)) continue;
            n = i;
            break;
        }
        if (n < 0) {
            this.error(20);
        }
        if (!this.isSyntaxCheck) {
            this.pc = n - 1;
        }
    }

    private void delay() throws ScriptException {
        long l = 0L;
        switch (this.getToken((int)1).tok) {
            case 0x100011: {
                l = 1L;
                break;
            }
            case 2: {
                l = this.intParameter(1) * 1000;
                break;
            }
            case 3: {
                l = (long)(this.floatParameter(1) * 1000.0f);
                break;
            }
            default: {
                this.error(25);
            }
        }
        if (!this.isSyntaxCheck) {
            this.delay(l);
        }
    }

    private void delay(long l) {
        long l2 = System.currentTimeMillis();
        this.refresh();
        if (l < 0L) {
            l = -l;
        } else {
            int n = this.viewer.getDelayMaximum();
            if (n > 0 && l > (long)n) {
                l = n;
            }
        }
        int n = (int)(l -= System.currentTimeMillis() - l2) / 1000;
        if ((l -= (long)(n * 1000)) <= 0L) {
            l = 1L;
        }
        while (n >= 0 && l > 0L && !this.interruptExecution.booleanValue() && this.currentThread == Thread.currentThread()) {
            this.viewer.popHoldRepaint();
            try {
                Thread.sleep(n-- > 0 ? 1000L : l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.viewer.pushHoldRepaint();
        }
    }

    private void slab(boolean bl) throws ScriptException {
        boolean bl2 = false;
        Point4f point4f = null;
        if (this.isCenterParameter(1) || this.tokAt(1) == 8) {
            point4f = this.planeParameter(1);
        } else {
            block0 : switch (this.getToken((int)1).tok) {
                case 2: {
                    this.checkLength(2);
                    int n = this.intParameter(1);
                    if (!this.isSyntaxCheck) {
                        if (bl) {
                            this.viewer.depthToPercent(n);
                        } else {
                            this.viewer.slabToPercent(n);
                        }
                    }
                    return;
                }
                case 0x100011: {
                    this.checkLength(2);
                    bl2 = true;
                }
                case 0x100010: {
                    this.checkLength(2);
                    this.setBooleanProperty("slabEnabled", bl2);
                    return;
                }
                case 4140: {
                    this.checkLength(2);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.slabReset();
                    this.setBooleanProperty("slabEnabled", true);
                    return;
                }
                case 36867: {
                    this.checkLength(2);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.setSlabDepthInternal(bl);
                    this.setBooleanProperty("slabEnabled", true);
                    return;
                }
                case 0x1100070: {
                    String string = this.parameterAsString(2);
                    if (string.equalsIgnoreCase("hkl")) {
                        point4f = this.hklParameter(3);
                    } else if (string.equalsIgnoreCase("plane")) {
                        point4f = this.planeParameter(3);
                    }
                    if (point4f == null) {
                        this.error(20);
                    }
                    point4f.scale(-1.0f);
                    break;
                }
                case 9439234: {
                    switch (this.getToken((int)2).tok) {
                        case 0x10000F: {
                            break block0;
                        }
                    }
                    point4f = this.planeParameter(2);
                    break;
                }
                case 1: {
                    String string = this.parameterAsString(1);
                    if (string.equalsIgnoreCase("hkl")) {
                        point4f = this.getToken((int)2).tok == 0x10000F ? null : this.hklParameter(2);
                        break;
                    }
                    if (string.equalsIgnoreCase("reference")) {
                        return;
                    }
                }
                default: {
                    this.error(20);
                }
            }
        }
        if (!this.isSyntaxCheck) {
            this.viewer.slabInternal(point4f, bl);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void ellipsoid() throws ScriptException {
        var1_1 = 0;
        var2_2 = 1;
        switch (this.getToken((int)1).tok) {
            case 0x100011: {
                var1_1 = 50;
                break;
            }
            case 0x100010: {
                break;
            }
            case 2: {
                var1_1 = this.intParameter(1);
                break;
            }
            case 1: {
                this.viewer.loadShape(19);
                if (this.parameterAsString(var2_2).equalsIgnoreCase("ID")) {
                    ++var2_2;
                }
                this.setShapeId(19, var2_2, false);
                ++var2_2;
                while (var2_2 < this.statementLength) {
                    var3_3 = this.parameterAsString(var2_2);
                    var4_4 /* !! */  = null;
                    if (!var3_3.equalsIgnoreCase("modelIndex")) ** GOTO lbl26
                    var4_4 /* !! */  = new Integer(this.intParameter(++var2_2));
                    var3_3 = "modelindex";
                    ** GOTO lbl69
lbl26:
                    // 1 sources

                    if (!var3_3.equalsIgnoreCase("axes")) ** GOTO lbl35
                    var5_5 = new Vector3f[3];
                    for (var6_7 = 0; var6_7 < 3; ++var6_7) {
                        var5_5[var6_7] = new Vector3f();
                        var5_5[var6_7].set((Tuple3f)this.centerParameter(++var2_2));
                        var2_2 = this.iToken;
                    }
                    var4_4 /* !! */  = var5_5;
                    ** GOTO lbl69
lbl35:
                    // 1 sources

                    if (!var3_3.equalsIgnoreCase("on")) ** GOTO lbl38
                    var4_4 /* !! */  = Boolean.TRUE;
                    ** GOTO lbl69
lbl38:
                    // 1 sources

                    if (!var3_3.equalsIgnoreCase("off")) ** GOTO lbl42
                    var3_3 = "on";
                    var4_4 /* !! */  = Boolean.FALSE;
                    ** GOTO lbl69
lbl42:
                    // 1 sources

                    if (!var3_3.equalsIgnoreCase("delete")) ** GOTO lbl46
                    var4_4 /* !! */  = Boolean.TRUE;
                    this.checkLength(3);
                    ** GOTO lbl69
lbl46:
                    // 1 sources

                    if (!var3_3.equalsIgnoreCase("center")) ** GOTO lbl50
                    var4_4 /* !! */  = this.centerParameter(++var2_2);
                    var2_2 = this.iToken;
                    ** GOTO lbl69
lbl50:
                    // 1 sources

                    if (!var3_3.equalsIgnoreCase("scale")) ** GOTO lbl53
                    var4_4 /* !! */  = new Float(this.floatParameter(++var2_2));
                    ** GOTO lbl69
lbl53:
                    // 1 sources

                    if (!var3_3.equalsIgnoreCase("color")) ** GOTO lbl69
                    var5_6 = NaNf;
                    if ((this.theTok = this.tokAt(++var2_2)) == 67108926) {
                        var4_4 /* !! */  = "translucent";
                        var5_6 = this.isFloatParameter(++var2_2) ? this.floatParameter(var2_2++) : this.viewer.getDefaultTranslucent();
                    } else if (this.theTok == 67108901) {
                        var4_4 /* !! */  = "opaque";
                        ++var2_2;
                    }
                    if (this.isColorParam(var2_2)) {
                        this.setShapeProperty(19, "color", new Integer(this.getArgbParam(var2_2)));
                        var2_2 = this.iToken;
                    }
                    if (var4_4 /* !! */  == null) ** GOTO lbl72
                    if (var5_6 != NaNf) {
                        this.setShapeProperty(19, "translucentLevel", new Float(var5_6));
                    }
                    var3_3 = "translucency";
lbl69:
                    // 9 sources

                    if (var4_4 /* !! */  == null) {
                        this.error(20);
                    }
                    this.setShapeProperty(19, var3_3.toLowerCase(), var4_4 /* !! */ );
lbl72:
                    // 2 sources

                    ++var2_2;
                }
                this.setShapeProperty(19, "thisID", null);
                return;
            }
            default: {
                this.error(20);
            }
        }
        this.setShapeSize(19, var1_1);
    }

    private int setShapeId(int n, int n2, boolean bl) throws ScriptException {
        String string;
        if (bl) {
            this.error(20);
        }
        if ((string = this.parameterAsString(n2)).length() == 0) {
            this.error(20);
        }
        this.setShapeProperty(n, "thisID", string.toLowerCase());
        return n2;
    }

    private void setAtomShapeSize(int n, int n2) throws ScriptException {
        int n3 = 0;
        int n4 = this.tokAt(1);
        switch (n4) {
            case 0x100011: {
                n3 = n2;
                break;
            }
            case 3146007: {
                n3 = -100;
                break;
            }
            case 0x100010: {
                break;
            }
            case 3: 
            case 0x1100071: {
                int n5;
                int n6 = n5 = n4 == 0x1100071 ? 2 : 1;
                if (n5 == 2) {
                    n3 = 10000;
                }
                n3 += (int)(this.floatParameter(n5, 0.0f, 3.0f) * 1000.0f * 2.0f);
                break;
            }
            case 2: {
                int n7 = this.intParameter(1);
                if (this.tokAt(2) == 17825922) {
                    int n8;
                    if (n7 < 0 || n7 > 200) {
                        this.integerOutOfRange(0, 200);
                    }
                    if ((n8 = JmolConstants.getVdwType(this.optParameterAsString(3))) >= 0) {
                        n3 = -(n8 + 1) * 2000 - n7;
                        break;
                    }
                    n3 = -n7;
                    break;
                }
                if (n7 > 749 || n7 < -200) {
                    this.integerOutOfRange(-200, 749);
                }
                n3 = n7 <= 0 ? n7 : n7 * 8;
                break;
            }
            case 3146123: {
                n3 = -1000;
                break;
            }
            case 67108886: {
                n3 = -1001;
                break;
            }
            case 0x70000E: {
                n3 = Short.MAX_VALUE;
                if (this.tokAt(2) != 2) break;
                n3 += this.intParameter(2);
                break;
            }
            case 0x70000F: {
                n3 = Short.MIN_VALUE;
                if (this.tokAt(2) != 2) break;
                n3 -= this.intParameter(2);
                break;
            }
            default: {
                this.error(20);
            }
        }
        this.setShapeSize(n, n3);
    }

    private void structure() throws ScriptException {
        String string = this.parameterAsString(1).toLowerCase();
        byte by = 0;
        BitSet bitSet = null;
        if (string.equals("helix")) {
            by = 3;
        } else if (string.equals("sheet")) {
            by = 2;
        } else if (string.equals("turn")) {
            by = 1;
        } else if (string.equals("none")) {
            by = 0;
        } else {
            this.error(20);
        }
        switch (this.tokAt(2)) {
            case 0x100001: 
            case 0x4000007: {
                bitSet = this.expression(2);
                this.checkLength(this.iToken + 1);
                break;
            }
            default: {
                this.checkLength(2);
            }
        }
        if (this.isSyntaxCheck) {
            return;
        }
        this.clearPredefined(JmolConstants.predefinedVariable);
        this.viewer.setProteinType(by, bitSet);
    }

    private void wireframe() throws ScriptException {
        int n = this.getMadParameter();
        if (this.isSyntaxCheck) {
            return;
        }
        this.setShapeProperty(1, "type", new Integer(1023));
        this.viewer.setShapeSize(1, n, this.viewer.getSelectionSet());
    }

    private void ssbond() throws ScriptException {
        this.setShapeProperty(1, "type", new Integer(256));
        this.setShapeSize(1, this.getMadParameter());
        this.setShapeProperty(1, "type", new Integer(1023));
    }

    private void hbond(boolean bl) throws ScriptException {
        if (this.statementLength == 2 && this.getToken((int)1).tok == 4102) {
            if (this.isSyntaxCheck) {
                return;
            }
            int n = this.viewer.autoHbond(null);
            this.scriptStatus(GT._((String)"{0} hydrogen bonds", (int)n));
            return;
        }
        this.setShapeProperty(1, "type", new Integer(30720));
        this.setShapeSize(1, this.getMadParameter());
        this.setShapeProperty(1, "type", new Integer(1023));
    }

    private void configuration() throws ScriptException {
        int n;
        BitSet bitSet;
        if (!this.isSyntaxCheck && this.viewer.getDisplayModelIndex() <= -2) {
            this.evalError(GT._((String)"{0} not allowed with background model displayed", (String)"\"CONFIGURATION\""));
        }
        if (this.statementLength == 1) {
            bitSet = this.viewer.setConformation();
            this.viewer.addStateScript("select", null, this.viewer.getSelectionSet(), null, "configuration", true, false);
        } else {
            this.checkLength(2);
            if (this.isSyntaxCheck) {
                return;
            }
            n = this.intParameter(1);
            bitSet = this.viewer.setConformation(n - 1);
            this.viewer.addStateScript("configuration " + n + ";", true, false);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        n = this.viewer.hasCalculatedHBonds(bitSet) ? 1 : 0;
        this.setShapeProperty(1, "type", new Integer(30720));
        this.viewer.setShapeSize(1, 0, bitSet);
        if (n != 0) {
            this.viewer.autoHbond(bitSet, bitSet, null);
        }
        this.viewer.select(bitSet, this.tQuiet);
    }

    private void vector() throws ScriptException {
        int n = 1;
        this.checkLength(-3);
        this.iToken = this.statementLength;
        block0 : switch (this.iToken) {
            case 1: {
                break;
            }
            case 2: {
                switch (this.getToken((int)1).tok) {
                    case 0x100011: {
                        break block0;
                    }
                    case 0x100010: {
                        n = 0;
                        break block0;
                    }
                    case 2: {
                        n = this.intParameter(1, 0, 19);
                        break block0;
                    }
                    case 3: {
                        n = (int)(this.floatParameter(1, 0.0f, 3.0f) * 1000.0f * 2.0f);
                        break block0;
                    }
                }
                this.error(5);
                break;
            }
            case 3: {
                if (!this.parameterAsString(1).equalsIgnoreCase("scale")) break;
                this.setFloatProperty("vectorScale", this.floatParameter(2, -10.0f, 10.0f));
                return;
            }
        }
        this.setShapeSize(17, n);
    }

    private void dipole() throws ScriptException {
        String string = null;
        Serializable serializable = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.viewer.loadShape(16);
        if (this.tokAt(1) == 6 && this.listIsosurface(16)) {
            return;
        }
        this.setShapeProperty(16, "init", null);
        if (this.statementLength == 1) {
            this.setShapeProperty(16, "thisID", null);
            return;
        }
        for (int i = 1; i < this.statementLength; ++i) {
            string = null;
            serializable = null;
            switch (this.getToken((int)i).tok) {
                case 0x100011: {
                    string = "on";
                    break;
                }
                case 0x100010: {
                    string = "off";
                    break;
                }
                case 12291: {
                    string = "delete";
                    break;
                }
                case 2: 
                case 3: {
                    string = "value";
                    serializable = new Float(this.floatParameter(i));
                    break;
                }
                case 0x4000007: {
                    string = "atomBitset";
                }
                case 0x100001: {
                    if (string == null) {
                        string = bl || bl2 ? "endSet" : "startSet";
                    }
                    serializable = this.expression(i);
                    i = this.iToken;
                    bl = true;
                    break;
                }
                case 7: 
                case 0x10000E: {
                    Point3f point3f = this.getPoint3f(i, true);
                    i = this.iToken;
                    string = bl || bl2 ? "endCoord" : "startCoord";
                    serializable = point3f;
                    bl2 = true;
                    break;
                }
                case 141557762: {
                    string = "bonds";
                    break;
                }
                case 4102: {
                    string = "calculate";
                    break;
                }
                case 1: {
                    String string2 = this.parameterAsString(i);
                    if (string2.equalsIgnoreCase("id")) {
                        this.setShapeId(16, ++i, bl3);
                        break;
                    }
                    if (string2.equalsIgnoreCase("cross")) {
                        string = "cross";
                        serializable = Boolean.TRUE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("noCross")) {
                        string = "cross";
                        serializable = Boolean.FALSE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("offset")) {
                        float f = this.floatParameter(++i);
                        if (this.theTok == 2) {
                            string = "offsetPercent";
                            serializable = new Integer((int)f);
                            break;
                        }
                        string = "offset";
                        serializable = new Float(f);
                        break;
                    }
                    if (string2.equalsIgnoreCase("value")) {
                        string = "value";
                        serializable = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (string2.equalsIgnoreCase("offsetSide")) {
                        string = "offsetSide";
                        serializable = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (string2.equalsIgnoreCase("width")) {
                        string = "width";
                        serializable = new Float(this.floatParameter(++i));
                        break;
                    }
                    this.setShapeId(16, i, bl3);
                    break;
                }
                default: {
                    this.error(20);
                }
            }
            boolean bl4 = bl3 = this.theTok != 12291 && this.theTok != 4102;
            if (string == null) continue;
            this.setShapeProperty(16, string, serializable);
        }
        if (bl2 || bl) {
            this.setShapeProperty(16, "set", null);
        }
    }

    private void animationMode() throws ScriptException {
        float f = 1.0f;
        float f2 = 1.0f;
        if (this.statementLength > 5) {
            this.error(1);
        }
        int n = 0;
        switch (this.getToken((int)2).tok) {
            case 528415: {
                n = 1;
                break;
            }
            case 1: {
                String string = this.parameterAsString(2);
                if (string.equalsIgnoreCase("once")) {
                    f2 = 0.0f;
                    f = 0.0f;
                    break;
                }
                if (string.equalsIgnoreCase("palindrome")) {
                    n = 2;
                    break;
                }
                this.error(20);
            }
        }
        if (this.statementLength >= 4) {
            f = f2 = this.floatParameter(3);
            if (this.statementLength == 5) {
                f2 = this.floatParameter(4);
            }
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setAnimationReplayMode(n, f, f2);
        }
    }

    private void vibration() throws ScriptException {
        this.checkLength(-3);
        float f = 0.0f;
        switch (this.getToken((int)1).tok) {
            case 0x100011: {
                this.checkLength(2);
                f = this.viewer.getVibrationPeriod();
                break;
            }
            case 0x100010: {
                this.checkLength(2);
                f = 0.0f;
                break;
            }
            case 2: 
            case 3: {
                this.checkLength(2);
                f = this.floatParameter(1);
                break;
            }
            case 1: {
                String string = this.optParameterAsString(1);
                if (string.equalsIgnoreCase("scale")) {
                    this.setFloatProperty("vibrationScale", this.floatParameter(2, -10.0f, 10.0f));
                    return;
                }
                if (string.equalsIgnoreCase("period")) {
                    this.setFloatProperty("vibrationPeriod", this.floatParameter(2));
                    return;
                }
                this.error(20);
            }
            default: {
                f = -1.0f;
            }
        }
        if (f < 0.0f) {
            this.error(20);
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (f == 0.0f) {
            this.viewer.setVibrationOff();
            return;
        }
        this.viewer.setVibrationPeriod(-f);
    }

    private void animationDirection() throws ScriptException {
        this.checkLength(4);
        boolean bl = false;
        this.getToken(2);
        if (this.theTok == 0x1100070) {
            bl = true;
        } else if (this.theTok != 0x1100071) {
            this.error(20);
        }
        int n = this.intParameter(3);
        if (n != 1) {
            this.error(26, "-1", "1");
        }
        if (bl) {
            n = -n;
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setAnimationDirection(n);
        }
    }

    private void calculate() throws ScriptException {
        boolean bl = false;
        this.iToken = this.statementLength;
        if (this.iToken >= 2) {
            this.clearPredefined(JmolConstants.predefinedVariable);
            switch (this.getToken((int)1).tok) {
                case 3145865: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.calculateStraightness();
                        this.viewer.addStateScript(this.thisCommand, false, true);
                    }
                    return;
                }
                case 67109275: {
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    int n = this.viewer.getCurrentModelIndex();
                    if (n < 0) {
                        this.error(23, "CALCULATE SYMMETRY");
                    }
                    if (this.tokAt(0) == 4112) {
                        this.runScript(this.viewer.getPointGroupDraw(n));
                    } else {
                        this.showString(this.viewer.calculatePointGroup());
                    }
                    return;
                }
                case 34603021: {
                    bl = true;
                }
                case 3145866: {
                    String string = this.optParameterAsString(2);
                    boolean bl2 = false;
                    if (!string.equalsIgnoreCase("within")) {
                        if (string.equalsIgnoreCase("from")) {
                            bl2 = true;
                        } else if (string.length() > 0) {
                            bl2 = true;
                            --this.iToken;
                        } else if (!bl) {
                            bl2 = true;
                        }
                    }
                    BitSet bitSet = this.iToken + 1 < this.statementLength ? this.expression(++this.iToken) : this.viewer.getSelectionSet();
                    this.checkLength(++this.iToken);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.calculateSurface(bitSet, bl2 ? Float.MAX_VALUE : -1.0f);
                    return;
                }
                case 1: {
                    if (!this.parameterAsString(1).equalsIgnoreCase("AROMATIC")) break;
                    this.checkLength(2);
                    if (!this.isSyntaxCheck) {
                        this.viewer.assignAromaticBonds();
                    }
                    return;
                }
                case 135794713: {
                    this.checkLength(2);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.viewer.autoHbond(null);
                    return;
                }
                case 3149845: {
                    BitSet bitSet;
                    BitSet bitSet2 = bitSet = this.statementLength == 2 ? null : this.expression(2);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    if (bitSet == null) {
                        bitSet = this.viewer.getModelAtomBitSet(-1, false);
                    }
                    this.viewer.calculateStructures(bitSet);
                    this.viewer.addStateScript(this.thisCommand, false, true);
                    return;
                }
            }
        }
        this.error(42, "CALCULATE", "aromatic? hbonds? polymers? straightness? structure? surfaceDistance FROM? surfaceDistance WITHIN?");
    }

    private void dots(int n) throws ScriptException {
        if (!this.isSyntaxCheck) {
            this.viewer.loadShape(n);
        }
        this.setShapeProperty(n, "init", null);
        int n2 = 0;
        int n3 = 1;
        switch (this.getToken((int)1).tok) {
            case 0x100011: 
            case 3146007: {
                n2 = 1;
                break;
            }
            case 67108886: {
                n2 = -1;
                break;
            }
            case 0x100010: {
                break;
            }
            case 0x1100071: {
                float f = this.floatParameter(++n3, 0.0f, 2.0f);
                n2 = (int)(f == 0.0f ? 1.0f : f * 1000.0f + 11002.0f);
                break;
            }
            case 3: {
                float f = this.floatParameter(n3, 0.0f, 10.0f);
                n2 = (int)(f == 0.0f ? 0.0f : f * 1000.0f + 1002.0f);
                break;
            }
            case 2: {
                int n4 = this.intParameter(n3++);
                if (this.statementLength > n3 && this.statement[n3].tok == 137363473) {
                    this.setShapeProperty(n, "atom", new Integer(n4));
                    this.setShapeProperty(n, "radius", new Float(this.floatParameter(++n3)));
                    if (this.statementLength > n3 + 1 && this.statement[++n3].tok == 141562115) {
                        this.setShapeProperty(n, "colorRGB", new Integer(this.getArgbParam(++n3)));
                    }
                    if (this.getToken((int)n3).tok != 0x4000007) {
                        this.error(20);
                    }
                    this.setShapeProperty(n, "dots", this.statement[n3].value);
                    return;
                }
                if (n4 < 0 || n4 > 1000) {
                    this.integerOutOfRange(0, 1000);
                }
                n2 = n4 == 0 ? 0 : n4 + 1;
                break;
            }
            case 0x70000E: {
                n2 = Short.MAX_VALUE;
                if (this.tokAt(2) != 2) break;
                n2 += this.intParameter(2);
                break;
            }
            case 0x70000F: {
                n2 = Short.MIN_VALUE;
                if (this.tokAt(2) != 2) break;
                n2 -= this.intParameter(2);
                break;
            }
            default: {
                this.error(5);
            }
        }
        this.setShapeSize(n, n2);
    }

    private void proteinShape(int n) throws ScriptException {
        int n2 = 0;
        switch (this.getToken((int)1).tok) {
            case 0x100011: {
                n2 = -1;
                break;
            }
            case 0x100010: {
                break;
            }
            case 3149845: {
                n2 = -2;
                break;
            }
            case 3146123: 
            case 0x400000E: {
                n2 = -4;
                break;
            }
            case 2: {
                n2 = this.intParameter(1, 0, 499) * 8;
                break;
            }
            case 3: {
                n2 = (int)(this.floatParameter(1, 0.0f, 4.0f) * 2000.0f);
                break;
            }
            case 0x4000007: {
                if (!this.isSyntaxCheck) {
                    this.viewer.loadShape(n);
                }
                this.setShapeProperty(n, "bitset", this.theToken.value);
                return;
            }
            default: {
                this.error(5);
            }
        }
        this.setShapeSize(n, n2);
    }

    private void animation() throws ScriptException {
        boolean bl = false;
        switch (this.getToken((int)1).tok) {
            case 0x100011: {
                bl = true;
            }
            case 0x100010: {
                if (this.isSyntaxCheck) break;
                this.viewer.setAnimationOn(bl);
                break;
            }
            case 4116: {
                this.frame(2);
                break;
            }
            case 67108892: {
                this.animationMode();
                break;
            }
            case 0x400000D: {
                this.animationDirection();
                break;
            }
            case 1: {
                String string = this.parameterAsString(1);
                if (string.equalsIgnoreCase("fps")) {
                    this.checkLength(3);
                    this.setIntProperty("animationFps", this.intParameter(2));
                    break;
                }
            }
            default: {
                this.frameControl(1, true);
            }
        }
    }

    private void file() throws ScriptException {
        this.checkLength(2);
        int n = this.intParameter(1);
        if (this.isSyntaxCheck) {
            return;
        }
        int n2 = this.viewer.getModelNumberIndex(n * 1000000 + 1, false, false);
        int n3 = -1;
        if (n2 >= 0) {
            n3 = this.viewer.getModelNumberIndex((n + 1) * 1000000 + 1, false, false);
            if (n3 < 0) {
                n3 = this.viewer.getModelCount();
            }
            --n3;
        }
        this.viewer.setAnimationOn(false);
        this.viewer.setAnimationDirection(1);
        this.viewer.setAnimationRange(n2, n3);
        this.viewer.setCurrentModelIndex(-1);
    }

    private void frame(int n) throws ScriptException {
        int n2;
        int n3;
        boolean bl = true;
        if (this.statementLength == 1 && n == 1) {
            int n4 = this.viewer.getCurrentModelIndex();
            if (!this.isSyntaxCheck && n4 >= 0 && (n4 = this.viewer.getJmolDataSourceFrame(n4)) >= 0) {
                this.viewer.setCurrentModelIndex(n4, true);
            }
            return;
        }
        if (this.statementLength == 3 && this.parameterAsString(1).equalsIgnoreCase("Title")) {
            if (!this.isSyntaxCheck) {
                this.viewer.setFrameTitle(this.parameterAsString(2));
            }
            return;
        }
        if (this.getToken((int)n).tok == 0x1100070) {
            this.checkLength(++n + 1);
            if (this.getToken((int)n).tok != 2 || this.intParameter(n) != 1) {
                this.error(20);
            }
            if (!this.isSyntaxCheck) {
                this.viewer.setAnimationPrevious();
            }
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int[] nArray = new int[]{-1, -1};
        int n5 = 0;
        block9: for (n3 = n; n3 < this.statementLength; ++n3) {
            switch (this.getToken((int)n3).tok) {
                case 0x100003: 
                case 0x1100081: {
                    this.checkLength(n + (bl3 ? 2 : 1));
                    bl4 = true;
                    continue block9;
                }
                case 0x1100070: {
                    if (n5 != 1) {
                        this.error(20);
                    }
                    bl5 = true;
                    continue block9;
                }
                case 0x10000F: {
                    this.checkLength(n + 1);
                    continue block9;
                }
                case 3: {
                    bl = false;
                    if (this.floatParameter(n3) < 0.0f) {
                        bl5 = true;
                    }
                }
                case 2: {
                    if (n5 == 2) {
                        this.error(20);
                    }
                    if ((n2 = this.statement[n3].intValue) >= 1000 && n2 < 1000000 && this.viewer.haveFileSet()) {
                        n2 = n2 / 1000 * 1000000 + n2 % 1000;
                    }
                    if (!bl && n2 == 0) {
                        bl4 = true;
                    }
                    if (n2 >= 1000000) {
                        bl = false;
                    }
                    nArray[n5++] = n2;
                    continue block9;
                }
                case 67108904: {
                    bl2 = true;
                    continue block9;
                }
                case 67108908: {
                    bl3 = true;
                    continue block9;
                }
                default: {
                    this.checkLength(n + 1);
                    this.frameControl(n3, false);
                    return;
                }
            }
        }
        n3 = this.viewer.haveFileSet() ? 1 : 0;
        if (bl3 && n5 == 0) {
            bl4 = true;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        if (bl4) {
            this.viewer.setAnimationOn(false);
            this.viewer.setAnimationRange(-1, -1);
            if (!bl3) {
                this.viewer.setCurrentModelIndex(-1);
            }
            return;
        }
        if (n5 == 2 && !bl3) {
            bl5 = true;
        }
        if (n3 != 0) {
            bl = false;
        } else if (bl) {
            for (n2 = 0; n2 < n5; ++n2) {
                if (nArray[n2] < 0) continue;
                int n6 = n2;
                nArray[n6] = nArray[n6] % 1000000;
            }
        }
        n2 = this.viewer.getModelNumberIndex(nArray[0], bl, false);
        int n7 = -1;
        if (n3 != 0 && n5 == 1 && n2 < 0 && nArray[0] != 0) {
            if (nArray[0] < 1000000) {
                nArray[0] = nArray[0] * 1000000;
            }
            if (nArray[0] % 1000000 == 0) {
                nArray[0] = nArray[0] + 1;
                n2 = this.viewer.getModelNumberIndex(nArray[0], false, false);
                if (n2 >= 0) {
                    n7 = this.viewer.getModelNumberIndex(nArray[0] + 1000000, false, false);
                    if (n7 < 0) {
                        n7 = this.viewer.getModelCount();
                    }
                    --n7;
                    if (bl3) {
                        n5 = 2;
                    } else if (!bl5 && n7 != n2) {
                        bl5 = true;
                    }
                    bl3 = bl3 || n2 == n7;
                }
            } else {
                return;
            }
        }
        if (!bl2 && !bl3 || n2 >= 0) {
            this.viewer.setCurrentModelIndex(n2, false);
        }
        if (bl2 && n5 == 2 || bl3 || bl5) {
            if (n7 < 0) {
                n7 = this.viewer.getModelNumberIndex(nArray[1], bl, false);
            }
            this.viewer.setAnimationOn(false);
            this.viewer.setAnimationDirection(1);
            this.viewer.setAnimationRange(n2, n7);
            this.viewer.setCurrentModelIndex(bl5 && !bl3 ? -1 : (n2 >= 0 ? n2 : 0), false);
        }
        if (bl2) {
            this.viewer.resumeAnimation();
        }
    }

    BitSet bitSetForModelFileNumber(int n) {
        int n2;
        BitSet bitSet = new BitSet();
        if (this.isSyntaxCheck) {
            return bitSet;
        }
        int n3 = this.viewer.getModelCount();
        boolean bl = this.viewer.haveFileSet();
        if (n < 1000000 && bl) {
            n *= 1000000;
        }
        if ((n2 = n % 1000000) == 0) {
            int n4;
            int n5 = this.viewer.getModelNumberIndex(n + 1, false, false);
            if (n5 < 0) {
                return bitSet;
            }
            int n6 = n4 = n == 0 ? n3 : this.viewer.getModelNumberIndex(n + 1000001, false, false);
            if (n5 < 0) {
                n5 = 0;
            }
            if (n4 < 0) {
                n4 = n3;
            }
            if (this.viewer.isTrajectory(n5)) {
                n4 = n5 + 1;
            }
            for (int i = n5; i < n4; ++i) {
                bitSet.or(this.viewer.getModelAtomBitSet(i, false));
            }
        } else {
            int n7 = this.viewer.getModelNumberIndex(n, false, true);
            if (n7 >= 0) {
                bitSet.or(this.viewer.getModelAtomBitSet(n7, false));
            }
        }
        return bitSet;
    }

    private void frameControl(int n, boolean bl) throws ScriptException {
        this.checkLength(n + 1);
        int n2 = this.getToken((int)n).tok;
        if (this.isSyntaxCheck) {
            switch (n2) {
                case 20485: 
                case 67108888: 
                case 67108894: 
                case 67108904: 
                case 67108905: 
                case 67108907: 
                case 67108911: 
                case 0x4000030: {
                    return;
                }
            }
        } else {
            switch (n2) {
                case 67108905: {
                    this.viewer.reverseAnimation();
                }
                case 67108904: 
                case 67108911: {
                    this.viewer.resumeAnimation();
                    return;
                }
                case 20485: {
                    this.viewer.pauseAnimation();
                    return;
                }
                case 67108894: {
                    this.viewer.setAnimationNext();
                    return;
                }
                case 67108907: {
                    this.viewer.setAnimationPrevious();
                    return;
                }
                case 0x4000030: {
                    this.viewer.rewindAnimation();
                    return;
                }
                case 67108888: {
                    this.viewer.setAnimationLast();
                    return;
                }
            }
        }
        this.error(20);
    }

    private int getShapeType(int n) throws ScriptException {
        int n2 = JmolConstants.shapeTokenIndex(n);
        if (n2 < 0) {
            this.error(38);
        }
        return n2;
    }

    private void font(int n, float f) throws ScriptException {
        String string = "SansSerif";
        String string2 = "Plain";
        int n2 = 0;
        float f2 = -1.0f;
        this.iToken = this.statementLength;
        switch (this.iToken) {
            case 6: {
                f2 = this.floatParameter(5);
                if (f2 >= 5.0f) {
                    f2 = this.viewer.getZoomSetting() / f2 / this.viewer.getScalePixelsPerAngstrom();
                }
            }
            case 5: {
                if (this.getToken((int)4).tok != 1) {
                    this.error(20);
                }
                string2 = this.parameterAsString(4);
            }
            case 4: {
                if (this.getToken((int)3).tok != 1) {
                    this.error(20);
                }
                string = this.parameterAsString(3);
                if (!this.isFloatParameter(2)) {
                    this.error(25);
                }
                f = this.floatParameter(2);
                n = this.getShapeType(this.getToken((int)1).tok);
                break;
            }
            case 3: {
                if (!this.isFloatParameter(2)) {
                    this.error(25);
                }
                if (n == -1) {
                    n = this.getShapeType(this.getToken((int)1).tok);
                    f = this.floatParameter(2);
                    break;
                }
                if (!(f >= 1.0f)) break;
                n2 = 5;
                f += (float)5;
                break;
            }
            default: {
                if (n == 4) {
                    f = 13.0f;
                    break;
                }
                this.error(1);
            }
        }
        if (n == 4) {
            if (f < 0.0f || f >= 1.0f && (f < 6.0f || f > 63.0f)) {
                this.integerOutOfRange(6 - n2, 63 - n2);
            }
            this.setShapeProperty(4, "setDefaults", this.viewer.getNoneSelected());
        }
        if (this.isSyntaxCheck) {
            return;
        }
        Font3D font3D = this.viewer.getFont3D(string, string2, f);
        this.viewer.loadShape(n);
        this.setShapeProperty(n, "font", font3D);
        if (f2 >= 0.0f) {
            this.setShapeProperty(n, "scalereference", new Float(f2));
        }
    }

    private void set() throws ScriptException {
        String string;
        if (this.statementLength == 1) {
            this.showString(this.viewer.getAllSettings(null));
            return;
        }
        boolean bl = this.parameterAsString(0).equals("set");
        if (bl && this.statementLength == 2 && (string = this.parameterAsString(1)).indexOf("?") >= 0) {
            this.showString(this.viewer.getAllSettings(string.substring(0, string.indexOf("?"))));
            return;
        }
        boolean bl2 = !this.isSyntaxCheck && !this.tQuiet && this.scriptLevel <= this.scriptReportingLevel && !((String)this.statement[0].value).equals("var");
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        switch (this.getToken((int)1).tok) {
            case 134746114: {
                this.axes(2);
                return;
            }
            case 134221828: {
                this.background(2);
                return;
            }
            case 142086157: {
                this.boundbox(2);
                return;
            }
            case 134746133: {
                this.frank(2);
                return;
            }
            case 134221850: {
                this.history(2);
                return;
            }
            case 150491656: {
                this.label(2);
                return;
            }
            case 169349184: {
                this.unitcell(2);
                return;
            }
            case 134230020: 
            case 134746163: {
                this.selectionHalo(2);
                return;
            }
            case 0x8000002: {
                this.setBondmode();
                return;
            }
            case 134238209: {
                this.setEcho();
                return;
            }
            case 0x8000003: {
                this.checkLength23();
                this.font(4, this.statementLength == 2 ? 0.0f : this.floatParameter(2));
                return;
            }
            case 135794713: {
                this.setHbond();
                return;
            }
            case 135794723: {
                this.setMonitor();
                return;
            }
            case 141558028: {
                string = this.parameterAsString(1).toLowerCase();
                if (string.startsWith("property_")) break;
                this.setProperty();
                return;
            }
            case 0x8000004: {
                this.setPicking();
                return;
            }
            case 0x800000D: {
                this.setPickingStyle();
                return;
            }
            case 134746167: {
                this.checkLength(4);
                this.setSpin(this.parameterAsString(2), (int)this.floatParameter(3));
                return;
            }
            case 134746168: {
                this.setSsbond();
                return;
            }
            case 0x800000B: {
                this.setFloatProperty("scaleAngstromsPerInch", this.floatSetting(2));
                return;
            }
            case 137363721: {
                n2 = this.intSetting(2);
                if (!this.isSyntaxCheck) {
                    this.viewer.setFormalCharges(n2);
                }
                return;
            }
            case 0x8000005: {
                if (this.statementLength == 2 || this.statement[2].tok != 2) {
                    string = "specular";
                    break;
                }
            }
            case 0x8000006: {
                string = "specularPercent";
                break;
            }
            case 0x8000001: {
                string = "ambientPercent";
                break;
            }
            case 0x800000C: {
                string = "diffusePercent";
                break;
            }
            case 0x8000007: {
                n = this.intSetting(2);
                if (n >= 0) {
                    string = "specularPower";
                    break;
                }
                if (n < -10 || n > -1) {
                    this.integerOutOfRange(-10, -1);
                }
                n = -n;
                string = "specularExponent";
                break;
            }
            case 0x8000008: {
                string = "specularExponent";
                break;
            }
            case 141557762: {
                string = "showMultipleBonds";
                break;
            }
            case 134746171: {
                string = "strandCount";
                break;
            }
            case 168820739: {
                string = "selectHetero";
                break;
            }
            case 168820740: {
                string = "selectHydrogen";
                break;
            }
            case 137363473: {
                string = "solventProbeRadius";
                break;
            }
            case 168820747: {
                string = "solventProbe";
                break;
            }
            case 0x800000A: 
            case 141562115: {
                string = "defaultColorScheme";
                break;
            }
            default: {
                string = this.parameterAsString(1);
                if (string.charAt(0) == '_') {
                    this.error(20);
                }
                if (string.equalsIgnoreCase("toggleLabel") && this.setLabel("toggle")) {
                    return;
                }
                if (string.toLowerCase().indexOf("label") == 0 && Parser.isOneOf((String)string.substring(5).toLowerCase(), (String)"front;group;atom;offset;pointer;alignment;toggle;scalereference") && this.setLabel(string.substring(5))) {
                    return;
                }
                if (string.equalsIgnoreCase("userColorScheme")) {
                    this.setUserColors();
                    return;
                }
                if (string.equalsIgnoreCase("defaultLattice")) {
                    int n3;
                    Vector vector = (Vector)this.parameterExpression(2, 0, "XXX", true);
                    if (vector == null || vector.size() == 0) {
                        this.error(20);
                    }
                    Token token = (Token)vector.elementAt(0);
                    Point3f point3f = token.tok == 7 ? (Point3f)token.value : ((n3 = Token.iValue(token)) < 555 ? new Point3f() : UnitCell.ijkToPoint3f((int)(n3 + 111)));
                    if (!this.isSyntaxCheck) {
                        this.viewer.setDefaultLattice(point3f);
                    }
                    return;
                }
                if (string.equalsIgnoreCase("defaultDrawArrowScale")) {
                    this.setFloatProperty(string, this.floatSetting(2));
                    return;
                }
                if (string.equalsIgnoreCase("logLevel")) {
                    int n4 = this.intSetting(2);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    this.setIntProperty("logLevel", n4);
                    return;
                }
                if (string.equalsIgnoreCase("backgroundModel")) {
                    int n5;
                    String string2 = this.stringSetting(2, false);
                    boolean bl3 = false;
                    if (string2.indexOf(".") < 0) {
                        n5 = Parser.parseInt((String)string2);
                        bl3 = true;
                    } else {
                        n5 = Compiler.modelValue(string2);
                    }
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    int n6 = this.viewer.getModelNumberIndex(n5, bl3, true);
                    this.viewer.setBackgroundModelIndex(n6);
                    return;
                }
                if (string.equalsIgnoreCase("language")) {
                    String string3 = this.stringSetting(2, bl);
                    this.setStringProperty(string, string3);
                    return;
                }
                if (string.equalsIgnoreCase("trajectory") || string.equalsIgnoreCase("trajectories")) {
                    Token token = this.tokenSetting(2);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    if (token.tok == 3) {
                        this.viewer.getModelNumberIndex(token.intValue, false, true);
                    }
                    return;
                }
                if (string.equalsIgnoreCase("showSelections")) {
                    string = "selectionHalos";
                    break;
                }
                if (!string.equalsIgnoreCase("measurementNumbers")) break;
                string = "measurementLabels";
            }
        }
        if (this.getContextVariableAsToken(string) != null || !this.setParameter(string, n, bl, bl2)) {
            int n7 = this.tokAt(1) == 0x100001 ? 0 : this.tokAt(2);
            this.setVariable(n7 == 17826148 ? 3 : 2, 0, string, bl2);
            if (!bl) {
                return;
            }
        }
        if (bl2) {
            this.viewer.showParameter(string, true, 80);
        }
    }

    private int intSetting(int n, int n2, int n3, int n4) throws ScriptException {
        if (n2 == Integer.MAX_VALUE) {
            n2 = this.intSetting(n);
        }
        if (n2 < n3 || n2 > n4) {
            this.integerOutOfRange(n3, n4);
        }
        return n2;
    }

    private int intSetting(int n) throws ScriptException {
        Vector vector = (Vector)this.parameterExpression(n, -1, "XXX", true);
        if (vector == null || vector.size() == 0) {
            this.error(20);
        }
        return Token.iValue((Token)vector.elementAt(0));
    }

    private float floatSetting(int n, float f, float f2) throws ScriptException {
        float f3 = this.floatSetting(n);
        if (f3 < f || f3 > f2) {
            this.numberOutOfRange(f, f2);
        }
        return f3;
    }

    private float floatSetting(int n) throws ScriptException {
        Vector vector = (Vector)this.parameterExpression(n, -1, "XXX", true);
        if (vector == null || vector.size() == 0) {
            this.error(20);
        }
        return Token.fValue((Token)vector.elementAt(0));
    }

    private String stringSetting(int n, boolean bl) throws ScriptException {
        if (bl && this.statementLength == n + 1) {
            return this.parameterAsString(n);
        }
        Vector vector = (Vector)this.parameterExpression(n, -1, "XXX", true);
        if (vector == null || vector.size() == 0) {
            this.error(20);
        }
        return Token.sValue((Token)vector.elementAt(0));
    }

    private Token tokenSetting(int n) throws ScriptException {
        Vector vector = (Vector)this.parameterExpression(n, -1, "XXX", true);
        if (vector == null || vector.size() == 0) {
            this.error(20);
        }
        return (Token)vector.elementAt(0);
    }

    private void setVariable(int n, int n2, String string, boolean bl) throws ScriptException {
        Token token;
        Object object;
        BitSet bitSet = null;
        String string2 = "";
        if (this.tokAt(n - 1) == 0x100001) {
            bitSet = this.expression(n - 1);
            n = this.iToken + 1;
        }
        int n3 = 0;
        if (this.tokAt(n) == 0x10000A) {
            if ((object = this.getBitsetPropertySelector(++n, true)) == null) {
                this.error(20);
            }
            if (this.tokAt(++n) != 17826148) {
                this.error(20);
            }
            ++n;
            n3 = ((Token)object).intValue;
            string2 = (String)((Token)object).value;
        } else if (bitSet != null) {
            this.error(20);
        }
        Token token2 = this.getContextVariableAsToken(string);
        boolean bl2 = token2 != null || n3 != 0;
        Object object2 = this.parameterExpression(n, n2, string, bl2);
        if (this.isSyntaxCheck || object2 == null) {
            return;
        }
        if (bl2 && ((Vector)object2).size() == 0) {
            this.error(20);
        }
        Token token3 = token = bl2 ? (Token)((Vector)object2).get(0) : null;
        if (n3 != 0) {
            if (bitSet == null) {
                if (token2 == null) {
                    object2 = this.viewer.getParameter(string);
                    if (!(object2 instanceof String)) {
                        this.error(20);
                    }
                    if (!((object2 = this.getStringObjectAsToken((String)object2, null)) instanceof Token)) {
                        this.error(20);
                    }
                    token2 = (Token)object2;
                }
                if (!(token2.value instanceof BitSet)) {
                    this.error(20);
                }
                bitSet = (BitSet)token2.value;
            }
            if (string2.startsWith("property_")) {
                this.viewer.setData(string2, new Object[]{string2, Token.sValue(token), bitSet}, this.viewer.getAtomCount(), 0, token.tok == 6 ? Integer.MAX_VALUE : Integer.MIN_VALUE);
                return;
            }
            this.setBitsetProperty(bitSet, n3, Token.iValue(token), Token.fValue(token), token);
            return;
        }
        if (token2 != null) {
            token2.value = token.value;
            token2.intValue = token.intValue;
            token2.tok = token.tok;
        }
        if (string.startsWith("property_")) {
            int n4 = this.viewer.getAtomCount();
            this.viewer.setData(string, new Object[]{string, "" + object2, this.viewer.getSelectionSet()}, n4, 0, Integer.MIN_VALUE);
            return;
        }
        if (object2 == null) {
            return;
        }
        if (object2 instanceof Boolean) {
            this.setBooleanProperty(string, (Boolean)object2);
        } else if (object2 instanceof Integer) {
            this.setIntProperty(string, (Integer)object2);
        } else if (object2 instanceof Float) {
            this.setFloatProperty(string, ((Float)object2).floatValue());
        } else if (object2 instanceof String) {
            this.setStringProperty(string, (String)object2);
        } else if (object2 instanceof Bond.BondSet) {
            this.setStringProperty(string, Escape.escape((BitSet)((BitSet)object2), (boolean)false));
        } else if (object2 instanceof BitSet) {
            this.setStringProperty(string, Escape.escape((BitSet)((BitSet)object2)));
        } else if (object2 instanceof Point3f) {
            object = Escape.escape((Tuple3f)((Point3f)object2));
            this.setStringProperty(string, (String)object);
        } else if (object2 instanceof Point4f) {
            object = Escape.escape((Point4f)((Point4f)object2));
            this.setStringProperty(string, (String)object);
        }
    }

    private boolean setParameter(String string, int n, boolean bl, boolean bl2) throws ScriptException {
        String string2 = string.toLowerCase();
        if (string.equalsIgnoreCase("scriptReportingLevel")) {
            n = this.intSetting(2);
            if (!this.isSyntaxCheck) {
                this.scriptReportingLevel = n;
                this.setIntProperty(string, n);
            }
            return true;
        }
        if (string.equalsIgnoreCase("historyLevel")) {
            n = this.intSetting(2);
            if (!this.isSyntaxCheck) {
                this.commandHistoryLevelMax = n;
                this.setIntProperty(string, n);
            }
            return true;
        }
        if (string.equalsIgnoreCase("dipoleScale")) {
            return this.setFloatProperty("dipoleScale", this.floatSetting(2, -10.0f, 10.0f));
        }
        if (string.equalsIgnoreCase("axesScale")) {
            return this.setFloatProperty("axesScale", this.floatSetting(2, -100.0f, 100.0f));
        }
        if (string.equalsIgnoreCase("measurementUnits")) {
            return this.setMeasurementUnits(this.stringSetting(2, bl));
        }
        if (string.equalsIgnoreCase("defaultVDW")) {
            String string3;
            String string4 = string3 = this.statementLength == 3 && JmolConstants.getVdwType(this.parameterAsString(2)) >= 0 ? this.parameterAsString(2) : this.stringSetting(2, false);
            if (JmolConstants.getVdwType(string3) < 0) {
                this.error(20);
            }
            this.setStringProperty(string, string3);
            return true;
        }
        if (Parser.isOneOf((String)string2, (String)"defaults;defaultcolorscheme")) {
            String string5;
            this.theTok = this.tokAt(2);
            if (this.theTok == 67108887 || this.theTok == 67108909) {
                string5 = this.parameterAsString(2).toLowerCase();
                this.checkLength(3);
            } else {
                string5 = this.stringSetting(2, false).toLowerCase();
            }
            if (!string5.equals("jmol") && !string5.equals("rasmol")) {
                this.error(20);
            }
            this.setStringProperty(string.equalsIgnoreCase("defaults") ? string : "defaultColorScheme", string5);
            return true;
        }
        if (Parser.isOneOf((String)string2, (String)"strandcount;strandcountformeshribbon;strandcountforstrands")) {
            return this.setIntProperty(string, this.intSetting(2, Integer.MAX_VALUE, 0, 20));
        }
        if (Parser.isOneOf((String)string2, (String)"specularpercent;ambientpercent;diffusepercent;specularPower")) {
            return this.setIntProperty(string, this.intSetting(2, n, 0, 100));
        }
        if (string.equalsIgnoreCase("specularExponent")) {
            return this.setIntProperty(string, this.intSetting(2, n, 1, 10));
        }
        boolean bl3 = this.viewer.isJmolVariable(string);
        if (bl && !bl3) {
            this.iToken = 1;
            if (!this.isStateScript) {
                this.error(39, "SET", string);
            }
            this.warning(40, "SET", string);
        }
        switch (this.statementLength) {
            case 2: {
                this.setBooleanProperty(string, true);
                return true;
            }
            case 3: {
                if (n != Integer.MAX_VALUE) {
                    this.setIntProperty(string, n);
                    return true;
                }
                this.getToken(2);
                if (this.theTok == 0x10000F) {
                    if (!this.isSyntaxCheck) {
                        this.viewer.removeUserVariable(string);
                    }
                } else if (!bl || this.theTok != 1) {
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private Object parameterExpression(int n, int n2, String string, boolean bl) throws ScriptException {
        return this.parameterExpression(n, n2, string, bl, -1, null, null);
    }

    private Object parameterExpression(int n, int n2, String string, boolean bl, int n3, Hashtable hashtable, String string2) throws ScriptException {
        Token token;
        boolean bl2;
        boolean bl3 = n == 0;
        boolean bl4 = n < 0;
        boolean bl5 = bl2 = string2 != null;
        if (bl4) {
            n = -n;
        }
        int n4 = 0;
        boolean bl6 = string != null && string.length() > 0;
        Rpn rpn = new Rpn(64, bl6 && this.tokAt(n) == 0x1100020, bl);
        if (n2 < n) {
            n2 = this.statementLength;
        }
        block17: for (int i = n; i < n2; ++i) {
            Object object = null;
            int n5 = this.getToken((int)i).tok;
            if (bl2 && this.tokAt(i + 1) != 0x10000A && Compiler.tokAttr(n5, 0x300000)) {
                rpn.addX((Token)hashtable.get(string2));
                if (rpn.addOp(new Token(0x11000A1, n5, this.parameterAsString(i).toLowerCase()))) continue;
                this.error(20);
                continue;
            }
            switch (n5) {
                case 9451009: {
                    int n6;
                    String string3 = "_x";
                    if (!bl3) {
                        if (this.getToken((int)(++i)).tok != 0x1100000 || this.getToken((int)(++i)).tok != 1) {
                            this.error(20);
                        }
                        string3 = this.parameterAsString(i);
                        if (this.getToken((int)(++i)).tok != 0x100013) {
                            this.error(20);
                        }
                    }
                    if (!((object = this.tokenSetting((int)(-(++i))).value) instanceof BitSet)) {
                        this.error(20);
                    }
                    BitSet bitSet = (BitSet)object;
                    i = this.iToken;
                    if (!bl3 && this.getToken((int)i++).tok != 0x100013) {
                        this.error(20);
                    }
                    BitSet bitSet2 = new BitSet();
                    BitSet bitSet3 = new BitSet();
                    Token.Token2 token2 = null;
                    int n7 = n6 = this.isSyntaxCheck ? 0 : this.viewer.getAtomCount();
                    if (hashtable == null) {
                        hashtable = new Hashtable<String, Token.Token2>();
                    }
                    token2 = new Token.Token2(0x4000007, 0, bitSet3);
                    hashtable.put(string3, token2);
                    for (int j = 0; j < n6; ++j) {
                        if (!bitSet.get(j)) continue;
                        bitSet3.clear();
                        bitSet3.set(j);
                        token2.intValue2 = j;
                        if (((Boolean)this.parameterExpression(i, -1, null, false, j, hashtable, bl3 ? string3 : null)).booleanValue()) {
                            bitSet2.set(j);
                        }
                        if (bl3 || this.tokAt(this.iToken) == 0x1100001) continue;
                        this.error(20);
                    }
                    if (bl3) {
                        return this.bitsetTokenVector(bitSet2);
                    }
                    i = this.iToken;
                    object = bitSet2;
                    break;
                }
                case 0x100013: {
                    break block17;
                }
                case 3: 
                case 4: 
                case 7: 
                case 8: 
                case 0x100010: 
                case 0x100011: 
                case 0x4000007: {
                    rpn.addX(this.theToken);
                    break;
                }
                case 2: 
                case 1048614: {
                    rpn.addX(Token.intToken(this.theToken.intValue));
                    break;
                }
                case 0x100009: {
                    rpn.addX(new Token(7, this.centerParameter(i)));
                    i = this.iToken;
                    break;
                }
                case 0x10000E: {
                    object = this.getPointOrPlane(i, false, true, true, false, 3, 4);
                    i = this.iToken;
                    break;
                }
                case 0x100001: {
                    object = this.expression(this.statement, i, 0, true, true, true, true);
                    i = this.iToken++;
                    if (n4 != 0 || !bl4) break;
                    return this.bitsetTokenVector(object);
                }
                case 0x100002: {
                    ++i;
                    break block17;
                }
                case 0x100012: {
                    this.error(20);
                }
                case 0x1100010: {
                    if (rpn.addOp(this.theToken)) break;
                    this.error(20);
                    break;
                }
                case 0x10000A: {
                    Token token2 = this.getBitsetPropertySelector(i + 1, false);
                    if (token2 == null) {
                        this.error(20);
                    }
                    if (this.tokAt(this.iToken + 1) == 0x10000A) {
                        if (this.tokAt(this.iToken + 2) == 0x100003) {
                            token2.intValue |= 0x60;
                            this.getToken(this.iToken + 2);
                        }
                        if (Compiler.tokAttrOr(this.tokAt(this.iToken + 2), 32, 64)) {
                            token2.intValue |= this.getToken((int)(this.iToken + 2)).tok;
                        }
                    }
                    if (!rpn.addOp(token2)) {
                        this.error(20);
                    }
                    i = this.iToken;
                    break;
                }
                default: {
                    if (this.theTok == 1 && this.compiler.isFunction((String)this.theToken.value)) {
                        if (rpn.addOp(new Token(9670657, this.theToken.value))) break;
                        this.error(20);
                        break;
                    }
                    if (Compiler.tokAttr(this.theTok, 0x1100000) || Compiler.tokAttr(this.theTok, 0x900000)) {
                        if (!rpn.addOp(this.theToken)) {
                            if (n3 >= 0) break block17;
                            this.error(20);
                        }
                        if (this.theTok == 0x1100000) {
                            ++n4;
                            break;
                        }
                        if (this.theTok != 0x1100001 || --n4 != 0 || !bl4) break;
                        ++this.iToken;
                        break block17;
                    }
                    String string4 = this.parameterAsString(i);
                    if (this.isSyntaxCheck) {
                        object = string4;
                        break;
                    }
                    if (hashtable != null && (object = hashtable.get(string4)) != null || !((object = this.getParameter(string4, true)) instanceof String)) break;
                    object = this.getStringObjectAsToken((String)object, string4);
                    break;
                }
            }
            if (object == null) continue;
            if (object instanceof Boolean) {
                rpn.addX((Boolean)object != false ? Token.tokenOn : Token.tokenOff);
                continue;
            }
            if (object instanceof Integer) {
                rpn.addX(Token.intToken((Integer)object));
                continue;
            }
            if (object instanceof Float) {
                rpn.addX(new Token(3, object));
                continue;
            }
            if (object instanceof String) {
                rpn.addX(new Token(4, object));
                continue;
            }
            if (object instanceof Point3f) {
                rpn.addX(new Token(7, object));
                continue;
            }
            if (object instanceof Point4f) {
                rpn.addX(new Token(8, object));
                continue;
            }
            if (object instanceof BitSet) {
                rpn.addX(new Token(0x4000007, object));
                continue;
            }
            if (object instanceof Token) {
                rpn.addX((Token)object);
                continue;
            }
            this.error(20);
        }
        if ((token = rpn.getResult(false, string)) == null) {
            if (!this.isSyntaxCheck) {
                rpn.dumpStacks();
            }
            this.error(11);
        }
        if (token.tok == 4161) {
            return token.value;
        }
        if (string == null) {
            return Token.bValue(token);
        }
        if (string.length() == 0) {
            if (token.tok == 4) {
                token.intValue = Integer.MAX_VALUE;
            }
            return Token.sValue(token);
        }
        if (token.tok == 4 && token.intValue != Integer.MAX_VALUE) {
            if (!this.isSyntaxCheck && !this.insertArrayValue(string, token)) {
                this.error(20);
            }
            return null;
        }
        switch (token.tok) {
            case 0x100010: 
            case 0x100011: {
                return token == Token.tokenOn;
            }
            case 2: {
                return new Integer(token.intValue);
            }
        }
        return token.value;
    }

    Object bitsetTokenVector(Object object) {
        Vector<Token> vector = new Vector<Token>();
        if (object instanceof BitSet) {
            vector.addElement(new Token(0x4000007, object));
        }
        return vector;
    }

    private boolean insertArrayValue(String string, Token token) {
        int n = token.intValue;
        boolean bl = false;
        if (n == Integer.MAX_VALUE) {
            return false;
        }
        token.intValue = Integer.MAX_VALUE;
        String string2 = Token.sValue(token);
        Object object = this.getParameter(string, false);
        if (object instanceof String[]) {
            object = this.getParameter(string, true);
            bl = true;
        } else {
            if (!(object instanceof String)) {
                return false;
            }
            object = this.getStringObjectAsToken((String)object, string);
        }
        if (object instanceof Token) {
            Token token2 = (Token)object;
            if (token2.tok != 6) {
                return false;
            }
            String[] stringArray = (String[])token2.value;
            if (n <= 0) {
                n = stringArray.length + n;
            }
            if (--n < 0) {
                n = 0;
            }
            if (stringArray.length > n) {
                stringArray[n] = string2;
                if (!bl) {
                    this.viewer.setListVariable(string, token2);
                }
                return true;
            }
            String[] stringArray2 = ArrayUtil.ensureLength((String[])stringArray, (int)(n + 1));
            for (int i = stringArray.length; i <= n; ++i) {
                stringArray2[i] = "";
            }
            stringArray2[n] = string2;
            token2.value = stringArray2;
            if (!bl) {
                this.viewer.setListVariable(string, token2);
            }
            return true;
        }
        if (object instanceof String) {
            String string3 = (String)object;
            int n2 = string3.length();
            if (n <= 0) {
                n = n2 + n;
            }
            if (--n < 0) {
                n = 0;
            }
            while (n >= string3.length()) {
                string3 = string3 + " ";
            }
            string3 = string3.substring(0, n) + string2 + string3.substring(n + 1);
            this.setStringProperty(string, string3);
            return true;
        }
        return false;
    }

    private void assignBitsetVariable(String string, BitSet bitSet) {
        this.variables.put(string, bitSet);
        this.setStringProperty("@" + string, Escape.escape((BitSet)bitSet));
    }

    String getBitsetIdent(BitSet bitSet, String string, Object object, boolean bl) {
        String string2;
        int n;
        int[] nArray;
        int n2;
        boolean bl2;
        boolean bl3 = bl2 = !(object instanceof Bond.BondSet);
        if (bl2 && string == null) {
            string = this.viewer.getStandardLabelFormat();
        }
        int n3 = n2 = string == null ? -1 : string.indexOf("%");
        if (bitSet == null || this.isSyntaxCheck || bl2 && n2 < 0) {
            return string == null ? "" : string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = bitSet.size();
        ModelSet modelSet = this.viewer.getModelSet();
        int n5 = 0;
        int[] nArray2 = nArray = bl2 || !bl ? null : ((Bond.BondSet)object).getAssociatedAtoms();
        if (nArray == null && string != null && string.indexOf("%D") > 0) {
            nArray = this.viewer.getAtomIndices(bitSet);
        }
        int n6 = 0;
        String[] stringArray = null;
        Object object2 = null;
        while (n2 >= 0 && (n2 = string.indexOf("{", n2 + 1)) > 0) {
            n = string.indexOf("}", n2);
            if (n > 0) {
                float[] fArray;
                if (n6 == 0) {
                    for (int i = n2; i < string.length(); ++i) {
                        if (string.charAt(i) != '{') continue;
                        ++n6;
                    }
                    stringArray = new String[n6];
                    object2 = new float[n6][];
                    n6 = 0;
                }
                if ((fArray = this.viewer.getDataFloat(string2 = string.substring(n2 + 1, n))) != null) {
                    object2[n6] = fArray;
                    stringArray[n6++] = '{' + string2 + '}';
                }
            }
            n2 = n;
        }
        for (n = 0; n < n4; ++n) {
            if (!bitSet.get(n)) continue;
            string2 = string;
            if (bl2) {
                if (string2 == null) {
                    string2 = modelSet.getAtomAt(n).getInfo();
                } else {
                    string2 = modelSet.getAtomAt(n).formatLabel(string2, '\u0000', nArray);
                    for (int i = 0; i < n6; ++i) {
                        if (n >= object2[i].length) continue;
                        string2 = TextFormat.formatString((String)string2, (String)stringArray[i], (float)object2[i][n]);
                    }
                }
            } else {
                Bond bond = modelSet.getBondAt(n);
                if (string2 == null) {
                    string2 = bond.getIdentity();
                } else {
                    int n7;
                    string2 = bond.formatLabel(string2, nArray);
                    int n8 = bond.getAtomIndex1();
                    int n9 = bond.getAtomIndex2();
                    for (n7 = 0; n7 < n6; ++n7) {
                        if (n8 >= object2[n7].length) continue;
                        string2 = TextFormat.formatString((String)string2, (String)(stringArray[n7] + "1"), (float)object2[n7][n8]);
                    }
                    for (n7 = 0; n7 < n6; ++n7) {
                        if (n9 >= object2[n7].length) continue;
                        string2 = TextFormat.formatString((String)string2, (String)(stringArray[n7] + "2"), (float)object2[n7][n9]);
                    }
                }
            }
            string2 = TextFormat.formatString((String)string2, (String)"#", (int)(++n5));
            if (n5 > 1) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    private Token getBitsetPropertySelector(int n, boolean bl) throws ScriptException {
        int n2 = this.getToken((int)n).tok;
        String string = null;
        switch (n2) {
            default: {
                if (Compiler.tokAttrOr(n2, 0x300000, 0x700000)) break;
                return null;
            }
            case 141558028: {
                break;
            }
            case 1: {
                string = this.parameterAsString(n).toLowerCase();
                if (string.equals("x")) {
                    n2 = 3146112;
                    break;
                }
                if (string.equals("y")) {
                    n2 = 3146113;
                    break;
                }
                if (string.equals("z")) {
                    n2 = 3146114;
                    break;
                }
                if (string.equals("w")) {
                    n2 = 0x4000042;
                    break;
                }
                return null;
            }
        }
        if (bl && !Compiler.tokAttr(n2, 256)) {
            return null;
        }
        if (string == null) {
            string = this.parameterAsString(n).toLowerCase();
        }
        return new Token(0x11000A1, n2, string);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected Object getBitsetProperty(BitSet bitSet, int n, Point3f point3f, Point4f point4f, Object object, Object object2, boolean bl, int n2) throws ScriptException {
        float f;
        int n3;
        int n4;
        int n5;
        boolean bl2 = !(object instanceof Bond.BondSet);
        boolean bl3 = Compiler.tokAttr(n, 32);
        boolean bl4 = Compiler.tokAttr(n, 64);
        boolean bl5 = Compiler.tokAttr(n, 96);
        if (bl5) {
            bl4 = false;
            bl3 = false;
        }
        float[] fArray = null;
        BitSet bitSet2 = null;
        if ((n &= 0xFFFFFF9F) == 0x700001) {
            BitSet bitSet3 = bitSet2 = !bl2 && !this.isSyntaxCheck ? this.viewer.getAtomBits(141557762, bitSet) : bitSet;
        }
        if (n == 141557762) {
            BitSet bitSet4 = bitSet2 = bl2 && !this.isSyntaxCheck ? this.viewer.getBondsForSelectedAtoms(bitSet) : bitSet;
        }
        if (bitSet2 != null) {
            if (!bl4) {
                if (!bl3) return bitSet2;
            }
            if (this.isSyntaxCheck) {
                return bitSet2;
            }
            int n6 = bitSet2.size();
            int n7 = 0;
            if (bl3) {
                n7 = -1;
                while (++n7 < n6 && !bitSet2.get(n7)) {
                }
            } else if (bl4) {
                n7 = n6;
                while (--n7 >= 0 && !bitSet2.get(n7)) {
                }
            }
            bitSet2.clear();
            if (n7 < 0) return bitSet2;
            if (n7 >= n6) return bitSet2;
            bitSet2.set(n7);
            return bitSet2;
        }
        if (n == 0x700004) {
            if (bl3) return "";
            if (bl4) return "";
            String string = this.getBitsetIdent(bitSet, null, object, bl);
            return string;
        }
        int n8 = 0;
        int n9 = 0;
        int n10 = Integer.MIN_VALUE;
        int n11 = Integer.MAX_VALUE;
        float f2 = 0.0f;
        float f3 = -3.4028235E38f;
        float f4 = Float.MAX_VALUE;
        Point3f point3f2 = new Point3f();
        if (n == 15729665 && point3f == null && point4f == null) {
            return point3f2;
        }
        boolean bl6 = true;
        Point3f point3f3 = n == 141562115 ? new Point3f() : null;
        ModelSet modelSet = this.viewer.getModelSet();
        float[] fArray2 = n == 141558028 ? this.viewer.getDataFloat((String)object2) : null;
        int n12 = 0;
        if (bl2 || n2 >= 0) {
            n5 = -1;
            n4 = 0;
            int n13 = n12 = this.isSyntaxCheck ? 0 : this.viewer.getAtomCount();
            if (bl5) {
                fArray = new float[n12];
            }
            for (n3 = n2 >= 0 ? n2 : 0; n3 < n12; ++n3) {
                if (n2 < 0 && bitSet != null && !bitSet.get(n3)) continue;
                ++n8;
                Atom atom = modelSet.getAtomAt(n3);
                if (bl6) {
                    int n14 = 0;
                    switch (n) {
                        case 0x300001: {
                            n14 = atom.getAtomNumber();
                            break;
                        }
                        case 0x300004: {
                            n14 = n3;
                            break;
                        }
                        case 0x300007: {
                            n14 = atom.getElementNumber();
                            break;
                        }
                        case 0x300006: {
                            n14 = atom.getAtomicAndIsotopeNumber();
                            break;
                        }
                        case 137363721: {
                            n14 = atom.getFormalCharge();
                            break;
                        }
                        case 0x300013: {
                            n14 = atom.getAtomSite();
                            break;
                        }
                        case 3145750: {
                            if (atom.getModelIndex() != n5) {
                                n5 = atom.getModelIndex();
                                n4 = modelSet.getModelSymmetryCount(n5);
                            }
                            BitSet bitSet5 = atom.getAtomSymmetry();
                            int n15 = n4;
                            int n16 = 0;
                            int n17 = Integer.MAX_VALUE;
                            int n18 = Integer.MIN_VALUE;
                            for (int i = 0; i < n15; ++i) {
                                if (!bitSet5.get(i)) continue;
                                n14 += i + 1;
                                n17 = Math.min(n17, i + 1);
                                n18 = Math.max(n18, i + 1);
                                ++n16;
                            }
                            if (bl3) {
                                n14 = n17;
                            } else if (bl4) {
                                n14 = n18;
                            }
                            n8 += n16 - 1;
                            break;
                        }
                        case 0x30000E: {
                            n14 = atom.getMoleculeNumber();
                            break;
                        }
                        case 3145999: {
                            n14 = atom.getOccupancy();
                            break;
                        }
                        case 0x300010: {
                            n14 = atom.getPolymerLength();
                            break;
                        }
                        case 3145746: {
                            n14 = atom.getResno();
                            break;
                        }
                        case 0x30000A: {
                            n14 = atom.getGroupID();
                            break;
                        }
                        case 0x300002: {
                            n14 = atom.getSpecialAtomID();
                            break;
                        }
                        case 3149845: {
                            n14 = atom.getProteinStructureType();
                            break;
                        }
                        case 0x300003: {
                            n14 = atom.getCovalentBondCount();
                            break;
                        }
                        case 3146008: {
                            n14 = atom.getValence();
                            break;
                        }
                        case 3149832: {
                            n14 = atom.getModelFileIndex() + 1;
                            break;
                        }
                        case 3149837: {
                            n14 = atom.getModelNumber();
                            break;
                        }
                        default: {
                            bl6 = false;
                        }
                    }
                    if (bl6) {
                        if (bl5) {
                            fArray[n3] = n14;
                        } else if (bl3) {
                            n11 = Math.min(n11, n14);
                        } else if (bl4) {
                            n10 = Math.max(n10, n14);
                        } else {
                            n9 += n14;
                        }
                        if (n2 < 0) continue;
                        n3 = n12;
                        continue;
                    }
                }
                float f5 = Float.MAX_VALUE;
                switch (n) {
                    case 141558028: {
                        f5 = fArray2 == null ? 0.0f : fArray2[n3];
                        break;
                    }
                    case 0x70000E: {
                        f5 = atom.getADPMinMax(true);
                        break;
                    }
                    case 0x70000F: {
                        f5 = atom.getADPMinMax(false);
                        break;
                    }
                    case 3146112: {
                        f5 = ((Tuple3f)atom).x;
                        break;
                    }
                    case 3146113: {
                        f5 = ((Tuple3f)atom).y;
                        break;
                    }
                    case 3146114: {
                        f5 = ((Tuple3f)atom).z;
                        break;
                    }
                    case 3146115: {
                        f5 = atom.getFractionalCoord('X');
                        break;
                    }
                    case 3146116: {
                        f5 = atom.getFractionalCoord('Y');
                        break;
                    }
                    case 3146117: {
                        f5 = atom.getFractionalCoord('Z');
                        break;
                    }
                    case 3146124: {
                        f5 = this.viewer.getVibrationCoord(n3, 'x');
                        break;
                    }
                    case 3146125: {
                        f5 = this.viewer.getVibrationCoord(n3, 'y');
                        break;
                    }
                    case 3146126: {
                        f5 = this.viewer.getVibrationCoord(n3, 'z');
                        break;
                    }
                    case 15729665: {
                        if (point4f != null) {
                            f5 = Graphics3D.distanceToPlane((Point4f)point4f, (Point3f)atom);
                            break;
                        }
                        f5 = atom.distance(point3f);
                        break;
                    }
                    case 137363473: {
                        f5 = atom.getRadius();
                        break;
                    }
                    case 3146007: {
                        f5 = atom.getVanderwaalsRadiusFloat();
                        break;
                    }
                    case 3146118: {
                        f5 = atom.getPartialCharge();
                        break;
                    }
                    case 3145863: {
                        f5 = atom.getGroupPhi();
                        break;
                    }
                    case 0x300088: {
                        f5 = atom.getGroupPsi();
                        break;
                    }
                    case 3145865: {
                        f5 = atom.getStraightness();
                        break;
                    }
                    case 3145866: {
                        this.viewer.getSurfaceDistanceMax();
                        f5 = (float)atom.getSurfaceDistance100() / 100.0f;
                        break;
                    }
                    case 3146123: {
                        f5 = (float)atom.getBfactor100() / 100.0f;
                        break;
                    }
                    case 7340297: {
                        point3f2.add((Tuple3f)atom);
                        f5 = 0.0f;
                        break;
                    }
                    case 7340298: {
                        point3f2.add((Tuple3f)atom.getFractionalCoord());
                        f5 = 0.0f;
                        break;
                    }
                    case 7340299: {
                        point3f2.add((Tuple3f)this.viewer.getVibrationVector(n3));
                        f5 = 0.0f;
                        break;
                    }
                    case 141562115: {
                        point3f2.add((Tuple3f)Graphics3D.colorPointFromInt((int)this.viewer.getColixArgb(atom.getColix()), (Point3f)point3f3));
                        f5 = 0.0f;
                        break;
                    }
                    default: {
                        this.error(34, Token.nameOf(n));
                    }
                }
                if (f5 == Float.MAX_VALUE) {
                    --n8;
                } else if (bl5) {
                    fArray[n3] = f5;
                } else if (Float.isNaN(f5)) {
                    --n8;
                } else if (bl3) {
                    f4 = Math.min(f4, f5);
                } else if (bl4) {
                    f3 = Math.max(f3, f5);
                } else {
                    f2 += f5;
                }
                if (n2 < 0) continue;
                n3 = n12;
            }
        } else {
            n12 = this.viewer.getBondCount();
            if (bl5) {
                fArray = new float[n12];
            }
            for (n5 = 0; n5 < n12; ++n5) {
                if (bitSet != null && !bitSet.get(n5)) continue;
                ++n8;
                Bond bond = modelSet.getBondAt(n5);
                switch (n) {
                    case 0x700005: {
                        float f6 = bond.getAtom1().distance((Point3f)bond.getAtom2());
                        f4 = Math.min(f4, f6);
                        f3 = Math.max(f3, f6);
                        f2 += f6;
                        if (!bl5) break;
                        fArray[n5] = f6;
                        break;
                    }
                    case 7340297: {
                        point3f2.add((Tuple3f)bond.getAtom1());
                        point3f2.add((Tuple3f)bond.getAtom2());
                        ++n8;
                        break;
                    }
                    case 141562115: {
                        point3f2.add((Tuple3f)Graphics3D.colorPointFromInt((int)this.viewer.getColixArgb(bond.getColix()), (Point3f)point3f3));
                        break;
                    }
                    default: {
                        this.error(35, Token.nameOf(n));
                    }
                }
                bl6 = false;
            }
        }
        if (n == 7340297 || n == 141562115) {
            Point3f point3f4;
            if (n8 == 0) {
                point3f4 = point3f2;
                return point3f4;
            }
            point3f4 = new Point3f(point3f2.x / (float)n8, point3f2.y / (float)n8, point3f2.z / (float)n8);
            return point3f4;
        }
        if (n8 == 0) {
            return new Float(Float.NaN);
        }
        if (bl3) {
            n8 = 1;
            n9 = n11;
            f2 = f4;
        } else if (bl4) {
            n8 = 1;
            n9 = n10;
            f2 = f3;
        } else if (bl5) {
            float[] fArray3 = new float[n8];
            n4 = 0;
            n3 = 0;
            while (true) {
                if (n4 >= n12) {
                    if (object2 != null) return Escape.escape((float[])fArray3);
                    return fArray3;
                }
                if (bitSet == null || bitSet.get(n4)) {
                    fArray3[n3++] = fArray[n4];
                }
                ++n4;
            }
        }
        if (bl6 && n9 / n8 * n8 == n9) {
            return new Integer(n9 / n8);
        }
        if (bl6) {
            f = (float)n9 * 1.0f;
            return new Float(f / (float)n8);
        }
        f = f2;
        return new Float(f / (float)n8);
    }

    private void setBitsetProperty(BitSet bitSet, int n, int n2, float f, Token token) throws ScriptException {
        if (this.isSyntaxCheck || BitSetUtil.cardinalityOf((BitSet)bitSet) == 0) {
            return;
        }
        switch (n) {
            case 7340297: 
            case 7340298: 
            case 7340299: {
                if (token.tok == 7) {
                    this.viewer.setAtomCoord(bitSet, n, token.value);
                    break;
                }
                if (token.tok != 6) break;
                String[] stringArray = (String[])token.value;
                int n3 = stringArray.length;
                if (n3 == 0) {
                    return;
                }
                Point3f[] point3fArray = new Point3f[n3];
                int n4 = n3;
                while (--n4 >= 0) {
                    Object object = Escape.unescapePoint((String)stringArray[n4]);
                    if (!(object instanceof Point3f)) {
                        this.error(39, "ARRAY", stringArray[n4]);
                    }
                    point3fArray[n4] = (Point3f)object;
                }
                this.viewer.setAtomCoord(bitSet, n, point3fArray);
                break;
            }
            case 141562115: {
                if (token.tok == 7) {
                    n2 = Eval.colorPtToInt((Point3f)token.value);
                } else if (token.tok == 6) {
                    String[] stringArray = (String[])token.value;
                    int n5 = stringArray.length;
                    if (n5 == 0) {
                        return;
                    }
                    int[] nArray = new int[n5];
                    int n6 = n5;
                    while (--n6 >= 0) {
                        Object object = Escape.unescapePoint((String)stringArray[n6]);
                        nArray[n6] = object instanceof Point3f ? Eval.colorPtToInt((Point3f)object) : Graphics3D.getArgbFromString((String)stringArray[n6]);
                        if (nArray[n6] != 0 || (nArray[n6] = Parser.parseInt((String)stringArray[n6])) != Integer.MIN_VALUE) continue;
                        this.error(39, "ARRAY", stringArray[n6]);
                    }
                    this.viewer.setShapeProperty(0, "colorValues", nArray, bitSet);
                    break;
                }
                this.viewer.setShapeProperty(0, "color", token.tok == 4 ? token.value : new Integer(n2), bitSet);
                break;
            }
            default: {
                float[] fArray = null;
                if (token.tok == 6 || token.tok == 4) {
                    String[] stringArray = token.tok == 6 ? (String[])token.value : Parser.getTokens((String)Token.sValue(token));
                    int n7 = stringArray.length;
                    if (n7 == 0) {
                        return;
                    }
                    fArray = new float[n7];
                    int n8 = n7;
                    while (--n8 >= 0) {
                        fArray[n8] = Parser.parseFloat((String)stringArray[n8]);
                    }
                }
                this.viewer.setAtomProperty(bitSet, n, n2, f, fArray);
            }
        }
    }

    private void axes(int n) throws ScriptException {
        String string = this.optParameterAsString(n).toLowerCase();
        if (this.statementLength == n + 1 && Parser.isOneOf((String)string, (String)"window;unitcell;molecular")) {
            this.setBooleanProperty("axes" + string, true);
            return;
        }
        if (this.statementLength == n + 2 && string.equals("scale")) {
            this.setFloatProperty("axesScale", this.floatParameter(++n));
            return;
        }
        if (string.equals("position")) {
            Point3f point3f;
            if (this.tokAt(++n) == 0x100010) {
                point3f = new Point3f();
            } else {
                point3f = this.xypParameter(n);
                if (point3f == null) {
                    this.error(20);
                }
                n = this.iToken;
            }
            this.setShapeProperty(26, "position", point3f);
            return;
        }
        int n2 = this.getSetAxesTypeMad(n);
        if (!this.isSyntaxCheck) {
            this.viewer.setObjectMad(26, "axes", n2);
        }
    }

    private void boundbox(int n) throws ScriptException {
        boolean bl = false;
        if (this.tokAt(n) == 1) {
            bl = this.parameterAsString(n).equalsIgnoreCase("corners");
        }
        if (bl) {
            ++n;
        }
        if (this.isCenterParameter(n)) {
            this.expressionResult = null;
            Point3f point3f = this.centerParameter(n);
            n = this.iToken + 1;
            if (bl || this.isCenterParameter(n)) {
                Point3f point3f2 = bl ? this.centerParameter(n) : this.getPoint3f(n, true);
                n = this.iToken + 1;
                if (!this.isSyntaxCheck) {
                    this.viewer.setBoundBox(point3f, point3f2, bl);
                }
            } else if (this.expressionResult != null && this.expressionResult instanceof BitSet) {
                if (!this.isSyntaxCheck) {
                    this.viewer.calcBoundBoxDimensions((BitSet)this.expressionResult);
                }
            } else {
                this.error(20);
            }
            if (n == this.statementLength) {
                return;
            }
        }
        int n2 = this.getSetAxesTypeMad(n);
        if (!this.isSyntaxCheck) {
            this.viewer.setObjectMad(27, "boundbox", n2);
        }
    }

    private void unitcell(int n) throws ScriptException {
        if (this.statementLength == n + 1) {
            if (this.getToken((int)n).tok == 2 && this.intParameter(n) >= 111) {
                if (!this.isSyntaxCheck) {
                    this.viewer.setCurrentUnitCellOffset(this.intParameter(n));
                }
            } else {
                int n2 = this.getSetAxesTypeMad(n);
                if (!this.isSyntaxCheck) {
                    this.viewer.setObjectMad(28, "unitCell", n2);
                }
            }
            return;
        }
        Point3f point3f = (Point3f)this.getPointOrPlane(2, false, true, false, true, 3, 3);
        if (!this.isSyntaxCheck) {
            this.viewer.setCurrentUnitCellOffset(point3f);
        }
    }

    private void frank(int n) throws ScriptException {
        this.setBooleanProperty("frank", this.booleanParameter(n));
    }

    private void setUserColors() throws ScriptException {
        int n;
        Vector<Integer> vector = new Vector<Integer>();
        for (n = 2; n < this.statementLength; ++n) {
            int n2 = this.getArgbParam(n);
            vector.addElement(new Integer(n2));
            n = this.iToken;
        }
        if (this.isSyntaxCheck) {
            return;
        }
        n = vector.size();
        int[] nArray = new int[n];
        int n3 = n;
        while (--n3 >= 0) {
            nArray[n3] = (Integer)vector.elementAt(n3);
        }
        Viewer.setUserScale(nArray);
    }

    private void setBondmode() throws ScriptException {
        this.checkLength(3);
        boolean bl = false;
        switch (this.getToken((int)2).tok) {
            case 0x1100040: {
                break;
            }
            case 0x1100030: {
                bl = true;
                break;
            }
            default: {
                this.error(20);
            }
        }
        this.setBooleanProperty("bondModeOr", bl);
    }

    private void selectionHalo(int n) throws ScriptException {
        boolean bl = false;
        switch (n == this.statementLength ? 0x100011 : this.getToken((int)n).tok) {
            case 0x100011: 
            case 34603018: {
                bl = true;
            }
            case 0x10000F: 
            case 0x100010: 
            case 0x4000022: {
                this.setBooleanProperty("selectionHalos", bl);
                break;
            }
            default: {
                this.error(20);
            }
        }
    }

    private void setEcho() throws ScriptException {
        int n;
        String string = "target";
        Object object = null;
        boolean bl = true;
        switch (this.getToken((int)2).tok) {
            case 0x100010: {
                this.checkLength(3);
                bl = false;
                string = "allOff";
                break;
            }
            case 0x10000F: {
                bl = false;
            }
            case 0x100003: {
                this.checkLength(3);
            }
            case 1: 
            case 12289: 
            case 0x4000009: 
            case 67108889: 
            case 67108913: 
            case 67108922: {
                object = this.parameterAsString(2);
                break;
            }
            case 3149837: {
                n = this.modelNumberParameter(3);
                if (this.isSyntaxCheck) {
                    return;
                }
                if (n >= this.viewer.getModelCount()) {
                    this.error(20);
                }
                string = "model";
                object = new Integer(n);
                break;
            }
            case 4: {
                this.echo(2);
                return;
            }
            default: {
                this.error(20);
            }
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setEchoStateActive(bl);
            this.viewer.loadShape(29);
            this.setShapeProperty(29, string, object);
        }
        if (this.statementLength == 3) {
            return;
        }
        string = "align";
        if (this.statementLength == 4) {
            if (this.isCenterParameter(3)) {
                this.setShapeProperty(29, "xyz", this.centerParameter(3));
                return;
            }
            switch (this.getToken((int)3).tok) {
                case 0x100010: {
                    string = "off";
                    break;
                }
                case 3149837: {
                    n = this.modelNumberParameter(4);
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    if (n >= this.viewer.getModelCount()) {
                        this.error(20);
                    }
                    string = "model";
                    object = new Integer(n);
                    break;
                }
                case 1: 
                case 12289: 
                case 0x4000009: 
                case 67108889: 
                case 67108913: 
                case 67108922: {
                    object = this.parameterAsString(3);
                    break;
                }
                default: {
                    this.error(20);
                }
            }
            this.setShapeProperty(29, string, object);
            return;
        }
        if (this.statementLength == 5) {
            switch (this.tokAt(3)) {
                case 9441795: {
                    string = "script";
                    object = this.parameterAsString(4);
                    this.setShapeProperty(29, string, object);
                    return;
                }
                case 3149837: {
                    n = this.modelNumberParameter(4);
                    if (!this.isSyntaxCheck && n >= this.viewer.getModelCount()) {
                        this.error(20);
                    }
                    string = "model";
                    object = new Integer(n);
                    this.setShapeProperty(29, string, object);
                    return;
                }
            }
        }
        this.getToken(4);
        n = 3;
        if (this.isCenterParameter(n)) {
            if (!this.isSyntaxCheck) {
                this.setShapeProperty(29, "xyz", this.centerParameter(n));
            }
            return;
        }
        object = this.xypParameter(n);
        String string2 = "xypos";
        if (object == null) {
            int n2 = this.intParameter(n++);
            object = new Integer(n2);
            string2 = this.tokAt(n) == 17825922 ? "%xpos" : "xpos";
            this.setShapeProperty(29, string2, object);
            int n3 = ++n;
            n2 = this.intParameter(n3);
            object = new Integer(n2);
            if (this.tokAt(++n) == 17825922) {
                string2 = "%ypos";
                ++n;
            } else {
                string2 = "ypos";
            }
        }
        this.setShapeProperty(29, string2, object);
    }

    private boolean setLabel(String string) throws ScriptException {
        this.viewer.loadShape(4);
        Object object = null;
        this.setShapeProperty(4, "setDefaults", this.viewer.getNoneSelected());
        if (string.equals("scalereference")) {
            float f = this.floatParameter(2);
            if (f >= 5.0f) {
                f = this.viewer.getZoomSetting() / f / this.viewer.getScalePixelsPerAngstrom();
            }
            object = new Float(f);
        } else if (string.equals("offset")) {
            int n = this.intParameter(2, -100, 100);
            int n2 = this.intParameter(3, -100, 100);
            object = new Integer((n & 0xFF) << 8 | n2 & 0xFF);
        } else if (string.equals("alignment")) {
            switch (this.getToken((int)2).tok) {
                case 12289: 
                case 67108889: 
                case 67108913: {
                    string = "align";
                    object = this.theToken.value;
                    break;
                }
                default: {
                    this.error(20);
                    break;
                }
            }
        } else if (string.equals("pointer")) {
            int n = 0;
            switch (this.getToken((int)2).tok) {
                case 0x10000F: 
                case 0x100010: {
                    break;
                }
                case 134221828: {
                    n |= 2;
                }
                case 0x100011: {
                    n |= 1;
                    break;
                }
                default: {
                    this.error(20);
                }
            }
            object = new Integer(n);
        } else {
            boolean bl;
            if (string.equals("toggle")) {
                this.iToken = 1;
                BitSet bitSet = this.statementLength == 2 ? null : this.expression(2);
                this.checkLength(this.iToken + 1);
                if (!this.isSyntaxCheck) {
                    this.viewer.togglePickingLabel(bitSet);
                }
                return true;
            }
            this.iToken = 1;
            boolean bl2 = bl = this.statementLength == 2 || this.getToken((int)2).tok == 0x100011;
            if (string.equals("front") || string.equals("group")) {
                if (!bl && this.tokAt(2) != 0x100010) {
                    this.error(20);
                }
                if (!bl) {
                    string = "front";
                }
                object = bl ? Boolean.TRUE : Boolean.FALSE;
            } else if (string.equals("atom")) {
                if (!bl && this.tokAt(2) != 0x100010) {
                    this.error(20);
                }
                string = "front";
                object = bl ? Boolean.FALSE : Boolean.TRUE;
            } else {
                return false;
            }
        }
        BitSet bitSet = this.iToken + 1 < this.statementLength ? this.expression(++this.iToken) : null;
        this.checkLength(this.iToken + 1);
        if (this.isSyntaxCheck) {
            return true;
        }
        if (bitSet == null) {
            this.setShapeProperty(4, string, object);
        } else {
            this.viewer.setShapeProperty(4, string, object, bitSet);
        }
        return true;
    }

    private void setMonitor() throws ScriptException {
        boolean bl = false;
        this.checkLength(3);
        switch (this.tokAt(2)) {
            case 0x100011: {
                bl = true;
            }
            case 0x100010: {
                this.setShapeProperty(5, "showMeasurementNumbers", bl ? Boolean.TRUE : Boolean.FALSE);
                return;
            }
            case 1: {
                this.setMeasurementUnits(this.parameterAsString(2));
                return;
            }
        }
        this.setShapeSize(5, this.getSetAxesTypeMad(2));
    }

    private boolean setMeasurementUnits(String string) throws ScriptException {
        if (!StateManager.isMeasurementUnit(string)) {
            this.error(39, "set measurementUnits ", string);
        }
        if (!this.isSyntaxCheck) {
            this.viewer.setMeasureDistanceUnits(string);
        }
        return true;
    }

    private void setProperty() throws ScriptException {
        this.checkLength(4);
        if (this.getToken((int)2).tok != 1) {
            this.error(29);
        }
        String string = this.parameterAsString(2);
        switch (this.getToken((int)3).tok) {
            case 0x100011: {
                this.setBooleanProperty(string, true);
                break;
            }
            case 0x100010: {
                this.setBooleanProperty(string, false);
                break;
            }
            case 2: {
                this.setIntProperty(string, this.intParameter(3));
                break;
            }
            case 3: {
                this.setFloatProperty(string, this.floatParameter(3));
                break;
            }
            case 4: {
                this.setStringProperty(string, this.stringParameter(3));
                break;
            }
            default: {
                this.error(39, "SET " + string.toUpperCase(), this.parameterAsString(3));
            }
        }
    }

    private void setSpin(String string, int n) throws ScriptException {
        if (Parser.isOneOf((String)(string = string.toLowerCase()), (String)"x;y;z;fps")) {
            if (!this.isSyntaxCheck) {
                this.viewer.setSpin(string, n);
            }
            return;
        }
        this.error(39, "set SPIN ", this.parameterAsString(2));
    }

    private void setSsbond() throws ScriptException {
        this.checkLength(3);
        boolean bl = false;
        switch (this.tokAt(2)) {
            case 35131395: {
                bl = true;
                break;
            }
            case 34603020: {
                break;
            }
            default: {
                this.error(20);
            }
        }
        this.setBooleanProperty("ssbondsBackbone", bl);
    }

    private void setHbond() throws ScriptException {
        this.checkLength(3);
        boolean bl = false;
        switch (this.tokAt(2)) {
            case 35131395: {
                bl = true;
            }
            case 34603020: {
                this.setBooleanProperty("hbondsBackbone", bl);
                break;
            }
            case 67108919: {
                bl = true;
            }
            case 0x400000F: {
                this.setBooleanProperty("hbondsSolid", bl);
                break;
            }
            default: {
                this.error(20);
            }
        }
    }

    private void setPicking() throws ScriptException {
        if (this.statementLength == 2) {
            this.setStringProperty("picking", "identify");
            return;
        }
        if (this.statementLength > 4 || this.tokAt(2) == 4) {
            this.setStringProperty("picking", this.stringSetting(2, false));
            return;
        }
        int n = 2;
        String string = "SELECT";
        switch (this.getToken((int)2).tok) {
            case 9451009: 
            case 134746167: 
            case 135794723: {
                this.checkLength34();
                if (this.statementLength != 4) break;
                string = this.parameterAsString(2).toUpperCase();
                if (string.equals("SPIN")) {
                    this.setIntProperty("pickingSpinRate", this.intParameter(3));
                    break;
                }
                n = 3;
                break;
            }
            default: {
                this.checkLength(3);
            }
        }
        String string2 = this.parameterAsString(n);
        switch (this.getToken((int)n).tok) {
            case 0x100011: 
            case 0x4000022: {
                string2 = "identify";
                break;
            }
            case 0x10000F: {
                string2 = "off";
                break;
            }
            case 9451009: {
                string2 = "atom";
                break;
            }
            case 141557762: {
                string2 = "bond";
            }
        }
        if (JmolConstants.getPickingMode(string2) < 0) {
            this.error(39, "SET PICKING " + string, string2);
        }
        this.setStringProperty("picking", string2);
    }

    private void setPickingStyle() throws ScriptException {
        if (this.statementLength > 4 || this.tokAt(2) == 4) {
            this.setStringProperty("pickingStyle", this.stringSetting(2, false));
            return;
        }
        int n = 2;
        boolean bl = false;
        String string = "SELECT";
        switch (this.getToken((int)2).tok) {
            case 135794723: {
                bl = true;
                string = "MEASURE";
            }
            case 9451009: {
                this.checkLength34();
                if (this.statementLength != 4) break;
                n = 3;
                break;
            }
            default: {
                this.checkLength(3);
            }
        }
        String string2 = this.parameterAsString(n);
        switch (this.getToken((int)n).tok) {
            case 0x10000F: 
            case 0x100010: {
                string2 = bl ? "measureoff" : "toggle";
                break;
            }
            case 0x100011: {
                if (!bl) break;
                string2 = "measure";
            }
        }
        if (JmolConstants.getPickingStyle(string2) < 0) {
            this.error(39, "SET PICKINGSTYLE " + string, string2);
        }
        this.setStringProperty("pickingStyle", string2);
    }

    private void save() throws ScriptException {
        if (this.statementLength > 1) {
            String string = this.optParameterAsString(2);
            switch (this.tokAt(1)) {
                case 67108914: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveOrientation(string);
                    }
                    return;
                }
                case 67108902: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveOrientation(string);
                    }
                    return;
                }
                case 141557762: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveBonds(string);
                    }
                    return;
                }
                case 67108921: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveState(string);
                    }
                    return;
                }
                case 3149845: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveStructure(string);
                    }
                    return;
                }
                case 0x100008: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveCoordinates(string, this.viewer.getSelectionSet());
                    }
                    return;
                }
                case 1: {
                    if (!this.parameterAsString(1).equalsIgnoreCase("selection")) break;
                    if (!this.isSyntaxCheck) {
                        this.viewer.saveSelection(string);
                    }
                    return;
                }
            }
        }
        this.error(42, "SAVE", "bonds? coords? orientation? selection? state? structure?");
    }

    private void restore() throws ScriptException {
        if (this.statementLength > 1) {
            String string = this.optParameterAsString(2);
            if (this.getToken((int)1).tok != 67108902) {
                this.checkLength23();
            }
            switch (this.getToken((int)1).tok) {
                case 67108914: {
                    float f;
                    float f2 = f = this.statementLength > 3 ? this.floatParameter(3) : 0.0f;
                    if (f < 0.0f) {
                        this.error(20);
                    }
                    if (!this.isSyntaxCheck) {
                        this.viewer.restoreRotation(string, f);
                    }
                    return;
                }
                case 67108902: {
                    float f;
                    float f3 = f = this.statementLength > 3 ? this.floatParameter(3) : 0.0f;
                    if (f < 0.0f) {
                        this.error(20);
                    }
                    if (!this.isSyntaxCheck) {
                        this.viewer.restoreOrientation(string, f);
                    }
                    return;
                }
                case 141557762: {
                    if (!this.isSyntaxCheck) {
                        this.viewer.restoreBonds(string);
                    }
                    return;
                }
                case 0x100008: {
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    String string2 = this.viewer.getSavedCoordinates(string);
                    if (string2 == null) {
                        this.error(20);
                    }
                    this.runScript(string2);
                    return;
                }
                case 67108921: {
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    String string3 = this.viewer.getSavedState(string);
                    if (string3 == null) {
                        this.error(20);
                    }
                    this.runScript(string3);
                    return;
                }
                case 3149845: {
                    if (this.isSyntaxCheck) {
                        return;
                    }
                    String string4 = this.viewer.getSavedStructure(string);
                    if (string4 == null) {
                        this.error(20);
                    }
                    this.runScript(string4);
                    return;
                }
                case 1: {
                    if (!this.parameterAsString(1).equalsIgnoreCase("selection")) break;
                    if (!this.isSyntaxCheck) {
                        this.viewer.restoreSelection(string);
                    }
                    return;
                }
            }
        }
        this.error(42, "RESTORE", "bonds? coords? orientation? selection? state? structure?");
    }

    String write(Token[] tokenArray) throws ScriptException {
        boolean bl;
        Object object;
        int n = 0;
        boolean bl2 = this.viewer.isApplet();
        boolean bl3 = false;
        String string = this.viewer.getExportDriverList();
        if (tokenArray == null) {
            tokenArray = this.statement;
            bl3 = true;
            ++n;
        }
        int n2 = tokenArray.length;
        int n3 = bl3 && tokenArray.length == 1 ? 0x400000B : this.tokAt(n, tokenArray);
        int n4 = 0;
        int n5 = -1;
        int n6 = -1;
        String string2 = "SPT";
        String string3 = "";
        String string4 = "";
        String string5 = null;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        int n7 = Integer.MIN_VALUE;
        if (n3 == 4 && (object = Token.getTokenFromName(Token.sValue(tokenArray[n]))) != null) {
            n3 = ((Token)object).tok;
        }
        switch (n3) {
            case 67109275: {
                string2 = "PGRP";
                ++n;
                break;
            }
            case 9443332: {
                boolean bl7;
                string4 = Token.sValue(this.tokenAt(++n, tokenArray)).toLowerCase();
                if (Parser.isOneOf((String)string4, (String)"w;x;y;z;a;r")) {
                    ++n;
                } else {
                    string4 = "w";
                }
                string2 = Token.sValue(this.tokenAt(n, tokenArray)).toLowerCase();
                boolean bl8 = bl7 = string2.indexOf("deriv") == 0 || string2.indexOf("diff") == 0;
                if (bl7 || string4.equals("a") || string4.equals("r")) {
                    string4 = string4 + " difference" + (string2.indexOf("2") >= 0 ? "2" : "");
                    if (bl7) {
                        string2 = Token.sValue(this.tokenAt(++n, tokenArray)).toLowerCase();
                    }
                }
                if (string2.equals("draw")) {
                    string4 = string4 + " draw";
                    ++n;
                }
                string4 = "quaternion " + string4;
                string2 = "QUAT";
                break;
            }
            case 1052714: {
                string4 = Token.sValue(this.tokenAt(++n, tokenArray)).toLowerCase();
                if (Parser.isOneOf((String)string4, (String)"r")) {
                    ++n;
                } else {
                    string4 = "";
                }
                string2 = Token.sValue(this.tokenAt(n, tokenArray)).toLowerCase();
                if (string2.equals("draw")) {
                    string4 = string4 + " draw";
                    ++n;
                }
                string4 = "ramachandran " + string4;
                string2 = "RAMA";
                break;
            }
            case 9670657: {
                string2 = "FUNCS";
                ++n;
                break;
            }
            case 0x100008: 
            case 9442306: {
                string2 = Token.sValue(this.tokenAt(++n, tokenArray)).toLowerCase();
                string2 = "data";
                bl4 = true;
                break;
            }
            case 9441795: 
            case 67108921: {
                ++n;
                break;
            }
            case 4130: {
                string2 = "MO";
                ++n;
                break;
            }
            case 4125: {
                string2 = "ISO";
                ++n;
                break;
            }
            case 134221850: {
                string2 = "HIS";
                ++n;
                break;
            }
            case 134385668: {
                n += 2;
                string2 = "VAR";
                break;
            }
            case 3149832: {
                string2 = "FILE";
                ++n;
                break;
            }
            case 1: 
            case 4: {
                string2 = Token.sValue(this.tokenAt(n, tokenArray)).toLowerCase();
                if (string2.equals("image")) {
                    if (this.tokAt(++n, tokenArray) != 2) break;
                    n5 = Token.iValue(this.tokenAt(n++, tokenArray));
                    n6 = Token.iValue(this.tokenAt(n++, tokenArray));
                    break;
                }
                if (Parser.isOneOf((String)string2, (String)string.toLowerCase())) {
                    string2 = string2.substring(0, 1).toUpperCase() + string2.substring(1);
                    bl6 = true;
                    string5 = "Jmol." + string2;
                    if (this.tokAt(++n, tokenArray) != 2) break;
                    n5 = Token.iValue(this.tokenAt(n++, tokenArray));
                    n6 = Token.iValue(this.tokenAt(n++, tokenArray));
                    break;
                }
                string2 = "(image)";
            }
        }
        object = Token.sValue(this.tokenAt(n, tokenArray));
        if (((String)object).equalsIgnoreCase("clipboard")) {
            if (this.isSyntaxCheck) {
                return "";
            }
        } else if (Parser.isOneOf((String)((String)object).toLowerCase(), (String)"png;jpg;jpeg;jpg64") && this.tokAt(n + 1, tokenArray) == 2) {
            n7 = Token.iValue(this.tokenAt(++n, tokenArray));
        } else if (Parser.isOneOf((String)((String)object).toLowerCase(), (String)"xyz;mol;pdb")) {
            string2 = ((String)object).toUpperCase();
            if (n + 1 == n2) {
                ++n;
            }
        }
        if (string2.equals("(image)") && Parser.isOneOf((String)((String)object).toUpperCase(), (String)"JPG;JPG64;JPEG;JPEG64;PNG;PPM")) {
            string2 = ((String)object).toUpperCase();
            ++n;
        }
        if (n + 2 == n2 && (string3 = Token.sValue(this.tokenAt(++n, tokenArray))).charAt(0) != '.') {
            string2 = ((String)object).toUpperCase();
        }
        switch (this.tokAt(n, tokenArray)) {
            case 0: {
                bl5 = true;
                break;
            }
            case 1: 
            case 4: {
                string5 = Token.sValue(this.tokenAt(n, tokenArray));
                if (n == n2 - 3 && this.tokAt(n + 1, tokenArray) == 0x10000A) {
                    string5 = string5 + "." + Token.sValue(this.tokenAt(n + 2, tokenArray));
                }
                if (string2 != "VAR" && n == 1) {
                    string2 = "image";
                } else if (string5.length() > 0 && string5.charAt(0) == '.' && (n == 2 || n == 3)) {
                    string5 = Token.sValue(this.tokenAt(n - 1, tokenArray)) + string5;
                    if (string2 != "VAR" && n == 2) {
                        string2 = "image";
                    }
                }
                if (!string5.equalsIgnoreCase("clipboard")) break;
                string5 = null;
                break;
            }
            case 0x400000B: {
                break;
            }
            default: {
                this.error(20);
            }
        }
        if (string2.equals("image")) {
            string2 = string5 != null && string5.indexOf(".") >= 0 ? string5.substring(string5.lastIndexOf(".") + 1).toUpperCase() : "JPG";
        }
        if (string2.equals("data")) {
            string2 = string5 != null && string5.indexOf(".") >= 0 ? string5.substring(string5.lastIndexOf(".") + 1).toUpperCase() : "XYZ";
        }
        if ((bl = Parser.isOneOf((String)string2, (String)"JPEG;JPG64;JPG;PPM;PNG")) && (bl2 || bl5)) {
            string2 = "JPG64";
        }
        if (!(bl || bl6 || Parser.isOneOf((String)string2, (String)"SPT;HIS;MO;ISO;VAR;FILE;XYZ;MOL;PDB;PGRP;QUAT;RAMA;FUNCS;"))) {
            this.evalError(GT._((String)"write what? {0} or {1} \"filename\"", (Object[])new Object[]{"COORDS|FILE|FUNCTIONS|HISTORY|IMAGE|ISOSURFACE|MO|POINTGROUP|QUATERNION [w,x,y,z] [derivative]|RAMACHANDRAN|STATE|VAR x  CLIPBOARD", "JPG|JPG64|PNG|PPM|SPT|JVXL|XYZ|MOL|PDB|" + string.toUpperCase().replace(';', '|')}));
        }
        if (this.isSyntaxCheck) {
            return "";
        }
        string3 = string2.intern();
        Object object2 = null;
        if (bl6) {
            boolean bl9 = string2.equals("Povray");
            string3 = this.viewer.generateOutput(string3, bl9 ? string5 : null, n5, n6);
            if (bl9) {
                string3 = TextFormat.simpleReplace((String)string3, (String)"%FILETYPE%", (String)"N");
                string3 = TextFormat.simpleReplace((String)string3, (String)"%OUTPUTFILENAME%", (String)(string5 + ".png"));
                if (!bl3) {
                    return string3;
                }
                this.viewer.createImage(string5 + ".ini", string3, Integer.MIN_VALUE, 0, 0);
                this.scriptStatus("Created " + string5 + ".ini:\n\n" + string3);
                return "";
            }
        } else if (string3 == "PGRP") {
            string3 = this.viewer.getPointGroupDraw(this.viewer.getCurrentModelIndex());
        } else if (string3 == "PDB") {
            string3 = this.viewer.getPdbData(null);
        } else if (string3 == "XYZ" || string3 == "MOL") {
            string3 = this.viewer.getData("selected", string3);
        } else if (string3 == "QUAT" || string3 == "RAMA") {
            int n8 = this.viewer.getCurrentModelIndex();
            if (n8 < 0) {
                this.error(23, "write " + string4);
            }
            string3 = this.viewer.getPdbData(n8, string4);
        } else if (string3 == "FUNCS") {
            string3 = this.getFunctionCalls("");
        } else if (string3 == "FILE") {
            if (bl5) {
                string3 = this.viewer.getCurrentFileAsString();
            } else {
                object2 = this.viewer.getCurrentFileAsBytes();
            }
            n7 = Integer.MIN_VALUE;
        } else if (string3 == "VAR") {
            string3 = "" + this.getParameter(Token.sValue(this.tokenAt(bl3 ? 2 : 1, tokenArray)), false);
        } else if (string3 == "SPT") {
            if (bl4) {
                BitSet bitSet = this.viewer.getTaintedAtoms((byte)0);
                this.viewer.setAtomCoordRelative(new Point3f(0.0f, 0.0f, 0.0f));
                string3 = (String)this.viewer.getProperty("string", "stateInfo", null);
                this.viewer.setTaintedAtoms(bitSet, (byte)0);
            } else {
                string3 = (String)this.viewer.getProperty("string", "stateInfo", null);
            }
        } else if (string3 == "HIS") {
            string3 = this.viewer.getSetHistory(Integer.MAX_VALUE);
        } else if (string3 == "MO") {
            string3 = this.getMoJvxl(Integer.MAX_VALUE);
        } else if (string3 == "ISO") {
            string3 = this.getIsosurfaceJvxl();
            if (string3 == null) {
                this.evalError(GT._((String)"No data available"));
            }
        } else {
            n4 = -1;
            if (string3 == "PNG") {
                if (n7 == Integer.MIN_VALUE) {
                    n7 = 2;
                } else if (n7 < 0 || n7 > 9) {
                    n7 = 0;
                }
            } else if (n7 <= 0) {
                n7 = 75;
            }
        }
        if (string3 == null) {
            string3 = "";
        }
        if (n4 == 0) {
            int n9 = object2 == null ? string3.length() : (n4 = object2 instanceof String ? ((String)object2).length() : ((byte[])object2).length);
        }
        if (bl) {
            this.refresh();
            if (n5 < 0) {
                n5 = this.viewer.getScreenWidth();
            }
            if (n6 < 0) {
                n6 = this.viewer.getScreenHeight();
            }
        }
        if (!bl3) {
            return string3;
        }
        if (bl5) {
            this.showString(string3);
        } else if (object2 != null && object2 instanceof String) {
            this.scriptStatus((String)object2);
        } else {
            if (object2 == null) {
                object2 = string3;
            }
            this.viewer.createImage(string5, object2, n7, n5, n6);
            this.scriptStatus("type=" + string2 + "; file=" + (string5 == null ? "CLIPBOARD" : string5) + (n4 >= 0 ? "; length=" + n4 : "") + (bl ? "; width=" + n5 + "; height=" + n6 : "") + (n7 >= 0 ? "; quality=" + n7 : ""));
        }
        return "";
    }

    private void print() throws ScriptException {
        if (this.statementLength == 1) {
            this.error(1);
        }
        String string = (String)this.parameterExpression(1, 0, "", false);
        if (!this.isSyntaxCheck) {
            this.showString(string);
        }
    }

    private void returnCmd() throws ScriptException {
        Vector vector;
        Token token = this.getContextVariableAsToken("_retval");
        if (token == null) {
            if (!this.isSyntaxCheck) {
                this.interruptExecution = Boolean.TRUE;
            }
            return;
        }
        Vector vector2 = vector = this.statementLength == 1 ? null : (Vector)this.parameterExpression(1, 0, null, true);
        if (this.isSyntaxCheck) {
            return;
        }
        Token token2 = vector == null || vector.size() == 0 ? Token.intToken(0) : (Token)vector.get(0);
        token.value = token2.value;
        token.intValue = token2.intValue;
        token.tok = token2.tok;
        this.pcEnd = this.pc;
    }

    private void show() throws ScriptException {
        String string = null;
        String string2 = this.parameterAsString(1);
        String string3 = null;
        this.checkLength(-3);
        int n = 2;
        if (this.statementLength == 2 && string2.indexOf("?") >= 0) {
            this.showString(this.viewer.getAllSettings(string2.substring(0, string2.indexOf("?"))));
            return;
        }
        int n2 = this.getToken((int)1).tok;
        block0 : switch (n2) {
            case 3146007: {
                if (this.statementLength == 2) {
                    if (!this.isSyntaxCheck) {
                        this.showString(this.viewer.getDefaultVdw(-1));
                    }
                    return;
                }
                int n3 = JmolConstants.getVdwType(this.parameterAsString(2));
                if (n3 < 0) {
                    this.error(20);
                }
                if (!this.isSyntaxCheck) {
                    this.showString(this.viewer.getDefaultVdw(n3));
                }
                return;
            }
            case 9670657: {
                this.checkLength23();
                if (!this.isSyntaxCheck) {
                    this.showString(this.getFunctionCalls(this.optParameterAsString(2)));
                }
                return;
            }
            case 36867: {
                this.checkLength(2);
                if (!this.isSyntaxCheck) {
                    this.showString(this.viewer.getAllSettings(null));
                }
                return;
            }
            case 0x4000040: {
                n = this.statementLength;
                if (n == 2) {
                    if (!this.isSyntaxCheck) {
                        this.viewer.showUrl(this.getFullPathName());
                    }
                    return;
                }
                String string4 = this.parameterAsString(2);
                if (!this.isSyntaxCheck) {
                    this.viewer.showUrl(string4);
                }
                return;
            }
            case 0x800000A: 
            case 141562115: {
                string2 = "defaultColorScheme";
                break;
            }
            case 0x800000B: {
                string2 = "scaleAngstromsPerInch";
                break;
            }
            case 1052714: 
            case 9443332: {
                if (this.isSyntaxCheck) {
                    return;
                }
                int n4 = this.viewer.getCurrentModelIndex();
                if (n4 < 0) {
                    this.error(23, "show " + this.theToken.value);
                }
                string3 = this.viewer.getPdbData(n4, this.theTok == 9443332 ? "quaternion w" : "ramachandran");
                break;
            }
            case 1: {
                if (string2.equalsIgnoreCase("historyLevel")) {
                    string = "" + this.commandHistoryLevelMax;
                    break;
                }
                if (string2.equalsIgnoreCase("defaultLattice")) {
                    string = Escape.escape((Tuple3f)this.viewer.getDefaultLattice());
                    break;
                }
                if (string2.equalsIgnoreCase("logLevel")) {
                    string = "" + Viewer.getLogLevel();
                    break;
                }
                if (string2.equalsIgnoreCase("fileHeader")) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getPDBHeader();
                    break;
                }
                if (string2.equalsIgnoreCase("debugScript")) {
                    string = "" + this.viewer.getDebugScript();
                    break;
                }
                if (string2.equalsIgnoreCase("colorScheme")) {
                    String string5 = this.optParameterAsString(2);
                    if (string5.length() > 0) {
                        n = 3;
                    }
                    if (this.isSyntaxCheck) break;
                    string = this.viewer.getColorSchemeList(string5, true);
                    break;
                }
                if (string2.equalsIgnoreCase("menu")) {
                    if (this.isSyntaxCheck) break;
                    string = this.viewer.getMenu("");
                    break;
                }
                if (string2.equalsIgnoreCase("strandCount")) {
                    string3 = "set strandCountForStrands " + this.viewer.getStrandCount(10) + "; set strandCountForMeshRibbon " + this.viewer.getStrandCount(11);
                    break;
                }
                if (!string2.equalsIgnoreCase("trajectory") && !string2.equalsIgnoreCase("trajectories")) break;
                string3 = this.viewer.getTrajectoryInfo();
                break;
            }
            case 4129: {
                string3 = this.viewer.getMinimizationInfo();
                break;
            }
            case 134746114: {
                switch (this.viewer.getAxesMode()) {
                    case 2: {
                        string3 = "set axesUnitcell";
                        break block0;
                    }
                    case 0: {
                        string3 = "set axesWindow";
                        break block0;
                    }
                }
                string3 = "set axesMolecular";
                break;
            }
            case 0x8000002: {
                string3 = "set bondMode " + (this.viewer.getBondSelectionModeOr() ? "OR" : "AND");
                break;
            }
            case 134746171: {
                string3 = "set strandCountForStrands " + this.viewer.getStrandCount(10) + "; set strandCountForMeshRibbon " + this.viewer.getStrandCount(11);
                break;
            }
            case 135794713: {
                string3 = "set hbondsBackbone " + this.viewer.getHbondsBackbone() + ";set hbondsSolid " + this.viewer.getHbondsSolid();
                break;
            }
            case 134746167: {
                string3 = this.viewer.getSpinState();
                break;
            }
            case 134746168: {
                string3 = "set ssbondsBackbone " + this.viewer.getSsbondsBackbone();
                break;
            }
            case 134230020: 
            case 134746163: {
                string3 = "selectionHalos " + (this.viewer.getSelectionHaloEnabled() ? "ON" : "OFF");
                break;
            }
            case 168820739: {
                string3 = "set selectHetero " + this.viewer.getRasmolHeteroSetting();
                break;
            }
            case 168820740: {
                string3 = "set selectHydrogens " + this.viewer.getRasmolHydrogenSetting();
                break;
            }
            case 0x8000001: 
            case 0x8000005: 
            case 0x8000007: 
            case 0x8000008: 
            case 0x800000C: {
                string3 = this.viewer.getSpecularState();
                break;
            }
            case 4146: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.listSavedStates();
                break;
            }
            case 169349184: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getUnitCellInfoText();
                break;
            }
            case 0x100008: {
                n = this.statementLength;
                if (n == 2) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getCoordinateState(this.viewer.getSelectionSet());
                    break;
                }
                String string6 = this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSavedCoordinates(string6);
                break;
            }
            case 67108921: {
                n = this.statementLength;
                if (n == 2) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getStateInfo();
                    break;
                }
                String string7 = this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSavedState(string7);
                break;
            }
            case 3149845: {
                n = this.statementLength;
                if (n == 2) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getProteinStructureState();
                    break;
                }
                String string8 = this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSavedStructure(string8);
                break;
            }
            case 9442306: {
                String string9;
                n = this.statementLength;
                String string10 = string9 = n == 3 ? this.parameterAsString(2) : null;
                if (this.isSyntaxCheck) break;
                Object[] objectArray = string9 == null ? this.data : this.viewer.getData(string9);
                string3 = (objectArray == null ? "no data" : "data \"" + objectArray[0] + "\"\n" + (objectArray[1] instanceof float[] ? Escape.escape((float[])((float[])objectArray[1])) : (objectArray[1] instanceof float[][] ? Escape.escape((float[][])((float[][])objectArray[1]), (boolean)false) : "" + objectArray[1]))) + "\nend \"" + objectArray[0] + "\";";
                break;
            }
            case 67108920: {
                n = this.statementLength;
                if (n == 2) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getSpaceGroupInfoText(null);
                    break;
                }
                String string11 = this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSpaceGroupInfoText(TextFormat.simpleReplace((String)string11, (String)"''", (String)"\""));
                break;
            }
            case 0x100009: {
                n = 3;
                int n5 = this.setShapeByNameParameter(2);
                if (this.isSyntaxCheck) break;
                if (n5 == 22) {
                    string3 = this.getIsosurfaceJvxl();
                    break;
                }
                string3 = (String)this.viewer.getShapeProperty(n5, "command");
                break;
            }
            case 142086157: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getBoundBoxCommand(true);
                break;
            }
            case 12289: {
                if (this.isSyntaxCheck) break;
                string3 = "center " + Escape.escape((Tuple3f)this.viewer.getRotationCenter());
                break;
            }
            case 4112: {
                if (this.isSyntaxCheck) break;
                string3 = (String)this.viewer.getShapeProperty(21, "command");
                break;
            }
            case 3149832: {
                if (this.statementLength == 2) {
                    if (this.isSyntaxCheck) break;
                    string3 = this.viewer.getCurrentFileAsString();
                    break;
                }
                n = 3;
                string = this.parameterAsString(2);
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getFileAsString(string);
                break;
            }
            case 4116: {
                if (this.tokAt(2) == 0x100003) {
                    n = 3;
                    if (3 > 0) {
                        string3 = this.viewer.getModelFileInfoAll();
                        break;
                    }
                }
                string3 = this.viewer.getModelFileInfo();
                break;
            }
            case 134221850: {
                int n6;
                n = this.statementLength;
                int n7 = n6 = n == 2 ? Integer.MAX_VALUE : this.intParameter(2);
                if (n6 < 1) {
                    this.error(20);
                }
                if (this.isSyntaxCheck) break;
                this.viewer.removeCommand();
                string3 = this.viewer.getSetHistory(n6);
                break;
            }
            case 4125: {
                if (this.isSyntaxCheck) break;
                string3 = (String)this.viewer.getShapeProperty(22, "jvxlFileData");
                break;
            }
            case 4130: {
                int n8;
                n = this.statementLength;
                int n9 = n8 = n == 2 ? Integer.MAX_VALUE : this.intParameter(2);
                if (this.isSyntaxCheck) break;
                string3 = this.getMoJvxl(n8);
                break;
            }
            case 3149837: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getModelInfoAsString();
                break;
            }
            case 135794723: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getMeasurementInfoAsString();
                break;
            }
            case 4133: 
            case 67108914: 
            case 67108925: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getOrientationText(n2);
                break;
            }
            case 67108902: {
                if (!this.isSyntaxCheck) {
                    string3 = this.viewer.getOrientationText(this.tokAt(2));
                }
                n = this.statementLength == 3 ? 3 : 2;
                break;
            }
            case 67108903: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getPDBHeader();
                break;
            }
            case 34603034: {
                if (this.isSyntaxCheck) break;
                string3 = this.viewer.getSymmetryInfoAsString();
                break;
            }
            case 67108924: {
                if (this.isSyntaxCheck) break;
                string3 = "transform:\n" + this.viewer.getTransformText();
                break;
            }
            case 4164: {
                string3 = "zoom " + (this.viewer.getZoomEnabled() ? "" + this.viewer.getZoomSetting() : "off");
                break;
            }
            case 134746133: {
                string3 = this.viewer.getShowFrank() ? "frank ON" : "frank OFF";
                break;
            }
            case 137363473: {
                string2 = "solventProbeRadius";
                break;
            }
            case 0x100006: 
            case 0x10000B: 
            case 0x100014: 
            case 0x700001: 
            case 34603018: 
            case 67108910: 
            case 67108985: 
            case 141557762: {
                string3 = this.viewer.getChimeInfo(n2);
                break;
            }
            case 20482: 
            case 0x8000003: 
            case 134238209: 
            case 141558028: 
            case 168820747: {
                string = "?";
            }
        }
        this.checkLength(n);
        if (this.isSyntaxCheck) {
            return;
        }
        if (string3 != null) {
            this.showString(string3);
        } else if (string != null) {
            this.showString(string2 + " = " + string);
        } else if (string2 != null) {
            this.showString(string2 + " = " + this.getParameterEscaped(string2));
        }
    }

    private void showString(String string) {
        if (this.isSyntaxCheck) {
            return;
        }
        if (this.outputBuffer != null) {
            this.outputBuffer.append(string).append('\n');
        } else {
            this.viewer.showString(string);
        }
    }

    private String getFunctionCalls(String string) {
        boolean bl;
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.indexOf("*");
        boolean bl2 = n >= 0;
        boolean bl3 = bl = string.indexOf("_") == 0;
        if (bl2) {
            string = string.substring(0, n);
        }
        string = string.toLowerCase();
        Hashtable hashtable = bl ? this.compiler.localFunctions : Compiler.globalFunctions;
        Object[] objectArray = new String[hashtable.size()];
        Enumeration enumeration = hashtable.keys();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string.length() != 0 && !string2.equalsIgnoreCase(string) && (!bl2 || string2.toLowerCase().indexOf(string) != 0)) continue;
            objectArray[n2++] = string2;
        }
        Arrays.sort(objectArray, 0, n2);
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(((Function)hashtable.get(objectArray[i])).toString());
        }
        return stringBuffer.toString();
    }

    private String getIsosurfaceJvxl() {
        if (this.isSyntaxCheck) {
            return "";
        }
        return (String)this.viewer.getShapeProperty(22, "jvxlFileData");
    }

    private String getMoJvxl(int n) throws ScriptException {
        Hashtable hashtable;
        this.viewer.loadShape(24);
        int n2 = this.viewer.getDisplayModelIndex();
        if (n2 < 0) {
            this.error(23, "MO isosurfaces");
        }
        if ((hashtable = (Hashtable)this.viewer.getModelAuxiliaryInfo(n2, "moData")) == null) {
            this.evalError(GT._((String)"no MO basis/coefficient data available for this frame"));
        }
        this.setShapeProperty(24, "moData", hashtable);
        return (String)this.viewer.getShapeProperty(24, "showMO", n);
    }

    /*
     * Unable to fully structure code
     */
    private void pmesh() throws ScriptException {
        this.viewer.loadShape(25);
        if (this.tokAt(1) == 6 && this.listIsosurface(25)) {
            return;
        }
        var2_1 = false;
        var3_2 = false;
        var4_3 = null;
        this.initIsosurface(25);
        block9: for (var5_4 = this.iToken; var5_4 < this.statementLength; ++var5_4) {
            var6_7 = null;
            var7_8 = null;
            var8_9 = this.getToken((int)var5_4).tok;
            if (var5_4 == 1 && this.tokAt(2) == 0x1100081) {
                var8_9 = 0;
            }
            switch (var8_9) {
                case 0: {
                    var6_7 = "thisID";
                    var7_8 = this.parameterAsString(var5_4) + this.getToken((int)(++var5_4)).value;
                    break;
                }
                case 1: {
                    var9_10 = this.parameterAsString(var5_4);
                    if (var9_10.equalsIgnoreCase("id")) {
                        this.setShapeId(25, ++var5_4, var2_1);
                        break;
                    }
                    if (var9_10.equalsIgnoreCase("FIXED")) {
                        var6_7 = "fixed";
                        var7_8 = Boolean.TRUE;
                        break;
                    }
                    if (var9_10.equalsIgnoreCase("BINARY")) {
                        var3_2 = true;
                        continue block9;
                    }
                    if (var9_10.equalsIgnoreCase("MODELBASED")) {
                        var6_7 = "fixed";
                        var7_8 = Boolean.FALSE;
                        break;
                    }
                    var5_4 = this.setShapeId(25, var5_4, var2_1);
                    break;
                }
                case 3149837: {
                    var10_11 = this.modelNumberParameter(++var5_4);
                    if (var10_11 < 0) {
                        var6_7 = "fixed";
                        var7_8 = Boolean.TRUE;
                        break;
                    }
                    var6_7 = "modelIndex";
                    var7_8 = new Integer(var10_11);
                    break;
                }
                case 141562115: {
                    var4_3 = this.setColorOptions(var5_4 + 1, 25, -1);
                    var5_4 = this.iToken;
                    var2_1 = true;
                    continue block9;
                }
                case 4: {
                    var11_12 = this.stringParameter(var5_4);
                    var6_7 = "fileData";
                    if (!var11_12.equalsIgnoreCase("inline")) ** GOTO lbl68
                    if (var5_4 + 1 < this.statementLength && this.tokAt(var5_4 + 1) == 4) {
                        if ((var12_13 = this.parameterAsString(++var5_4)).indexOf("|") < 0 && var12_13.indexOf("\n") < 0) {
                            var12_13 = var12_13.replace(' ', '\n');
                            var6_7 = "bufferedReaderOnePerLine";
                        }
                        var12_13 = var12_13.replace('{', ' ').replace(',', ' ').replace('}', ' ').replace('|', '\n');
                        var12_13 = TextFormat.simpleReplace((String)var12_13, (String)"\n\n", (String)"\n");
                        if (this.logMessages) {
                            Logger.debug((String)("pmesh inline data:\n" + (String)var12_13));
                        }
                        var1_6 = this.viewer.getBufferedReaderForString((String)var12_13);
                    } else {
                        this.error(32);
                        break;
lbl68:
                        // 1 sources

                        if (this.isSyntaxCheck) {
                            return;
                        }
                        if (this.thisCommand.indexOf("# FILE0=") >= 0) {
                            var11_12 = this.extractCommandOption("# FILE0");
                        }
                        if ((var1_6 = this.viewer.getBufferedReaderOrErrorMessageFromName(var11_12, (String[])(var12_13 = new String[1]), var3_2)) instanceof BufferedReader) {
                            var13_14 = (BufferedReader)var1_6;
                            try {
                                var13_14.mark(4);
                                var14_15 = new char[4];
                                var13_14.read(var14_15);
                                if (((Boolean)this.viewer.getShapeProperty(25, "checkMagicNumber:" + new String(var14_15))).booleanValue()) {
                                    var13_14.close();
                                    var1_6 = this.viewer.getBufferedReaderOrErrorMessageFromName(var11_12, (String[])var12_13, true);
                                } else {
                                    var13_14.reset();
                                }
                            }
                            catch (Exception var14_16) {
                                // empty catch block
                            }
                        }
                        if (var1_6 instanceof String) {
                            this.error(15, var11_12 + ":" + var1_6);
                        }
                        this.setShapeProperty(25, "commandOption", "FILE0=" + Escape.escape((String)var12_13[0]));
                        Logger.info((String)("reading pmesh data from " + (String)var12_13[0]));
                    }
                    var7_8 = var1_6;
                    break;
                }
                default: {
                    if (!this.setMeshDisplayProperty(25, var5_4, this.theTok)) {
                        this.error(20);
                    }
                    var5_4 = this.iToken;
                }
            }
            v0 = var2_1 = this.theTok != 12291;
            if (var6_7 == null) continue;
            this.setShapeProperty(25, var6_7, var7_8);
        }
        if (!this.isSyntaxCheck && (var5_5 = (String)this.viewer.getShapeProperty(25, "pmeshError")) != null) {
            this.evalError(var5_5);
        }
        if (var4_3 != null) {
            this.setShapeProperty(25, "translucency", var4_3);
        }
    }

    private String extractCommandOption(String string) {
        int n = this.fullCommand.indexOf(string + "=");
        return n < 0 ? null : Parser.getNextQuotedString((String)this.fullCommand, (int)n);
    }

    private void draw() throws ScriptException {
        this.viewer.loadShape(21);
        switch (this.tokAt(1)) {
            case 6: {
                if (!this.listIsosurface(21)) break;
                return;
            }
            case 67109275: {
                this.calculate();
                return;
            }
            case 9443332: {
                this.dataFrame(1);
                return;
            }
            case 1052714: {
                this.dataFrame(0);
                return;
            }
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        float f = Float.MAX_VALUE;
        int n = Integer.MIN_VALUE;
        int n2 = 0;
        boolean bl5 = false;
        int n3 = 0;
        this.initIsosurface(21);
        block29: for (int i = this.iToken; i < this.statementLength; ++i) {
            String string = null;
            Object object = null;
            int n4 = this.getToken((int)i).tok;
            if (i == 1 && this.tokAt(2) == 0x1100081) {
                n4 = 0;
            }
            switch (n4) {
                case 0: {
                    string = "thisID";
                    object = this.parameterAsString(i) + this.getToken((int)(++i)).value;
                    break;
                }
                case 7: 
                case 8: 
                case 0x10000E: {
                    if (n4 == 8 || !this.isPoint3f(i)) {
                        object = this.getPoint4f(i);
                        string = "planedef";
                    } else {
                        object = this.getPoint3f(i, true);
                        string = "coord";
                    }
                    i = this.iToken;
                    bl = true;
                    break;
                }
                case 9439234: {
                    if (bl) {
                        object = this.planeParameter(++i);
                        i = this.iToken;
                        string = "planedef";
                        break;
                    }
                    string = "plane";
                    break;
                }
                case 0x100001: 
                case 0x4000007: {
                    string = "atomSet";
                    object = this.expression(i);
                    i = this.iToken;
                    bl = true;
                    break;
                }
                case 6: {
                    string = "modelBasedPoints";
                    object = this.theToken.value;
                    bl = true;
                    break;
                }
                case 0x1100010: {
                    break;
                }
                case 0x1100020: {
                    object = this.xypParameter(i);
                    if (object != null) {
                        i = this.iToken;
                        string = "coord";
                        bl = true;
                        break;
                    }
                }
                case 0x1100021: {
                    bl3 = !bl3;
                    if (bl3 != (this.theTok == 0x1100021)) break;
                    this.error(20);
                    break;
                }
                case 4: {
                    object = this.stringParameter(i);
                    string = "title";
                    break;
                }
                case 4161: {
                    string = "vector";
                    break;
                }
                case 0x700005: {
                    object = new Float(this.floatParameter(++i));
                    string = "length";
                    break;
                }
                case 3: {
                    object = new Float(this.floatParameter(i));
                    string = "length";
                    break;
                }
                case 2: {
                    if (bl3) {
                        string = "modelIndex";
                        object = new Integer(this.intParameter(i));
                        break;
                    }
                    n2 = this.intParameter(i);
                    break;
                }
                case 1: {
                    String string2 = this.parameterAsString(i);
                    if (string2.equalsIgnoreCase("id")) {
                        this.setShapeId(21, ++i, bl5);
                        break;
                    }
                    if (string2.equalsIgnoreCase("FIXED")) {
                        string = "fixed";
                        object = Boolean.TRUE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("MODELBASED")) {
                        string = "fixed";
                        object = Boolean.FALSE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("CROSSED")) {
                        string = "crossed";
                        break;
                    }
                    if (string2.equalsIgnoreCase("CURVE")) {
                        string = "curve";
                        break;
                    }
                    if (string2.equalsIgnoreCase("ARROW")) {
                        string = "arrow";
                        break;
                    }
                    if (string2.equalsIgnoreCase("ARC")) {
                        string = "arc";
                        break;
                    }
                    if (string2.equalsIgnoreCase("CIRCLE")) {
                        string = "circle";
                        break;
                    }
                    if (string2.equalsIgnoreCase("CYLINDER")) {
                        string = "cylinder";
                        break;
                    }
                    if (string2.equalsIgnoreCase("VERTICES")) {
                        string = "vertices";
                        break;
                    }
                    if (string2.equalsIgnoreCase("REVERSE")) {
                        string = "reverse";
                        break;
                    }
                    if (string2.equalsIgnoreCase("NOHEAD")) {
                        string = "nohead";
                        break;
                    }
                    if (string2.equalsIgnoreCase("ROTATE45")) {
                        string = "rotate45";
                        break;
                    }
                    if (string2.equalsIgnoreCase("PERP") || string2.equalsIgnoreCase("PERPENDICULAR")) {
                        string = "perp";
                        break;
                    }
                    if (string2.equalsIgnoreCase("OFFSET")) {
                        Point3f point3f = this.getPoint3f(++i, true);
                        i = this.iToken;
                        string = "offset";
                        object = point3f;
                        break;
                    }
                    if (string2.equalsIgnoreCase("SCALE")) {
                        if (++i >= this.statementLength) {
                            this.error(25);
                        }
                        switch (this.getToken((int)i).tok) {
                            case 2: {
                                n2 = this.intParameter(i);
                                continue block29;
                            }
                            case 3: {
                                n2 = (int)(this.floatParameter(i) * 100.0f);
                                continue block29;
                            }
                            default: {
                                this.error(25);
                            }
                        }
                    }
                    if (string2.equalsIgnoreCase("DIAMETER")) {
                        object = new Float(this.floatParameter(++i));
                        string = this.tokAt(i) == 3 ? "width" : "diameter";
                        break;
                    }
                    if (string2.equalsIgnoreCase("WIDTH")) {
                        object = new Float(this.floatParameter(++i));
                        string = "width";
                        break;
                    }
                    this.setShapeId(21, i, bl5);
                    break;
                }
                case 0x100009: {
                    if (this.tokAt(i + 2) == 0x1100020) {
                        Point3f point3f = this.centerParameter(i);
                        i = this.iToken;
                        string = "coord";
                        object = point3f;
                        bl = true;
                        break;
                    }
                    object = this.objectNameParameter(++i);
                    string = "identifier";
                    bl = true;
                    break;
                }
                case 141562115: {
                    ++i;
                }
                case 67108901: 
                case 67108926: {
                    bl4 = false;
                    boolean bl6 = false;
                    if (this.tokAt(i) == 67108926) {
                        bl4 = true;
                        if (this.isFloatParameter(++i)) {
                            f = this.floatParameter(i++);
                        }
                        bl6 = true;
                    } else if (this.tokAt(i) == 67108901) {
                        ++i;
                        bl6 = true;
                    }
                    if (this.isColorParam(i)) {
                        n = this.getArgbParam(i);
                        i = this.iToken;
                        bl6 = true;
                    }
                    if (!bl6) {
                        this.error(20);
                    }
                    bl5 = true;
                    continue block29;
                }
                default: {
                    if (n3 == 0) {
                        n3 = i;
                    }
                    if (this.setMeshDisplayProperty(21, 0, this.theTok)) continue block29;
                    this.error(20);
                    continue block29;
                }
            }
            boolean bl7 = bl5 = this.theTok != 12291;
            if (bl && !bl2) {
                this.setShapeProperty(21, "points", new Integer(n2));
                bl2 = true;
                n2 = 0;
            }
            if (string == null) continue;
            this.setShapeProperty(21, string, object);
        }
        if (bl) {
            this.setShapeProperty(21, "set", null);
        }
        if (n != Integer.MIN_VALUE) {
            this.setShapeProperty(21, "color", new Integer(n));
        }
        if (bl4) {
            this.setShapeTranslucency(21, "", "translucent", f);
        }
        if (n2 != 0) {
            this.setShapeProperty(21, "scale", new Integer(n2));
        }
        if (n3 > 0 && !this.setMeshDisplayProperty(21, n3, this.getToken((int)n3).tok)) {
            this.error(20);
        }
    }

    private void polyhedra() throws ScriptException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = 0;
        this.viewer.loadShape(20);
        this.setShapeProperty(20, "init", null);
        String string = "centers";
        String string2 = "radius_";
        boolean bl6 = false;
        float f = Float.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        block12: for (int i = 1; i < this.statementLength; ++i) {
            if (this.isColorParam(i)) {
                n2 = this.getArgbParam(i);
                i = this.iToken;
                continue;
            }
            String string3 = null;
            Object object = null;
            switch (this.getToken((int)i).tok) {
                case 0x1100010: 
                case 17826148: {
                    continue block12;
                }
                case 141557762: {
                    if (n > 0) {
                        this.error(21);
                    }
                    bl = true;
                    string3 = "bonds";
                    break;
                }
                case 137363473: {
                    string2 = "radius";
                    continue block12;
                }
                case 141562115: {
                    ++i;
                }
                case 67108901: 
                case 67108926: {
                    bl6 = false;
                    boolean bl7 = false;
                    if (this.tokAt(i) == 67108926) {
                        bl6 = true;
                        if (this.isFloatParameter(++i)) {
                            f = this.floatParameter(i++);
                        }
                        bl7 = true;
                    } else if (this.tokAt(i) == 67108901) {
                        ++i;
                        bl7 = true;
                    }
                    if (this.isColorParam(i)) {
                        n2 = this.getArgbParam(i);
                        i = this.iToken;
                        bl7 = true;
                    }
                    if (bl7) continue block12;
                    this.error(20);
                    continue block12;
                }
                case 1: {
                    String string4 = this.parameterAsString(i);
                    if ("collapsed".equalsIgnoreCase(string4)) {
                        string3 = "collapsed";
                        object = Boolean.TRUE;
                        if (bl3) {
                            this.error(16);
                        }
                        bl3 = true;
                        break;
                    }
                    if ("flat".equalsIgnoreCase(string4)) {
                        string3 = "collapsed";
                        object = Boolean.FALSE;
                        if (bl3) {
                            this.error(16);
                        }
                        bl3 = true;
                        break;
                    }
                    if ("edges".equalsIgnoreCase(string4) || "noedges".equalsIgnoreCase(string4) || "frontedges".equalsIgnoreCase(string4)) {
                        if (bl4) {
                            this.error(16);
                        }
                        string3 = string4;
                        bl4 = true;
                        break;
                    }
                    if (!bl) {
                        this.error(17);
                    }
                    if ("to".equalsIgnoreCase(string4)) {
                        if (n > 1) {
                            this.error(21);
                        }
                        if (this.getToken((int)(i + 1)).tok == 0x4000007) {
                            string3 = "toBitSet";
                            object = this.getToken((int)(++i)).value;
                            bl = true;
                            break;
                        }
                        string = "to";
                        continue block12;
                    }
                    if ("faceCenterOffset".equalsIgnoreCase(string4)) {
                        string2 = "faceCenterOffset";
                        bl5 = true;
                        continue block12;
                    }
                    if ("distanceFactor".equalsIgnoreCase(string4)) {
                        string2 = "distanceFactor";
                        bl5 = true;
                        continue block12;
                    }
                    this.error(20);
                }
                case 2: {
                    if (n > 0 && !bl5) {
                        this.error(21);
                    }
                    if (string2 == "radius_") {
                        string3 = "nVertices";
                        object = new Integer(this.intParameter(i));
                        bl = true;
                        break;
                    }
                }
                case 3: {
                    if (n > 0 && !bl5) {
                        this.error(21);
                    }
                    string3 = string2 == "radius_" ? "radius" : string2;
                    object = new Float(this.floatParameter(i));
                    string2 = "radius_";
                    bl5 = false;
                    bl = true;
                    break;
                }
                case 12291: 
                case 0x100010: 
                case 0x100011: {
                    if (i + 1 != this.statementLength || bl || n > 1 || n == 0 && string == "to") {
                        this.error(16);
                    }
                    string3 = this.parameterAsString(i);
                    bl2 = true;
                    break;
                }
                case 0x100001: 
                case 0x4000007: {
                    if (bl3) {
                        this.error(21);
                    }
                    if (++n > 2) {
                        this.error(1);
                    }
                    if (string == "to") {
                        bl = true;
                    }
                    string3 = string;
                    string = "to";
                    object = this.expression(i);
                    i = this.iToken;
                    break;
                }
                default: {
                    this.error(20);
                }
            }
            this.setShapeProperty(20, string3, object);
            if (!bl2) continue;
            return;
        }
        if (!(bl || bl3 || bl4)) {
            this.error(17);
        }
        if (bl) {
            this.setShapeProperty(20, "generate", null);
        }
        if (n2 != Integer.MIN_VALUE) {
            this.setShapeProperty(20, "colorThis", new Integer(n2));
        }
        if (bl6) {
            this.setShapeTranslucency(20, "", "translucent", f);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void lcaoCartoon() throws ScriptException {
        this.viewer.loadShape(23);
        if (this.tokAt(1) == 6 && this.listIsosurface(23)) {
            return;
        }
        this.setShapeProperty(23, "init", null);
        if (this.statementLength == 1) {
            this.setShapeProperty(23, "lcaoID", null);
            return;
        }
        boolean bl = false;
        String string = null;
        int n = 1;
        while (true) {
            block33: {
                if (n >= this.statementLength) {
                    this.setShapeProperty(23, "clear", null);
                    return;
                }
                String string2 = null;
                Object object = null;
                switch (this.getToken((int)n).tok) {
                    case 12289: {
                        this.isosurface(23);
                        return;
                    }
                    case 528432: {
                        String string3;
                        Vector3f vector3f = new Vector3f();
                        switch (this.getToken((int)(++n)).tok) {
                            case 1: {
                                string3 = this.parameterAsString(n);
                                float f = this.floatParameter(++n) * ((float)Math.PI / 180);
                                if (string3.equalsIgnoreCase("x")) {
                                    vector3f.set(f, 0.0f, 0.0f);
                                    break;
                                }
                                if (string3.equalsIgnoreCase("y")) {
                                    vector3f.set(0.0f, f, 0.0f);
                                    break;
                                }
                                if (string3.equalsIgnoreCase("z")) {
                                    vector3f.set(0.0f, 0.0f, f);
                                    break;
                                }
                                this.error(20);
                            }
                            default: {
                                this.error(20);
                            }
                        }
                        string2 = "rotationAxis";
                        object = vector3f;
                        break;
                    }
                    case 0x100011: {
                        string2 = "on";
                        break;
                    }
                    case 0x100010: {
                        string2 = "off";
                        break;
                    }
                    case 12291: {
                        string2 = "delete";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string2 = "scale";
                        object = new Float(this.floatParameter(++n));
                        break;
                    }
                    case 0x100001: 
                    case 0x4000007: {
                        string2 = "select";
                        object = this.expression(n);
                        n = this.iToken;
                        break;
                    }
                    case 141562115: {
                        string = this.setColorOptions(n + 1, 23, -2);
                        if (string != null) {
                            this.setShapeProperty(23, "settranslucency", string);
                        }
                        n = this.iToken;
                        bl = true;
                        break block33;
                    }
                    case 67108901: 
                    case 67108926: {
                        this.setMeshDisplayProperty(23, n, this.theTok);
                        n = this.iToken;
                        bl = true;
                        break block33;
                    }
                    case 4: {
                        object = this.stringParameter(n);
                        string2 = "create";
                        if (!this.optParameterAsString(n + 1).equalsIgnoreCase("molecular")) break;
                        ++n;
                        string2 = "molecular";
                        break;
                    }
                    case 9451009: {
                        if (this.tokAt(n + 1) == 0x4000007 || this.tokAt(n + 1) == 0x100001) {
                            string2 = "select";
                            object = this.expression(n + 1);
                            n = this.iToken;
                            break;
                        }
                        string2 = "selectType";
                        object = this.parameterAsString(++n);
                        break;
                    }
                    case 1: {
                        String string3 = this.parameterAsString(n);
                        if (string3.equalsIgnoreCase("SCALE")) {
                            string2 = "scale";
                            object = new Float(this.floatParameter(++n));
                            break;
                        }
                        if (string3.equalsIgnoreCase("MOLECULAR")) {
                            string2 = "molecular";
                            break;
                        }
                        if (string3.equalsIgnoreCase("CREATE")) {
                            object = this.parameterAsString(++n);
                            string2 = "create";
                            if (!this.optParameterAsString(n + 1).equalsIgnoreCase("molecular")) break;
                            ++n;
                            string2 = "molecular";
                            break;
                        }
                        object = string3;
                    }
                    case 0x100003: {
                        if (bl) {
                            this.error(20);
                        }
                        string2 = "lcaoID";
                    }
                }
                if (this.theTok != 12291) {
                    bl = true;
                }
                if (string2 == null) {
                    this.error(20);
                }
                this.setShapeProperty(23, string2, object);
            }
            ++n;
        }
    }

    private boolean mo(boolean bl) throws ScriptException {
        int n = Integer.MAX_VALUE;
        int n2 = this.viewer.getDisplayModelIndex();
        if (!this.isSyntaxCheck && n2 < 0) {
            this.error(23, "MO isosurfaces");
        }
        this.viewer.loadShape(24);
        if (this.tokAt(1) == 6 && this.listIsosurface(24)) {
            return true;
        }
        this.setShapeProperty(24, "init", new Integer(n2));
        String string = null;
        int n3 = (Integer)this.viewer.getShapeProperty(24, "moNumber");
        if (bl) {
            return true;
        }
        if (n3 == 0 && !this.isSyntaxCheck) {
            this.lastMoNumber = 0;
            n3 = Integer.MAX_VALUE;
        }
        String string2 = null;
        Object object = null;
        switch (this.getToken((int)1).tok) {
            case 2: {
                n3 = this.intParameter(1);
                break;
            }
            case 67108894: {
                n3 = this.lastMoNumber + 1;
                break;
            }
            case 67108907: {
                n3 = this.lastMoNumber - 1;
                break;
            }
            case 141562115: {
                this.setColorOptions(2, 24, 2);
                break;
            }
            case 9439234: {
                string2 = "plane";
                object = this.planeParameter(2);
                break;
            }
            case 1: {
                String string3 = this.parameterAsString(1);
                n = this.moOffset(1);
                if (n != Integer.MAX_VALUE) {
                    n3 = 0;
                    break;
                }
                if (string3.equalsIgnoreCase("CUTOFF")) {
                    if (this.tokAt(2) == 0x1100071) {
                        string2 = "cutoffPositive";
                        object = new Float(this.floatParameter(3));
                        break;
                    }
                    string2 = "cutoff";
                    object = new Float(this.floatParameter(2));
                    break;
                }
                if (string3.equalsIgnoreCase("RESOLUTION") || string3.equalsIgnoreCase("POINTSPERANGSTROM")) {
                    string2 = "resolution";
                    object = new Float(this.floatParameter(2));
                    break;
                }
                if (string3.equalsIgnoreCase("SCALE")) {
                    string2 = "scale";
                    object = new Float(this.floatParameter(2));
                    break;
                }
                if (string3.equalsIgnoreCase("SQUARED")) {
                    string2 = "squareData";
                    object = Boolean.TRUE;
                    break;
                }
                if (string3.equalsIgnoreCase("TITLEFORMAT")) {
                    if (2 >= this.statementLength || this.tokAt(2) != 4) break;
                    string2 = "titleFormat";
                    object = this.parameterAsString(2);
                    break;
                }
                if (string3.equalsIgnoreCase("DEBUG")) {
                    string2 = "debug";
                    break;
                }
                if (string3.equalsIgnoreCase("noplane")) {
                    string2 = "plane";
                    break;
                }
                this.error(20);
            }
            default: {
                if (!this.setMeshDisplayProperty(24, 1, this.theTok)) {
                    this.error(20);
                }
                return true;
            }
        }
        if (string2 != null) {
            this.setShapeProperty(24, string2, object);
        }
        if (n3 != Integer.MAX_VALUE) {
            if (this.tokAt(2) == 4) {
                string = this.parameterAsString(2);
            }
            if (!this.isSyntaxCheck) {
                this.viewer.setCursor(4);
            }
            this.setMoData(24, n3, n, n2, string);
            this.setShapeProperty(24, "finalize", null);
        }
        return true;
    }

    private String setColorOptions(int n, int n2, int n3) throws ScriptException {
        this.getToken(n);
        String string = "opaque";
        if (this.theTok == 67108926) {
            string = "translucent";
            if (n3 < 0) {
                float f = this.isFloatParameter(n + 1) ? this.floatParameter(++n) : Float.MAX_VALUE;
                this.setShapeTranslucency(n2, null, "translucent", f);
            } else {
                this.setMeshDisplayProperty(n2, n, this.theTok);
            }
        } else if (this.theTok == 67108901) {
            if (n3 >= 0) {
                this.setMeshDisplayProperty(n2, n, this.theTok);
            }
        } else {
            --this.iToken;
        }
        n3 = Math.abs(n3);
        for (int i = 0; i < n3; ++i) {
            if (this.isColorParam(this.iToken + 1)) {
                this.setShapeProperty(n2, "colorRGB", new Integer(this.getArgbParam(++this.iToken)));
                continue;
            }
            if (this.iToken >= n) break;
            this.error(20);
        }
        return string;
    }

    private int moOffset(int n) throws ScriptException {
        String string = this.parameterAsString(n++);
        boolean bl = false;
        int n2 = Integer.MAX_VALUE;
        bl = string.equalsIgnoreCase("HOMO");
        if (bl || string.equalsIgnoreCase("LUMO")) {
            int n3 = n2 = bl ? 0 : 1;
            if (this.tokAt(n) == 2 && this.intParameter(n) < 0) {
                n2 += this.intParameter(n);
            } else if (this.tokAt(n) == 0x1100071) {
                n2 += this.intParameter(n + 1);
            } else if (this.tokAt(n) == 0x1100070) {
                n2 -= this.intParameter(n + 1);
            }
        }
        return n2;
    }

    private void setMoData(int n, int n2, int n3, int n4, String string) throws ScriptException {
        Hashtable hashtable;
        if (this.isSyntaxCheck) {
            return;
        }
        if (n4 == 0) {
            n4 = this.viewer.getDisplayModelIndex();
        }
        if (n4 < 0) {
            this.error(23, "MO isosurfaces");
        }
        if ((hashtable = (Hashtable)this.viewer.getModelAuxiliaryInfo(n4, "jmolSurfaceInfo")) == null || !((String)hashtable.get("surfaceDataType")).equals("mo")) {
            Vector vector;
            int n5;
            hashtable = (Hashtable)this.viewer.getModelAuxiliaryInfo(n4, "moData");
            if (hashtable == null) {
                this.evalError(GT._((String)"no MO basis/coefficient data available for this frame"));
            }
            int n6 = n5 = (vector = (Vector)hashtable.get("mos")) == null ? 0 : vector.size();
            if (n5 == 0) {
                this.evalError(GT._((String)"no MO coefficient data available"));
            }
            if (n5 == 1 && n2 > 1) {
                this.evalError(GT._((String)"Only one molecular orbital is available in this file"));
            }
            if (n3 != Integer.MAX_VALUE) {
                if (hashtable.containsKey("HOMO")) {
                    this.lastMoNumber = n2 = (Integer)hashtable.get("HOMO") + n3;
                } else {
                    for (int i = 0; i < n5; ++i) {
                        Hashtable hashtable2 = (Hashtable)vector.get(i);
                        if (!hashtable2.containsKey("occupancy")) {
                            this.evalError(GT._((String)"no MO occupancy data available"));
                        }
                        if (((Float)hashtable2.get("occupancy")).floatValue() != 0.0f) continue;
                        this.lastMoNumber = n2 = i + n3;
                        break;
                    }
                }
                Logger.info((String)("MO " + n2));
            }
            if (n2 < 1 || n2 > n5) {
                this.evalError(GT._((String)"An MO index from 1 to {0} is required", (int)n5));
            }
        }
        this.lastMoNumber = n2;
        this.setShapeProperty(n, "moData", hashtable);
        if (string != null) {
            this.setShapeProperty(n, "title", string);
        }
        this.setShapeProperty(n, "molecularOrbital", new Integer(n2));
        this.setShapeProperty(n, "clear", null);
    }

    private void initIsosurface(int n) throws ScriptException {
        this.setShapeProperty(n, "init", this.fullCommand);
        this.iToken = 0;
        if (this.tokAt(1) == 12291 || this.tokAt(2) == 12291 && this.tokAt(++this.iToken) == 0x100003) {
            this.setShapeProperty(n, "delete", null);
            this.iToken += 2;
            if (this.statementLength > this.iToken) {
                this.setShapeProperty(n, "init", this.fullCommand);
                this.setShapeProperty(n, "thisID", "+PREVIOUS_MESH+");
            }
            return;
        }
        this.iToken = 1;
        if (!this.setMeshDisplayProperty(n, 0, this.tokAt(1))) {
            this.setShapeProperty(n, "thisID", "+PREVIOUS_MESH+");
            if (n != 21) {
                this.setShapeProperty(n, "title", new String[]{this.thisCommand});
            }
        }
    }

    private String getNextComment() {
        String string = this.getCommand(this.pc + 1);
        return string.startsWith("#") ? string : "";
    }

    private boolean listIsosurface(int n) throws ScriptException {
        if (this.getToken((int)1).value instanceof String[]) {
            return false;
        }
        this.checkLength(2);
        if (!this.isSyntaxCheck) {
            this.showString((String)this.viewer.getShapeProperty(n, "list"));
        }
        return true;
    }

    private void isosurface(int n) throws ScriptException {
        Object object;
        Object object2;
        int n2;
        this.viewer.loadShape(n);
        if (this.tokAt(1) == 6 && this.listIsosurface(n)) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        boolean bl = n == 22;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        float[] fArray = new float[5];
        float[] fArray2 = null;
        int n5 = 0;
        int n6 = n2 = this.isSyntaxCheck ? 0 : this.viewer.getDisplayModelIndex();
        if (!this.isSyntaxCheck) {
            this.viewer.setCursor(4);
        }
        boolean bl6 = false;
        String string = null;
        this.initIsosurface(n);
        block35: for (int i = this.iToken; i < this.statementLength; ++i) {
            if (this.isColorParam(i)) {
                if (i != n4) {
                    this.error(21);
                }
                this.setShapeProperty(n, "colorRGB", new Integer(this.getArgbParam(i)));
                i = this.iToken;
                n4 = i + 1;
                bl6 = true;
                continue;
            }
            object2 = null;
            object = null;
            int n7 = this.getToken((int)i).tok;
            if (i == 1 && this.tokAt(2) == 0x1100081) {
                n7 = 0;
            }
            block3 : switch (n7) {
                case 0: {
                    object2 = "thisID";
                    object = this.parameterAsString(i) + this.getToken((int)(++i)).value;
                    break;
                }
                case 9439745: {
                    float f = this.floatParameter(++i);
                    object = this.centerParameter(++i);
                    i = this.iToken;
                    object2 = "withinPoint";
                    this.setShapeProperty(n, "withinDistance", new Float(f));
                    break;
                }
                case 141558028: {
                    this.setShapeProperty(n, "propertySmoothing", this.viewer.getIsosurfacePropertySmoothing() ? Boolean.TRUE : Boolean.FALSE);
                    String string2 = this.parameterAsString(i);
                    object2 = "property";
                    if (!bl4 && string2.toLowerCase().indexOf("property_") == 0) {
                        fArray2 = new float[this.viewer.getAtomCount()];
                        if (this.isSyntaxCheck) continue block35;
                        fArray2 = this.viewer.getDataFloat(string2);
                        if (fArray2 == null) {
                            this.error(20);
                        }
                        object = fArray2;
                        break;
                    }
                    int n8 = this.getToken((int)(++i)).tok;
                    int n9 = this.viewer.getAtomCount();
                    float[] fArray3 = fArray2 = bl4 ? new float[]{} : new float[n9];
                    if (bl4) {
                        this.error(20);
                    }
                    if (!this.isSyntaxCheck && !bl4) {
                        Atom[] atomArray = this.viewer.getModelSet().atoms;
                        if (n8 == 3145866) {
                            this.viewer.getSurfaceDistanceMax();
                        }
                        int n10 = n9;
                        while (--n10 >= 0) {
                            fArray2[n10] = this.atomProperty(atomArray[n10], n8, false);
                        }
                    }
                    object = fArray2;
                    break;
                }
                case 3149837: {
                    if (bl2) {
                        this.error(20);
                    }
                    if ((n2 = this.modelNumberParameter(++i)) < 0) {
                        object2 = "fixed";
                        object = Boolean.TRUE;
                        break;
                    }
                    object2 = "modelIndex";
                    object = new Integer(n2);
                    break;
                }
                case 9451009: {
                    object2 = "select";
                    object = this.expression(++i);
                    i = this.iToken;
                    break;
                }
                case 12289: {
                    object2 = "center";
                    object = this.centerParameter(++i);
                    i = this.iToken;
                    break;
                }
                case 141562115: {
                    n3 = 0;
                    if (this.getToken((int)(i + 1)).tok == 4) {
                        this.setShapeProperty(n, "setColorScheme", this.parameterAsString(++i));
                    }
                    if ((this.theTok = this.tokAt(i + 1)) == 67108926 || this.tokAt(i + 1) == 67108901) {
                        string = this.setColorOptions(i + 1, 22, -2);
                        i = this.iToken;
                    }
                    switch (this.tokAt(i + 1)) {
                        case 0x4000001: 
                        case 67108908: {
                            this.getToken(++i);
                            n3 = 1;
                            object2 = "rangeAll";
                            if (this.tokAt(i + 1) != 0x100003) break block3;
                            this.getToken(++i);
                            break block3;
                        }
                        default: {
                            n4 = i + 1;
                            break;
                        }
                    }
                    continue block35;
                }
                case 3149832: {
                    continue block35;
                }
                case 0x1100071: {
                    if (n3 != 0) break;
                    object2 = "cutoffPositive";
                    object = new Float(this.floatParameter(++i));
                    break;
                }
                case 2: 
                case 3: {
                    object2 = n3 == 1 ? "red" : (n3 == 2 ? "blue" : "cutoff");
                    object = new Float(this.floatParameter(i));
                    if (n3 <= 0) break;
                    ++n3;
                    break;
                }
                case 67108886: {
                    object2 = "ionicRadius";
                    object = new Float(this.radiusParameter(++i, 0.0f));
                    i = this.iToken;
                    break;
                }
                case 3146007: {
                    object2 = "vdwRadius";
                    object = new Float(this.radiusParameter(++i, 0.0f));
                    i = this.iToken;
                    break;
                }
                case 9439234: {
                    bl3 = true;
                    object2 = "plane";
                    object = this.planeParameter(++i);
                    i = this.iToken;
                    break;
                }
                case 1: {
                    Object object3;
                    int n11;
                    String string3;
                    String string2 = this.parameterAsString(i);
                    if (string2.equalsIgnoreCase("id")) {
                        this.setShapeId(n, ++i, bl6);
                        break;
                    }
                    if (string2.equalsIgnoreCase("REMAPPABLE")) {
                        object2 = "remappable";
                        break;
                    }
                    if (string2.equalsIgnoreCase("DOWNSAMPLE")) {
                        object2 = "downsample";
                        object = new Integer(this.intParameter(++i));
                        break;
                    }
                    if (string2.equalsIgnoreCase("LINK")) {
                        object2 = "link";
                        break;
                    }
                    if (string2.equalsIgnoreCase("SQUARED")) {
                        object2 = "squareData";
                        object = Boolean.TRUE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("CAP")) {
                        object2 = "cappingPlane";
                        object = this.planeParameter(++i);
                        i = this.iToken;
                        break;
                    }
                    if (string2.equalsIgnoreCase("IGNORE")) {
                        object2 = "ignore";
                        object = this.expression(++i);
                        i = this.iToken;
                        break;
                    }
                    if (string2.equalsIgnoreCase("CUTOFF")) {
                        if (++i < this.statementLength && this.getToken((int)i).tok == 0x1100071) {
                            object2 = "cutoffPositive";
                            object = new Float(this.floatParameter(++i));
                            break;
                        }
                        object2 = "cutoff";
                        object = new Float(this.floatParameter(i));
                        break;
                    }
                    if (string2.equalsIgnoreCase("CAVITY")) {
                        float f;
                        if (!bl) {
                            this.error(20);
                        }
                        bl4 = true;
                        if (this.isSyntaxCheck) continue block35;
                        float f2 = this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 1.2f;
                        float f3 = f = this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 10.0f;
                        if (f > 10.0f) {
                            this.integerOutOfRange(0, 10);
                        }
                        this.setShapeProperty(n, "envelopeRadius", new Float(f));
                        this.setShapeProperty(n, "cavityRadius", new Float(f2));
                        object2 = "cavity";
                        break;
                    }
                    if (string2.equalsIgnoreCase("POCKET")) {
                        object2 = "pocket";
                        object = Boolean.TRUE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("INTERIOR")) {
                        object2 = "pocket";
                        object = Boolean.FALSE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("SCALE")) {
                        object2 = "scale";
                        object = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (string2.equalsIgnoreCase("MINSET")) {
                        object2 = "minset";
                        object = new Integer(this.intParameter(++i));
                        break;
                    }
                    if (string2.equalsIgnoreCase("MAXSET")) {
                        object2 = "maxset";
                        object = new Integer(this.intParameter(++i));
                        break;
                    }
                    if (string2.equalsIgnoreCase("ANGSTROMS")) {
                        object2 = "angstroms";
                        break;
                    }
                    if (string2.equalsIgnoreCase("RESOLUTION") || string2.equalsIgnoreCase("POINTSPERANGSTROM")) {
                        object2 = "resolution";
                        object = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (string2.equalsIgnoreCase("ANISOTROPY")) {
                        object2 = "anisotropy";
                        object = this.getPoint3f(++i, false);
                        i = this.iToken;
                        break;
                    }
                    if (string2.equalsIgnoreCase("ECCENTRICITY")) {
                        object2 = "eccentricity";
                        object = this.getPoint4f(++i);
                        i = this.iToken;
                        break;
                    }
                    if (string2.equalsIgnoreCase("FIXED")) {
                        object2 = "fixed";
                        object = Boolean.TRUE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("BLOCKDATA")) {
                        object2 = "blockData";
                        object = Boolean.TRUE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("MODELBASED")) {
                        object2 = "fixed";
                        object = Boolean.FALSE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("SIGN")) {
                        n4 = i + 1;
                        object2 = "sign";
                        object = Boolean.TRUE;
                        n3 = 1;
                        break;
                    }
                    if (string2.equalsIgnoreCase("REVERSECOLOR")) {
                        object2 = "reverseColor";
                        object = Boolean.TRUE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("ADDHYDROGENS")) {
                        object2 = "addHydrogens";
                        object = Boolean.TRUE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("COLORSCHEME")) {
                        object2 = "setColorScheme";
                        object = this.parameterAsString(++i);
                        break;
                    }
                    if (string2.equalsIgnoreCase("DEBUG") || string2.equalsIgnoreCase("NODEBUG")) {
                        object2 = "debug";
                        object = string2.equalsIgnoreCase("DEBUG") ? Boolean.TRUE : Boolean.FALSE;
                        break;
                    }
                    if (string2.equalsIgnoreCase("GRIDPOINTS")) {
                        object2 = "gridPoints";
                        break;
                    }
                    if (string2.equalsIgnoreCase("CONTOUR")) {
                        object2 = "contour";
                        object = new Integer(this.tokAt(i + 1) == 2 ? this.intParameter(++i) : 0);
                        break;
                    }
                    if (string2.equalsIgnoreCase("PHASE")) {
                        object2 = "phase";
                        object = this.tokAt(i + 1) == 4 ? this.stringParameter(++i) : "_orb";
                        break;
                    }
                    if (string2.equalsIgnoreCase("INSIDEOUT")) {
                        object2 = "insideOut";
                        break;
                    }
                    if (string2.equalsIgnoreCase("MAP")) {
                        bl2 = !bl4;
                        object2 = "map";
                        break;
                    }
                    if (string2.equalsIgnoreCase("hkl")) {
                        bl3 = true;
                        object2 = "plane";
                        object = this.hklParameter(++i);
                        i = this.iToken;
                        break;
                    }
                    if (string2.equalsIgnoreCase("sphere")) {
                        bl2 = true;
                        object2 = "sphere";
                        object = new Float(this.floatParameter(++i));
                        break;
                    }
                    if (string2.equalsIgnoreCase("lobe")) {
                        bl2 = true;
                        object2 = "lobe";
                        object = this.getPoint4f(++i);
                        i = this.iToken;
                        break;
                    }
                    if (string2.equalsIgnoreCase("AtomicOrbital") || string2.equalsIgnoreCase("orbital")) {
                        bl2 = true;
                        fArray[0] = this.intParameter(++i);
                        fArray[1] = this.intParameter(++i);
                        fArray[2] = this.intParameter(++i);
                        fArray[3] = this.isFloatParameter(i + 1) ? this.floatParameter(++i) : 6.0f;
                        object2 = "hydrogenOrbital";
                        object = fArray;
                        break;
                    }
                    if (string2.equalsIgnoreCase("functionXY")) {
                        Vector<Object> vector = new Vector<Object>();
                        if (this.getToken((int)(++i)).tok != 4) {
                            this.error(42, "functionXY must be followed by a function name in quotes.");
                        }
                        String string4 = this.parameterAsString(i++);
                        string3 = this.extractCommandOption("# DATA" + (bl5 ? "2" : ""));
                        if (string3 != null) {
                            string4 = string3;
                        }
                        n11 = string4.indexOf("data2d_xyz") == 0 ? 1 : 0;
                        vector.addElement(string4);
                        vector.addElement(this.getPoint3f(i, false));
                        int n12 = ++this.iToken;
                        Point4f point4f = this.getPoint4f(n12);
                        vector.addElement(point4f);
                        int n13 = (int)point4f.x;
                        int n14 = ++this.iToken;
                        point4f = this.getPoint4f(n14);
                        vector.addElement(point4f);
                        int n15 = (int)point4f.x;
                        vector.addElement(this.getPoint4f(++this.iToken));
                        if (n13 == 0 || n15 == 0) {
                            this.error(20);
                        }
                        if (!this.isSyntaxCheck) {
                            object3 = n11 != 0 ? this.viewer.getDataFloat2D(string4) : this.viewer.functionXY(string4, n13, n15);
                            if (n11 != 0) {
                                n13 = object3 == null ? 0 : ((Object)object3).length;
                                n15 = 3;
                            } else {
                                n13 = Math.abs(n13);
                                n15 = Math.abs(n15);
                            }
                            if (object3 == null) {
                                this.iToken = n12;
                                this.error(42, "fdata is null.");
                            }
                            if (((Object)object3).length != n13 && n11 == 0) {
                                this.iToken = n12;
                                this.error(42, "fdata length is not correct: " + ((Object)object3).length + " " + n13 + ".");
                            }
                            for (int j = 0; j < n13; ++j) {
                                if (object3[j] == null) {
                                    this.iToken = n14;
                                    this.error(42, "fdata[" + j + "] is null.");
                                }
                                if (((Object)object3[j]).length == n15) continue;
                                this.iToken = n14;
                                this.error(42, "fdata[" + j + "] is not the right length: " + ((Object)object3[j]).length + " " + n15 + ".");
                            }
                            vector.addElement(object3);
                        }
                        i = this.iToken;
                        object2 = "functionXY";
                        object = vector;
                        bl2 = true;
                        bl5 = true;
                        break;
                    }
                    if (string2.equalsIgnoreCase("molecular")) {
                        bl2 = true;
                        object2 = "molecular";
                        object = new Float(1.4);
                        break;
                    }
                    if (string2.equalsIgnoreCase("VARIABLE")) {
                        object2 = "property";
                        fArray2 = new float[this.viewer.getAtomCount()];
                        if (!this.isSyntaxCheck) {
                            Parser.parseFloatArray((String)("" + this.getParameter(this.parameterAsString(++i), false)), null, (float[])fArray2);
                        }
                        object = fArray2;
                        break;
                    }
                    i = this.setShapeId(n, i, bl6);
                    break;
                }
                case 0x100003: {
                    if (bl6) {
                        this.error(20);
                    }
                    object2 = "thisID";
                    break;
                }
                case 528401: {
                    BitSet bitSet;
                    bl2 = true;
                    ++i;
                    try {
                        object = this.getPoint4f(i);
                        object2 = "ellipsoid";
                        i = this.iToken;
                    }
                    catch (ScriptException scriptException) {
                        try {
                            float[] fArray4 = new float[6];
                            i = this.floatParameterSet(i, fArray4);
                            object = fArray4;
                            object2 = "ellipsoid";
                        }
                        catch (ScriptException scriptException2) {
                            bitSet = this.expression(i);
                            int n16 = BitSetUtil.firstSetBit((BitSet)bitSet);
                            Atom[] atomArray = this.viewer.getModelSet().atoms;
                            if (n16 >= 0) {
                                object = atomArray[n16].getEllipsoid();
                            }
                            if (object == null) {
                                return;
                            }
                            i = this.iToken;
                            object2 = "ellipsoid";
                            if (this.isSyntaxCheck) break;
                            this.setShapeProperty(n, "center", this.viewer.getAtomPoint3f(n16));
                        }
                    }
                    break;
                }
                case 4126: {
                    BitSet bitSet;
                    int n11;
                    bl2 = true;
                    String string3 = this.parameterAsString(++i);
                    this.setShapeProperty(n, "lcaoType", string3);
                    switch (this.getToken((int)(++i)).tok) {
                        case 0x100001: 
                        case 0x4000007: {
                            Point3f point3f;
                            object2 = "lcaoCartoon";
                            bitSet = this.expression(i);
                            i = this.iToken;
                            n11 = BitSetUtil.firstSetBit((BitSet)bitSet);
                            n2 = 0;
                            if (n11 < 0) {
                                if (!this.isSyntaxCheck) {
                                    this.error(12);
                                }
                                point3f = new Point3f();
                            } else {
                                n2 = this.viewer.getAtomModelIndex(n11);
                                point3f = this.viewer.getAtomPoint3f(n11);
                            }
                            this.setShapeProperty(n, "modelIndex", new Integer(n2));
                            Point3f point3f2 = new Point3f[]{new Vector3f(), new Vector3f(), new Vector3f((Tuple3f)point3f), new Vector3f()};
                            if (!this.isSyntaxCheck) {
                                this.viewer.getHybridizationAndAxes(n11, (Vector3f)point3f2[0], (Vector3f)point3f2[1], string3, false);
                            }
                            object = point3f2;
                            break block3;
                        }
                    }
                    this.error(12);
                    break;
                }
                case 4130: {
                    if (++i == this.statementLength) {
                        this.error(1);
                    }
                    int n11 = Integer.MAX_VALUE;
                    int n17 = Integer.MAX_VALUE;
                    if (this.tokAt(i) == 2) {
                        n11 = this.intParameter(i);
                    } else {
                        n17 = this.moOffset(i);
                        if (n17 != Integer.MAX_VALUE) {
                            n11 = 0;
                            i = this.iToken;
                        }
                    }
                    this.setMoData(n, n11, n17, n2, null);
                    bl2 = true;
                    continue block35;
                }
                case 67108890: {
                    float[] fArray5 = null;
                    try {
                        fArray5 = this.viewer.getPartialCharges();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!this.isSyntaxCheck && fArray5 == null) {
                        this.evalError(GT._((String)"No partial charges were read from the file; Jmol needs these to render the MEP data."));
                    }
                    bl2 = true;
                    object2 = "mep";
                    object = fArray5;
                    break;
                }
                case 0x4000034: 
                case 168820747: {
                    bl2 = true;
                    this.setShapeProperty(n, "bsSolvent", this.lookupIdentifierValue("solvent"));
                    object2 = this.theTok == 0x4000034 ? "sasurface" : "solvent";
                    float f = this.isFloatParameter(i + 1) ? this.floatParameter(++i) : this.viewer.getSolventProbeRadius();
                    object = new Float(f);
                    break;
                }
                case 4: {
                    Object object3;
                    object2 = bl2 || bl3 ? "mapColor" : "readFile";
                    String string5 = this.parameterAsString(i);
                    if (string5.equals("TESTDATA") && Viewer.testData != null) {
                        object = Viewer.testData;
                        break;
                    }
                    if (string5.equals("TESTDATA2") && Viewer.testData2 != null) {
                        object = Viewer.testData2;
                        break;
                    }
                    if (string5.length() == 0) {
                        if (bl2 || bl3) {
                            object = this.viewer.getModelAuxiliaryInfo(n2, "jmolMappedDataInfo");
                        }
                        if (object == null) {
                            object = this.viewer.getModelAuxiliaryInfo(n2, "jmolSurfaceInfo");
                        }
                        bl2 = true;
                        if (object != null) break;
                        string5 = this.getFullPathName();
                    }
                    bl2 = true;
                    if (this.tokAt(i + 1) == 2) {
                        this.setShapeProperty(n, "fileIndex", new Integer(this.intParameter(++i)));
                    }
                    if (this.thisCommand.indexOf("# FILE" + n5 + "=") >= 0) {
                        string5 = this.extractCommandOption("# FILE" + n5);
                    }
                    String[] stringArray = new String[1];
                    Object object4 = object3 = this.isSyntaxCheck ? null : this.viewer.getBufferedReaderOrErrorMessageFromName(string5, stringArray, false);
                    if (object3 instanceof String) {
                        this.error(15, string5 + ":" + object3);
                    }
                    if (!this.isSyntaxCheck) {
                        Logger.info((String)("reading isosurface data from " + stringArray[0]));
                    }
                    this.setShapeProperty(n, "commandOption", "FILE" + n5++ + "=" + Escape.escape((String)stringArray[0]));
                    object = object3;
                    break;
                }
                default: {
                    if (bl3 && !bl2) {
                        this.setShapeProperty(n, "nomap", new Float(0.0f));
                        bl2 = true;
                    }
                    if (!this.setMeshDisplayProperty(n, i, this.theTok)) {
                        this.error(20);
                    }
                    i = this.iToken;
                }
            }
            boolean bl7 = bl6 = this.theTok != 12291;
            if (object2 == "property" && !bl2) {
                bl2 = true;
                this.setShapeProperty(n, "bsSolvent", this.lookupIdentifierValue("solvent"));
                this.setShapeProperty(n, "sasurface", new Float(0.0f));
            }
            if (object2 == null) continue;
            this.setShapeProperty(n, (String)object2, object);
        }
        if (bl4 && !bl2) {
            bl2 = true;
            this.setShapeProperty(n, "bsSolvent", this.lookupIdentifierValue("solvent"));
            this.setShapeProperty(n, "sasurface", new Float(0.0f));
        }
        if (bl3 && !bl2) {
            this.setShapeProperty(n, "nomap", new Float(0.0f));
            bl2 = true;
        }
        if (bl2 && bl && !this.isSyntaxCheck) {
            String string6 = (String)this.viewer.getShapeProperty(n, "ID");
            object2 = (float[])this.viewer.getShapeProperty(n, "dataRange");
            object = (Integer)this.viewer.getShapeProperty(n, "count");
            if (string6 != null) {
                string6 = string6 + " created; number of isosurfaces = " + object;
                if (object2 != null && object2[0] != object2[1]) {
                    string6 = string6 + "\ncolor range " + (float)object2[2] + " " + (float)object2[3] + "; mapped data range " + (float)object2[0] + " to " + (float)object2[1];
                }
                this.showString(string6);
            }
            this.setShapeProperty(n, "finalize", null);
        }
        if (string != null) {
            this.setShapeProperty(n, "translucency", string);
        }
        this.setShapeProperty(n, "clear", null);
    }

    private boolean setMeshDisplayProperty(int n, int n2, int n3) throws ScriptException {
        String string = null;
        Comparable<Boolean> comparable = null;
        boolean bl = n2 == 0;
        switch (n3) {
            case 0: 
            case 12291: 
            case 0x100010: 
            case 0x100011: {
                if (this.iToken == 1) {
                    this.setShapeProperty(n, "thisID", null);
                }
                if (n3 == 0) {
                    return this.iToken == 1;
                }
                if (!bl) {
                    this.setShapeProperty(n, this.parameterAsString(this.iToken), null);
                }
                return true;
            }
            case 528399: {
                comparable = Boolean.TRUE;
            }
            case 67108895: {
                string = "dots";
                break;
            }
            case 67108891: {
                comparable = Boolean.TRUE;
            }
            case 67108897: {
                string = "mesh";
                break;
            }
            case 0x4000010: {
                comparable = Boolean.TRUE;
            }
            case 0x4000020: {
                string = "fill";
                break;
            }
            case 67108927: {
                comparable = Boolean.TRUE;
            }
            case 0x4000024: {
                string = "triangles";
                break;
            }
            case 0x4000014: {
                comparable = Boolean.TRUE;
            }
            case 67108899: {
                string = "frontOnly";
                break;
            }
            case 67108883: {
                string = "lighting";
                comparable = new Integer(0);
                break;
            }
            case 0x4000006: {
                string = "lighting";
                comparable = new Integer(1);
                break;
            }
            case 67108885: {
                string = "lighting";
                comparable = new Integer(2);
                break;
            }
            case 67108901: 
            case 67108926: {
                if (bl) {
                    return true;
                }
                this.colorShape(n, this.iToken, false);
                return true;
            }
        }
        if (string == null) {
            return false;
        }
        if (bl) {
            return true;
        }
        this.setShapeProperty(n, string, comparable);
        n3 = this.tokAt(this.iToken + 1);
        if (n3 != 0 && !this.setMeshDisplayProperty(n, ++this.iToken, n3)) {
            --this.iToken;
        }
        return true;
    }

    private void planeExpected() throws ScriptException {
        this.evalError(GT._((String)"plane expected -- either three points or atom expressions or {0} or {1} or {2}", (Object[])new Object[]{"{a b c d}", "\"xy\" \"xz\" \"yz\" \"x=...\" \"y=...\" \"z=...\"", "$xxxxx"}));
    }

    void evalError(String string) throws ScriptException {
        if (this.ignoreError) {
            throw new NullPointerException();
        }
        if (!this.isSyntaxCheck) {
            String string2 = this.viewer.removeCommand();
            this.viewer.addCommand(string2 + "#??");
            this.viewer.setCursor(0);
            this.viewer.setRefreshing(true);
        }
        throw new ScriptException(string);
    }

    private void integerOutOfRange(int n, int n2) throws ScriptException {
        this.error(19, "" + n, "" + n2);
    }

    private void numberOutOfRange(float f, float f2) throws ScriptException {
        this.error(27, "" + f, "" + f2);
    }

    void error(int n) throws ScriptException {
        this.error(n, null, null, false);
    }

    void error(int n, String string) throws ScriptException {
        this.error(n, string, null, false);
    }

    void error(int n, String string, String string2) throws ScriptException {
        this.error(n, string, string2, false);
    }

    private boolean warning(int n, String string, String string2) throws ScriptException {
        return this.error(n, string, string2, true);
    }

    boolean error(int n, String string, String string2, boolean bl) throws ScriptException {
        String string3 = errors[n];
        if (string3.indexOf("{0}") < 0) {
            if (string != null) {
                string3 = string3 + ": " + string;
            }
        } else if ((string3 = TextFormat.simpleReplace((String)string3, (String)"{0}", (String)string)).indexOf("{1}") >= 0) {
            string3 = TextFormat.simpleReplace((String)string3, (String)"{1}", (String)string2);
        } else if (string2 != null) {
            string3 = string3 + ": " + string2;
        }
        if (!bl) {
            this.evalError(string3);
        }
        this.showString(string3);
        return false;
    }

    private String statementAsString() {
        if (this.statement.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.statement[0].tok;
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = n == 36867 && (String)this.statement[0].value == "";
        block26: for (int i = 0; i < this.statementLength; ++i) {
            if (this.iToken == i - 1) {
                stringBuffer.append(" <<");
            }
            if (i != 0) {
                stringBuffer.append(' ');
            }
            if (i == 2 && bl4) {
                bl4 = false;
                stringBuffer.append("= ");
            }
            Token token = this.statement[i];
            if (this.iToken == i && token.tok != 0x100002) {
                stringBuffer.append(">> ");
            }
            switch (token.tok) {
                case 0x100001: {
                    if (!bl) continue block26;
                    stringBuffer.append("{");
                    continue block26;
                }
                case 0x100002: {
                    if (bl3 && i == this.statementLength - 1) {
                        bl = false;
                    }
                    if (!bl) continue block26;
                    stringBuffer.append("}");
                    continue block26;
                }
                case 0x1100020: 
                case 0x1100021: {
                    break;
                }
                case 0x10000E: 
                case 0x100012: {
                    bl2 = token.tok == 0x10000E;
                    break;
                }
                case 135278594: {
                    if (i <= 0 || !((String)token.value).equals("define")) break;
                    stringBuffer.append("@");
                    if (this.tokAt(i + 1) != 0x100001) continue block26;
                    if (!bl) {
                        bl3 = true;
                    }
                    bl = true;
                    continue block26;
                }
                case 0x100011: {
                    stringBuffer.append("true");
                    continue block26;
                }
                case 0x100010: {
                    stringBuffer.append("false");
                    continue block26;
                }
                case 9451009: {
                    break;
                }
                case 2: {
                    stringBuffer.append(token.intValue);
                    continue block26;
                }
                case 7: 
                case 8: 
                case 0x4000007: {
                    stringBuffer.append(Token.sValue(token));
                    continue block26;
                }
                case 5: {
                    stringBuffer.append('^');
                    continue block26;
                }
                case 1048615: {
                    if (token.intValue != Integer.MAX_VALUE) {
                        stringBuffer.append(token.intValue);
                    } else {
                        stringBuffer.append(Group.getSeqcodeString(Eval.getSeqCode(token)));
                    }
                    token = this.statement[++i];
                    stringBuffer.append(' ');
                    stringBuffer.append(bl2 ? "-" : "- ");
                }
                case 1048614: {
                    if (token.intValue != Integer.MAX_VALUE) {
                        stringBuffer.append(token.intValue);
                        continue block26;
                    }
                    stringBuffer.append(Group.getSeqcodeString(Eval.getSeqCode(token)));
                    continue block26;
                }
                case 0x100021: {
                    stringBuffer.append("*:");
                    stringBuffer.append((char)token.intValue);
                    continue block26;
                }
                case 0x10001F: {
                    stringBuffer.append("*%");
                    if (token.value == null) continue block26;
                    stringBuffer.append(token.value.toString());
                    continue block26;
                }
                case 0x100022: {
                    stringBuffer.append("*/");
                }
                case 3: 
                case 1048611: {
                    if (token.intValue < Integer.MAX_VALUE) {
                        stringBuffer.append(Escape.escapeModelFileNumber((int)token.intValue));
                        continue block26;
                    }
                    stringBuffer.append("" + token.value);
                    continue block26;
                }
                case 1048613: {
                    stringBuffer.append('[');
                    stringBuffer.append(Group.getGroup3((short)token.intValue));
                    stringBuffer.append(']');
                    continue block26;
                }
                case 1048612: {
                    stringBuffer.append('[');
                    stringBuffer.append(token.value);
                    stringBuffer.append(']');
                    continue block26;
                }
                case 0x100020: {
                    stringBuffer.append("*.");
                    break;
                }
                case 0x300005: {
                    if (!(token.value instanceof Point3f)) break;
                    Point3f point3f = (Point3f)token.value;
                    stringBuffer.append("cell={").append(point3f.x).append(" ").append(point3f.y).append(" ").append(point3f.z).append("}");
                    continue block26;
                }
                case 4: {
                    stringBuffer.append("\"").append(token.value).append("\"");
                    continue block26;
                }
                case 0x1100160: 
                case 0x1100161: 
                case 17826146: 
                case 17826147: 
                case 17826148: 
                case 17826149: {
                    if (token.intValue == 141558028) {
                        stringBuffer.append((String)this.statement[++i].value).append(" ");
                        break;
                    }
                    if (token.intValue == Integer.MAX_VALUE) break;
                    stringBuffer.append(Token.nameOf(token.intValue)).append(" ");
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    if (!this.logMessages) break;
                    stringBuffer.append(token.toString());
                    continue block26;
                }
            }
            if (token.value == null) continue;
            stringBuffer.append(token.value.toString());
        }
        if (this.iToken >= this.statementLength - 1) {
            stringBuffer.append(" <<");
        }
        return stringBuffer.toString();
    }

    String contextTrace() {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            String string = (this.functionName == null ? "" : " function " + this.functionName) + " file " + this.filename;
            stringBuffer.append(Eval.setErrorLineMessage(string, this.getLinenumber(), this.pc, this.statementAsString()));
            if (this.scriptLevel <= 0) break;
            this.popContext();
        }
        return stringBuffer.toString();
    }

    static String setErrorLineMessage(String string, int n, int n2, String string2) {
        String string3 = "\n----";
        if (string != null) {
            string3 = string3 + "line " + n + " command " + (n2 + 1) + " of " + string + ":";
        }
        string3 = string3 + "\n         " + string2;
        return string3;
    }

    class Rpn {
        private Token[] oStack;
        private Token[] xStack;
        private int oPt = -1;
        private int xPt = -1;
        private int maxLevel;
        private int parenCount;
        private int squareCount;
        private int braceCount;
        private boolean wasX;
        private boolean isAssignment;
        private boolean asVector;

        Rpn(int n, boolean bl, boolean bl2) {
            this.isAssignment = bl;
            this.maxLevel = n;
            this.asVector = bl2;
            this.oStack = new Token[n];
            this.xStack = new Token[n];
            if (Eval.this.logMessages) {
                Logger.info((String)"initialize RPN");
            }
        }

        Token getResult(boolean bl, String string) throws ScriptException {
            boolean bl2 = true;
            Token token = null;
            int n = Integer.MAX_VALUE;
            while (bl2 && this.oPt >= 0) {
                bl2 = this.operate();
            }
            if (bl2 && this.isAssignment && this.xPt == 2 && this.xStack[1].tok == 0x1100020) {
                token = this.xStack[2];
                n = Token.iValue(this.xStack[0]);
                this.xPt = 0;
            } else if (bl2 && this.asVector) {
                Vector<Token> vector = new Vector<Token>();
                for (int i = 0; i <= this.xPt; ++i) {
                    vector.addElement(Token.selectItem(this.xStack[i]));
                }
                return new Token(4161, vector);
            }
            if (bl2 && this.xPt == 0) {
                if (token == null) {
                    token = this.xStack[0];
                }
                if (token.tok == 0x4000007 || token.tok == 6 || token.tok == 4) {
                    token = this.xStack[0] = Token.selectItem(token);
                }
                if (n == Integer.MAX_VALUE && string != null && string.length() > 0 && !Eval.this.isSyntaxCheck) {
                    Eval.this.viewer.setListVariable(string, token.tok == 6 ? token : null);
                }
                if (n != Integer.MAX_VALUE || token.tok == 6) {
                    token = new Token(4, n, Token.sValue(token));
                }
                return token;
            }
            if (!(bl || this.xPt < 0 && this.oPt < 0)) {
                Eval.this.error(20);
            }
            return null;
        }

        boolean addX(Token token) throws ScriptException {
            if (this.xPt + 1 == this.maxLevel) {
                this.stackOverflow();
            }
            if (this.wasX && token.tok == 2 && token.intValue < 0) {
                this.addOp(Token.tokenMinus);
                this.xStack[++this.xPt] = Token.intToken(-token.intValue);
            } else if (this.wasX && token.tok == 3 && ((Float)token.value).floatValue() < 0.0f) {
                this.addOp(Token.tokenMinus);
                this.xStack[++this.xPt] = new Token(3, new Float(-Token.fValue(token)));
            } else {
                this.xStack[++this.xPt] = token;
            }
            if (Eval.this.logMessages) {
                Logger.info((String)("addX token " + token));
            }
            this.wasX = true;
            return true;
        }

        boolean addX(Object object) throws ScriptException {
            if (object instanceof Integer) {
                return this.addX((Integer)object);
            }
            if (object instanceof Float) {
                return this.addX(((Float)object).floatValue());
            }
            if (object instanceof String) {
                return this.addX((String)object);
            }
            if (object instanceof Vector3f) {
                return this.addX(new Point3f((Tuple3f)((Vector3f)object)));
            }
            if (object instanceof Point3f) {
                return this.addX((Point3f)object);
            }
            if (object instanceof Point4f) {
                return this.addX((Point4f)object);
            }
            if (object instanceof BitSet) {
                return this.addX((BitSet)object);
            }
            if (object instanceof Token) {
                return this.addX((Token)object);
            }
            return false;
        }

        boolean addX(boolean bl) {
            if (++this.xPt >= this.maxLevel) {
                this.stackOverflow();
            }
            this.xStack[this.xPt] = bl ? Token.tokenOn : Token.tokenOff;
            return true;
        }

        boolean addX(int n) {
            if (++this.xPt >= this.maxLevel) {
                this.stackOverflow();
            }
            this.xStack[this.xPt] = Token.intToken(n);
            this.wasX = true;
            return true;
        }

        boolean addX(float f) {
            if (++this.xPt >= this.maxLevel) {
                this.stackOverflow();
            }
            this.xStack[this.xPt] = new Token(3, new Float(f));
            this.wasX = true;
            return true;
        }

        boolean addX(String string) {
            if (++this.xPt >= this.maxLevel) {
                this.stackOverflow();
            }
            this.xStack[this.xPt] = new Token(4, string);
            this.wasX = true;
            return true;
        }

        boolean addX(String[] stringArray) {
            if (++this.xPt >= this.maxLevel) {
                this.stackOverflow();
            }
            this.xStack[this.xPt] = new Token(6, stringArray);
            this.wasX = true;
            return true;
        }

        boolean addX(Point3f point3f) {
            if (++this.xPt >= this.maxLevel) {
                this.stackOverflow();
            }
            this.xStack[this.xPt] = new Token(7, point3f);
            this.wasX = true;
            return true;
        }

        boolean addX(Point4f point4f) {
            if (++this.xPt >= this.maxLevel) {
                this.stackOverflow();
            }
            this.xStack[this.xPt] = new Token(8, point4f);
            this.wasX = true;
            return true;
        }

        boolean addX(BitSet bitSet) {
            if (++this.xPt >= this.maxLevel) {
                this.stackOverflow();
            }
            this.xStack[this.xPt] = new Token(0x4000007, bitSet);
            this.wasX = true;
            return true;
        }

        boolean isOpFunc(Token token) {
            return Compiler.tokAttr(token.tok, 0x900000) || token.tok == 0x11000A1 && Compiler.tokAttr(token.intValue, 0x900000);
        }

        boolean addOp(Token token) throws ScriptException {
            boolean bl;
            if (Eval.this.logMessages) {
                this.dumpStacks();
                Logger.info((String)("\naddOp: " + token));
            }
            Token token2 = null;
            boolean bl2 = false;
            boolean bl3 = bl = token.tok == 0x11000A1;
            if (bl && !this.wasX) {
                return false;
            }
            boolean bl4 = this.isOpFunc(token);
            if (this.oPt >= 1 && token.tok != 0x1100000 && this.oStack[this.oPt].tok == 9439234) {
                --this.oPt;
            }
            boolean bl5 = this.oPt >= 1 && this.oStack[this.oPt].tok == 0x1100000;
            switch (token.tok) {
                case 0x1100010: {
                    if (this.wasX) break;
                    return false;
                }
                case 32: 
                case 64: 
                case 96: {
                    int n;
                    int n2 = n = this.oPt < 0 ? 0 : this.oStack[this.oPt].tok;
                    if (!this.wasX || n != 0x11000A1 && n != 141557762 && n != 0x700001) {
                        return false;
                    }
                    this.oStack[this.oPt].intValue |= token.tok;
                    return true;
                }
                case 0x1100020: {
                    bl2 = true;
                    break;
                }
                case 0x1100070: {
                    if (this.wasX) break;
                    this.addX(0);
                    token = new Token(0x1100090, "-");
                    break;
                }
                case 0x1100001: {
                    if (this.wasX || this.oPt < 1 || this.oStack[this.oPt].tok != 0x1100000 || this.isOpFunc(this.oStack[this.oPt - 1])) break;
                    return false;
                }
                case 0x1100000: 
                case 0x1100050: {
                    bl2 = true;
                }
                default: {
                    if (bl4) {
                        if (!bl && this.wasX && !bl5) {
                            return false;
                        }
                        token2 = token;
                        bl2 = true;
                        break;
                    }
                    if (this.wasX != bl2) break;
                    return false;
                }
            }
            while (this.oPt >= 0 && (!bl2 && token.tok != 0x1100020 || (token.tok == 0x11000A1 || token.tok == 0x1100020) && this.oStack[this.oPt].tok == 0x11000A1) && Token.getPrecedence(this.oStack[this.oPt].tok) >= Token.getPrecedence(token.tok)) {
                if (Eval.this.logMessages) {
                    this.dumpStacks();
                    Logger.info((String)("\noperating, oPt=" + this.oPt + " isLeftOp=" + bl2 + " oStack[oPt]=" + Token.nameOf(this.oStack[this.oPt].tok) + "        prec=" + Token.getPrecedence(this.oStack[this.oPt].tok) + " pending op=" + Token.nameOf(token.tok) + " prec=" + Token.getPrecedence(token.tok)));
                }
                if (token.tok == 0x1100001 && this.oStack[this.oPt].tok == 0x1100000) {
                    if (this.xPt < 0) break;
                    this.xStack[this.xPt] = Token.selectItem(this.xStack[this.xPt]);
                    break;
                }
                if (token.tok == 0x1100021 && this.oStack[this.oPt].tok == 0x1100020) {
                    if (this.xPt == 0 && this.isAssignment) {
                        this.addX(Token.tokenArraySelector);
                        break;
                    }
                    if (this.doBitsetSelect()) break;
                    return false;
                }
                if (this.operate()) continue;
                return false;
            }
            if (token2 != null) {
                this.addX(token2);
            }
            switch (token.tok) {
                case 0x1100010: {
                    this.wasX = false;
                    return true;
                }
                case 0x1100000: {
                    ++this.parenCount;
                    this.wasX = false;
                    break;
                }
                case 0x1100020: {
                    ++this.squareCount;
                    this.wasX = false;
                    break;
                }
                case 0x1100001: {
                    this.wasX = true;
                    --this.oPt;
                    if (this.parenCount-- <= 0) {
                        return false;
                    }
                    if (this.oPt < 0) {
                        return true;
                    }
                    return this.isOpFunc(this.oStack[this.oPt]) ? this.evaluateFunction() : true;
                }
                case 0x1100021: {
                    this.wasX = true;
                    --this.oPt;
                    return this.squareCount-- > 0;
                }
                case 0x11000A1: {
                    this.wasX = !Compiler.tokAttr(token.intValue, 0x900000);
                    break;
                }
                case 0x10000E: {
                    ++this.braceCount;
                    this.wasX = false;
                    break;
                }
                case 0x100012: {
                    if (this.braceCount-- <= 0) {
                        return false;
                    }
                }
                default: {
                    this.wasX = false;
                }
            }
            if (++this.oPt >= this.maxLevel) {
                this.stackOverflow();
            }
            this.oStack[this.oPt] = token;
            return true;
        }

        private boolean doBitsetSelect() {
            if (this.xPt < 0 || this.xPt == 0 && !this.isAssignment) {
                return false;
            }
            int n = Token.iValue(this.xStack[this.xPt--]);
            Token token = this.xStack[this.xPt];
            switch (token.tok) {
                default: {
                    token = new Token(4, Token.sValue(token));
                }
                case 4: 
                case 6: 
                case 0x4000007: 
            }
            this.xStack[this.xPt] = Token.selectItem(token, n);
            return true;
        }

        void dumpStacks() {
            int n;
            Logger.info((String)"RPN stacks:");
            for (n = 0; n <= this.xPt; ++n) {
                Logger.info((String)("x[" + n + "]: " + this.xStack[n]));
            }
            Logger.info((String)"\n");
            for (n = 0; n <= this.oPt; ++n) {
                Logger.info((String)("o[" + n + "]: " + this.oStack[n] + " prec=" + Token.getPrecedence(this.oStack[n].tok)));
            }
        }

        Token getX() throws ScriptException {
            if (this.xPt < 0) {
                Eval.this.error(11);
            }
            return this.xStack[this.xPt--];
        }

        private boolean evaluateFunction() throws ScriptException {
            Token token = this.oStack[this.oPt--];
            int n = token.tok == 0x11000A1 ? token.intValue : token.tok;
            int n2 = Token.getMaxMathParams(n);
            int n3 = 0;
            int n4 = this.xPt;
            while (n4 >= 0 && this.xStack[n4--] != token) {
                ++n3;
            }
            if (n2 > 0 && n3 > n2) {
                return false;
            }
            Token[] tokenArray = new Token[n3];
            int n5 = n3;
            while (--n5 >= 0) {
                tokenArray[n5] = Token.selectItem(this.getX());
            }
            --this.xPt;
            if (Eval.this.isScriptCheck) {
                return token.tok == 0x11000A1 ? true : this.addX(true);
            }
            switch (n) {
                case 15729665: {
                    if (token.tok == 0x11000A1) {
                        return this.evaluateDistance(tokenArray);
                    }
                }
                case 9439233: {
                    return this.evaluateMeasure(tokenArray, token.tok == 9439233);
                }
                case 9670657: {
                    return this.evaluateUserFunction((String)token.value, tokenArray);
                }
                case 15729155: {
                    return this.evaluateFind(tokenArray);
                }
                case 15729667: {
                    return this.evaluateReplace(tokenArray);
                }
                case 0x900001: {
                    return this.evaluateArray(tokenArray);
                }
                case 9437701: 
                case 9437702: 
                case 9437703: 
                case 9439237: 
                case 9443332: {
                    return this.evaluateMath(tokenArray, n);
                }
                case 9438211: {
                    return this.evaluateCross(tokenArray);
                }
                case 9438209: {
                    return this.evaluateRandom(tokenArray);
                }
                case 0xF00200: 
                case 15729153: 
                case 0xF00202: {
                    return this.evaluateString(token.intValue, tokenArray);
                }
                case 15729156: 
                case 15729157: 
                case 15729158: 
                case 15729159: {
                    return this.evaluateList(token.intValue, tokenArray);
                }
                case 150491656: {
                    return this.evaluateLabel(tokenArray);
                }
                case 9442306: {
                    return this.evaluateData(tokenArray);
                }
                case 9441793: {
                    return this.evaluateLoad(tokenArray);
                }
                case 9441283: {
                    return this.evaluateWrite(tokenArray);
                }
                case 9441795: 
                case 9458180: {
                    return this.evaluateScript(tokenArray, n == 9458180);
                }
                case 9439745: {
                    return this.evaluateWithin(tokenArray);
                }
                case 9441282: {
                    return this.evaluateGetProperty(tokenArray);
                }
                case 9439235: {
                    return this.evaluatePoint(tokenArray);
                }
                case 9439234: {
                    return this.evaluatePlane(tokenArray);
                }
                case 9439746: {
                    return this.evaluateConnected(tokenArray);
                }
                case 0x900202: {
                    return this.evaluateSubstructure(tokenArray);
                }
            }
            return false;
        }

        private boolean evaluateDistance(Token[] tokenArray) throws ScriptException {
            Token token = this.getX();
            if (tokenArray.length != 1) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX(1.0f);
            }
            Token token2 = tokenArray[0];
            Point3f point3f = this.ptValue(token2);
            Point4f point4f = this.planeValue(token2);
            if (token.tok == 0x4000007) {
                return this.addX(Eval.this.getBitsetProperty(Token.bsSelect(token), 15729665, point3f, point4f, token.value, null, false, Token.Token2.bsItem2(token)));
            }
            Point3f point3f2 = this.ptValue(token);
            Point4f point4f2 = this.planeValue(token);
            if (point4f2 == null) {
                return this.addX(point4f == null ? point3f.distance(point3f2) : Graphics3D.distanceToPlane((Point4f)point4f, (Point3f)point3f2));
            }
            return this.addX(Graphics3D.distanceToPlane((Point4f)point4f2, (Point3f)point3f));
        }

        private boolean evaluateMeasure(Token[] tokenArray, boolean bl) throws ScriptException {
            int n = tokenArray.length;
            if (n < (bl ? 3 : 2) || n > (bl ? 4 : 2)) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX(1.0f);
            }
            Point3f[] point3fArray = new Point3f[n];
            for (int i = 0; i < n; ++i) {
                point3fArray[i] = this.ptValue(tokenArray[i]);
            }
            switch (n) {
                case 2: {
                    return this.addX(point3fArray[0].distance(point3fArray[1]));
                }
                case 3: {
                    return this.addX(Measure.computeAngle((Point3f)point3fArray[0], (Point3f)point3fArray[1], (Point3f)point3fArray[2], (boolean)true));
                }
                case 4: {
                    return this.addX(Measure.computeTorsion((Point3f)point3fArray[0], (Point3f)point3fArray[1], (Point3f)point3fArray[2], (Point3f)point3fArray[3], (boolean)true));
                }
            }
            return false;
        }

        private boolean evaluateUserFunction(String string, Token[] tokenArray) throws ScriptException {
            if (Eval.this.isSyntaxCheck) {
                return this.addX(1);
            }
            Vector<Token> vector = new Vector<Token>();
            for (int i = 0; i < tokenArray.length; ++i) {
                vector.addElement(tokenArray[i]);
            }
            Token token = Eval.this.getFunctionReturn(string, vector);
            this.wasX = false;
            return token == null ? false : this.addX(token);
        }

        private boolean evaluateFind(Token[] tokenArray) throws ScriptException {
            if (tokenArray.length != 1) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX(1);
            }
            Token token = this.getX();
            String string = Token.sValue(tokenArray[0]);
            switch (token.tok) {
                default: {
                    return this.addX(Token.sValue(token).indexOf(string) + 1);
                }
                case 6: 
            }
            int n = 0;
            String[] stringArray = (String[])token.value;
            int n2 = -1;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].indexOf(string) < 0) continue;
                ++n;
                n2 = i;
            }
            if (n == 1) {
                return this.addX(stringArray[n2]);
            }
            String[] stringArray2 = new String[n];
            if (n > 0) {
                int n3 = stringArray.length;
                while (--n3 >= 0) {
                    if (stringArray[n3].indexOf(string) < 0) continue;
                    stringArray2[--n] = stringArray[n3];
                }
            }
            return this.addX(stringArray2);
        }

        private boolean evaluateGetProperty(Token[] tokenArray) throws ScriptException {
            Object object;
            Object object2;
            String string;
            if (Eval.this.isSyntaxCheck) {
                return this.addX("");
            }
            int n = 0;
            String string2 = string = tokenArray.length > n ? Token.sValue(tokenArray[n++]).toLowerCase() : "";
            Object object3 = tokenArray.length > n && tokenArray[n].tok == 0x4000007 ? Token.bsSelect(tokenArray[n++]) : (object2 = tokenArray.length > n && tokenArray[n].tok == 4 && PropertyManager.acceptsStringParameter(string) ? tokenArray[n++].value : "");
            if (string.equalsIgnoreCase("fileContents") && tokenArray.length > 2) {
                object = Token.sValue(tokenArray[1]);
                for (int i = 2; i < tokenArray.length; ++i) {
                    object = (String)object + "|" + Token.sValue(tokenArray[i]);
                }
                object2 = object;
                n = tokenArray.length;
            }
            object = Eval.this.viewer.getProperty(null, string, object2);
            if ((object = PropertyManager.extractProperty(object, tokenArray, n)) instanceof String) {
                return this.addX(object);
            }
            if (object instanceof Integer) {
                return this.addX(object);
            }
            if (object instanceof Float) {
                return this.addX(object);
            }
            if (object instanceof Point3f) {
                return this.addX(object);
            }
            if (object instanceof Vector3f) {
                return this.addX(new Point3f((Tuple3f)((Vector3f)object)));
            }
            if (object instanceof Vector) {
                Vector vector = (Vector)object;
                int n2 = vector.size();
                String[] stringArray = new String[n2];
                for (int i = 0; i < n2; ++i) {
                    Object e = vector.elementAt(i);
                    stringArray[i] = e instanceof String ? (String)e : Escape.toReadable(e);
                }
                return this.addX(stringArray);
            }
            return this.addX(Escape.toReadable((Object)object));
        }

        private boolean evaluatePoint(Token[] tokenArray) throws ScriptException {
            if (tokenArray.length != 1 && tokenArray.length != 3 && tokenArray.length != 4) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX(tokenArray.length == 4 ? new Point4f() : new Point3f());
            }
            switch (tokenArray.length) {
                case 1: {
                    Object object = Escape.unescapePoint((String)Token.sValue(tokenArray[0]));
                    if (object instanceof Point3f) {
                        return this.addX((Point3f)object);
                    }
                    return this.addX("" + object);
                }
                case 3: {
                    return this.addX(new Point3f(Token.fValue(tokenArray[0]), Token.fValue(tokenArray[1]), Token.fValue(tokenArray[2])));
                }
                case 4: {
                    return this.addX(new Point4f(Token.fValue(tokenArray[0]), Token.fValue(tokenArray[1]), Token.fValue(tokenArray[2]), Token.fValue(tokenArray[3])));
                }
            }
            return false;
        }

        private boolean evaluatePlane(Token[] tokenArray) throws ScriptException {
            if (tokenArray.length != 1 && tokenArray.length != 3 && tokenArray.length != 4) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX(new Point4f(0.0f, 0.0f, 1.0f, 0.0f));
            }
            switch (tokenArray.length) {
                case 1: {
                    Object object = Escape.unescapePoint((String)Token.sValue(tokenArray[0]));
                    if (object instanceof Point4f) {
                        return this.addX((Point4f)object);
                    }
                    return this.addX("" + object);
                }
                case 3: 
                case 4: {
                    switch (tokenArray[0].tok) {
                        case 7: 
                        case 0x4000007: {
                            Point3f point3f = this.ptValue(tokenArray[0]);
                            Point3f point3f2 = this.ptValue(tokenArray[1]);
                            Point3f point3f3 = this.ptValue(tokenArray[2]);
                            Vector3f vector3f = new Vector3f();
                            Vector3f vector3f2 = new Vector3f();
                            Vector3f vector3f3 = new Vector3f();
                            float f = Graphics3D.getDirectedNormalThroughPoints((Point3f)point3f, (Point3f)point3f2, (Point3f)point3f3, (Point3f)(tokenArray.length == 4 ? this.ptValue(tokenArray[3]) : null), (Vector3f)vector3f3, (Vector3f)vector3f, (Vector3f)vector3f2);
                            return this.addX(new Point4f(vector3f3.x, vector3f3.y, vector3f3.z, f));
                        }
                    }
                    if (tokenArray.length != 4) {
                        return false;
                    }
                    float f = Token.fValue(tokenArray[0]);
                    float f2 = Token.fValue(tokenArray[1]);
                    float f3 = Token.fValue(tokenArray[2]);
                    float f4 = Token.fValue(tokenArray[3]);
                    return this.addX(new Point4f(f, f2, f3, f4));
                }
            }
            return false;
        }

        private boolean evaluateReplace(Token[] tokenArray) throws ScriptException {
            String string;
            if (tokenArray.length != 2) {
                return false;
            }
            Token token = this.getX();
            if (Eval.this.isSyntaxCheck) {
                return this.addX("");
            }
            String string2 = Token.sValue(tokenArray[0]);
            String string3 = Token.sValue(tokenArray[1]);
            String string4 = string = token.tok == 6 ? null : Token.sValue(token);
            if (string != null) {
                return this.addX(TextFormat.simpleReplace((String)string, (String)string2, (String)string3));
            }
            String[] stringArray = (String[])token.value;
            int n = stringArray.length;
            while (--n >= 0) {
                stringArray[n] = TextFormat.simpleReplace((String)stringArray[n], (String)string2, (String)string3);
            }
            return this.addX(stringArray);
        }

        private boolean evaluateString(int n, Token[] tokenArray) throws ScriptException {
            String string;
            if (tokenArray.length > 1) {
                return false;
            }
            Token token = this.getX();
            if (Eval.this.isSyntaxCheck) {
                return this.addX(Token.sValue(token));
            }
            String string2 = string = n == 0xF00200 && token.tok == 0x4000007 || n == 0xF00202 && token.tok == 6 ? null : Token.sValue(token);
            String string3 = tokenArray.length == 1 ? Token.sValue(tokenArray[0]) : (n == 0xF00202 ? "" : "\n");
            switch (n) {
                case 0xF00200: {
                    if (token.tok == 0x4000007) {
                        BitSet bitSet = Token.bsSelect(token);
                        string3 = "\n";
                        int n2 = Eval.this.viewer.getModelCount();
                        string = "";
                        for (int i = 0; i < n2; ++i) {
                            string = string + (i == 0 ? "" : "\n");
                            BitSet bitSet2 = Eval.this.viewer.getModelAtomBitSet(i, true);
                            bitSet2.and(bitSet);
                            string = string + Escape.escape((BitSet)bitSet2);
                        }
                    }
                    return this.addX(TextFormat.split((String)string, (String)string3));
                }
                case 15729153: {
                    if (string.length() > 0 && string.charAt(string.length() - 1) == '\n') {
                        string = string.substring(0, string.length() - 1);
                    }
                    return this.addX(TextFormat.simpleReplace((String)string, (String)"\n", (String)string3));
                }
                case 0xF00202: {
                    if (string != null) {
                        return this.addX(TextFormat.trim((String)string, (String)string3));
                    }
                    String[] stringArray = (String[])token.value;
                    int n3 = stringArray.length;
                    while (--n3 >= 0) {
                        stringArray[n3] = TextFormat.trim((String)stringArray[n3], (String)string3);
                    }
                    return this.addX(stringArray);
                }
            }
            return this.addX("");
        }

        private boolean evaluateList(int n, Token[] tokenArray) throws ScriptException {
            String[] stringArray;
            String string;
            if (tokenArray.length != 1) {
                return false;
            }
            Token token = this.getX();
            Token token2 = tokenArray[0];
            if (token.tok != 6 && token.tok != 4) {
                this.wasX = false;
                this.addOp(Token.tokenLeftParen);
                this.addX(token);
                switch (n) {
                    case 15729156: {
                        this.addOp(Token.tokenPlus);
                        break;
                    }
                    case 15729157: {
                        this.addOp(Token.tokenMinus);
                        break;
                    }
                    case 15729158: {
                        this.addOp(Token.tokenTimes);
                        break;
                    }
                    case 15729159: {
                        this.addOp(Token.tokenDivide);
                    }
                }
                this.addX(token2);
                return this.addOp(Token.tokenRightParen);
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX("");
            }
            boolean bl = token2.tok != 6 && Token.sValue(token2).indexOf("\n") < 0;
            String string2 = string = bl ? Token.sValue(token2) : "";
            float f = string.indexOf("{") >= 0 ? Float.NaN : (bl ? Token.fValue(token2) : 0.0f);
            String[] stringArray2 = stringArray = token.value instanceof String ? TextFormat.split((String)((String)token.value), (String)"\n") : (String[])token.value;
            String[] stringArray3 = bl ? null : (token2.value instanceof String ? TextFormat.split((String)((String)token2.value), (String)"\n") : (String[])token2.value);
            int n2 = bl ? stringArray.length : Math.min(stringArray.length, stringArray3.length);
            String[] stringArray4 = new String[n2];
            float[] fArray = new float[stringArray.length];
            Parser.parseFloatArray((String[])stringArray, (float[])fArray);
            float[] fArray2 = new float[bl ? stringArray.length : stringArray3.length];
            if (bl) {
                int n3 = n2;
                while (--n3 >= 0) {
                    fArray2[n3] = f;
                }
            } else {
                Parser.parseFloatArray((String[])stringArray3, (float[])fArray2);
            }
            Token token3 = null;
            switch (n) {
                case 15729156: {
                    token3 = Token.tokenPlus;
                    break;
                }
                case 15729157: {
                    token3 = Token.tokenMinus;
                    break;
                }
                case 15729158: {
                    token3 = Token.tokenTimes;
                    break;
                }
                case 15729159: {
                    token3 = Token.tokenDivide;
                }
            }
            for (int i = 0; i < n2; ++i) {
                if (Float.isNaN(fArray[i])) {
                    this.addX(Token.unescapePointOrBitsetAsToken(stringArray[i]));
                } else {
                    this.addX(fArray[i]);
                }
                if (!Float.isNaN(fArray2[i])) {
                    this.addX(fArray2[i]);
                } else if (bl) {
                    this.addX(Token.unescapePointOrBitsetAsToken(string));
                } else {
                    this.addX(Token.unescapePointOrBitsetAsToken(stringArray3[i]));
                }
                if (!this.addOp(token3) || !this.operate()) {
                    return false;
                }
                stringArray4[i] = Token.sValue(this.xStack[this.xPt--]);
            }
            return this.addX(stringArray4);
        }

        private boolean evaluateArray(Token[] tokenArray) {
            if (Eval.this.isSyntaxCheck) {
                return this.addX("");
            }
            int n = tokenArray.length;
            if (n == 0) {
                n = 1;
            }
            String[] stringArray = new String[n];
            stringArray[0] = "";
            for (int i = 0; i < tokenArray.length; ++i) {
                stringArray[i] = Token.sValue(tokenArray[i]);
            }
            return this.addX(stringArray);
        }

        private boolean evaluateMath(Token[] tokenArray, int n) {
            if (n == 9443332 || n == 9439237) {
                if (tokenArray.length != 1 && tokenArray.length != 2 && tokenArray.length != 4 || tokenArray.length == 2 && tokenArray[0].tok != 7) {
                    return false;
                }
                if (Eval.this.isSyntaxCheck) {
                    return this.addX(new Point4f(0.0f, 0.0f, 0.0f, 1.0f));
                }
                Quaternion quaternion = null;
                Point4f point4f = null;
                switch (tokenArray.length) {
                    case 4: {
                        if (n == 9443332) {
                            point4f = new Point4f(Token.fValue(tokenArray[1]), Token.fValue(tokenArray[2]), Token.fValue(tokenArray[3]), Token.fValue(tokenArray[0]));
                            break;
                        }
                        quaternion = new Quaternion((Tuple3f)new Point3f(Token.fValue(tokenArray[0]), Token.fValue(tokenArray[1]), Token.fValue(tokenArray[2])), Token.fValue(tokenArray[3]));
                        break;
                    }
                    case 2: {
                        quaternion = new Quaternion((Tuple3f)((Point3f)tokenArray[0].value), Token.fValue(tokenArray[1]));
                        break;
                    }
                    default: {
                        if (tokenArray[0].tok == 8) {
                            point4f = (Point4f)tokenArray[0].value;
                        } else if (tokenArray[0].tok == 0x4000007 && n == 9443332) {
                            int n2 = BitSetUtil.firstSetBit((BitSet)((BitSet)tokenArray[0].value));
                            if (n2 < 0 || (quaternion = Eval.this.viewer.getModelSet().getAtomAt(n2).getQuaternion(Eval.this.viewer.getQuaternionFrame())) == null) {
                                return this.addX(0);
                            }
                        } else {
                            Object object = Escape.unescapePoint((String)Token.sValue(tokenArray[0]));
                            if (!(object instanceof Point4f)) {
                                return false;
                            }
                            point4f = (Point4f)object;
                        }
                        if (n != 9439237) break;
                        quaternion = new Quaternion((Tuple3f)new Point3f(point4f.x, point4f.y, point4f.z), point4f.w);
                    }
                }
                if (quaternion == null) {
                    quaternion = new Quaternion(point4f);
                }
                return this.addX(quaternion.toPoint4f());
            }
            if (tokenArray.length != 1) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX(1);
            }
            double d = Token.fValue(tokenArray[0]);
            switch (n) {
                case 9437702: {
                    return this.addX((float)Math.cos(d * Math.PI / 180.0));
                }
                case 9437701: {
                    return this.addX((float)Math.sin(d * Math.PI / 180.0));
                }
                case 9437703: {
                    return this.addX((float)Math.sqrt(d));
                }
            }
            return false;
        }

        private boolean evaluateRandom(Token[] tokenArray) {
            if (tokenArray.length > 2) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX(1);
            }
            float f = tokenArray.length < 2 ? 0.0f : Token.fValue(tokenArray[0]);
            float f2 = tokenArray.length == 0 ? 1.0f : Token.fValue(tokenArray[tokenArray.length - 1]);
            return this.addX((float)(Math.random() * (double)(f2 -= f)) + f);
        }

        private boolean evaluateCross(Token[] tokenArray) {
            if (tokenArray.length != 2) {
                return false;
            }
            Token token = tokenArray[0];
            Token token2 = tokenArray[1];
            if (token.tok != 7 || token2.tok != 7) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX(new Point3f());
            }
            Vector3f vector3f = new Vector3f((Tuple3f)((Point3f)token.value));
            Vector3f vector3f2 = new Vector3f((Tuple3f)((Point3f)token2.value));
            vector3f.cross(vector3f, vector3f2);
            return this.addX(new Point3f((Tuple3f)vector3f));
        }

        private boolean evaluateLoad(Token[] tokenArray) {
            if (tokenArray.length != 1) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX("");
            }
            return this.addX(Eval.this.viewer.getFileAsString(Token.sValue(tokenArray[0])));
        }

        private boolean evaluateWrite(Token[] tokenArray) throws ScriptException {
            if (tokenArray.length == 0) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX("");
            }
            return this.addX(Eval.this.write(tokenArray));
        }

        private boolean evaluateScript(Token[] tokenArray, boolean bl) throws ScriptException {
            if (tokenArray.length != 1) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX("");
            }
            String string = Token.sValue(tokenArray[0]);
            if (bl) {
                return this.addX(Eval.this.viewer.eval(string));
            }
            StringBuffer stringBuffer = new StringBuffer();
            Eval.this.runScript(string, stringBuffer);
            return this.addX(stringBuffer.toString());
        }

        private boolean evaluateData(Token[] tokenArray) {
            String string;
            if (tokenArray.length == 0 || tokenArray.length > 2) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX("");
            }
            String string2 = Token.sValue(tokenArray[0]);
            String string3 = string = tokenArray.length == 2 ? Token.sValue(tokenArray[1]) : "";
            if (string2.indexOf("property_") == 0) {
                float[] fArray;
                float[] fArray2 = Eval.this.viewer.getDataFloat(string2);
                if (fArray2 == null) {
                    return this.addX("");
                }
                float[] fArray3 = fArray = string.indexOf("property_") == 0 ? Eval.this.viewer.getDataFloat(string) : null;
                if (fArray != null) {
                    fArray2 = (float[])fArray2.clone();
                    int n = Math.min(fArray2.length, fArray.length);
                    while (--n >= 0) {
                        int n2 = n;
                        fArray2[n2] = fArray2[n2] + fArray[n];
                    }
                }
                return this.addX(Escape.escape((float[])fArray2));
            }
            if (string2.indexOf("data2d_") == 0) {
                float[][] fArray = Eval.this.viewer.getDataFloat2D(string2);
                if (fArray == null) {
                    return this.addX("");
                }
                if (tokenArray.length == 2 && tokenArray[1].tok == 2) {
                    int n = tokenArray[1].intValue;
                    if (n < 0) {
                        n += fArray.length;
                    }
                    if (n >= 0 && n < fArray.length) {
                        return this.addX(Escape.escape((float[])fArray[n]));
                    }
                    return this.addX("");
                }
                return this.addX(Escape.escape((float[][])fArray, (boolean)false));
            }
            if (tokenArray.length == 1) {
                Object[] objectArray = Eval.this.viewer.getData(string2);
                return this.addX(objectArray == null ? "" : "" + objectArray[1]);
            }
            return this.addX(Eval.this.viewer.getData(string2, string));
        }

        private boolean evaluateLabel(Token[] tokenArray) throws ScriptException {
            String string;
            Token token = this.getX();
            String string2 = string = tokenArray.length == 0 ? "%U" : Token.sValue(tokenArray[0]);
            if (tokenArray.length > 1 || token.tok != 0x4000007) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX("");
            }
            return this.addX(Eval.this.getBitsetIdent(Token.bsSelect(token), string, token.value, true));
        }

        private boolean evaluateWithin(Token[] tokenArray) {
            boolean bl;
            if (tokenArray.length < 1) {
                return false;
            }
            int n = tokenArray.length;
            Object object = tokenArray[0].value;
            int n2 = tokenArray[0].tok;
            String string = "" + object;
            BitSet bitSet = new BitSet();
            float f = 0.0f;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = bl = n2 == 3 || n2 == 2;
            if (string.equals("branch")) {
                if (n != 3 || !(tokenArray[1].value instanceof BitSet) || !(tokenArray[2].value instanceof BitSet)) {
                    return false;
                }
                return this.addX(Eval.this.viewer.getBranchBitSet(BitSetUtil.firstSetBit((BitSet)((BitSet)tokenArray[2].value)), BitSetUtil.firstSetBit((BitSet)((BitSet)tokenArray[1].value))));
            }
            if (object instanceof String) {
                bl2 = !Parser.isOneOf((String)string, (String)"element;site;group;chain;structure;molecule;model;boundbox");
            } else if (bl) {
                f = Token.fValue(tokenArray[0]);
                if (n < 2) {
                    return false;
                }
                if (tokenArray[1].tok == 0x100011 || tokenArray[1].tok == 0x100010) {
                    bl4 = Token.bValue(tokenArray[1]);
                    n = 0;
                }
            } else {
                return false;
            }
            if (n == 3) {
                string = Token.sValue(tokenArray[1]);
                if (!Parser.isOneOf((String)string, (String)"on;off;plane;hkl;coord")) {
                    return false;
                }
            } else if (n == 1) {
                if (!string.equals("boundbox")) {
                    return false;
                }
                bl3 = true;
            }
            Point3f point3f = null;
            Point4f point4f = null;
            n = tokenArray.length - 1;
            if (tokenArray[n].value instanceof Point4f) {
                point4f = (Point4f)tokenArray[n].value;
            } else if (tokenArray[n].value instanceof Point3f) {
                point3f = (Point3f)tokenArray[n].value;
            }
            if (n > 0 && point4f == null && point3f == null && !(tokenArray[n].value instanceof BitSet)) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX(bitSet);
            }
            if (point4f != null) {
                return this.addX(Eval.this.viewer.getAtomsWithin(f, point4f));
            }
            if (point3f != null) {
                return this.addX(Eval.this.viewer.getAtomsWithin(f, point3f));
            }
            BitSet bitSet2 = bitSet = bl3 ? null : Token.bsSelect(tokenArray[n]);
            if (bl) {
                return this.addX(Eval.this.viewer.getAtomsWithin(f, bitSet, bl4));
            }
            if (bl2) {
                return this.addX(Eval.this.viewer.getSequenceBits(string, bitSet));
            }
            return this.addX(Eval.this.viewer.getAtomBits(Token.getTokenFromName((String)string).tok, bitSet));
        }

        private boolean evaluateConnected(Token[] tokenArray) throws ScriptException {
            float f = -2.1474836E9f;
            float f2 = 2.1474836E9f;
            float f3 = 0.0f;
            float f4 = Float.MAX_VALUE;
            short s = 16383;
            BitSet bitSet = null;
            BitSet bitSet2 = null;
            boolean bl = false;
            boolean bl2 = false;
            block5: for (int i = 0; i < tokenArray.length; ++i) {
                Token token = tokenArray[i];
                switch (token.tok) {
                    case 0x4000007: {
                        bl2 = token.value instanceof Bond.BondSet;
                        if (bl2 && bitSet != null) {
                            return false;
                        }
                        if (bitSet == null) {
                            bitSet = Token.bsSelect(token);
                            continue block5;
                        }
                        if (bitSet2 == null) {
                            bitSet2 = Token.bsSelect(token);
                            continue block5;
                        }
                        return false;
                    }
                    case 4: {
                        s = JmolConstants.getBondOrderFromString(Token.sValue(token));
                        if (s != Short.MAX_VALUE) continue block5;
                        return false;
                    }
                    case 3: {
                        bl = true;
                    }
                    default: {
                        int n = Token.iValue(token);
                        float f5 = Token.fValue(token);
                        if (f2 != 2.1474836E9f) {
                            return false;
                        }
                        if (f == -2.1474836E9f) {
                            f = Math.max(n, 1);
                            f3 = f5;
                            continue block5;
                        }
                        f2 = n;
                        f4 = f5;
                    }
                }
            }
            if (f == -2.1474836E9f) {
                f = 1.0f;
                f2 = 100.0f;
                f3 = 0.1f;
                f4 = 1.0E8f;
            } else if (f2 == 2.1474836E9f) {
                f2 = f;
                f4 = f3;
                f3 = 0.1f;
            }
            if (bitSet == null) {
                bitSet = Eval.this.viewer.getModelAtomBitSet(-1, true);
            }
            if (bl && bitSet2 == null) {
                bitSet2 = bitSet;
            }
            if (bitSet2 != null) {
                BitSet bitSet3 = new BitSet();
                if (Eval.this.isSyntaxCheck) {
                    return this.addX(new Token(0x4000007, new Bond.BondSet(bitSet3)));
                }
                Eval.this.viewer.makeConnections(f3, f4, s, 5, bitSet, bitSet2, bitSet3, bl2);
                return this.addX(new Token(0x4000007, new Bond.BondSet(bitSet3, Eval.this.viewer.getAtomIndices(Eval.this.viewer.getAtomBits(141557762, bitSet3)))));
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX(bitSet);
            }
            return this.addX(Eval.this.viewer.getAtomsConnected(f, f2, s, bitSet));
        }

        private boolean evaluateSubstructure(Token[] tokenArray) throws ScriptException {
            if (tokenArray.length != 1) {
                return false;
            }
            BitSet bitSet = new BitSet();
            if (Eval.this.isSyntaxCheck) {
                return this.addX(bitSet);
            }
            String string = Token.sValue(tokenArray[0]);
            if (string.length() == 0) {
                return false;
            }
            try {
                SmilesMatcherInterface smilesMatcherInterface = (SmilesMatcherInterface)Class.forName("org.jmol.smiles.PatternMatcher").newInstance();
                smilesMatcherInterface.setViewer(Eval.this.viewer);
                bitSet = smilesMatcherInterface.getSubstructureSet(string);
            }
            catch (Exception exception) {
                Eval.this.evalError(exception.getMessage());
            }
            return this.addX(bitSet);
        }

        private boolean operate() throws ScriptException {
            Token token = this.oStack[this.oPt--];
            if (this.oPt < 0 && token.tok == 17826148 && this.isAssignment && this.xPt == 2) {
                return true;
            }
            Token token2 = this.getX();
            if (token2 == Token.tokenArraySelector) {
                return false;
            }
            if (token2.tok == 6) {
                token2 = Token.selectItem(token2);
            }
            if (token.tok == 0x1100050) {
                return Eval.this.isScriptCheck ? this.addX(true) : (token2.tok == 8 ? this.addX(new Quaternion((Point4f)token2.value).inv().toPoint4f()) : (token2.tok == 0x4000007 ? this.addX(BitSetUtil.copyInvert((BitSet)Token.bsSelect(token2), (int)(token2.value instanceof Bond.BondSet ? Eval.this.viewer.getBondCount() : Eval.this.viewer.getAtomCount()))) : this.addX(!Token.bValue(token2))));
            }
            int n = token.intValue & 0xFFFFFF9F;
            if (token.tok == 0x11000A1) {
                switch (n) {
                    case 0x700007: {
                        return this.addX(Token.sizeOf(token2));
                    }
                    case 0x700008: {
                        return this.addX(Token.typeOf(token2));
                    }
                    case 0x700006: {
                        if (token2.tok != 4) {
                            return Eval.this.isScriptCheck ? this.addX(1) : false;
                        }
                        String string = (String)token2.value;
                        string = TextFormat.simpleReplace((String)string, (String)"\n\r", (String)"\n").replace('\r', '\n');
                        return this.addX(TextFormat.split((String)string, (char)'\n'));
                    }
                    case 141562115: {
                        switch (token2.tok) {
                            case 4: 
                            case 6: {
                                Point3f point3f = new Point3f();
                                return this.addX(Graphics3D.colorPointFromString((String)Token.sValue(token2), (Point3f)point3f));
                            }
                            case 2: 
                            case 3: {
                                return this.addX(Eval.this.viewer.getColorPointForPropertyValue(Token.fValue(token2)));
                            }
                            case 7: {
                                return this.addX(Escape.escapeColor((int)Eval.colorPtToInt((Point3f)token2.value)));
                            }
                        }
                        break;
                    }
                    case 142086157: {
                        return Eval.this.isScriptCheck ? this.addX("x") : this.evaluateBoundBox(token2);
                    }
                }
                if (Eval.this.isScriptCheck) {
                    return this.addX(Token.sValue(token2));
                }
                if (token2.tok == 4) {
                    Object object = Token.unescapePointOrBitsetAsToken(Token.sValue(token2));
                    if (!(object instanceof Token)) {
                        return false;
                    }
                    token2 = (Token)object;
                }
                return this.evaluatePointOrBitsetOperation(token, token2);
            }
            Token token3 = this.getX();
            if (Eval.this.isScriptCheck) {
                return this.addX(Token.sValue(token3));
            }
            if (token3.tok == 6) {
                token3 = Token.selectItem(token3);
            }
            switch (token.tok) {
                case 0x1100040: {
                    if (token3.tok == 0x4000007 && token2.tok == 0x4000007) {
                        BitSet bitSet = Token.bsSelect(token3);
                        bitSet.and(Token.bsSelect(token2));
                        return this.addX(bitSet);
                    }
                    return this.addX(Token.bValue(token3) && Token.bValue(token2));
                }
                case 0x1100030: {
                    if (token3.tok == 0x4000007 && token2.tok == 0x4000007) {
                        BitSet bitSet = Token.bsSelect(token3);
                        bitSet.or(Token.bsSelect(token2));
                        return this.addX(bitSet);
                    }
                    return this.addX(Token.bValue(token3) || Token.bValue(token2));
                }
                case 0x1100031: {
                    if (token3.tok == 0x4000007 && token2.tok == 0x4000007) {
                        BitSet bitSet = Token.bsSelect(token3);
                        bitSet.xor(Token.bsSelect(token2));
                        return this.addX(bitSet);
                    }
                    boolean bl = Token.bValue(token3);
                    boolean bl2 = Token.bValue(token2);
                    return this.addX(bl && !bl2 || bl2 && !bl);
                }
                case 17825842: {
                    if (token3.tok != 0x4000007 || token2.tok != 0x4000007) {
                        return false;
                    }
                    return this.addX(BitSetUtil.toggleInPlace((BitSet)Token.bsSelect(token3), (BitSet)Token.bsSelect(token2), (int)Eval.this.viewer.getAtomCount()));
                }
                case 17826146: {
                    return this.addX(Token.fValue(token3) <= Token.fValue(token2));
                }
                case 0x1100161: {
                    return this.addX(Token.fValue(token3) >= Token.fValue(token2));
                }
                case 0x1100160: {
                    return this.addX(Token.fValue(token3) > Token.fValue(token2));
                }
                case 17826147: {
                    return this.addX(Token.fValue(token3) < Token.fValue(token2));
                }
                case 17826148: {
                    if (token3.tok == 4 && token2.tok == 4) {
                        return this.addX(Token.sValue(token3).equalsIgnoreCase(Token.sValue(token2)));
                    }
                    if (token3.tok == 7 && token2.tok == 7) {
                        return this.addX((double)((Point3f)token3.value).distance((Point3f)token2.value) < 1.0E-6);
                    }
                    if (token3.tok == 8 && token2.tok == 8) {
                        return this.addX((double)((Point4f)token3.value).distance((Point4f)token2.value) < 1.0E-6);
                    }
                    return this.addX((double)Math.abs(Token.fValue(token3) - Token.fValue(token2)) < 1.0E-6);
                }
                case 17826149: {
                    if (token3.tok == 4 && token2.tok == 4) {
                        return this.addX(!Token.sValue(token3).equalsIgnoreCase(Token.sValue(token2)));
                    }
                    if (token3.tok == 7 && token2.tok == 7) {
                        return this.addX((double)((Point3f)token3.value).distance((Point3f)token2.value) >= 1.0E-6);
                    }
                    if (token3.tok == 8 && token2.tok == 8) {
                        return this.addX((double)((Point4f)token3.value).distance((Point4f)token2.value) >= 1.0E-6);
                    }
                    return this.addX((double)Math.abs(Token.fValue(token3) - Token.fValue(token2)) >= 1.0E-6);
                }
                case 0x1100071: {
                    String string;
                    if (token3.tok == 6 || token2.tok == 6) {
                        return this.addX(Token.concatList(token3, token2));
                    }
                    if (token3.tok == 2 && (token2.tok == 4 ? (string = Token.sValue(token2).trim()).indexOf(".") < 0 && string.indexOf("+") <= 0 && string.lastIndexOf("-") <= 0 : token2.tok != 3)) {
                        return this.addX(token3.intValue + Token.iValue(token2));
                    }
                    switch (token3.tok) {
                        default: {
                            return this.addX(Token.fValue(token3) + Token.fValue(token2));
                        }
                        case 4: {
                            return this.addX(Token.sValue(token3) + Token.sValue(token2));
                        }
                        case 8: {
                            Quaternion quaternion = new Quaternion((Point4f)token3.value);
                            switch (token2.tok) {
                                default: {
                                    return this.addX(quaternion.add(Token.fValue(token2)).toPoint4f());
                                }
                                case 8: 
                            }
                            return this.addX(quaternion.mul(new Quaternion((Point4f)token2.value)).toPoint4f());
                        }
                        case 7: 
                    }
                    Point3f point3f = new Point3f((Point3f)token3.value);
                    switch (token2.tok) {
                        case 7: {
                            point3f.add((Tuple3f)((Point3f)token2.value));
                            return this.addX(point3f);
                        }
                        case 8: {
                            Point4f point4f = (Point4f)token2.value;
                            point3f.add((Tuple3f)new Point3f(point4f.x, point4f.y, point4f.z));
                            return this.addX(point3f);
                        }
                        case 2: {
                            if (!(token2.tok == 4 ? (string = Token.sValue(token2).trim()).indexOf(".") < 0 && string.indexOf("+") <= 0 && string.lastIndexOf("-") <= 0 : token2.tok != 3)) break;
                            return this.addX(token3.intValue + Token.iValue(token2));
                        }
                    }
                    float f = Token.fValue(token2);
                    return this.addX(new Point3f(point3f.x + f, point3f.y + f, point3f.z + f));
                }
                case 0x1100070: {
                    String string;
                    if (token3.tok == 2 && (token2.tok == 4 ? (string = Token.sValue(token2).trim()).indexOf(".") < 0 && string.indexOf("+") <= 0 && string.lastIndexOf("-") <= 0 : token2.tok != 3)) {
                        return this.addX(token3.intValue - Token.iValue(token2));
                    }
                    if (token3.tok == 4 && token2.tok == 2 && (string = Token.sValue(token3).trim()).indexOf(".") < 0 && string.indexOf("+") <= 0 && string.lastIndexOf("-") <= 0) {
                        return this.addX(Token.iValue(token3) - token2.intValue);
                    }
                    switch (token3.tok) {
                        default: {
                            return this.addX(Token.fValue(token3) - Token.fValue(token2));
                        }
                        case 7: {
                            Point3f point3f = new Point3f((Point3f)token3.value);
                            switch (token2.tok) {
                                default: {
                                    float f = Token.fValue(token2);
                                    return this.addX(new Point3f(point3f.x - f, point3f.y - f, point3f.z - f));
                                }
                                case 7: {
                                    point3f.sub((Tuple3f)((Point3f)token2.value));
                                    return this.addX(point3f);
                                }
                                case 8: 
                            }
                            Point4f point4f = (Point4f)token2.value;
                            point3f.sub((Tuple3f)new Point3f(point4f.x, point4f.y, point4f.z));
                            return this.addX(point3f);
                        }
                        case 8: 
                    }
                    Quaternion quaternion = new Quaternion((Point4f)token3.value);
                    switch (token2.tok) {
                        default: {
                            return this.addX(quaternion.add(-Token.fValue(token2)).toPoint4f());
                        }
                        case 8: 
                    }
                    Quaternion quaternion2 = new Quaternion((Point4f)token2.value);
                    return this.addX(quaternion2.mul(quaternion.inv()).toPoint4f());
                }
                case 0x1100090: {
                    switch (token2.tok) {
                        default: {
                            return this.addX(-Token.fValue(token2));
                        }
                        case 2: {
                            return this.addX(-Token.iValue(token2));
                        }
                        case 7: {
                            Point3f point3f = new Point3f((Point3f)token2.value);
                            point3f.scale(-1.0f);
                            return this.addX(point3f);
                        }
                        case 8: {
                            Point4f point4f = new Point4f((Point4f)token2.value);
                            point4f.scale(-1.0f);
                            return this.addX(point4f);
                        }
                        case 0x4000007: 
                    }
                    return this.addX(BitSetUtil.copyInvert((BitSet)Token.bsSelect(token2), (int)(token2.value instanceof Bond.BondSet ? Eval.this.viewer.getBondCount() : Eval.this.viewer.getAtomCount())));
                }
                case 0x1100081: {
                    if (token3.tok == 2 && token2.tok != 3) {
                        return this.addX(token3.intValue * Token.iValue(token2));
                    }
                    switch (token3.tok) {
                        default: {
                            return this.addX(Token.fValue(token3) * Token.fValue(token2));
                        }
                        case 7: {
                            Point3f point3f = new Point3f((Point3f)token3.value);
                            switch (token2.tok) {
                                case 7: {
                                    Point3f point3f2 = (Point3f)token2.value;
                                    return this.addX(point3f.x * point3f2.x + point3f.y * point3f2.y + point3f.z * point3f2.z);
                                }
                            }
                            float f = Token.fValue(token2);
                            return this.addX(new Point3f(point3f.x * f, point3f.y * f, point3f.z * f));
                        }
                        case 8: 
                    }
                    if (token2.tok == 8) {
                        Quaternion quaternion = new Quaternion((Point4f)token3.value);
                        Quaternion quaternion3 = new Quaternion((Point4f)token2.value);
                        quaternion3 = quaternion.mul(quaternion3);
                        return this.addX(new Point4f(quaternion3.q1, quaternion3.q2, quaternion3.q3, quaternion3.q0));
                    }
                    return this.addX(new Quaternion((Point4f)token3.value).mul(Token.fValue(token2)).toPoint4f());
                }
                case 17825922: {
                    String string = null;
                    int n2 = Token.iValue(token2);
                    switch (token3.tok) {
                        default: {
                            if (n2 == 0) {
                                return this.addX(0);
                            }
                            return this.addX(Token.iValue(token3) % n2);
                        }
                        case 3: {
                            float f = Token.fValue(token3);
                            if (n2 == 0) {
                                return this.addX((int)(f + 0.5f * (float)(f < 0.0f ? -1 : 1)));
                            }
                            string = TextFormat.formatDecimal((float)f, (int)n2);
                            return this.addX(string);
                        }
                        case 4: {
                            string = (String)token3.value;
                            if (n2 == 0) {
                                return this.addX(TextFormat.trim((String)string, (String)"\n\t "));
                            }
                            if (n2 > 0) {
                                return this.addX(TextFormat.format((String)string, (int)n2, (int)n2, (boolean)false, (boolean)false));
                            }
                            return this.addX(TextFormat.format((String)string, (int)(-n2), (int)n2, (boolean)true, (boolean)false));
                        }
                        case 6: {
                            String[] stringArray = (String[])token3.value;
                            String[] stringArray2 = new String[stringArray.length];
                            for (int i = 0; i < stringArray.length; ++i) {
                                stringArray2[i] = n2 == 0 ? stringArray[i].trim() : (n2 > 0 ? TextFormat.format((String)stringArray[i], (int)n2, (int)n2, (boolean)true, (boolean)false) : TextFormat.format((String)string, (int)(-n2), (int)n2, (boolean)false, (boolean)false));
                            }
                            return this.addX(stringArray2);
                        }
                        case 7: {
                            Point3f point3f = new Point3f((Point3f)token3.value);
                            Eval.this.viewer.toUnitCell(point3f, new Point3f((float)n2, (float)n2, (float)n2));
                            return this.addX(point3f);
                        }
                        case 8: {
                            Point4f point4f = (Point4f)token3.value;
                            if (token2.tok == 7) {
                                return this.addX(new Quaternion(point4f).transform((Point3f)token2.value));
                            }
                            if (token2.tok == 8) {
                                Point4f point4f2 = new Point4f((Point4f)token2.value);
                                new Quaternion(point4f).getThetaDirected(point4f2);
                                return this.addX(point4f2);
                            }
                            switch (n2) {
                                case 0: {
                                    return this.addX(point4f.w);
                                }
                                case 1: {
                                    return this.addX(point4f.x);
                                }
                                case 2: {
                                    return this.addX(point4f.y);
                                }
                                case 3: {
                                    return this.addX(point4f.z);
                                }
                                case 4: {
                                    return this.addX(new Quaternion(point4f).getNormal());
                                }
                                case -1: {
                                    return this.addX(new Quaternion(point4f).getVector(-1));
                                }
                                case -2: {
                                    return this.addX(new Quaternion(point4f).getTheta());
                                }
                                case -3: {
                                    return this.addX(new Quaternion(point4f).getVector(0));
                                }
                                case -4: {
                                    return this.addX(new Quaternion(point4f).getVector(1));
                                }
                                case -5: {
                                    return this.addX(new Quaternion(point4f).getVector(2));
                                }
                            }
                            return this.addX(point4f);
                        }
                        case 0x4000007: 
                    }
                    return this.addX(Token.bsSelect(token3, n2));
                }
                case 0x1100080: {
                    if (token3.tok == 2 && token2.tok == 2 && token2.intValue != 0) {
                        return this.addX(token3.intValue / token2.intValue);
                    }
                    float f = Token.fValue(token2);
                    switch (token3.tok) {
                        default: {
                            float f2 = Token.fValue(token3);
                            if (f == 0.0f) {
                                return this.addX(f2 == 0.0f ? 0.0f : (f2 < 0.0f ? Float.POSITIVE_INFINITY : Float.POSITIVE_INFINITY));
                            }
                            return this.addX(f2 / f);
                        }
                        case 7: {
                            Point3f point3f = new Point3f((Point3f)token3.value);
                            if (f == 0.0f) {
                                return this.addX(new Point3f(Float.NaN, Float.NaN, Float.NaN));
                            }
                            return this.addX(new Point3f(point3f.x / f, point3f.y / f, point3f.z / f));
                        }
                        case 8: 
                    }
                    if (f == 0.0f) {
                        return this.addX(new Point4f(Float.NaN, Float.NaN, Float.NaN, Float.NaN));
                    }
                    if (token2.tok == 8) {
                        return this.addX(new Quaternion((Point4f)token3.value).div(new Quaternion((Point4f)token2.value)).toPoint4f());
                    }
                    return this.addX(new Quaternion((Point4f)token3.value).mul(1.0f / f).toPoint4f());
                }
                case 17825923: {
                    float f = Token.fValue(token2);
                    switch (token3.tok) {
                        default: {
                            return this.addX(f == 0.0f ? 0 : (int)(Token.fValue(token3) / Token.fValue(token2)));
                        }
                        case 8: 
                    }
                    if (f == 0.0f) {
                        return this.addX(new Point4f(Float.NaN, Float.NaN, Float.NaN, Float.NaN));
                    }
                    if (token2.tok == 8) {
                        return this.addX(new Quaternion((Point4f)token3.value).divLeft(new Quaternion((Point4f)token2.value)).toPoint4f());
                    }
                    return this.addX(new Quaternion((Point4f)token3.value).mul(1.0f / f).toPoint4f());
                }
            }
            return true;
        }

        private boolean evaluateBoundBox(Token token) {
            if (token.tok != 0x4000007) {
                return false;
            }
            if (Eval.this.isSyntaxCheck) {
                return this.addX("");
            }
            BoxInfo boxInfo = Eval.this.viewer.getBoxInfo(Token.bsSelect(token));
            Point3f[] point3fArray = boxInfo.getBoundBoxPoints();
            return this.addX(new String[]{Escape.escape((Tuple3f)point3fArray[0]), Escape.escape((Tuple3f)point3fArray[1]), Escape.escape((Tuple3f)point3fArray[2]), Escape.escape((Tuple3f)point3fArray[3])});
        }

        private boolean evaluatePointOrBitsetOperation(Token token, Token token2) throws ScriptException {
            switch (token2.tok) {
                case 6: {
                    String[] stringArray = (String[])token2.value;
                    String[] stringArray2 = new String[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        Object object = Token.unescapePointOrBitsetAsToken(stringArray[i]);
                        if (!(object instanceof Token) || !this.evaluatePointOrBitsetOperation(token, (Token)object)) {
                            return false;
                        }
                        stringArray2[i] = Token.sValue(this.xStack[this.xPt--]);
                    }
                    return this.addX(stringArray2);
                }
                case 7: {
                    switch (token.intValue) {
                        case 3146112: {
                            return this.addX(((Point3f)token2.value).x);
                        }
                        case 3146113: {
                            return this.addX(((Point3f)token2.value).y);
                        }
                        case 3146114: {
                            return this.addX(((Point3f)token2.value).z);
                        }
                        case 3146115: 
                        case 3146116: 
                        case 3146117: {
                            Point3f point3f = new Point3f((Point3f)token2.value);
                            Eval.this.viewer.toFractional(point3f);
                            return this.addX(token.intValue == 3146115 ? point3f.x : (token.intValue == 3146116 ? point3f.y : point3f.z));
                        }
                    }
                    break;
                }
                case 8: {
                    switch (token.intValue) {
                        case 3146112: {
                            return this.addX(((Point4f)token2.value).x);
                        }
                        case 3146113: {
                            return this.addX(((Point4f)token2.value).y);
                        }
                        case 3146114: {
                            return this.addX(((Point4f)token2.value).z);
                        }
                        case 0x4000042: {
                            return this.addX(((Point4f)token2.value).w);
                        }
                    }
                    break;
                }
                case 0x4000007: {
                    if (token.intValue == 141557762 && token2.value instanceof Bond.BondSet) {
                        return this.addX(token2);
                    }
                    Object object = Eval.this.getBitsetProperty(Token.bsSelect(token2), token.intValue, null, null, token2.value, token.value, false, Token.Token2.bsItem2(token2));
                    if (token.intValue == 141557762) {
                        return this.addX(new Token(0x4000007, new Bond.BondSet((BitSet)object, Eval.this.viewer.getAtomIndices(Token.bsSelect(token2)))));
                    }
                    return this.addX(object);
                }
            }
            return false;
        }

        Point3f ptValue(Token token) throws ScriptException {
            if (Eval.this.isSyntaxCheck) {
                return new Point3f();
            }
            switch (token.tok) {
                case 7: {
                    return (Point3f)token.value;
                }
                case 0x4000007: {
                    return (Point3f)Eval.this.getBitsetProperty(Token.bsSelect(token), 7340297, null, null, token.value, null, false, -1);
                }
                case 4: 
                case 6: {
                    Object object = Escape.unescapePoint((String)Token.sValue(token));
                    if (!(object instanceof Point3f)) break;
                    return (Point3f)object;
                }
            }
            float f = Token.fValue(token);
            return new Point3f(f, f, f);
        }

        Point4f planeValue(Token token) {
            if (Eval.this.isSyntaxCheck) {
                return new Point4f();
            }
            switch (token.tok) {
                case 8: {
                    return (Point4f)token.value;
                }
                case 4: 
                case 6: {
                    Object object = Escape.unescapePoint((String)Token.sValue(token));
                    return object instanceof Point4f ? (Point4f)object : null;
                }
            }
            return null;
        }

        void stackOverflow() {
            this.oStack = (Token[])ArrayUtil.doubleLength((Object)this.oStack);
            this.xStack = (Token[])ArrayUtil.doubleLength((Object)this.xStack);
            this.maxLevel *= 2;
        }
    }

    class ScriptException
    extends Exception {
        private String message;

        ScriptException(String string) {
            boolean bl = false;
            this.message = string;
            if (string == null) {
                this.message = "";
            } else if (string.indexOf("file recognized as a script file:") >= 0) {
                bl = true;
            }
            if (!bl) {
                this.message = this.message + Eval.this.contextTrace();
                if (!Eval.this.isSyntaxCheck) {
                    Logger.error((String)("eval ERROR: " + this.toString()));
                }
            }
        }

        public String toString() {
            return this.message;
        }
    }

    private static class Context {
        String filename;
        String functionName;
        String script;
        short[] lineNumbers;
        int[] lineIndices;
        Token[][] aatoken;
        Token[] statement;
        int statementLength;
        int pc;
        int pcEnd = Integer.MAX_VALUE;
        int lineEnd = Integer.MAX_VALUE;
        int iToken;
        StringBuffer outputBuffer;
        Hashtable contextVariables;
        boolean isStateScript;

        Context() {
        }
    }
}

