/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomCollection;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Escape;
import org.jmol.util.Parser;
import org.jmol.viewer.JmolConstants;

class DataManager {
    private Hashtable dataValues = new Hashtable();
    int[] userVdwMars;
    float[] userVdws;
    int defaultVdw = 0;
    BitSet bsUserVdws;

    DataManager() {
    }

    void clear() {
        this.dataValues.clear();
    }

    void setData(String string, Object[] objectArray, int n, int n2, int n3) {
        if (string == null) {
            this.clear();
            return;
        }
        if (string.equals("element_vdw")) {
            String string2 = ((String)objectArray[1]).trim();
            if (string2.length() == 0) {
                this.userVdwMars = null;
                this.userVdws = null;
                this.bsUserVdws = null;
                return;
            }
            if (this.bsUserVdws == null) {
                this.setUserVdw(this.defaultVdw);
            }
            Parser.parseFloatArrayFromMatchAndField((String)string2, (BitSet)this.bsUserVdws, (int)1, (int[])((int[])objectArray[2]), (int)2, (float[])this.userVdws);
            int n4 = this.userVdws.length;
            while (--n4 >= 0) {
                this.userVdwMars[n4] = (int)(this.userVdws[n4] * 1000.0f);
            }
            return;
        }
        if (objectArray[2] != null && n > 0) {
            BitSet bitSet;
            String string3 = (String)objectArray[1];
            boolean bl = n2 != 0 || n3 != Integer.MIN_VALUE && n3 != Integer.MAX_VALUE;
            Object[] objectArray2 = (Object[])this.dataValues.get(string);
            float[] fArray = objectArray2 == null || bl ? new float[n] : ArrayUtil.ensureLength((float[])((float[])objectArray2[1]), (int)n);
            String[] stringArray = null;
            if (n3 == Integer.MIN_VALUE && (stringArray = Parser.getTokens((String)string3)).length > 1) {
                n3 = 0;
            }
            if (n3 == 0 || n3 == Integer.MAX_VALUE) {
                bitSet = (BitSet)objectArray[2];
                if (stringArray == null) {
                    stringArray = Parser.getTokens((String)string3);
                }
                Parser.parseFloatArray((String[])stringArray, (BitSet)bitSet, (float[])fArray);
            } else if (n2 == 0) {
                bitSet = (BitSet)objectArray[2];
                Parser.parseFloatArrayFromMatchAndField((String)string3, (BitSet)bitSet, (int)0, null, (int)n3, (float[])fArray);
            } else {
                int[] nArray = (int[])objectArray[2];
                bitSet = new BitSet();
                Parser.parseFloatArrayFromMatchAndField((String)string3, null, (int)n2, (int[])nArray, (int)n3, (float[])fArray);
                int n5 = nArray.length;
                while (--n5 >= 0) {
                    if (nArray[n5] < 0) continue;
                    bitSet.set(nArray[n5]);
                }
            }
            if (objectArray2 != null && objectArray2[2] instanceof BitSet && !bl) {
                bitSet.or((BitSet)objectArray2[2]);
            }
            objectArray[2] = bitSet;
            objectArray[1] = fArray;
        }
        this.dataValues.put(string, objectArray);
    }

    Object[] getData(String string) {
        if (this.dataValues == null) {
            return null;
        }
        if (string.equalsIgnoreCase("types")) {
            Object[] objectArray = new String[]{"types", ""};
            int n = 0;
            Enumeration enumeration = this.dataValues.keys();
            while (enumeration.hasMoreElements()) {
                objectArray[1] = (String)objectArray[1] + (n++ > 0 ? "\n" : "") + enumeration.nextElement();
            }
            return objectArray;
        }
        return (Object[])this.dataValues.get(string);
    }

    float[] getDataFloat(String string) {
        if (this.dataValues == null) {
            return null;
        }
        Object[] objectArray = this.getData(string);
        if (objectArray == null || !(objectArray[1] instanceof float[])) {
            return null;
        }
        return (float[])objectArray[1];
    }

    float getDataFloat(String string, int n) {
        float[] fArray;
        Object[] objectArray;
        if (this.dataValues != null && (objectArray = this.getData(string)) != null && objectArray[1] instanceof float[] && n < (fArray = (float[])objectArray[1]).length) {
            return fArray[n];
        }
        return Float.NaN;
    }

    float[][] getDataFloat2D(String string) {
        if (this.dataValues == null) {
            return null;
        }
        Object[] objectArray = this.getData(string);
        if (objectArray == null || !(objectArray[1] instanceof float[][])) {
            return null;
        }
        return (float[][])objectArray[1];
    }

    void getDataState(StringBuffer stringBuffer, StringBuffer stringBuffer2, Atom[] atomArray, int n, String string) {
        String string2;
        if (this.dataValues == null) {
            return;
        }
        Enumeration enumeration = this.dataValues.keys();
        StringBuffer stringBuffer3 = new StringBuffer();
        int n2 = 0;
        if (string.length() > 0) {
            n2 = 1;
            stringBuffer3.append(string);
        }
        while (enumeration.hasMoreElements()) {
            Object object;
            string2 = (String)enumeration.nextElement();
            if (string2.indexOf("property_") == 0) {
                ++n2;
                object = ((Object[])this.dataValues.get(string2))[1];
                if (object instanceof float[]) {
                    AtomCollection.getAtomicPropertyState(stringBuffer3, atomArray, n, (byte)8, (BitSet)((Object[])this.dataValues.get(string2))[2], string2, (float[])object);
                    stringBuffer3.append("\n");
                    continue;
                }
                stringBuffer3.append("\n").append(Escape.encapsulateData((String)string2, (Object)object));
                continue;
            }
            if (string2.indexOf("data2d") != 0 || !((object = ((Object[])this.dataValues.get(string2))[1]) instanceof float[][])) continue;
            ++n2;
            stringBuffer3.append("\n").append(Escape.encapsulateData((String)string2, (Object)object));
        }
        if (this.userVdws != null && (string2 = this.getDefaultVdw(3, this.bsUserVdws)).length() > 0) {
            ++n2;
            stringBuffer3.append(string2);
        }
        if (n2 == 0) {
            return;
        }
        if (stringBuffer2 != null) {
            stringBuffer.append("function _setDataState();\n");
        }
        stringBuffer.append(stringBuffer3);
        if (stringBuffer2 != null) {
            stringBuffer2.append("  _setDataState;\n");
            stringBuffer.append("end function;\n\n");
        }
    }

    public void setUserVdw(int n) {
        this.userVdwMars = new int[JmolConstants.elementNumberMax];
        this.userVdws = new float[JmolConstants.elementNumberMax];
        this.bsUserVdws = new BitSet();
        if (n == 3) {
            n = 0;
        }
        for (int i = 1; i < JmolConstants.elementNumberMax; ++i) {
            this.userVdwMars[i] = JmolConstants.getVanderwaalsMar(i, n);
            this.userVdws[i] = (float)this.userVdwMars[i] / 1000.0f;
        }
    }

    public void setDefaultVdw(String string) {
        int n = JmolConstants.getVdwType(string);
        if (n < 0) {
            n = 0;
        }
        if (n != this.defaultVdw && n == 3 && this.bsUserVdws == null) {
            this.setUserVdw(this.defaultVdw);
        }
        this.defaultVdw = n;
    }

    public String getDefaultVdw(int n, BitSet bitSet) {
        if (n == Integer.MIN_VALUE) {
            return JmolConstants.vdwLabels[this.defaultVdw];
        }
        if (n < 0) {
            n = this.defaultVdw;
        }
        if (n == Integer.MAX_VALUE) {
            bitSet = this.bsUserVdws;
            if (bitSet == null) {
                return "";
            }
            n = 3;
        }
        if (n == 3 && this.bsUserVdws == null) {
            this.setUserVdw(this.defaultVdw);
        }
        StringBuffer stringBuffer = new StringBuffer(JmolConstants.vdwLabels[n] + "\n");
        for (int i = 1; i < JmolConstants.elementNumberMax; ++i) {
            if (bitSet != null && !bitSet.get(i)) continue;
            stringBuffer.append(i).append('\t').append(n == 3 ? this.userVdws[i] : (float)JmolConstants.getVanderwaalsMar(i, n) / 1000.0f).append('\t').append(JmolConstants.elementSymbolFromNumber(i)).append('\n');
        }
        return bitSet == null ? stringBuffer.toString() : "\n  DATA \"element_vdw\"\n" + stringBuffer.append("  end \"element_vdw\";\n\n").toString();
    }
}

