/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import org.jmol.i18n.GT;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;
import org.jmol.viewer.Eval;
import org.jmol.viewer.Function;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Token;
import org.jmol.viewer.Viewer;

class Compiler {
    Hashtable localFunctions = new Hashtable();
    static Hashtable globalFunctions = new Hashtable();
    private Function thisFunction;
    private Viewer viewer;
    private String filename;
    private String script;
    private short[] lineNumbers;
    private int[] lineIndices;
    private Token[][] aatokenCompiled;
    private String errorMessage;
    private String errorLine;
    private boolean preDefining;
    private boolean isSilent;
    private boolean isShowScriptOutput;
    private boolean isCheckOnly;
    private Hashtable contextVariables;
    private boolean logMessages = false;
    private FlowContext flowContext;
    private int nSemiSkip = 0;
    private int cchScript;
    private short lineCurrent;
    private int ichToken;
    private int cchToken;
    private int iCommand;
    private int ichCurrentCommand;
    private boolean isNewSet;
    private boolean isSetBrace;
    private int ptNewSetModifier;
    private boolean iHaveQuotedString = false;
    private Vector ltoken;
    private Token lastToken;
    private boolean isShowCommand;
    static String[] loadFormats = new String[]{"append", "files", "trajectory", "menu", "alchemy", "mol2", "mopac", "nmrpdb", "charmm", "xyz", "mdl", "pdb"};
    boolean isImplicitExpression;
    boolean isSetOrDefine;
    Token tokenCommand;
    int tokCommand;
    Vector ltokenPostfix = null;
    Token[] atokenInfix;
    int itokenInfix;
    boolean isEmbeddedExpression;
    boolean isCommaAsOrAllowed;
    Token theToken;
    Object theValue;
    boolean haveString;
    private boolean residueSpecCodeGenerated;
    private static final int ERROR_badArgumentCount = 0;
    private static final int ERROR_badContext = 1;
    private static final int ERROR_commandExpected = 2;
    private static final int ERROR_coordinateExpected = 3;
    private static final int ERROR_endOfCommandUnexpected = 4;
    private static final int ERROR_endOfExpressionExpected = 5;
    private static final int ERROR_identifierOrResidueSpecificationExpected = 6;
    private static final int ERROR_invalidAtomSpecification = 7;
    private static final int ERROR_invalidChainSpecification = 8;
    private static final int ERROR_invalidExpressionToken = 9;
    private static final int ERROR_invalidModelSpecification = 10;
    private static final int ERROR_missingEnd = 11;
    private static final int ERROR_numberExpected = 12;
    private static final int ERROR_numberOrVariableNameExpected = 13;
    private static final int ERROR_residueSpecificationExpected = 14;
    private static final int ERROR_tokenExpected = 15;
    private static final int ERROR_tokenUnexpected = 16;
    private static final int ERROR_unrecognizedExpressionToken = 17;
    private static final int ERROR_unrecognizedParameter = 18;
    private static final int ERROR_unrecognizedToken = 19;
    private static final String[] errors = new String[]{GT._((String)"bad argument count"), GT._((String)"invalid context for {0}"), GT._((String)"command expected"), GT._((String)"{ number number number } expected"), GT._((String)"unexpected end of script command"), GT._((String)"end of expression expected"), GT._((String)"identifier or residue specification expected"), GT._((String)"invalid atom specification"), GT._((String)"invalid chain specification"), GT._((String)"invalid expression token: {0}"), GT._((String)"invalid model specification"), GT._((String)"missing END for {0}"), GT._((String)"number expected"), GT._((String)"number or variable name expected"), GT._((String)"residue specification (ALA, AL?, A*) expected"), GT._((String)"{0} expected"), GT._((String)"{0} unexpected"), GT._((String)"unrecognized expression token: {0}"), GT._((String)"unrecognized {0} parameter"), GT._((String)"unrecognized token: {0}")};

    boolean isFunction(String string) {
        return (string.indexOf("_") == 0 ? this.localFunctions : globalFunctions).containsKey(string);
    }

    Compiler(Viewer viewer) {
        this.viewer = viewer;
    }

    boolean compile(String string, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.isCheckOnly = bl4;
        this.filename = string;
        this.isSilent = bl2;
        this.script = Compiler.cleanScriptComments(string2);
        this.contextVariables = null;
        this.logMessages = !bl2 && !bl && bl3;
        this.preDefining = string == "#predefine";
        return this.compile0() || this.handleError();
    }

    String getScript() {
        return this.script;
    }

    short[] getLineNumbers() {
        return this.lineNumbers;
    }

    int[] getLineIndices() {
        return this.lineIndices;
    }

    Hashtable getContextVariables() {
        return this.contextVariables;
    }

    private void addContextVariable(String string) {
        if (this.thisFunction == null) {
            if (this.contextVariables == null) {
                this.contextVariables = new Hashtable();
            }
            this.contextVariables.put(string, new Token(4, ""));
        } else {
            this.thisFunction.addVariable(string, false);
        }
    }

    Token[][] getAatokenCompiled() {
        return this.aatokenCompiled;
    }

    static boolean tokAttr(int n, int n2) {
        return (n & n2) == n2;
    }

    static boolean tokAttrOr(int n, int n2, int n3) {
        return (n & n2) == n2 || (n & n3) == n3;
    }

    static int modelValue(String string) {
        int n = string.indexOf(".");
        if (n < 1 || string.charAt(0) == '-') {
            return Integer.MAX_VALUE;
        }
        int n2 = 0;
        int n3 = 0;
        if (n > 0 && (n2 = Integer.parseInt(string.substring(0, n))) < 0) {
            n2 = -n2;
        }
        if (n < string.length() - 1) {
            try {
                n3 = Integer.parseInt(string.substring(n + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2 * 1000000 + n3;
    }

    private static String cleanScriptComments(String string) {
        int n;
        String string2;
        int n2;
        int n3 = -1;
        while (true) {
            ++n3;
            if ((n3 = string.indexOf("//", n3)) < 0) break;
            if (n3 != 0 && string.charAt(n3 - 1) != '\n') continue;
            n2 = string.indexOf("\n", n3) + 1;
            if (n2 == 0) {
                n2 = string.length();
            }
            string = string.substring(0, n3) + string.substring(n2);
        }
        while ((n3 = string.indexOf("/**")) >= 0 && (n2 = string.indexOf("**/", n3 + 3)) >= 0) {
            string2 = string.substring(n3, n2);
            n = string2.indexOf("**** Jmol Embedded Script ****");
            if (n >= 0) {
                return Compiler.cleanScriptComments(string2.substring(n + 30));
            }
            string = string.substring(0, n3) + string.substring(n2 + 3);
        }
        while ((n3 = string.indexOf("/*")) >= 0 && (n2 = string.indexOf("*/", n3 + 2)) >= 0) {
            string2 = string.substring(n3 + 2, n2);
            n = string2.indexOf("**** Jmol Embedded Script ****");
            if (n >= 0) {
                return string2.substring(n + 30);
            }
            string = string.substring(0, n3) + string.substring(n2 + 2);
        }
        return string;
    }

    private void addTokenToPrefix(Token token) {
        this.ltoken.addElement(token);
        this.lastToken = token;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private boolean compile0() {
        this.lineNumbers = null;
        this.lineIndices = null;
        this.aatokenCompiled = null;
        this.errorLine = null;
        this.errorMessage = null;
        this.flowContext = null;
        this.nSemiSkip = 0;
        this.cchScript = this.script.length();
        this.ichToken = 0;
        this.ichCurrentCommand = 0;
        this.lineCurrent = 1;
        this.iCommand = 0;
        this.lastToken = Token.tokenOff;
        var1_1 = 8;
        var2_2 = 0;
        var3_3 = 0;
        var4_4 = 0;
        this.lineNumbers = new short[var1_1];
        this.lineIndices = new int[var1_1];
        this.isSetBrace = false;
        this.isNewSet = false;
        this.ptNewSetModifier = 1;
        this.isShowScriptOutput = false;
        var5_5 = new Vector<Token[]>();
        this.ltoken = new Vector<E>();
        var6_6 = 0;
        var7_7 = null;
        var8_8 = false;
        while (true) {
            block125: {
                block143: {
                    block130: {
                        block142: {
                            block141: {
                                block140: {
                                    block139: {
                                        block137: {
                                            block138: {
                                                block136: {
                                                    block134: {
                                                        block135: {
                                                            block133: {
                                                                block132: {
                                                                    block131: {
                                                                        block129: {
                                                                            block128: {
                                                                                block127: {
                                                                                    block126: {
                                                                                        if ((var9_9 = this.ltoken.size()) == 0 && this.thisFunction != null && this.thisFunction.chpt0 == 0) {
                                                                                            this.thisFunction.chpt0 = this.ichToken;
                                                                                        }
                                                                                        if (this.lookingAtLeadingWhitespace()) break block125;
                                                                                        if (!this.lookingAtComment()) break block126;
                                                                                        if (var9_9 > 0) break block125;
                                                                                        var7_7 = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                                                                                        var10_10 = this.cchToken;
                                                                                        this.ichCurrentCommand = this.ichToken;
                                                                                        this.ichToken += this.cchToken;
                                                                                        var8_8 = this.lookingAtEndOfLine();
                                                                                        if (var8_8 || this.lookingAtEndOfStatement()) {
                                                                                            this.cchToken += var10_10;
                                                                                        }
                                                                                        this.ichToken = this.ichCurrentCommand;
                                                                                        break block127;
                                                                                    }
                                                                                    var8_8 = this.lookingAtEndOfLine();
                                                                                }
                                                                                if (var7_7 == null && !var8_8 && !this.lookingAtEndOfStatement()) break block128;
                                                                                if (var9_9 > 0 || var7_7 != null) {
                                                                                    if (var9_9 == 0) {
                                                                                        this.ichCurrentCommand = this.ichToken;
                                                                                    }
                                                                                    this.iCommand = var5_5.size();
                                                                                    if (this.thisFunction != null && this.thisFunction.cmdpt0 < 0) {
                                                                                        this.thisFunction.cmdpt0 = this.iCommand;
                                                                                    }
                                                                                    if (var3_3 > 0 || var4_4 > 0 || var2_2 > 0) {
                                                                                        return this.error(4);
                                                                                    }
                                                                                    if (!this.compileCommand()) {
                                                                                        return false;
                                                                                    }
                                                                                    if (!Compiler.tokAttr(var6_6, 131072) || this.atokenInfix[0].intValue <= 0) {
                                                                                        if (this.iCommand == var1_1) {
                                                                                            var10_11 = new short[var1_1 * 2];
                                                                                            System.arraycopy(this.lineNumbers, 0, var10_11, 0, var1_1);
                                                                                            this.lineNumbers = var10_11;
                                                                                            var11_12 = new int[var1_1 * 2];
                                                                                            System.arraycopy(this.lineIndices, 0, var11_12, 0, var1_1);
                                                                                            this.lineIndices = var11_12;
                                                                                            var1_1 *= 2;
                                                                                        }
                                                                                        this.lineNumbers[this.iCommand] = this.lineCurrent;
                                                                                        this.lineIndices[this.iCommand] = this.ichCurrentCommand;
                                                                                        var5_5.addElement(this.atokenInfix);
                                                                                    }
                                                                                    this.ltoken.setSize(0);
                                                                                    var9_9 = 0;
                                                                                    var6_6 = 0;
                                                                                    this.tokenCommand = null;
                                                                                    this.iHaveQuotedString = false;
                                                                                    if (var7_7 != null) {
                                                                                        var7_7 = null;
                                                                                    }
                                                                                }
                                                                                if (this.ichToken >= this.cchScript) break;
                                                                                if (var8_8) {
                                                                                    this.lineCurrent = (short)(this.lineCurrent + 1);
                                                                                }
                                                                                if (this.isShowScriptOutput) {
                                                                                    this.ichCurrentCommand = this.ichToken + this.cchToken;
                                                                                }
                                                                                break block125;
                                                                            }
                                                                            if (var9_9 != 0) break block129;
                                                                            this.isSetBrace = false;
                                                                            this.isNewSet = false;
                                                                            this.ptNewSetModifier = 1;
                                                                            this.nSemiSkip = 0;
                                                                            var2_2 = 0;
                                                                            var4_4 = 0;
                                                                            break block130;
                                                                        }
                                                                        if (var9_9 != this.ptNewSetModifier) break block131;
                                                                        var10_10 = this.script.charAt(this.ichToken);
                                                                        if (var6_6 != 36867 && !Compiler.tokAttr(var6_6, 0x8000000) || (!Compiler.tokAttr(var6_6, 0x8000000) || var10_10 != '=') && (!this.isNewSet && !this.isSetBrace || var10_10 != '=' && var10_10 != '[' && var10_10 != '.')) break block131;
                                                                        this.tokenCommand = var10_10 == '=' ? Token.tokenSet : (var10_10 == '[' ? Token.tokenSetArray : Token.tokenSetProperty);
                                                                        var6_6 = 36867;
                                                                        this.ltoken.insertElementAt(this.tokenCommand, 0);
                                                                        this.cchToken = 1;
                                                                        if (var10_10 == '[') {
                                                                            this.addTokenToPrefix(new Token(0x1100020, "["));
                                                                            ++var4_4;
                                                                        } else if (var10_10 == '.') {
                                                                            this.addTokenToPrefix(new Token(0x10000A, "."));
                                                                        }
                                                                        break block125;
                                                                    }
                                                                    if (!this.lookingAtString()) break block132;
                                                                    if (this.cchToken < 0) {
                                                                        return this.error(4);
                                                                    }
                                                                    var11_13 = (var6_6 == 9441793 || var6_6 == 9441795) && this.iHaveQuotedString == false ? this.script.substring(this.ichToken + 1, this.ichToken + this.cchToken - 1) : this.getUnescapedStringLiteral();
                                                                    this.addTokenToPrefix(new Token(4, var11_13));
                                                                    this.iHaveQuotedString = true;
                                                                    if (var6_6 == 9442306 && var11_13.indexOf("@") < 0 && !this.getData(var11_13)) {
                                                                        return this.error(11, "data");
                                                                    }
                                                                    break block125;
                                                                }
                                                                if (var6_6 != 4156 || var9_9 != 1 || !this.charToken()) break block133;
                                                                var11_14 = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                                                                this.addTokenToPrefix(new Token(1, var11_14));
                                                                break block125;
                                                            }
                                                            if (var6_6 != 9441793) break block134;
                                                            if (!this.lookingAtLoadFormat()) break block135;
                                                            var11_15 = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                                                            if ((var11_15 = var11_15.toLowerCase()).equals("append") || var11_15.equals("files") || var11_15.equals("menu") || var11_15.equals("trajectory")) {
                                                                this.addTokenToPrefix(new Token(1, var11_15));
                                                            } else if (var11_15.indexOf("=") == 0) {
                                                                this.addTokenToPrefix(new Token(4, var11_15));
                                                            }
                                                            break block125;
                                                        }
                                                        if (this.iHaveQuotedString || !this.lookingAtSpecialString()) break block134;
                                                        var11_16 = this.script.substring(this.ichToken, this.ichToken + this.cchToken).trim();
                                                        var12_22 = var11_16.indexOf(" ");
                                                        if (var12_22 > 0) {
                                                            this.cchToken = var12_22;
                                                            var11_16 = var11_16.substring(0, var12_22);
                                                        }
                                                        this.addTokenToPrefix(new Token(4, var11_16));
                                                        this.iHaveQuotedString = true;
                                                        break block125;
                                                    }
                                                    if (var6_6 != 9441795 || this.iHaveQuotedString || !this.lookingAtSpecialString()) break block136;
                                                    var11_17 = this.script.substring(this.ichToken, this.ichToken + this.cchToken).trim();
                                                    var12_23 = var11_17.indexOf(" ");
                                                    if (var12_23 > 0) {
                                                        this.cchToken = var12_23;
                                                        var11_17 = var11_17.substring(0, var12_23);
                                                    }
                                                    this.addTokenToPrefix(new Token(4, var11_17));
                                                    this.iHaveQuotedString = true;
                                                    break block125;
                                                }
                                                if (var6_6 != 9441283) break block137;
                                                var11_18 = this.cchToken;
                                                if (var9_9 <= 2 || this.iHaveQuotedString || !this.lookingAtSpecialString()) break block137;
                                                var12_24 = this.script.substring(this.ichToken, this.ichToken + this.cchToken).trim();
                                                if (var12_24.indexOf(" ") >= 0) break block138;
                                                this.addTokenToPrefix(new Token(4, var12_24));
                                                this.iHaveQuotedString = true;
                                                break block125;
                                            }
                                            this.cchToken = var11_18;
                                        }
                                        if (!Compiler.tokAttr(var6_6, 20480) || var6_6 == 9441795 && this.iHaveQuotedString || !this.lookingAtSpecialString()) break block139;
                                        var11_19 = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                                        this.addTokenToPrefix(new Token(4, var11_19));
                                        break block125;
                                    }
                                    var11_20 = this.lookingAtExponential();
                                    if (Float.isNaN(var11_20)) break block140;
                                    this.addTokenToPrefix(new Token(3, new Float(var11_20)));
                                    break block125;
                                }
                                if (!this.lookingAtDecimal()) break block141;
                                var11_20 = Float.valueOf(this.script.substring(this.ichToken, this.ichToken + this.cchToken)).floatValue();
                                var12_25 = Compiler.modelValue(this.script.substring(this.ichToken, this.ichToken + this.cchToken));
                                this.ltoken.addElement(new Token(3, var12_25, new Float(var11_20)));
                                break block125;
                            }
                            if (this.lookingAtSeqcode()) {
                                var10_10 = this.script.charAt(this.ichToken);
                                try {
                                    var12_26 = var10_10 == '*' || var10_10 == '^' ? 0x7FFFFFFF : Integer.parseInt(this.script.substring(this.ichToken, this.ichToken + this.cchToken - 2));
                                    var13_31 = this.script.charAt(this.ichToken + this.cchToken - 1);
                                    if (var13_31 == '^') {
                                        var13_31 = ' ';
                                    }
                                    var14_35 = Group.getSeqcode(var12_26, var13_31);
                                    this.addTokenToPrefix(new Token(5, var14_35, "seqcode"));
                                }
                                catch (NumberFormatException var12_27) {
                                    return this.error(9, "" + var10_10);
                                }
                            }
                            if (!this.lookingAtInteger()) break block142;
                            var12_28 = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                            var13_32 = Integer.parseInt(var12_28);
                            if (var6_6 == 364551 || var6_6 == 364552) {
                                if (var9_9 != 1) {
                                    return this.error(0);
                                }
                                var14_36 = this.getBreakableContext(var13_32 = Math.abs(var13_32));
                                if (var14_36 == null) {
                                    return this.error(1, (String)this.tokenCommand.value);
                                }
                                ((Token)this.ltoken.get((int)0)).intValue = var14_36.pt0;
                            }
                            this.addTokenToPrefix(new Token(2, var13_32, var12_28));
                            break block125;
                        }
                        if (this.lastToken.tok != 9451009 && Compiler.tokenAttr(this.lastToken, 0x900000)) break block130;
                        var12_29 = this.script.charAt(this.ichToken) == '[';
                        var13_33 = this.lookingAtBitset();
                        if (var13_33 == null) break block130;
                        if (var12_29) {
                            this.addTokenToPrefix(new Token(0x4000007, new Bond.BondSet(var13_33)));
                        } else {
                            this.addTokenToPrefix(new Token(0x4000007, var13_33));
                        }
                        break block125;
                    }
                    if (!this.lookingAtLookupToken()) break block143;
                    var11_21 = this.script.substring(this.ichToken, this.ichToken + this.cchToken);
                    if (var11_21.length() == 1) {
                        var12_30 = Token.getTokenFromName(var11_21);
                        if (var12_30 == null && (var12_30 = Token.getTokenFromName(var11_21.toLowerCase())) != null) {
                            var12_30 = new Token(var12_30.tok, var12_30.intValue, var11_21);
                        }
                    } else {
                        var11_21 = var11_21.toLowerCase();
                        var12_30 = Token.getTokenFromName(var11_21);
                    }
                    if (var12_30 == null) {
                        var12_30 = var11_21.indexOf("property_") == 0 ? new Token(141558028, var11_21.toLowerCase()) : new Token(1, var11_21);
                    }
                    var13_34 = var12_30.tok;
                    switch (var13_34) {
                        case 0x10000E: 
                        case 0x1100000: {
                            ++var3_3;
                            if (var9_9 <= 1 || this.lastToken.tok != 9451009) break;
                            this.nSemiSkip += 2;
                            break;
                        }
                        case 0x100012: 
                        case 0x1100001: {
                            if (--var3_3 < 0) {
                                return this.error(16, (String)var12_30.value);
                            }
                            if (var3_3 != 0) break;
                            this.nSemiSkip = 0;
                            break;
                        }
                        case 0x1100020: {
                            ++var4_4;
                            break;
                        }
                        case 0x1100021: {
                            if (--var4_4 >= 0) break;
                            return this.error(16, "]");
                        }
                    }
                    block7 : switch (var6_6) {
                        case 0: {
                            this.lastToken = Token.tokenOff;
                            this.ichCurrentCommand = this.ichToken;
                            this.tokenCommand = var12_30;
                            var6_6 = var13_34;
                            if (Compiler.tokAttr(var6_6, 102400)) {
                                var14_35 = var5_5.size();
                                var15_37 = false;
                                var16_38 = true;
                                switch (var13_34) {
                                    case 233481: {
                                        if (this.flowContext == null) {
                                            return this.error(1, "end");
                                        }
                                        var15_37 = true;
                                        if (this.flowContext.token.tok == 9670657) break;
                                        var12_30 = new Token(var13_34, -this.flowContext.pt0, var12_30.value);
                                        break;
                                    }
                                    case 102401: 
                                    case 102405: 
                                    case 102406: {
                                        break;
                                    }
                                    case 364548: {
                                        var15_37 = true;
                                        if (this.flowContext != null && (this.flowContext.token.tok == 102401 || this.flowContext.token.tok == 364547 || this.flowContext.token.tok == 102402)) break;
                                        return this.error(1, "endif");
                                    }
                                    case 364547: {
                                        if (this.flowContext == null || this.flowContext.token.tok != 102401 && this.flowContext.token.tok != 102402) {
                                            return this.error(1, "else");
                                        }
                                        this.flowContext.token.intValue = this.flowContext.pt0 = var14_35;
                                        break;
                                    }
                                    case 364551: 
                                    case 364552: {
                                        var16_38 = false;
                                        var17_39 = this.getBreakableContext(0);
                                        if (var17_39 == null) {
                                            return this.error(1, (String)var12_30.value);
                                        }
                                        var12_30 = new Token(var13_34, var17_39.pt0, var12_30.value);
                                        break;
                                    }
                                    case 102402: {
                                        if (this.flowContext == null || this.flowContext.token.tok != 102401 && this.flowContext.token.tok != 102402 && this.flowContext.token.tok != 364547) {
                                            return this.error(1, "elseif");
                                        }
                                        this.flowContext.token.intValue = this.flowContext.pt0 = var14_35;
                                        break;
                                    }
                                    case 9670657: {
                                        if (this.flowContext == null) break;
                                        return this.error(1, "function");
                                    }
                                }
                                if (var15_37) {
                                    this.flowContext.token.intValue = var14_35;
                                    if (var13_34 == 364548) {
                                        this.flowContext = this.flowContext.parent;
                                    }
                                } else if (var16_38) {
                                    var12_30 = new Token(var13_34, var12_30.value);
                                    if (var13_34 == 364547 || var13_34 == 102402) {
                                        this.flowContext.token = var12_30;
                                    } else {
                                        this.flowContext = new FlowContext(var12_30, var14_35, this.flowContext);
                                    }
                                }
                            } else if (!Compiler.tokAttr(var6_6, 4096)) {
                                if (!Compiler.tokAttr(var13_34, 1) && !Compiler.tokAttr(var13_34, 0x8000000)) {
                                    return this.commandExpected();
                                }
                                var6_6 = 36867;
                                this.isSetBrace = var13_34 == 0x10000E;
                                this.isNewSet = this.isSetBrace == false;
                                var2_2 = this.isSetBrace != false ? 1 : 0;
                                var4_4 = 0;
                                this.ptNewSetModifier = this.isNewSet != false ? 1 : 0x7FFFFFFF;
                            }
                            ** GOTO lbl435
                        }
                        case 9670657: {
                            if (this.tokenCommand.intValue == 0) {
                                if (var9_9 == 1) {
                                    this.tokenCommand.value = var11_21;
                                    break;
                                }
                            } else if (var9_9 == 1) {
                                this.thisFunction = new Function(var11_21);
                                this.flowContext.setFunction(this.thisFunction);
                            } else if (var9_9 == 2) {
                                if (var13_34 != 0x1100000) {
                                    return this.error(15, "(");
                                }
                            } else if (var9_9 != 3 || var13_34 != 0x1100001) {
                                if (var9_9 % 2 == 0) {
                                    if (var13_34 != 0x1100010 && var13_34 != 0x1100001) {
                                        return this.error(15, ", / )");
                                    }
                                } else {
                                    this.thisFunction.addVariable(var11_21, true);
                                }
                            }
                            ** GOTO lbl435
                        }
                        case 364547: {
                            if (var9_9 != 1 || var13_34 != 102401) {
                                return this.error(0);
                            }
                            this.ltoken.removeElementAt(0);
                            var12_30 = new Token(102402, "elseif");
                            this.ltoken.addElement(var12_30);
                            this.flowContext.token = var12_30;
                            var6_6 = 102402;
                            break;
                        }
                        case 134385668: {
                            if (var9_9 == 1) {
                                this.addContextVariable(var11_21);
                                this.ltoken.removeElementAt(0);
                                this.ltoken.addElement(Token.tokenSetVar);
                                var6_6 = 36867;
                            }
                            ** GOTO lbl435
                        }
                        case 233481: {
                            if (var9_9 != 1) {
                                return this.error(0);
                            }
                            if ((this.flowContext == null || this.flowContext.token.tok != var13_34) && (var13_34 != 102401 || this.flowContext.token.tok != 364547 && this.flowContext.token.tok != 102402)) {
                                return this.error(1, "end " + var11_21);
                            }
                            switch (var13_34) {
                                case 102401: 
                                case 102405: 
                                case 102406: {
                                    break;
                                }
                                case 9670657: {
                                    if (!this.isCheckOnly) {
                                        (this.thisFunction.name.indexOf("_") == 0 ? this.localFunctions : Compiler.globalFunctions).put(this.thisFunction.name, this.thisFunction);
                                    }
                                    this.flowContext.setFunction(this.script, this.ichCurrentCommand, var5_5.size(), this.lineNumbers, this.lineIndices, var5_5);
                                    this.thisFunction = null;
                                    this.tokenCommand.intValue = 0x7FFFFFFF;
                                    this.flowContext = this.flowContext.parent;
                                    break block7;
                                }
                                default: {
                                    return this.error(19, "end " + var11_21);
                                }
                            }
                            this.flowContext = this.flowContext.parent;
                            ** GOTO lbl435
                        }
                        case 102405: {
                            if (var9_9 == 1) {
                                if (var13_34 != 0x1100000) {
                                    return this.error(19, var11_21);
                                }
                                this.nSemiSkip += 2;
                            } else if (var9_9 == 3 && ((Token)this.ltoken.get((int)2)).tok == 134385668) {
                                this.addContextVariable(var11_21);
                            }
                            ** GOTO lbl435
                        }
                        case 36867: {
                            if (var13_34 == 0x10000E) {
                                ++var2_2;
                            } else if (var13_34 == 0x100012 && this.isSetBrace && --var2_2 == 0 && this.ptNewSetModifier == 0x7FFFFFFF) {
                                this.ptNewSetModifier = var9_9 + 1;
                            }
                            if (var9_9 == this.ptNewSetModifier) {
                                var14_35 = 0;
                                if (var13_34 == 17826148 || var13_34 == 0x1100020) {
                                    var12_30 = (Token)this.ltoken.get(0);
                                    this.ltoken.removeElementAt(0);
                                    var14_35 = var13_34 == 0x1100020 ? 1 : 0;
                                    this.ltoken.addElement(var14_35 != 0 ? Token.tokenSetArray : Token.tokenSet);
                                    var13_34 = var12_30.tok;
                                    var6_6 = 36867;
                                }
                                if (var13_34 == 0x1100000) {
                                    var12_30 = (Token)this.ltoken.get(0);
                                    this.ltoken.removeElementAt(0);
                                    this.tokenCommand = new Token(9670657, 0, var12_30.value);
                                    this.ltoken.add(0, this.tokenCommand);
                                    var6_6 = 9670657;
                                    var12_30 = Token.tokenLeftParen;
                                    var13_34 = 0x1100000;
                                } else {
                                    if (var13_34 != 1 && !Compiler.tokAttr(var13_34, 0x8000000)) {
                                        return this.isNewSet != false ? this.commandExpected() : this.error(18, "SET", ": " + var11_21);
                                    }
                                    if (var14_35 != 0) {
                                        this.addTokenToPrefix(var12_30);
                                        var12_30 = Token.tokenArraySelector;
                                        var13_34 = 0x1100020;
                                    }
                                }
                            }
                            ** GOTO lbl435
                        }
                        case 12291: 
                        case 12293: 
                        case 12294: 
                        case 9451009: 
                        case 134230020: 
                        case 135278594: {
                            if (var13_34 != 135278594) ** GOTO lbl429
                            if (var9_9 == 1) {
                                if (var13_34 != 1) {
                                    if (this.preDefining) {
                                        if (!Compiler.tokAttr(var13_34, 0x2100000)) {
                                            return this.error("ERROR IN Token.java or JmolConstants.java -- the following term was used in JmolConstants.java but not listed as predefinedset in Token.java: " + var11_21);
                                        }
                                    } else if (Compiler.tokAttr(var13_34, 0x2100000)) {
                                        Logger.warn((String)("WARNING: predefined term '" + var11_21 + "' has been redefined by the user until the next file load."));
                                    } else if (!this.isCheckOnly && var11_21.length() > 1) {
                                        Logger.warn((String)("WARNING: redefining " + var11_21 + "; was " + var12_30 + "not all commands may continue to be functional for the life of the applet!"));
                                        var12_30.tok = 1;
                                        var13_34 = 1;
                                        Token.addToken(var11_21, var12_30);
                                    }
                                }
                            } else {
                                if (var9_9 == 2 && var13_34 == 17826148) {
                                    this.ltoken.insertElementAt(Token.tokenSet, 0);
                                    break;
                                }
lbl429:
                                // 3 sources

                                if (var4_4 == 0 && var13_34 != 1 && !Compiler.tokAttr(var13_34, 0x100000) && var13_34 != 32 && var13_34 != 64) {
                                    return this.error(9, var11_21);
                                }
                            }
                            ** GOTO lbl435
                        }
                        case 12289: {
                            if (var13_34 != 1 && var13_34 != 0x100009 && !Compiler.tokAttr(var13_34, 0x100000)) {
                                return this.error(9, var11_21);
                            }
                        }
lbl435:
                        // 22 sources

                        default: {
                            this.addTokenToPrefix(var12_30);
                            break;
                        }
                    }
                    break block125;
                }
                if (var9_9 == 0 || (this.isNewSet || this.isSetBrace) && var9_9 == this.ptNewSetModifier) {
                    return this.commandExpected();
                }
                return this.error(19, this.script.substring(this.ichToken, this.ichToken + 1));
            }
            this.ichToken += this.cchToken;
        }
        this.aatokenCompiled = new Token[var5_5.size()][];
        var5_5.copyInto((Object[])this.aatokenCompiled);
        if (this.flowContext != null) {
            return this.error(11, Token.nameOf(this.flowContext.token.tok));
        }
        return true;
    }

    private FlowContext getBreakableContext(int n) {
        FlowContext flowContext = this.flowContext;
        while (flowContext != null && (flowContext.token.tok != 102405 && flowContext.token.tok != 102406 || n-- > 0)) {
            flowContext = flowContext.parent;
        }
        return flowContext;
    }

    private boolean getData(String string) {
        int n;
        this.ichToken += string.length() + 2;
        if (this.script.length() > this.ichToken && this.script.charAt(this.ichToken) == '\r') {
            ++this.ichToken;
        }
        if (this.script.length() > this.ichToken && this.script.charAt(this.ichToken) == '\n') {
            ++this.ichToken;
        }
        if ((n = this.script.indexOf("\"" + string + "\"", this.ichToken) - 4) < 0 || !this.script.substring(n, n + 4).equalsIgnoreCase("END ")) {
            return false;
        }
        String string2 = this.script.substring(this.ichToken, n);
        this.addTokenToPrefix(new Token(9442306, string2));
        this.addTokenToPrefix(new Token(1, "end"));
        this.addTokenToPrefix(new Token(4, string));
        this.cchToken = n - this.ichToken + string.length() + 6;
        return true;
    }

    private static boolean isSpaceOrTab(char c) {
        return c == ' ' || c == '\t';
    }

    private boolean eol(char c) {
        return c == '\r' || c == '\n' || c == ';' && this.nSemiSkip <= 0;
    }

    private boolean lookingAtLeadingWhitespace() {
        int n;
        for (n = this.ichToken; n < this.cchScript && Compiler.isSpaceOrTab(this.script.charAt(n)); ++n) {
        }
        if (this.isLineContinuation(n)) {
            n += 2;
        }
        this.cchToken = n - this.ichToken;
        return this.cchToken > 0;
    }

    private boolean isLineContinuation(int n) {
        char c;
        return n < this.cchScript - 1 && this.script.charAt(n) == '\\' && ((c = this.script.charAt(n + 1)) == '\r' || c == '\n');
    }

    private boolean lookingAtComment() {
        int n;
        int n2 = 88;
        int n3 = -1;
        if (this.ichToken == this.ichCurrentCommand && this.ichToken < this.cchScript && this.script.charAt(this.ichToken) == '$') {
            this.isShowScriptOutput = true;
            for (n = this.ichToken; n2 != 93 && n < this.cchScript; ++n) {
                char c = this.script.charAt(n);
                n2 = c;
                if (this.eol(c)) break;
            }
            this.cchToken = n - this.ichToken;
            this.isShowCommand = true;
            return true;
        }
        if (this.isShowScriptOutput) {
            if (!this.isShowCommand) {
                n3 = this.ichToken;
            }
            if (this.ichToken >= this.cchScript || this.eol(this.script.charAt(this.ichToken))) {
                this.isShowCommand = false;
                return false;
            }
        }
        while (n < this.cchScript) {
            char c = this.script.charAt(n);
            n2 = c;
            if (this.eol(c)) break;
            if (this.isLineContinuation(n)) {
                ++n;
            } else if (n2 == 35 && n3 == -1) {
                n3 = n;
            }
            ++n;
        }
        if (n3 == -1) {
            return false;
        }
        if (this.cchScript - n3 >= 3 && this.script.charAt(n3 + 1) == 'j' && this.script.charAt(n3 + 2) == 'c') {
            this.cchToken = n - this.ichToken;
            return true;
        }
        if (n3 != this.ichToken) {
            return false;
        }
        if (this.cchScript > this.ichToken + 3 && this.script.charAt(this.ichToken + 1) == 'j' && this.script.charAt(this.ichToken + 2) == 'x' && Compiler.isSpaceOrTab(this.script.charAt(this.ichToken + 3))) {
            this.cchToken = 4;
            return true;
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    private boolean lookingAtEndOfLine() {
        if (this.ichToken >= this.cchScript) {
            return true;
        }
        int n = this.ichToken;
        char c = this.script.charAt(n);
        if (c == '\r') {
            if (++n < this.cchScript && this.script.charAt(n) == '\n') {
                ++n;
            }
        } else if (c == '\n') {
            ++n;
        } else {
            return false;
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    private boolean lookingAtEndOfStatement() {
        if (this.ichToken == this.cchScript || this.script.charAt(this.ichToken) != ';' || this.nSemiSkip-- > 0) {
            return false;
        }
        this.cchToken = 1;
        return true;
    }

    private boolean lookingAtString() {
        char c;
        if (this.ichToken == this.cchScript) {
            return false;
        }
        if (this.script.charAt(this.ichToken) != '\"') {
            return false;
        }
        int n = this.ichToken;
        boolean bl = false;
        while (++n < this.cchScript && ((c = this.script.charAt(n)) != '\"' || bl)) {
            bl = c == '\\' ? !bl : false;
        }
        this.cchToken = n == this.cchScript ? -1 : ++n - this.ichToken;
        return true;
    }

    String getUnescapedStringLiteral() {
        if (this.cchToken < 2) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(this.cchToken - 2);
        int n = this.ichToken + this.cchToken - 1;
        int n2 = this.ichToken + 1;
        while (n2 < n) {
            int n3;
            if ((n3 = this.script.charAt(n2++)) == 92 && n2 < n) {
                n3 = this.script.charAt(n2++);
                switch (n3) {
                    case 98: {
                        n3 = 8;
                        break;
                    }
                    case 110: {
                        n3 = 10;
                        break;
                    }
                    case 116: {
                        n3 = 9;
                        break;
                    }
                    case 114: {
                        n3 = 13;
                    }
                    case 34: 
                    case 39: 
                    case 92: {
                        break;
                    }
                    case 117: 
                    case 120: {
                        char c;
                        int n4;
                        int n5;
                        int n6 = n5 = n3 == 120 ? 2 : 4;
                        if (n2 >= n) break;
                        int n7 = 0;
                        int n8 = n5;
                        while (--n8 >= 0 && n2 < n && (n4 = Compiler.getHexitValue(c = this.script.charAt(n2))) >= 0) {
                            n7 <<= 4;
                            n7 += n4;
                            ++n2;
                        }
                        n3 = (char)n7;
                    }
                }
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    static int getHexitValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + c - 97;
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + c - 65;
        }
        return -1;
    }

    private boolean lookingAtLoadFormat() {
        String string = this.script.substring(this.ichToken, Math.min(this.cchScript, this.ichToken + 10)).toLowerCase();
        int n = loadFormats.length;
        while (--n >= 0) {
            int n2;
            String string2 = loadFormats[n];
            int n3 = string2.length();
            if (string.indexOf(string2) != 0 || (n2 = this.ichToken + n3) >= this.cchScript || !Compiler.isSpaceOrTab(this.script.charAt(n2))) continue;
            this.cchToken = n3;
            return true;
        }
        return false;
    }

    private boolean lookingAtSpecialString() {
        int n;
        for (n = this.ichToken; n < this.cchScript && !this.eol(this.script.charAt(n)); ++n) {
        }
        if (n > this.ichToken && this.script.charAt(this.ichToken) == '@' && (n <= this.ichToken + 1 || this.script.charAt(this.ichToken + 1) != '{')) {
            return false;
        }
        this.cchToken = n - this.ichToken;
        if (this.logMessages) {
            Logger.debug((String)("lookingAtSpecialString cchToken=" + this.cchToken));
        }
        return this.cchToken > 0;
    }

    private float lookingAtExponential() {
        boolean bl;
        boolean bl2;
        if (this.ichToken == this.cchScript) {
            return Float.NaN;
        }
        int n = this.ichToken;
        boolean bl3 = bl2 = this.script.charAt(n) == '-';
        if (bl2) {
            ++n;
        }
        int n2 = n;
        boolean bl4 = false;
        int n3 = 88;
        while (n < this.cchScript) {
            char c = this.script.charAt(n);
            n3 = c;
            if (!Character.isDigit(c)) break;
            ++n;
            bl4 = true;
        }
        if (n < this.cchScript && n3 == 46) {
            ++n;
        }
        while (n < this.cchScript) {
            char c = this.script.charAt(n);
            n3 = c;
            if (!Character.isDigit(c)) break;
            ++n;
            bl4 = true;
        }
        if (n == this.cchScript || !bl4) {
            return Float.NaN;
        }
        int n4 = n;
        int n5 = 1;
        int n6 = 0;
        boolean bl5 = bl = n3 == 69 || n3 == 101;
        if (!bl || ++n == this.cchScript) {
            return Float.NaN;
        }
        n3 = this.script.charAt(n);
        if (n3 == 45 || n3 == 43) {
            ++n;
            int n7 = n5 = n3 == 45 ? -1 : 1;
        }
        while (n < this.cchScript) {
            char c = this.script.charAt(n);
            n3 = c;
            if (!Character.isDigit(c)) break;
            ++n;
            n6 = n6 * 10 + n3 - 48;
        }
        if (n6 == 0) {
            return Float.NaN;
        }
        this.cchToken = n - this.ichToken;
        double d = Float.valueOf(this.script.substring(n2, n4)).doubleValue();
        return (float)(d *= (double)(bl2 ? -1 : 1) * Math.pow(10.0, n5 * n6));
    }

    private boolean lookingAtDecimal() {
        char c;
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int n = this.ichToken;
        if (this.script.charAt(n) == '-') {
            ++n;
        }
        boolean bl = false;
        int n2 = 88;
        while (n < this.cchScript) {
            char c2 = this.script.charAt(n++);
            n2 = c2;
            if (!Character.isDigit(c2)) break;
            bl = true;
        }
        if (n2 != 46) {
            return false;
        }
        if (n < this.cchScript && !this.eol(c = this.script.charAt(n))) {
            if (Character.isLetter(c) || c == '?') {
                return false;
            }
            if (n + 1 < this.cchScript && (Character.isLetter(c = this.script.charAt(n + 1)) || c == '?')) {
                return false;
            }
        }
        while (n < this.cchScript && Character.isDigit(this.script.charAt(n))) {
            ++n;
            bl = true;
        }
        this.cchToken = n - this.ichToken;
        return bl;
    }

    private boolean lookingAtSeqcode() {
        int n;
        char c = ' ';
        if (n + 1 < this.cchScript && this.script.charAt(n) == '*' && this.script.charAt(n + 1) == '^') {
            c = '^';
            ++n;
        } else {
            for (n = this.ichToken; n < this.cchScript; ++n) {
                char c2 = this.script.charAt(n);
                c = c2;
                if (!Character.isDigit(c2)) break;
            }
        }
        if (c != '^') {
            return false;
        }
        if ((c = ++n == this.cchScript ? (char)' ' : (char)this.script.charAt(n++)) != ' ' && c != '*' && c != '?' && !Character.isLetter(c)) {
            return false;
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    private boolean lookingAtInteger() {
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int n = this.ichToken;
        if (this.script.charAt(this.ichToken) == '-') {
            ++n;
        }
        int n2 = n;
        while (n < this.cchScript && Character.isDigit(this.script.charAt(n))) {
            ++n;
        }
        if (n2 == n) {
            return false;
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    BitSet lookingAtBitset() {
        int n;
        if (this.script.indexOf("({null})", this.ichToken) == this.ichToken) {
            this.cchToken = 8;
            return new BitSet();
        }
        if (this.ichToken + 4 > this.cchScript || this.script.charAt(this.ichToken + 1) != '{' || this.script.charAt(this.ichToken) != '(' && this.script.charAt(this.ichToken) != '[') {
            return null;
        }
        char c = this.script.charAt(this.ichToken) == '(' ? (char)')' : ']';
        char c2 = ' ';
        for (n = this.ichToken + 2; n < this.cchScript; ++n) {
            char c3 = this.script.charAt(n);
            c2 = c3;
            if (c3 == '}' || !Character.isDigit(c2) && !Compiler.isSpaceOrTab(c2) && c2 != 58) break;
        }
        if (c2 != '}' || n + 1 == this.cchScript || this.script.charAt(n + 1) != c) {
            return null;
        }
        int n2 = -1;
        int n3 = 0;
        BitSet bitSet = new BitSet();
        int n4 = this.ichToken + 2;
        while (n4 < n) {
            while (Compiler.isSpaceOrTab(c2 = this.script.charAt(n4))) {
                ++n4;
            }
            n3 = n4;
            while (Character.isDigit(c2 = this.script.charAt(n3))) {
                ++n3;
            }
            if (n3 == n4) {
                return null;
            }
            int n5 = Integer.parseInt(this.script.substring(n4, n3));
            if (c2 == ':') {
                n2 = n5;
            } else {
                if (n2 >= 0) {
                    if (n2 > n5) {
                        return null;
                    }
                    for (int i = n2; i <= n5; ++i) {
                        bitSet.set(i);
                    }
                } else {
                    bitSet.set(n5);
                }
                n2 = -1;
            }
            n4 = ++n3;
        }
        if (n2 >= 0) {
            return null;
        }
        this.cchToken = n + 2 - this.ichToken;
        return bitSet;
    }

    private boolean lookingAtLookupToken() {
        if (this.ichToken == this.cchScript) {
            return false;
        }
        int n = this.ichToken;
        char c = this.script.charAt(n++);
        switch (c) {
            case '$': 
            case '%': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case ':': 
            case ';': 
            case '@': 
            case '[': 
            case '\\': 
            case ']': 
            case '{': 
            case '}': {
                break;
            }
            case '&': 
            case '|': {
                if (n >= this.cchScript || this.script.charAt(n) != c) break;
                ++n;
                break;
            }
            case '<': 
            case '=': 
            case '>': {
                if (n >= this.cchScript || (c = this.script.charAt(n)) != '<' && c != '=' && c != '>') break;
                ++n;
                break;
            }
            case '!': 
            case '/': {
                if (n >= this.cchScript || this.script.charAt(n) != '=') break;
                ++n;
                break;
            }
            default: {
                if (!Character.isLetter(c)) {
                    return false;
                }
            }
            case '\'': 
            case '?': 
            case '_': 
            case '~': {
                while (n < this.cchScript && (Character.isLetterOrDigit(c = this.script.charAt(n)) || c == '_' || c == '?' || c == '~' || c == '\'') || c == '^' && n > this.ichToken && Character.isDigit(this.script.charAt(n - 1))) {
                    ++n;
                }
                break block0;
            }
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    private boolean charToken() {
        int n;
        char c;
        if (this.ichToken == this.cchScript || (c = this.script.charAt(this.ichToken)) == '\"' || c == '@') {
            return false;
        }
        for (n = this.ichToken; n < this.cchScript && !Compiler.isSpaceOrTab(c = this.script.charAt(n)) && c != '#' && !this.eol(c); ++n) {
        }
        this.cchToken = n - this.ichToken;
        return true;
    }

    private boolean compileCommand() {
        int n;
        if (this.ltoken.size() == 0) {
            this.atokenInfix = new Token[0];
            this.ltoken.copyInto(this.atokenInfix);
            return true;
        }
        this.tokenCommand = (Token)this.ltoken.firstElement();
        this.tokCommand = this.tokenCommand.tok;
        this.isImplicitExpression = Compiler.tokAttr(this.tokCommand, 36864);
        this.isSetOrDefine = this.tokCommand == 36867 || this.tokCommand == 135278594;
        this.isCommaAsOrAllowed = Compiler.tokAttr(this.tokCommand, 12288);
        int n2 = this.ltoken.size();
        if (n2 == 1 && Compiler.tokAttr(this.tokCommand, 524288)) {
            this.addTokenToPrefix(Token.tokenOn);
        }
        this.atokenInfix = new Token[this.ltoken.size()];
        this.ltoken.copyInto(this.atokenInfix);
        if (this.logMessages) {
            for (n = 0; n < this.atokenInfix.length; ++n) {
                Logger.debug((String)(n + ": " + this.atokenInfix[n]));
            }
        }
        this.isEmbeddedExpression = this.tokCommand != 9670657 && !Compiler.tokAttrOr(this.tokCommand, 12288, 20480);
        int n3 = n = this.isEmbeddedExpression || Compiler.tokAttr(this.tokCommand, 12288) ? 1 : 0;
        if (this.tokCommand == 12289 && this.tokAt(1) == 0x100009) {
            n = 0;
        }
        if (n != 0 && !this.compileExpression()) {
            return false;
        }
        n2 = this.atokenInfix.length;
        int n4 = 0;
        for (int i = 1; i < n2; ++i) {
            if (this.tokAt(i) != 135278594) continue;
            ++n4;
        }
        if (this.isNewSet && (n2 -= n4) == 1) {
            this.atokenInfix[0] = new Token(9670657, 0, this.atokenInfix[0].value);
            this.isNewSet = false;
        }
        if ((this.isNewSet || this.isSetBrace) && n2 < this.ptNewSetModifier + 2) {
            return this.commandExpected();
        }
        return n2 == 1 || !Compiler.tokAttr(this.tokCommand, 262144) ? true : this.error(0);
    }

    private boolean compileExpression() {
        int n = this.isSetOrDefine && !this.isSetBrace ? 2 : 1;
        this.ltokenPostfix = new Vector();
        this.itokenInfix = 0;
        Token token = null;
        for (int i = 0; i < n && this.addNextToken(); ++i) {
        }
        while (this.moreTokens()) {
            if (this.isEmbeddedExpression) {
                while (!this.isExpressionNext() && this.addNextToken()) {
                }
                if (!this.moreTokens()) break;
            }
            if (this.lastToken.tok == 135278594) {
                if (this.clauseDefine()) continue;
                return false;
            }
            if (!this.isImplicitExpression) {
                token = new Token(0x100001, "implicitExpressionBegin");
                this.addTokenToPostfix(token);
            }
            if (!this.clauseOr(this.isCommaAsOrAllowed || !this.isImplicitExpression && this.tokPeek(0x1100000))) {
                return false;
            }
            if (!(this.isImplicitExpression || this.isEmbeddedExpression && this.lastToken == Token.tokenCoordinateEnd)) {
                this.addTokenToPostfix(Token.tokenExpressionEnd);
            }
            if (!this.moreTokens()) continue;
            if (this.tokCommand != 9451009 && !this.isEmbeddedExpression) {
                return this.error(5);
            }
            if (this.tokCommand != 9451009) continue;
            token.intValue = 0;
            this.tokCommand = 0;
            this.isEmbeddedExpression = true;
            this.isImplicitExpression = true;
            this.isCommaAsOrAllowed = false;
        }
        this.atokenInfix = new Token[this.ltokenPostfix.size()];
        this.ltokenPostfix.copyInto(this.atokenInfix);
        return true;
    }

    private boolean isExpressionNext() {
        return this.tokPeek(0x10000E) || !this.isImplicitExpression && this.tokPeek(0x1100000);
    }

    private static boolean tokenAttr(Token token, int n) {
        return token != null && (token.tok & n) == n;
    }

    private boolean moreTokens() {
        return this.itokenInfix < this.atokenInfix.length;
    }

    private int tokAt(int n) {
        return n < this.atokenInfix.length ? this.atokenInfix[n].tok : 0;
    }

    private int tokPeek() {
        if (this.itokenInfix >= this.atokenInfix.length) {
            return 0;
        }
        return this.atokenInfix[this.itokenInfix].tok;
    }

    private boolean tokPeek(int n) {
        if (this.itokenInfix >= this.atokenInfix.length) {
            return false;
        }
        return this.atokenInfix[this.itokenInfix].tok == n;
    }

    private int intPeek() {
        if (this.itokenInfix >= this.atokenInfix.length) {
            return Integer.MAX_VALUE;
        }
        return this.atokenInfix[this.itokenInfix].intValue;
    }

    private Object valuePeek() {
        if (this.moreTokens()) {
            return this.atokenInfix[this.itokenInfix].value;
        }
        return "";
    }

    private Token tokenNext() {
        if (this.itokenInfix >= this.atokenInfix.length) {
            return null;
        }
        return this.atokenInfix[this.itokenInfix++];
    }

    private boolean tokenNext(int n) {
        Token token = this.tokenNext();
        return token != null && token.tok == n;
    }

    private boolean returnToken() {
        --this.itokenInfix;
        return false;
    }

    private Token getToken() {
        this.theToken = this.tokenNext();
        this.theValue = this.theToken == null ? null : this.theToken.value;
        return this.theToken;
    }

    private boolean isToken(int n) {
        return this.theToken != null && this.theToken.tok == n;
    }

    private boolean getNumericalToken() {
        return this.getToken() != null && (this.isToken(2) || this.isToken(3));
    }

    private float floatValue() {
        switch (this.theToken.tok) {
            case 2: {
                return this.theToken.intValue;
            }
            case 3: {
                return ((Float)this.theValue).floatValue();
            }
        }
        return 0.0f;
    }

    private boolean addTokenToPostfix(int n, Object object) {
        return this.addTokenToPostfix(new Token(n, object));
    }

    private boolean addTokenToPostfix(int n, int n2, Object object) {
        return this.addTokenToPostfix(new Token(n, n2, object));
    }

    private boolean addTokenToPostfix(Token token) {
        if (token == null) {
            return false;
        }
        if (this.logMessages) {
            Logger.debug((String)("addTokenToPostfix" + token));
        }
        this.ltokenPostfix.addElement(token);
        this.lastToken = token;
        return true;
    }

    private boolean addNextToken() {
        return this.addTokenToPostfix(this.tokenNext());
    }

    private boolean addNextTokenIf(int n) {
        return this.tokPeek(n) && this.addNextToken();
    }

    private boolean addSubstituteTokenIf(int n, Token token) {
        if (!this.tokPeek(n)) {
            return false;
        }
        ++this.itokenInfix;
        return this.addTokenToPostfix(token);
    }

    private boolean clauseOr(boolean bl) {
        int n;
        this.haveString = false;
        if (!this.clauseAnd()) {
            return false;
        }
        while ((n = this.tokPeek()) == 0x1100030 || n == 0x1100031 || n == 17825842 || bl && n == 0x1100010) {
            if (n == 0x1100010 && !this.haveString) {
                this.addSubstituteTokenIf(0x1100010, Token.tokenOr);
            } else {
                this.addNextToken();
            }
            if (this.clauseAnd()) continue;
            return false;
        }
        return true;
    }

    private boolean clauseAnd() {
        if (!this.clauseNot()) {
            return false;
        }
        while (this.tokPeek(0x1100040)) {
            this.addNextToken();
            if (this.clauseNot()) continue;
            return false;
        }
        return true;
    }

    private boolean clauseNot() {
        if (this.tokPeek(0x1100050)) {
            this.addNextToken();
            return this.clauseNot();
        }
        return this.clausePrimitive();
    }

    private boolean clausePrimitive() {
        int n = this.tokPeek();
        switch (n) {
            case 0: {
                return this.error(4);
            }
            case 0x100003: 
            case 0x10000D: 
            case 0x10000F: 
            case 0x1100080: 
            case 0x4000007: {
                return this.addNextToken();
            }
            case 4: {
                this.haveString = true;
                return this.addNextToken();
            }
            case 3: {
                return this.addTokenToPostfix(1048611, this.getToken().intValue, this.theValue);
            }
            case 1: 
            case 2: 
            case 5: 
            case 0x100007: 
            case 0x1100020: 
            case 0x1100081: 
            case 17825922: {
                if (this.clauseResidueSpec()) {
                    return true;
                }
            }
            default: {
                if (Compiler.tokAttrOr(n, 141558028, 0x300000)) {
                    return this.clauseComparator();
                }
                if (!Compiler.tokAttrOr(n, 2, 0x2100000)) break;
                return this.addNextToken();
            }
            case 0x300005: {
                return this.clauseCell();
            }
            case 9439746: {
                return this.clauseConnected();
            }
            case 0x900202: {
                return this.clauseSubstructure();
            }
            case 9439745: {
                return this.clauseWithin();
            }
            case 135278594: {
                this.addNextToken();
                if (this.tokPeek() == 0) {
                    return this.error(4);
                }
                return this.clauseDefine();
            }
            case 135794723: 
            case 141557762: {
                this.addNextToken();
                if (this.tokPeek(0x4000007)) {
                    this.addNextToken();
                } else if (this.tokPeek(135278594)) {
                    this.addNextToken();
                    return this.clauseDefine();
                }
                return true;
            }
            case 0x1100000: {
                this.addNextToken();
                if (!this.clauseOr(true)) {
                    return false;
                }
                if (!this.addNextTokenIf(0x1100001)) {
                    return this.error(15, ")");
                }
                return this.checkForItemSelector();
            }
            case 0x10000E: {
                return this.checkForCoordinate(this.isImplicitExpression);
            }
        }
        return this.error(17, "" + this.valuePeek());
    }

    private boolean checkForCoordinate(boolean bl) {
        boolean bl2 = false;
        int n = this.ltokenPostfix.size();
        if (bl) {
            this.addTokenToPostfix(Token.tokenExpressionBegin);
            this.tokenNext();
        } else if (this.isEmbeddedExpression) {
            this.tokenNext();
            --n;
        } else {
            this.addNextToken();
        }
        if (!this.clauseOr(false)) {
            return false;
        }
        int n2 = 1;
        while (!this.tokPeek(0x100012)) {
            boolean bl3 = this.addNextTokenIf(0x1100010);
            if (!this.clauseOr(false)) {
                return bl3 || n2 < 3 ? false : this.error(15, "}");
            }
            ++n2;
        }
        boolean bl4 = bl2 = n2 >= 2;
        if (bl2 && (bl || this.isEmbeddedExpression)) {
            this.ltokenPostfix.set(n, Token.tokenCoordinateBegin);
            this.addTokenToPostfix(Token.tokenCoordinateEnd);
            this.tokenNext();
        } else if (bl) {
            this.addTokenToPostfix(Token.tokenExpressionEnd);
            this.tokenNext();
        } else if (this.isEmbeddedExpression) {
            this.tokenNext();
        } else {
            this.addNextToken();
        }
        return this.checkForItemSelector();
    }

    private boolean checkForItemSelector() {
        for (int i = 0; i < 2 && this.addNextTokenIf(0x1100020); ++i) {
            if (!this.clauseItemSelector()) {
                return false;
            }
            if (this.addNextTokenIf(0x1100021)) continue;
            return this.error(15, "]");
        }
        return true;
    }

    private boolean clauseWithin() {
        this.addNextToken();
        if (!this.addNextTokenIf(0x1100000)) {
            return false;
        }
        if (this.getToken() == null) {
            return false;
        }
        float f = Float.MAX_VALUE;
        String string = null;
        boolean bl = true;
        switch (this.theToken.tok) {
            case 0x1100070: {
                if (this.getToken() == null) {
                    return false;
                }
                if (this.theToken.tok != 2) {
                    return this.error(12);
                }
                f = -this.theToken.intValue;
                break;
            }
            case 2: 
            case 3: {
                f = this.floatValue();
                break;
            }
            case 0x100005: {
                bl = false;
            }
            case 4: 
            case 0x100006: 
            case 0x100008: 
            case 0x10000B: 
            case 0x300006: 
            case 0x30000E: 
            case 0x300013: 
            case 3149837: 
            case 3149845: 
            case 9439234: 
            case 142086157: {
                string = (String)this.theValue;
                break;
            }
            case 1: {
                string = ((String)this.theValue).toLowerCase();
                break;
            }
            default: {
                return this.error(18, "WITHIN", ": " + this.theToken.value);
            }
        }
        if (string == null) {
            this.addTokenToPostfix(3, new Float(f));
        } else {
            this.addTokenToPostfix(4, string);
        }
        while (this.addNextTokenIf(0x1100010)) {
            int n = this.tokPeek();
            if (f != Float.MAX_VALUE && (n == 0x100011 || n == 0x100010)) {
                this.addTokenToPostfix(this.getToken());
                if (!this.addNextTokenIf(0x1100010)) break;
                n = this.tokPeek();
            }
            boolean bl2 = false;
            if (string == null) {
                if (n == 1) {
                    this.getToken();
                    string = ((String)this.theValue).toLowerCase();
                    if (string.equals("hkl")) {
                        bl2 = true;
                        this.addTokenToPostfix(4, string);
                    } else {
                        this.returnToken();
                    }
                } else if (n == 0x100008 || n == 9439234) {
                    bl2 = true;
                    this.addNextToken();
                } else if (n == 0x10000E) {
                    this.returnToken();
                    bl2 = true;
                    this.addTokenToPostfix(Token.getTokenFromName(f == Float.MAX_VALUE ? "plane" : "coord"));
                }
                this.addNextTokenIf(0x1100010);
            }
            n = this.tokPeek();
            if (bl2) {
                block13: while (!this.tokPeek(0x1100001)) {
                    switch (this.tokPeek()) {
                        case 0: {
                            return this.error(4);
                        }
                        case 0x1100000: {
                            this.addTokenToPostfix(Token.tokenExpressionBegin);
                            this.addNextToken();
                            if (!this.clauseOr(false)) {
                                return this.error(18, "WITHIN", ": ?");
                            }
                            if (!this.addNextTokenIf(0x1100001)) {
                                return this.error(15, ", / )");
                            }
                            this.addTokenToPostfix(Token.tokenExpressionEnd);
                            continue block13;
                        }
                        case 135278594: {
                            this.addTokenToPostfix(this.getToken());
                            if (this.clauseDefine()) continue block13;
                            return false;
                        }
                    }
                    this.addTokenToPostfix(this.getToken());
                }
                continue;
            }
            if (this.clauseOr(bl)) continue;
            return this.error(0);
        }
        if (!this.addNextTokenIf(0x1100001)) {
            return this.error(15, ")");
        }
        return true;
    }

    private boolean clauseConnected() {
        block10: {
            block11: {
                String string;
                block12: {
                    this.addNextToken();
                    if (!this.addNextTokenIf(0x1100000)) {
                        this.addTokenToPostfix(Token.tokenLeftParen);
                        this.addTokenToPostfix(Token.tokenRightParen);
                        return true;
                    }
                    if (this.addNextTokenIf(2) && !this.addNextTokenIf(0x1100010) || this.addNextTokenIf(2) && !this.addNextTokenIf(0x1100010) || this.addNextTokenIf(3) && !this.addNextTokenIf(0x1100010) || this.addNextTokenIf(3) && !this.addNextTokenIf(0x1100010)) break block10;
                    if (this.tokPeek() != 1 && this.tokPeek() != 135794713) break block11;
                    string = (String)this.getToken().value;
                    short s = JmolConstants.getBondOrderFromString(string);
                    if (s != Short.MAX_VALUE) break block12;
                    this.returnToken();
                    break block11;
                }
                this.addTokenToPostfix(4, string);
                if (!this.addNextTokenIf(0x1100010)) break block10;
            }
            if (this.addNextTokenIf(0x1100001)) {
                return true;
            }
            if (!this.clauseOr(this.tokPeek(0x1100000))) {
                return false;
            }
            if (this.addNextTokenIf(0x1100001)) {
                return true;
            }
            if (!this.addNextTokenIf(0x1100010)) {
                return false;
            }
            if (!this.clauseOr(this.tokPeek(0x1100000))) {
                return false;
            }
        }
        if (!this.addNextTokenIf(0x1100001)) {
            return this.error(15, ")");
        }
        return true;
    }

    private boolean clauseSubstructure() {
        this.addNextToken();
        if (!this.addNextTokenIf(0x1100000)) {
            return false;
        }
        if (!this.addNextTokenIf(4)) {
            return this.error(15, "\"...\"");
        }
        if (!this.addNextTokenIf(0x1100001)) {
            return this.error(15, ")");
        }
        return true;
    }

    private boolean clauseItemSelector() {
        int n;
        while ((n = this.tokPeek()) != 0 && n != 0x1100021) {
            if (!this.clauseOr(false)) {
                return false;
            }
            this.returnToken();
            if (this.tokPeek() != 0x1100081) {
                this.tokenNext();
            }
            if ((n = this.tokPeek()) == 0x1100021 || !Compiler.tokAttr(n, 0x1100000)) break;
            if (n == 0x1100000) continue;
            this.addNextToken();
        }
        return true;
    }

    private boolean clauseComparator() {
        Token token = this.tokenNext();
        Token token2 = this.tokenNext();
        if (!Compiler.tokenAttr(token2, 0x1100100)) {
            return this.error(15, "== != < > <= >=");
        }
        if (this.getToken() == null) {
            return this.error(17, "" + this.valuePeek());
        }
        boolean bl = this.isToken(0x1100070);
        if (bl && this.getToken() == null) {
            return this.error(12);
        }
        switch (this.theToken.tok) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 0x10000E: 
            case 135278594: {
                break;
            }
            default: {
                return this.error(13);
            }
        }
        this.addTokenToPostfix(token2.tok, token.tok, token2.value + (bl ? " -" : ""));
        if (token.tok == 141558028) {
            this.addTokenToPostfix(token);
        }
        if (this.isToken(0x10000E)) {
            this.returnToken();
            return this.clausePrimitive();
        }
        this.addTokenToPostfix(this.theToken);
        if (this.theToken.tok == 135278594) {
            return this.clauseDefine();
        }
        return true;
    }

    private boolean clauseCell() {
        Point3f point3f = new Point3f();
        this.tokenNext();
        if (!this.tokenNext(17826148)) {
            return this.error(15, "=");
        }
        if (this.getToken() == null) {
            return this.error(3);
        }
        if (this.isToken(2)) {
            int n = this.theToken.intValue;
            point3f.x = n / 100 - 4;
            point3f.y = n % 100 / 10 - 4;
            point3f.z = n % 10 - 4;
            return this.addTokenToPostfix(0x300005, point3f);
        }
        if (!this.isToken(0x10000E) || !this.getNumericalToken()) {
            return this.error(3);
        }
        point3f.x = this.floatValue();
        if (this.tokPeek(0x1100010)) {
            this.tokenNext();
        }
        if (!this.getNumericalToken()) {
            return this.error(3);
        }
        point3f.y = this.floatValue();
        if (this.tokPeek(0x1100010)) {
            this.tokenNext();
        }
        if (!this.getNumericalToken() || !this.tokenNext(0x100012)) {
            return this.error(3);
        }
        point3f.z = this.floatValue();
        return this.addTokenToPostfix(0x300005, point3f);
    }

    private boolean clauseDefine() {
        if (!this.addSubstituteTokenIf(0x10000E, Token.tokenExpressionBegin)) {
            return this.addNextToken() && this.checkForItemSelector();
        }
        while (this.moreTokens() && !this.tokPeek(0x100012)) {
            if (this.tokPeek(0x10000E)) {
                if (this.checkForCoordinate(true)) continue;
                return false;
            }
            this.addNextToken();
        }
        return this.addSubstituteTokenIf(0x100012, Token.tokenExpressionEnd) && this.checkForItemSelector();
    }

    private boolean generateResidueSpecCode(Token token) {
        if (this.residueSpecCodeGenerated) {
            this.addTokenToPostfix(Token.tokenAnd);
        }
        this.addTokenToPostfix(token);
        this.residueSpecCodeGenerated = true;
        return true;
    }

    private boolean clauseResidueSpec() {
        boolean bl = false;
        this.residueSpecCodeGenerated = false;
        int n = this.tokPeek();
        if (n == 0x1100081 || n == 0x1100020 || n == 1) {
            if (!this.clauseResNameSpec()) {
                return false;
            }
            bl = true;
            n = this.tokPeek();
        }
        boolean bl2 = false;
        if (n == 0x1100081 || n == 2 || n == 5) {
            boolean bl3 = bl2 = n == 2;
            if (this.tokPeek(0x1100081)) {
                this.getToken();
            } else if (!this.clauseSequenceSpec()) {
                return false;
            }
            bl = true;
            n = this.tokPeek();
        }
        if (n == 0x100007 || n == 0x1100081 || n == 1 || n == 2 && !bl2) {
            if (!this.clauseChainSpec(n)) {
                return false;
            }
            bl = true;
            n = this.tokPeek();
        }
        if (n == 0x10000A) {
            if (!this.clauseAtomSpec()) {
                return false;
            }
            bl = true;
            n = this.tokPeek();
        }
        if (n == 17825922) {
            if (!this.clauseAlternateSpec()) {
                return false;
            }
            bl = true;
            n = this.tokPeek();
        }
        if (n == 0x100007 || n == 0x1100080) {
            if (!this.clauseModelSpec()) {
                return false;
            }
            bl = true;
            n = this.tokPeek();
        }
        if (!bl) {
            return this.error(14);
        }
        if (!this.residueSpecCodeGenerated) {
            this.addTokenToPostfix(Token.tokenAll);
        }
        return true;
    }

    private boolean clauseResNameSpec() {
        this.getToken();
        if (this.isToken(0x1100081) || this.isToken(0)) {
            return !this.isToken(0);
        }
        if (this.isToken(0x1100020)) {
            int n;
            String string = "";
            while (this.getToken() != null && !this.isToken(0x1100021)) {
                string = string + this.theValue;
            }
            if (!this.isToken(0x1100021)) {
                return false;
            }
            if (string == "") {
                return true;
            }
            if (string.length() > 0 && (n = string.indexOf("*")) >= 0 && n != string.length() - 1) {
                return this.error(14);
            }
            string = string.toUpperCase();
            return this.generateResidueSpecCode(new Token(1048612, string));
        }
        if (!this.isToken(1)) {
            return this.error(6);
        }
        if (this.tokPeek(0x1100081)) {
            String string = this.theValue + "*";
            this.getToken();
            return this.generateResidueSpecCode(new Token(1, string));
        }
        return this.generateResidueSpecCode(this.theToken);
    }

    private boolean clauseSequenceSpec() {
        Token token = this.getSequenceCode(false);
        if (token == null) {
            return false;
        }
        int n = this.tokPeek();
        if (n == 0x1100070 || n == 2 && this.intPeek() < 0) {
            if (n == 0x1100070) {
                this.tokenNext();
            } else {
                int n2;
                this.tokenNext().intValue = n2 = -this.intPeek();
                this.returnToken();
            }
            token.tok = 1048615;
            this.generateResidueSpecCode(token);
            return this.addTokenToPostfix(this.getSequenceCode(true));
        }
        return this.generateResidueSpecCode(token);
    }

    private Token getSequenceCode(boolean bl) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = this.tokPeek();
        if (n3 == 5) {
            n = this.tokenNext().intValue;
        } else if (n3 == 2) {
            n2 = this.tokenNext().intValue;
        } else if (!bl) {
            return null;
        }
        return new Token(1048614, n2, new Integer(n));
    }

    private boolean clauseChainSpec(int n) {
        char c;
        if (n == 0x100007) {
            this.tokenNext();
            n = this.tokPeek();
            if (this.isSpecTerminator(n)) {
                return this.generateResidueSpecCode(new Token(0x100021, 0, "spec_chain"));
            }
        }
        if (n == 0x1100081) {
            return this.getToken() != null;
        }
        switch (n) {
            case 2: {
                this.getToken();
                int n2 = this.theToken.intValue;
                if (n2 < 0 || n2 > 9) {
                    return this.error(8);
                }
                c = (char)(48 + n2);
                break;
            }
            case 1: {
                String string = (String)this.getToken().value;
                if (string.length() != 1) {
                    return this.error(8);
                }
                c = string.charAt(0);
                if (c != '?') break;
                return true;
            }
            default: {
                return this.error(8);
            }
        }
        return this.generateResidueSpecCode(new Token(0x100021, c, "spec_chain"));
    }

    private boolean isSpecTerminator(int n) {
        switch (n) {
            case 0: 
            case 0x1100001: 
            case 0x1100010: 
            case 0x1100030: 
            case 0x1100040: 
            case 0x1100050: 
            case 0x1100080: 
            case 17825922: {
                return true;
            }
        }
        return false;
    }

    private boolean clauseAlternateSpec() {
        this.tokenNext();
        int n = this.tokPeek();
        if (this.isSpecTerminator(n)) {
            return this.generateResidueSpecCode(new Token(0x10001F, null));
        }
        String string = (String)this.getToken().value;
        switch (this.theToken.tok) {
            case 1: 
            case 2: 
            case 4: 
            case 0x1100081: {
                break;
            }
            default: {
                return this.error(10);
            }
        }
        return this.generateResidueSpecCode(new Token(0x10001F, string));
    }

    private boolean clauseModelSpec() {
        this.getToken();
        if (this.tokPeek(0x1100081)) {
            this.getToken();
            return true;
        }
        switch (this.tokPeek()) {
            case 2: {
                return this.generateResidueSpecCode(new Token(0x100022, new Integer(this.getToken().intValue)));
            }
            case 3: {
                return this.generateResidueSpecCode(new Token(0x100022, this.getToken().intValue, this.theValue));
            }
            case 0: 
            case 0x100012: 
            case 0x1100010: {
                return this.generateResidueSpecCode(new Token(0x100022, new Integer(1)));
            }
        }
        return this.error(10);
    }

    private boolean clauseAtomSpec() {
        if (!this.tokenNext(0x10000A)) {
            return this.error(7);
        }
        if (this.getToken() == null) {
            return true;
        }
        String string = "";
        if (this.isToken(2)) {
            string = string + "" + this.theToken.intValue;
            if (this.getToken() == null) {
                return this.error(7);
            }
        }
        switch (this.theToken.tok) {
            case 0x1100081: {
                return true;
            }
            case 1: {
                break;
            }
            default: {
                return this.error(7);
            }
        }
        string = string + this.theValue;
        if (this.tokPeek(0x1100081)) {
            this.tokenNext();
            string = string + "*";
        }
        return this.generateResidueSpecCode(new Token(0x100020, string));
    }

    private boolean commandExpected() {
        this.ichToken = this.ichCurrentCommand;
        return this.error(errors[2]);
    }

    private boolean error(int n) {
        return this.error(n, null, null);
    }

    private boolean error(int n, String string) {
        return this.error(n, string, null);
    }

    private boolean error(int n, String string, String string2) {
        String string3 = errors[n];
        if (string != null) {
            string3 = TextFormat.simpleReplace((String)string3, (String)"{0}", (String)string);
        }
        if (string2 != null) {
            string3 = string3 + string2;
        }
        return this.error(string3);
    }

    private boolean error(String string) {
        this.errorMessage = string;
        return false;
    }

    String getErrorMessage() {
        return this.errorMessage;
    }

    private boolean handleError() {
        int n = this.script.indexOf(13, this.ichCurrentCommand);
        if (n == -1 && (n = this.script.indexOf(10, this.ichCurrentCommand)) == -1) {
            n = this.script.length();
        }
        this.errorLine = this.script.substring(this.ichCurrentCommand, n);
        String string = (this.ichToken < this.errorLine.length() ? this.errorLine.substring(0, this.ichToken - this.ichCurrentCommand) + " >>>> " + this.errorLine.substring(this.ichToken - this.ichCurrentCommand) : this.errorLine) + " <<<<";
        this.errorMessage = "script compiler ERROR: " + this.errorMessage + Eval.setErrorLineMessage(this.filename, this.lineCurrent, this.iCommand, string);
        if (!this.isSilent) {
            this.viewer.addCommand(this.errorLine + "#??");
            Logger.error((String)this.errorMessage);
        }
        return false;
    }

    private class FlowContext {
        Token token;
        int pt0;
        Function function;
        FlowContext parent;

        FlowContext(Token token, int n, FlowContext flowContext) {
            this.token = token;
            this.pt0 = n;
            this.parent = flowContext;
        }

        void setFunction(Function function) {
            this.function = function;
        }

        void setFunction(String string, int n, int n2, short[] sArray, int[] nArray, Vector vector) {
            int n3;
            int n4 = this.function.cmdpt0;
            int n5 = this.function.chpt0;
            int n6 = n2 - n4;
            this.function.script = string.substring(n5, n);
            this.function.aatoken = new Token[n6][];
            Token[][] tokenArrayArray = this.function.aatoken;
            this.function.lineIndices = new int[n6];
            this.function.lineNumbers = new short[n6];
            short s = (short)(sArray[n4] - 1);
            for (n3 = 0; n3 < n6; ++n3) {
                this.function.lineNumbers[n3] = (short)(sArray[n4 + n3] - s);
                this.function.lineIndices[n3] = nArray[n4 + n3] - n5;
                tokenArrayArray[n3] = (Token[])vector.get(n4 + n3);
                if (tokenArrayArray[n3].length <= 0) continue;
                Token token = tokenArrayArray[n3][0];
                if (!Compiler.tokAttr(token.tok, 102400)) continue;
                token.intValue = token.intValue - (token.intValue < 0 ? -n4 : n4);
            }
            n3 = n2;
            while (--n3 >= n4) {
                vector.remove(n3);
                nArray[n3] = 0;
            }
        }
    }
}

