/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.BitSet;
import java.util.Enumeration;
import javax.vecmath.Point3f;
import org.jmol.shape.Text;
import org.jmol.shape.TextShape;
import org.jmol.util.Logger;

public class Echo
extends TextShape {
    private static final String FONTFACE = "Serif";
    private static final int FONTSIZE = 20;
    private static final short COLOR = 10;

    public void initShape() {
        super.initShape();
        this.setProperty("target", "top", null);
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        String string2;
        if (Logger.debugging) {
            Logger.debug((String)("Echo.setProperty(" + string + "," + object + ")"));
        }
        if ("script" == string) {
            if (this.currentText != null) {
                this.currentText.setScript((String)object);
            }
            return;
        }
        if ("scalereference" == string) {
            if (this.currentText != null) {
                float f = ((Float)object).floatValue();
                this.currentText.setScalePixelsPerMicron(f == 0.0f ? 0.0f : 10000.0f / f);
            }
            return;
        }
        if ("xpos" == string) {
            if (this.currentText != null) {
                this.currentText.setMovableX((Integer)object);
            }
            return;
        }
        if ("ypos" == string) {
            if (this.currentText != null) {
                this.currentText.setMovableY((Integer)object);
            }
            return;
        }
        if ("%xpos" == string) {
            if (this.currentText != null) {
                this.currentText.setMovableXPercent((Integer)object);
            }
            return;
        }
        if ("%ypos" == string) {
            if (this.currentText != null) {
                this.currentText.setMovableYPercent((Integer)object);
            }
            return;
        }
        if ("xypos" == string) {
            if (this.currentText == null) {
                return;
            }
            Point3f point3f = (Point3f)object;
            if (point3f.z == Float.MAX_VALUE) {
                this.currentText.setMovableX((int)point3f.x);
                this.currentText.setMovableY((int)point3f.y);
            } else {
                this.currentText.setMovableXPercent((int)point3f.x);
                this.currentText.setMovableYPercent((int)point3f.y);
            }
            return;
        }
        if ("xyz" == string) {
            if (this.currentText != null) {
                this.currentText.setXYZ((Point3f)object);
                if (this.viewer.getFontScaling()) {
                    this.currentText.setScalePixelsPerMicron(this.viewer.getScalePixelsPerAngstrom() * 10000.0f);
                }
            }
            return;
        }
        if ("target" == string && (string2 = ((String)object).intern().toLowerCase()) != "none" && string2 != "all") {
            Text text = (Text)this.texts.get(string2);
            if (text == null) {
                int n = 0;
                int n2 = 1;
                if ("top" == string2) {
                    n = 1;
                    n2 = 2;
                } else if ("middle" == string2) {
                    n = 3;
                    n2 = 2;
                } else if ("bottom" == string2) {
                    n = 2;
                }
                text = new Text(this.viewer, this.g3d, this.g3d.getFont3D(FONTFACE, 20.0f), string2, 10, n, n2, 0.0f);
                text.setAdjustForWindow(true);
                this.texts.put(string2, text);
                if (this.currentFont != null) {
                    text.setFont(this.currentFont);
                }
                if (this.currentColor != null) {
                    text.setColix(this.currentColor);
                }
                if (this.currentBgColor != null) {
                    text.setBgColix(this.currentBgColor);
                }
                if (this.currentTranslucentLevel != 0.0f) {
                    text.setTranslucent(this.currentTranslucentLevel, false);
                }
                if (this.currentBgTranslucentLevel != 0.0f) {
                    text.setTranslucent(this.currentBgTranslucentLevel, true);
                }
            }
            this.currentText = text;
        }
        super.setProperty(string, object, null);
    }

    public void setVisibilityFlags(BitSet bitSet) {
        Enumeration enumeration = this.texts.elements();
        while (enumeration.hasMoreElements()) {
            Text text = (Text)enumeration.nextElement();
            text.setVisibility(text.modelIndex < 0 || bitSet.get(text.modelIndex));
        }
    }

    public String getShapeState() {
        StringBuffer stringBuffer = new StringBuffer("\n  set echo off;\n");
        String string = "";
        Enumeration enumeration = this.texts.elements();
        while (enumeration.hasMoreElements()) {
            Text text = (Text)enumeration.nextElement();
            stringBuffer.append(text.getState(true));
            String string2 = text.getState(false);
            if (string2.equals(string)) continue;
            string = string2;
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public Point3f checkObjectClicked(int n, int n2, int n3, BitSet bitSet) {
        Enumeration enumeration = this.texts.elements();
        while (enumeration.hasMoreElements()) {
            Text text = (Text)enumeration.nextElement();
            if (!text.checkObjectClicked(n, n2, bitSet)) continue;
            String string = text.getScript();
            if (string != null) {
                this.viewer.evalStringQuiet(string);
            }
            return text.xyz == null ? new Point3f() : text.xyz;
        }
        return null;
    }

    public boolean checkObjectHovered(int n, int n2, BitSet bitSet) {
        Enumeration enumeration = this.texts.elements();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            Text text = (Text)enumeration.nextElement();
            String string = text.getScript();
            if (string == null) continue;
            bl = true;
            if (!text.checkObjectClicked(n, n2, bitSet)) continue;
            this.viewer.setCursor(1);
            return true;
        }
        if (bl) {
            this.viewer.setCursor(0);
        }
        return false;
    }
}

