/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.ModelSet;
import org.jmol.util.Escape;
import org.jmol.util.Measure;
import org.jmol.util.TextFormat;
import org.jmol.vecmath.Point3fi;
import org.jmol.viewer.Viewer;

public class Measurement {
    private Viewer viewer;
    public ModelSet modelSet;
    protected int count;
    protected int[] countPlusIndices = new int[5];
    protected Point3fi[] points;
    private String strMeasurement;
    private String strFormat;
    protected float value;
    private boolean isVisible = true;
    private boolean isHidden = false;
    private boolean isDynamic = false;
    private boolean isTrajectory = false;
    private short colix;
    private int index;
    private AxisAngle4f aa;
    private Point3f pointArc;

    public int getCount() {
        return this.count;
    }

    public void setCount(int n) {
        this.count = this.countPlusIndices[0] = n;
    }

    public int[] getCountPlusIndices() {
        return this.countPlusIndices;
    }

    public Point3fi[] getPoints() {
        return this.points;
    }

    public int getAtomIndex(int n) {
        return n > 0 && n <= this.count ? this.countPlusIndices[n] : -1;
    }

    public Point3fi getAtom(int n) {
        int n2 = this.countPlusIndices[n];
        return n2 < -1 ? this.points[-2 - n2] : this.modelSet.getAtomAt(n2);
    }

    public int getLastIndex() {
        return this.count > 0 ? this.countPlusIndices[this.count] : -1;
    }

    public String getString() {
        return this.strMeasurement;
    }

    public String getStringDetail() {
        return (this.count == 2 ? "Distance" : (this.count == 3 ? "Angle" : "Torsion")) + this.getMeasurementScript(" - ") + " : " + this.value;
    }

    public String getStrFormat() {
        return this.strFormat;
    }

    public float getValue() {
        return this.value;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public boolean isTrajectory() {
        return this.isTrajectory;
    }

    public void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    public void setHidden(boolean bl) {
        this.isHidden = bl;
    }

    public void setDynamic(boolean bl) {
        this.isDynamic = bl;
    }

    public short getColix() {
        return this.colix;
    }

    public void setColix(short s) {
        this.colix = s;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    public AxisAngle4f getAxisAngle() {
        return this.aa;
    }

    public Point3f getPointArc() {
        return this.pointArc;
    }

    public Measurement(ModelSet modelSet, int[] nArray, Point3fi[] point3fiArray, float f, short s, String string, int n) {
        this.index = n;
        this.modelSet = modelSet;
        this.viewer = modelSet.viewer;
        this.colix = s;
        this.strFormat = string;
        int n2 = this.count = nArray == null ? 0 : nArray[0];
        if (this.count > 0) {
            System.arraycopy(nArray, 0, this.countPlusIndices, 0, this.count + 1);
            this.isTrajectory = modelSet.isTrajectory(this.countPlusIndices);
        }
        this.value = Float.isNaN(f) || this.isTrajectory ? this.getMeasurement() : f;
        this.points = point3fiArray == null ? new Point3fi[4] : point3fiArray;
        this.formatMeasurement();
    }

    public Measurement(ModelSet modelSet, int[] nArray, Point3fi[] point3fiArray) {
        this.countPlusIndices = nArray;
        this.count = nArray[0];
        this.points = point3fiArray == null ? new Point3fi[4] : point3fiArray;
        this.modelSet = modelSet;
    }

    public void refresh() {
        this.value = this.getMeasurement();
        this.isTrajectory = this.modelSet.isTrajectory(this.countPlusIndices);
        this.formatMeasurement();
    }

    public String getMeasurementScript(String string) {
        String string2 = "";
        boolean bl = string.equals(" ");
        for (int i = 1; i <= this.count; ++i) {
            int n = this.countPlusIndices[i];
            string2 = string2 + (i > 1 ? string : " ") + (n < 0 ? Escape.escape((Tuple3f)this.getAtom(i)) : (bl ? "{atomIndex=" + this.countPlusIndices[i] + "}" : this.viewer.getAtomInfo(n)));
        }
        return string2;
    }

    public void formatMeasurement(String string, boolean bl) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (!bl && string != null && string.indexOf(this.countPlusIndices[0] + ":") != 0) {
            return;
        }
        this.strFormat = string;
        this.formatMeasurement();
    }

    protected void formatMeasurement() {
        this.strMeasurement = null;
        if (Float.isNaN(this.value) || this.count == 0) {
            return;
        }
        switch (this.count) {
            case 2: {
                this.strMeasurement = this.formatDistance(this.value);
                return;
            }
            case 3: {
                if (this.value == 180.0f) {
                    this.aa = null;
                    this.pointArc = null;
                } else {
                    Vector3f vector3f = new Vector3f();
                    Vector3f vector3f2 = new Vector3f();
                    float f = Measure.computeAngle((Point3f)this.getAtom(1), (Point3f)this.getAtom(2), (Point3f)this.getAtom(3), (Vector3f)vector3f, (Vector3f)vector3f2, (boolean)false);
                    Vector3f vector3f3 = new Vector3f();
                    vector3f3.cross(vector3f, vector3f2);
                    this.aa = new AxisAngle4f(vector3f3.x, vector3f3.y, vector3f3.z, f);
                    vector3f.normalize();
                    vector3f.scale(0.5f);
                    this.pointArc = new Point3f((Tuple3f)vector3f);
                }
            }
            case 4: {
                this.strMeasurement = this.formatAngle(this.value);
                return;
            }
        }
    }

    public void reformatDistanceIfSelected() {
        if (this.count != 2) {
            return;
        }
        if (this.viewer.isSelected(this.countPlusIndices[1]) && this.viewer.isSelected(this.countPlusIndices[2])) {
            this.formatMeasurement();
        }
    }

    private String formatDistance(float f) {
        float f2;
        int n = (int)(f * 100.0f + 0.5f);
        String string = this.viewer.getMeasureDistanceUnits();
        if (string == "nanometers") {
            string = "nm";
            f2 = (float)n / 1000.0f;
        } else if (string == "picometers") {
            string = "pm";
            f2 = (float)((int)((double)(f * 1000.0f) + 0.5)) / 10.0f;
        } else if (string == "au") {
            f2 = (float)((int)(f / 0.5291772f * 1000.0f + 0.5f)) / 1000.0f;
        } else {
            string = "\u00c5";
            f2 = (float)n / 100.0f;
        }
        return this.formatString(f2, string);
    }

    private String formatAngle(float f) {
        f = (int)(f * 10.0f + (f >= 0.0f ? 0.5f : -0.5f));
        return this.formatString(f /= 10.0f, "\u00b0");
    }

    private String formatString(float f, String string) {
        String string2;
        String string3 = this.countPlusIndices[0] + ":" + "";
        String string4 = string2 = this.strFormat != null && this.strFormat.indexOf(string3) == 0 ? this.strFormat : this.viewer.getDefaultMeasurementLabel(this.countPlusIndices[0]);
        if (string2.indexOf(string3) == 0) {
            string2 = string2.substring(2);
        }
        string2 = TextFormat.formatString((String)string2, (String)"#", (int)(this.index + 1));
        string2 = TextFormat.formatString((String)string2, (String)"UNITS", (String)string);
        string2 = TextFormat.formatString((String)string2, (String)"VALUE", (float)f);
        for (int i = this.countPlusIndices[0]; i >= 1 && string2.indexOf("%") >= 0; --i) {
            string2 = this.modelSet.atoms[this.countPlusIndices[i]].formatLabel(string2, (char)(48 + i), null);
        }
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public boolean sameAs(int[] nArray, Point3fi[] point3fiArray) {
        int n;
        if (this.count != nArray[0]) {
            return false;
        }
        boolean bl = true;
        for (n = 1; n <= this.count && bl; ++n) {
            bl = this.countPlusIndices[n] == nArray[n];
        }
        if (bl) {
            for (n = 0; n < this.count && bl; ++n) {
                if (point3fiArray[n] == null) continue;
                bl = (double)this.points[n].distance((Point3f)point3fiArray[n]) < 0.01;
            }
        }
        if (bl) {
            return true;
        }
        switch (this.count) {
            default: {
                return true;
            }
            case 2: {
                return this.sameAs(nArray, point3fiArray, 1, 2) && this.sameAs(nArray, point3fiArray, 2, 1);
            }
            case 3: {
                return this.sameAs(nArray, point3fiArray, 1, 3) && this.sameAs(nArray, point3fiArray, 2, 2) && this.sameAs(nArray, point3fiArray, 3, 1);
            }
            case 4: 
        }
        return this.sameAs(nArray, point3fiArray, 1, 4) && this.sameAs(nArray, point3fiArray, 2, 3) && this.sameAs(nArray, point3fiArray, 3, 2) && this.sameAs(nArray, point3fiArray, 4, 1);
    }

    private boolean sameAs(int[] nArray, Point3fi[] point3fiArray, int n, int n2) {
        int n3 = this.countPlusIndices[n];
        int n4 = nArray[n2];
        if (n4 < 0 && point3fiArray[-2 - n4] == null) {
            System.out.println("measurement -- ohoh");
        }
        return n3 >= 0 || n4 >= 0 ? n3 == n4 : (double)this.points[-2 - n3].distance((Point3f)point3fiArray[-2 - n4]) < 0.01;
    }

    public boolean sameAs(int n, int n2) {
        return this.sameAs(this.countPlusIndices, this.points, n, n2);
    }

    public Vector toVector() {
        Vector<String> vector = new Vector<String>();
        for (int i = 1; i <= this.count; ++i) {
            vector.addElement(this.getLabel(i, false));
        }
        vector.addElement(this.strMeasurement);
        return vector;
    }

    public float getMeasurement() {
        if (this.countPlusIndices == null) {
            return Float.NaN;
        }
        if (this.count < 2) {
            return Float.NaN;
        }
        int n = this.count;
        while (--n >= 0) {
            if (this.countPlusIndices[n + 1] != -1) continue;
            return Float.NaN;
        }
        Point3fi point3fi = this.getAtom(1);
        Point3fi point3fi2 = this.getAtom(2);
        switch (this.count) {
            case 2: {
                return point3fi.distance((Point3f)point3fi2);
            }
            case 3: {
                Point3fi point3fi3 = this.getAtom(3);
                return Measure.computeAngle((Point3f)point3fi, (Point3f)point3fi2, (Point3f)point3fi3, (boolean)true);
            }
            case 4: {
                Point3fi point3fi4 = this.getAtom(3);
                Point3fi point3fi5 = this.getAtom(4);
                return Measure.computeTorsion((Point3f)point3fi, (Point3f)point3fi2, (Point3f)point3fi4, (Point3f)point3fi5, (boolean)true);
            }
        }
        return Float.NaN;
    }

    public String getLabel(int n, boolean bl) {
        int n2 = this.countPlusIndices[n];
        return n2 < 0 ? Escape.escape((Tuple3f)this.getAtom(n)) : (bl ? "({" + n2 + "})" : this.viewer.getAtomInfo(n2));
    }
}

