/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import java.util.Hashtable;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Logger;
import org.jmol.util.Quaternion;
import org.jmol.viewer.JmolConstants;

public class Group {
    protected Chain chain;
    int seqcode;
    protected short groupID;
    protected boolean isAmino;
    int selectedIndex;
    protected int firstAtomIndex = -1;
    protected int lastAtomIndex;
    private static final int SEQUENCE_NUMBER_FLAG = 128;
    private static final int INSERTION_CODE_MASK = 127;
    private static final int SEQUENCE_NUMBER_SHIFT = 8;
    public int shapeVisibilityFlags = 0;
    private int minZ;
    protected float phi = Float.NaN;
    protected float psi = Float.NaN;
    protected float omega = Float.NaN;
    protected float straightness = Float.NaN;
    private static Hashtable htGroup = new Hashtable();
    static String[] group3Names = new String[128];
    static short group3NameCount = 0;

    public int getFirstAtomIndex() {
        return this.firstAtomIndex;
    }

    public int getLastAtomIndex() {
        return this.lastAtomIndex;
    }

    public void setMinZ(int n) {
        this.minZ = n;
    }

    public int getMinZ() {
        return this.minZ;
    }

    public float getStraightness() {
        return this.straightness;
    }

    public void setStraightness(float f) {
        this.straightness = f;
    }

    public float getPhi() {
        return this.phi;
    }

    public void setPhi(float f) {
        this.phi = f;
    }

    public float getPsi() {
        return this.psi;
    }

    public void setPsi(float f) {
        this.psi = f;
    }

    public void setOmega(float f) {
        this.omega = f;
    }

    public float getOmega() {
        return this.omega;
    }

    public Group(Chain chain, String string, int n, int n2, int n3) {
        this.chain = chain;
        this.seqcode = n;
        if (string == null) {
            string = "";
        }
        this.groupID = Group.getGroupID(string);
        this.isAmino = this.groupID >= 1 && this.groupID < 24;
        this.firstAtomIndex = n2;
        this.lastAtomIndex = n3;
    }

    public void setModelSet(ModelSet modelSet) {
        this.chain.modelSet = modelSet;
    }

    public final void setShapeVisibility(int n, boolean bl) {
        this.shapeVisibilityFlags = bl ? (this.shapeVisibilityFlags |= n) : (this.shapeVisibilityFlags &= ~n);
    }

    final boolean isGroup3(String string) {
        return group3Names[this.groupID].equalsIgnoreCase(string);
    }

    final String getGroup3() {
        return group3Names[this.groupID];
    }

    public static String getGroup3(short s) {
        return group3Names[s];
    }

    public final char getGroup1() {
        if (this.groupID >= JmolConstants.predefinedGroup1Names.length) {
            return '?';
        }
        return JmolConstants.predefinedGroup1Names[this.groupID];
    }

    public final short getGroupID() {
        return this.groupID;
    }

    final boolean isGroup3Match(String string) {
        int n;
        int n2 = 0;
        String string2 = group3Names[this.groupID];
        int n3 = string2.length();
        if (n < n3) {
            return false;
        }
        for (n = string.length(); n > n3; --n) {
            if (string.charAt(n2) == '?') {
                ++n2;
                continue;
            }
            if (string.charAt(n2 + n - 1) == '?') continue;
            return false;
        }
        int n4 = n3;
        while (--n4 >= 0) {
            char c = string.charAt(n2 + n4);
            if (c == '?' || c == string2.charAt(n4)) continue;
            return false;
        }
        return true;
    }

    public final char getChainID() {
        return this.chain.chainID;
    }

    public int getBioPolymerLength() {
        return 0;
    }

    public int getBioPolymerIndex() {
        return -1;
    }

    public Object getStructure() {
        return null;
    }

    public int getProteinStructureID() {
        return Integer.MIN_VALUE;
    }

    public byte getProteinStructureType() {
        return 0;
    }

    public int setProteinStructureType(byte by, int n) {
        return -1;
    }

    public Hashtable getMyInfo() {
        return null;
    }

    public boolean isProtein() {
        return false;
    }

    public boolean isNucleic() {
        return false;
    }

    public boolean isDna() {
        return false;
    }

    public boolean isRna() {
        return false;
    }

    public boolean isPurine() {
        return false;
    }

    public boolean isPyrimidine() {
        return false;
    }

    public boolean isCarbohydrate() {
        return false;
    }

    static synchronized short addGroup3Name(String string) {
        if (group3NameCount == group3Names.length) {
            group3Names = ArrayUtil.doubleLength((String[])group3Names);
        }
        short s = group3NameCount;
        group3NameCount = (short)(s + 1);
        short s2 = s;
        Group.group3Names[s2] = string;
        htGroup.put(string, new Short(s2));
        return s2;
    }

    public static short getGroupID(String string) {
        if (string == null) {
            return -1;
        }
        short s = Group.lookupGroupID(string);
        return s != -1 ? s : Group.addGroup3Name(string);
    }

    public static short lookupGroupID(String string) {
        Short s;
        if (string != null && (s = (Short)htGroup.get(string)) != null) {
            return s;
        }
        return -1;
    }

    public final int getResno() {
        return this.seqcode == Integer.MIN_VALUE ? 0 : this.seqcode >> 8;
    }

    public final int getSeqcode() {
        return this.seqcode;
    }

    public final int getSeqNumber() {
        return this.seqcode >> 8;
    }

    public static final int getSequenceNumber(int n) {
        return Group.haveSequenceNumber(n) ? n >> 8 : Integer.MAX_VALUE;
    }

    public static final int getInsertionCodeValue(int n) {
        return n & 0x7F;
    }

    public static final boolean haveSequenceNumber(int n) {
        return (n & 0x80) != 0;
    }

    public final String getSeqcodeString() {
        return Group.getSeqcodeString(this.seqcode);
    }

    public static int getSeqcode(int n, char c) {
        if (n == Integer.MIN_VALUE) {
            return n;
        }
        if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '?' || c == '*')) {
            if (c != ' ' && c != '\u0000') {
                Logger.warn((String)("unrecognized insertionCode:" + c));
            }
            c = '\u0000';
        }
        return (n == Integer.MAX_VALUE ? 0 : n << 8 | 0x80) + c;
    }

    public static String getSeqcodeString(int n) {
        if (n == Integer.MIN_VALUE) {
            return null;
        }
        return (n & 0x7F) == 0 ? "" + (n >> 8) : "" + (n >> 8) + '^' + (char)(n & 0x7F);
    }

    public char getInsertionCode() {
        if (this.seqcode == Integer.MIN_VALUE) {
            return '\u0000';
        }
        return (char)(this.seqcode & 0x7F);
    }

    public static char getInsertionCode(int n) {
        if (n == Integer.MIN_VALUE) {
            return '\u0000';
        }
        return (char)(n & 0x7F);
    }

    public final void selectAtoms(BitSet bitSet) {
        for (int i = this.firstAtomIndex; i <= this.lastAtomIndex; ++i) {
            bitSet.set(i);
        }
    }

    public boolean isSelected(BitSet bitSet) {
        for (int i = this.firstAtomIndex; i <= this.lastAtomIndex; ++i) {
            if (!bitSet.get(i)) continue;
            return true;
        }
        return false;
    }

    boolean isHetero() {
        return this.chain.getAtom(this.firstAtomIndex).isHetero();
    }

    public String toString() {
        return "[" + this.getGroup3() + "-" + this.getSeqcodeString() + "]";
    }

    protected int scaleToScreen(int n, int n2) {
        return this.chain.modelSet.viewer.scaleToScreen(n, n2);
    }

    protected boolean isCursorOnTopOf(Atom atom, int n, int n2, int n3, Atom atom2) {
        return this.chain.modelSet.isCursorOnTopOf(atom, n, n2, n3, atom2);
    }

    protected boolean isAtomHidden(int n) {
        return this.chain.modelSet.isAtomHidden(n);
    }

    public Model getModel() {
        return this.chain.model;
    }

    public int getModelIndex() {
        return this.chain.model.getModelIndex();
    }

    public int getSelectedMonomerCount() {
        return 0;
    }

    public int getSelectedMonomerIndex() {
        return -1;
    }

    public int getSelectedGroupIndex() {
        return this.selectedIndex;
    }

    public Atom getLeadAtom(Atom atom) {
        Atom atom2 = this.getLeadAtom();
        return atom2 == null ? atom : atom2;
    }

    public Atom getLeadAtom() {
        return null;
    }

    public Quaternion getQuaternion(char c) {
        return null;
    }

    static {
        for (int i = 0; i < JmolConstants.predefinedGroup3Names.length; ++i) {
            Group.addGroup3Name(JmolConstants.predefinedGroup3Names[i]);
        }
    }
}

