/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.SmarterJmolAdapter;

public class NWChemReader
extends AtomSetCollectionReader {
    private int taskNumber = 1;
    private int equivalentAtomSets = 0;
    private String energyKey = "";
    private String energyValue = "";
    private boolean converged;
    private boolean haveEnergy;
    private boolean haveAt;
    private boolean inInput;

    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("nwchem");
        this.init();
        try {
            while (this.readLine() != null) {
                if (this.line.startsWith("          Step")) {
                    this.init();
                    continue;
                }
                if (this.line.startsWith("      Symmetry information")) {
                    this.readSymmetry();
                    continue;
                }
                if (this.line.indexOf("Total") >= 0) {
                    this.readTotal();
                    continue;
                }
                if (this.line.indexOf("@") >= 0) {
                    this.readAtSign();
                    continue;
                }
                if (this.line.startsWith("      Optimization converged")) {
                    this.converged = true;
                    continue;
                }
                if (this.line.indexOf("Output coordinates in angstroms") >= 0) {
                    ++this.equivalentAtomSets;
                    this.readAtoms();
                    continue;
                }
                if (this.line.indexOf("ENERGY GRADIENTS") >= 0) {
                    ++this.equivalentAtomSets;
                    this.readGradients();
                    continue;
                }
                if (this.line.indexOf("NWChem Nuclear Hessian and Frequency Analysis") >= 0) {
                    this.readFrequencies();
                    continue;
                }
                if (this.line.startsWith(" Task  times")) {
                    this.init();
                    ++this.taskNumber;
                    continue;
                }
                if (this.line.trim().startsWith("NWChem")) {
                    this.readNWChemLine();
                    continue;
                }
                if (!this.line.startsWith("  Mulliken analysis of the total density") || this.equivalentAtomSets <= 0) continue;
                this.readPartialCharges();
            }
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        return this.atomSetCollection;
    }

    private void init() {
        this.haveEnergy = false;
        this.haveAt = false;
        this.converged = false;
        this.inInput = false;
        this.equivalentAtomSets = 0;
    }

    private void setEnergies(String string, String string2, int n) {
        this.energyKey = string;
        this.energyValue = string2;
        this.atomSetCollection.setAtomSetProperties(this.energyKey, this.energyValue, this.equivalentAtomSets);
        this.atomSetCollection.setAtomSetNames(this.energyKey + " = " + this.energyValue, this.equivalentAtomSets);
        this.haveEnergy = true;
    }

    private void setEnergy(String string, String string2) {
        this.energyKey = string;
        this.energyValue = string2;
        this.atomSetCollection.setAtomSetProperty(this.energyKey, this.energyValue);
        this.atomSetCollection.setAtomSetName(this.energyKey + " = " + this.energyValue);
        this.haveEnergy = true;
    }

    private void readSymmetry() throws Exception {
        this.discardLines(2);
        if (this.readLine() == null) {
            return;
        }
        String[] stringArray = this.getTokens();
        this.atomSetCollection.setAtomSetProperties("Symmetry group name", stringArray[stringArray.length - 1], this.equivalentAtomSets);
    }

    private void readNWChemLine() {
        this.inInput = this.line.indexOf("NWChem Input Module") >= 0;
    }

    private void readTotal() {
        String[] stringArray = this.getTokens();
        try {
            if (stringArray[2].startsWith("energy") && !this.haveAt) {
                this.setEnergies("E(" + stringArray[1] + ")", stringArray[stringArray.length - 1], this.equivalentAtomSets);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readAtSign() throws Exception {
        if (this.line.charAt(2) == 'S') {
            this.discardLines(1);
            if (this.readLine() == null) {
                return;
            }
        }
        String[] stringArray = this.getTokens();
        if (!this.haveEnergy) {
            this.setEnergies("E", stringArray[2], this.equivalentAtomSets);
        } else {
            this.setEnergies(this.energyKey, this.energyValue, this.equivalentAtomSets);
        }
        this.atomSetCollection.setAtomSetProperties("Step", stringArray[1], this.equivalentAtomSets);
        this.haveAt = true;
    }

    private void readAtoms() throws Exception {
        String[] stringArray;
        this.discardLines(3);
        this.haveEnergy = false;
        this.atomSetCollection.newAtomSet();
        this.atomSetCollection.setAtomSetProperty(".PATH", "Task " + this.taskNumber + (this.inInput ? SmarterJmolAdapter.PATH_SEPARATOR + "Input" : SmarterJmolAdapter.PATH_SEPARATOR + "Geometry"));
        while (this.readLine() != null && this.line.length() > 0 && (stringArray = this.getTokens()).length >= 6) {
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = this.fixTag(stringArray[1]);
            atom.set(this.parseFloat(stringArray[3]), this.parseFloat(stringArray[4]), this.parseFloat(stringArray[5]));
        }
        if (this.converged) {
            this.setEnergy(this.energyKey, this.energyValue);
            this.atomSetCollection.setAtomSetProperty("Step", "converged");
        } else if (this.inInput) {
            this.atomSetCollection.setAtomSetName("Input");
        }
    }

    private void readGradients() throws Exception {
        String[] stringArray;
        this.discardLines(3);
        this.atomSetCollection.newAtomSet();
        if (this.equivalentAtomSets > 1) {
            this.atomSetCollection.cloneLastAtomSetProperties();
        }
        this.atomSetCollection.setAtomSetProperty("vector", "gradient");
        this.atomSetCollection.setAtomSetProperty(".PATH", "Task " + this.taskNumber + SmarterJmolAdapter.PATH_SEPARATOR + "Gradients");
        while (this.readLine() != null && this.line.length() > 0 && (stringArray = this.getTokens()).length >= 8) {
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = this.fixTag(stringArray[1]);
            atom.set(this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3]), this.parseFloat(stringArray[4]));
            atom.scale(0.5291772f);
            atom.vectorX = -this.parseFloat(stringArray[5]);
            atom.vectorY = -this.parseFloat(stringArray[6]);
            atom.vectorZ = -this.parseFloat(stringArray[7]);
        }
    }

    private void readFrequencies() throws Exception {
        Atom[] atomArray;
        int n;
        int n2;
        String[] stringArray;
        String string = "Task " + this.taskNumber + SmarterJmolAdapter.PATH_SEPARATOR + "Frequencies";
        this.discardLinesUntilContains("Atom information");
        this.discardLines(2);
        this.atomSetCollection.newAtomSet();
        this.atomSetCollection.setAtomSetProperty(".PATH", string);
        while (this.readLine() != null && this.line.indexOf("---") < 0) {
            stringArray = this.getTokens();
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = this.fixTag(stringArray[0]);
            atom.set(this.parseFloat(stringArray[2]), this.parseFloat(stringArray[3]), this.parseFloat(stringArray[4]));
            atom.scale(0.5291772f);
        }
        int n3 = this.atomSetCollection.getCurrentAtomSetIndex();
        int n4 = 0;
        int n5 = this.atomSetCollection.getLastAtomSetAtomCount();
        boolean bl = true;
        this.discardLinesUntilContains("(Projected Frequencies expressed in cm-1)");
        this.discardLines(3);
        while (this.readLine() != null && this.line.indexOf("P.Frequency") >= 0) {
            stringArray = AtomSetCollectionReader.getTokens((String)this.line, (int)12);
            n2 = stringArray.length;
            int n6 = n = bl ? 1 : 0;
            while (n < n2) {
                this.atomSetCollection.cloneLastAtomSet();
                this.atomSetCollection.setAtomSetProperty(".PATH", string);
                ++n;
            }
            bl = false;
            for (n = 0; n < n2; ++n) {
                int n7 = n3 + n4 + n;
                String string2 = stringArray[n] + " cm**-1";
                this.atomSetCollection.setAtomSetName(string2, n7);
                this.atomSetCollection.setAtomSetProperty("Frequency", string2, n7);
            }
            n = this.atomSetCollection.getAtomCount() - n2 * n5;
            this.discardLines(1);
            atomArray = this.atomSetCollection.getAtoms();
            for (int i = 0; i < n5 * 3; ++i) {
                if (this.readLine() == null) {
                    return;
                }
                stringArray = this.getTokens();
                block12: for (int j = 0; j < n2; ++j) {
                    Atom atom = atomArray[n + j * n5 + i / 3];
                    float f = this.parseFloat(stringArray[j + 1]);
                    switch (i % 3) {
                        case 0: {
                            atom.vectorX = f;
                            continue block12;
                        }
                        case 1: {
                            atom.vectorY = f;
                            continue block12;
                        }
                        case 2: {
                            atom.vectorZ = f;
                        }
                    }
                }
            }
            n4 += n2;
            this.discardLines(3);
        }
        try {
            this.discardLinesUntilContains("Projected Infra Red Intensities");
            this.discardLines(2);
            n2 = n4;
            n = n3;
            while (--n2 >= 0) {
                if (this.readLine() == null) {
                    return;
                }
                stringArray = this.getTokens();
                atomArray = stringArray[1] + " cm**-1";
                this.atomSetCollection.setAtomSetName((String)atomArray, n);
                this.atomSetCollection.setAtomSetProperty("Frequency", (String)atomArray, n);
                this.atomSetCollection.setAtomSetProperty("IR Intensity", stringArray[5] + " KM/mol", n);
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void readPartialCharges() throws Exception {
        this.discardLines(4);
        int n = this.atomSetCollection.getAtomCount();
        int n2 = this.atomSetCollection.getLastAtomSetAtomIndex();
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        for (int i = n2; i < n; ++i) {
            while (atomArray[i].elementNumber == 0) {
                ++i;
            }
            if (this.readLine() == null) {
                return;
            }
            String[] stringArray = this.getTokens();
            atomArray[i].partialCharge = (float)this.parseInt(stringArray[2]) - this.parseFloat(stringArray[3]);
        }
    }

    private String fixTag(String string) {
        String string2 = string.toLowerCase();
        if (string2.equals("bq")) {
            return "X";
        }
        if (string2.startsWith("bq")) {
            return string.substring(2) + "-Bq";
        }
        return string;
    }
}

