/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.BitSet;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.shape.Shape;
import org.jmol.shapespecial.Isosurface;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.TextFormat;

public class LcaoCartoon
extends Isosurface {
    private String thisType;
    private int myColorPt;
    private String lcaoID;
    private BitSet thisSet;
    private boolean isMolecular;
    private Vector3f rotationAxis;
    private Float lcaoScale;
    private boolean isTranslucent;
    private float translucentLevel;
    private Integer lcaoColorPos;
    private Integer lcaoColorNeg;

    public void initShape() {
        super.initShape();
        this.myType = "lcaoCartoon";
        this.allowMesh = false;
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if (Logger.debugging) {
            Logger.debug((String)("\nLcaoCartoon.setProperty " + string + " " + object));
        }
        if ("init" == string) {
            this.myColorPt = 0;
            this.lcaoID = null;
            this.thisSet = bitSet;
            this.isMolecular = false;
            this.thisType = null;
            this.rotationAxis = null;
            super.setProperty("init", null, null);
            return;
        }
        if ("lcaoID" == string) {
            this.lcaoID = (String)object;
            return;
        }
        if ("thisID" == string) {
            this.lcaoID = (String)object;
        }
        if ("selectType" == string) {
            this.thisType = (String)object;
            return;
        }
        if ("rotationAxis" == string) {
            this.rotationAxis = (Vector3f)object;
            return;
        }
        if ("scale" == string) {
            this.lcaoScale = (Float)object;
        }
        if ("colorRGB" == string) {
            this.lcaoColorPos = (Integer)object;
            if (this.myColorPt++ == 0) {
                this.lcaoColorNeg = this.lcaoColorPos;
            }
        }
        if ("select" == string) {
            this.thisSet = (BitSet)object;
        }
        if (string == "translucentLevel") {
            this.translucentLevel = ((Float)object).floatValue();
        }
        if ("settranslucency" == string) {
            this.isTranslucent = ((String)object).equals("translucent");
            return;
        }
        if ("translucency" == string) {
            this.isTranslucent = ((String)object).equals("translucent");
            if (this.lcaoID == null) {
                return;
            }
        }
        if ("molecular" == string) {
            this.isMolecular = true;
            if (object == null) {
                return;
            }
            string = "create";
        }
        if ("create" == string) {
            this.myColorPt = 0;
            this.thisType = (String)object;
            this.createLcaoCartoon();
            return;
        }
        if ("on" == string) {
            this.setLcaoOn(true);
            return;
        }
        if ("off" == string) {
            this.setLcaoOn(false);
            return;
        }
        if ("delete" == string) {
            this.deleteLcaoCartoon();
            return;
        }
        super.setProperty(string, object, bitSet);
        if ("lobe" == string || "sphere" == string) {
            this.setScriptInfo();
        }
    }

    private void setLcaoOn(boolean bl) {
        int n;
        int n2 = n = ((Shape)this).viewer.getAtomCount();
        while (--n2 >= 0) {
            if (this.lcaoID == null && !this.thisSet.get(n2)) continue;
            this.setLcaoOn(n2, bl);
        }
    }

    private void setLcaoOn(int n, boolean bl) {
        String string = this.getID(this.lcaoID, n);
        int n2 = this.meshCount;
        while (--n2 >= 0) {
            if (this.meshes[n2].thisID.indexOf(string) != 0) continue;
            this.meshes[n2].visible = bl;
        }
    }

    private void deleteLcaoCartoon() {
        int n;
        int n2 = n = ((Shape)this).viewer.getAtomCount();
        while (--n2 >= 0) {
            if (this.lcaoID == null && !this.thisSet.get(n2)) continue;
            this.deleteLcaoCartoon(n2);
        }
    }

    private void deleteLcaoCartoon(int n) {
        String string = this.getID(this.lcaoID, n);
        int n2 = this.meshCount;
        while (--n2 >= 0) {
            if (this.meshes[n2].thisID.indexOf(string) != 0) continue;
            this.deleteMesh(n2);
        }
    }

    private void createLcaoCartoon() {
        this.isMolecular = this.isMolecular && (this.thisType.indexOf("px") >= 0 || this.thisType.indexOf("py") >= 0 || this.thisType.indexOf("pz") >= 0);
        int n = ((Shape)this).viewer.getAtomCount();
        String string = this.lcaoID;
        for (int i = 0; i < n; ++i) {
            if (!this.thisSet.get(i)) continue;
            this.createLcaoCartoon(i);
            this.lcaoID = string;
        }
    }

    private void createLcaoCartoon(int n) {
        String string = this.getID(this.lcaoID, n);
        int n2 = this.meshCount;
        while (--n2 >= 0) {
            if (this.meshes[n2].thisID.indexOf(string) != 0) continue;
            this.deleteMesh(n2);
        }
        super.setProperty("init", null, null);
        super.setProperty("thisID", string, null);
        System.out.println("lcaocartoon: " + string);
        if (this.lcaoScale != null) {
            super.setProperty("scale", this.lcaoScale, null);
        }
        if (this.lcaoColorNeg != null) {
            super.setProperty("colorRGB", this.lcaoColorNeg, null);
            super.setProperty("colorRGB", this.lcaoColorPos, null);
        }
        super.setProperty("lcaoType", this.thisType, null);
        super.setProperty("atomIndex", new Integer(n), null);
        Vector3f[] vector3fArray = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f((Tuple3f)((Shape)this).modelSet.atoms[n]), new Vector3f()};
        if (this.rotationAxis != null) {
            vector3fArray[3].set((Tuple3f)this.rotationAxis);
        }
        if (this.isMolecular) {
            if (this.thisType.indexOf("px") >= 0) {
                vector3fArray[0].set(0.0f, -1.0f, 0.0f);
                vector3fArray[1].set(1.0f, 0.0f, 0.0f);
            } else if (this.thisType.indexOf("py") >= 0) {
                vector3fArray[0].set(-1.0f, 0.0f, 0.0f);
                vector3fArray[1].set(0.0f, 0.0f, 1.0f);
            } else if (this.thisType.indexOf("pz") >= 0) {
                vector3fArray[0].set(0.0f, 0.0f, 1.0f);
                vector3fArray[1].set(1.0f, 0.0f, 0.0f);
            }
            if (this.thisType.indexOf("-") == 0) {
                vector3fArray[0].scale(-1.0f);
            }
        }
        if (this.isMolecular || this.thisType.equalsIgnoreCase("s") || ((Shape)this).viewer.getHybridizationAndAxes(n, vector3fArray[0], vector3fArray[1], this.thisType, true) != null) {
            super.setProperty("lcaoCartoon", vector3fArray, null);
        }
        if (this.isTranslucent) {
            int n3 = this.meshCount;
            while (--n3 >= 0) {
                if (this.meshes[n3].thisID.indexOf(string) != 0) continue;
                this.meshes[n3].setTranslucent(true, this.translucentLevel);
            }
        }
    }

    private String getID(String string, int n) {
        return (string != null ? string : "lcao_" + (n + 1) + "_") + (this.thisType == null ? "" : TextFormat.simpleReplace((String)this.thisType, (String)"-", (String)(this.thisType.indexOf("-p") == 0 ? "" : "_")));
    }

    public String getShapeState() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.lcaoScale != null) {
            Shape.appendCmd((StringBuffer)stringBuffer, (String)("lcaoCartoon scale " + this.lcaoScale.floatValue()));
        }
        if (this.lcaoColorNeg != null) {
            Shape.appendCmd((StringBuffer)stringBuffer, (String)("lcaoCartoon color " + Escape.escapeColor((int)this.lcaoColorNeg) + " " + Escape.escapeColor((int)this.lcaoColorPos)));
        }
        if (this.isTranslucent) {
            Shape.appendCmd((StringBuffer)stringBuffer, (String)("lcaoCartoon translucent " + this.translucentLevel));
        }
        int n = this.meshCount;
        while (--n >= 0) {
            if (this.meshes[n].visible) continue;
            Shape.appendCmd((StringBuffer)stringBuffer, (String)("lcaoCartoon ID " + this.meshes[n].thisID + " off"));
        }
        return super.getShapeState() + stringBuffer.toString();
    }
}

