/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import javax.vecmath.Point3i;
import org.jmol.geodesic.EnvelopeCalculation;
import org.jmol.geodesic.Geodesic;
import org.jmol.shape.DotsRenderer;
import org.jmol.shape.ShapeRenderer;
import org.jmol.shapespecial.GeoSurface;

public class GeoSurfaceRenderer
extends DotsRenderer {
    private Point3i facePt1 = new Point3i();
    private Point3i facePt2 = new Point3i();
    private Point3i facePt3 = new Point3i();

    protected void render() {
        GeoSurface geoSurface = (GeoSurface)((ShapeRenderer)this).shape;
        boolean bl = this.iShowSolid = !((ShapeRenderer)this).viewer.getInMotion() || geoSurface.ec.getDotsConvexMax() <= 100;
        if (!this.iShowSolid && !((ShapeRenderer)this).g3d.setColix((short)4)) {
            return;
        }
        if (this.iShowSolid && this.faceMap == null) {
            this.faceMap = new int[this.screenDotCount];
        }
        this.render1(geoSurface);
    }

    protected void renderConvex(short s, int[] nArray, int n) {
        ((ShapeRenderer)this).colix = s;
        if (this.iShowSolid) {
            if (((ShapeRenderer)this).g3d.setColix(s)) {
                this.renderSurface(nArray);
            }
            return;
        }
        this.renderDots(n);
    }

    private void renderSurface(int[] nArray) {
        if (this.faceMap == null) {
            return;
        }
        short[] sArray = Geodesic.getFaceVertexes((int)this.screenLevel);
        int[] nArray2 = this.screenCoordinates;
        int n = nArray.length << 5;
        if (this.screenDotCount < n) {
            n = this.screenDotCount;
        }
        int n2 = 0;
        while (n2 < sArray.length) {
            short s = sArray[n2++];
            short s2 = sArray[n2++];
            short s3 = sArray[n2++];
            if (s >= n || s2 >= n || s3 >= n || !EnvelopeCalculation.getBit((int[])nArray, (int)s) || !EnvelopeCalculation.getBit((int[])nArray, (int)s2) || !EnvelopeCalculation.getBit((int[])nArray, (int)s3)) continue;
            this.facePt1.set(nArray2[this.faceMap[s]], nArray2[this.faceMap[s] + 1], nArray2[this.faceMap[s] + 2]);
            this.facePt2.set(nArray2[this.faceMap[s2]], nArray2[this.faceMap[s2] + 1], nArray2[this.faceMap[s2] + 2]);
            this.facePt3.set(nArray2[this.faceMap[s3]], nArray2[this.faceMap[s3] + 1], nArray2[this.faceMap[s3] + 2]);
            if (!((ShapeRenderer)this).isGenerator) {
                ((ShapeRenderer)this).g3d.calcSurfaceShade(this.facePt1, this.facePt2, this.facePt3);
            }
            ((ShapeRenderer)this).g3d.fillTriangle(this.facePt1, ((ShapeRenderer)this).colix, s, this.facePt2, ((ShapeRenderer)this).colix, s2, this.facePt3, ((ShapeRenderer)this).colix, s3);
        }
    }
}

