/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.Enumeration;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple3i;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.shape.Shape;
import org.jmol.shape.ShapeRenderer;
import org.jmol.shapespecial.Ellipsoids;
import org.jmol.util.Logger;
import org.jmol.util.Quadric;

public class EllipsoidsRenderer
extends ShapeRenderer {
    private Ellipsoids ellipsoids;
    private boolean drawDots;
    private boolean drawArcs;
    private boolean drawAxes;
    private boolean drawFill;
    private boolean drawBall;
    private boolean wireframeOnly;
    private int dotCount;
    private int[] coords;
    private Vector3f[] axes;
    private final float[] factoredLengths = new float[3];
    private int diameter;
    private int diameter0;
    private int selectedOctant = -1;
    private Point3i[] selectedPoints = new Point3i[3];
    private int iCutout = -1;
    private Matrix3f mat = new Matrix3f();
    private Matrix3f mTemp = new Matrix3f();
    private Matrix4f mDeriv = new Matrix4f();
    private Matrix3f matScreenToCartesian = new Matrix3f();
    private Matrix3f matScreenToEllipsoid = new Matrix3f();
    private Matrix3f matEllipsoidToScreen = new Matrix3f();
    private double[] coef = new double[10];
    private final Vector3f v1 = new Vector3f();
    private final Vector3f v2 = new Vector3f();
    private final Vector3f v3 = new Vector3f();
    private final Point3f pt1 = new Point3f();
    private final Point3f pt2 = new Point3f();
    private final Point3i s0 = new Point3i();
    private final Point3i s1 = new Point3i();
    private final Point3i s2 = new Point3i();
    private static final float toRadians = (float)Math.PI / 180;
    private static final float[] cossin = new float[36];
    private final Point3i[] screens = new Point3i[32];
    private final Point3f[] points = new Point3f[6];
    private static int[] axisPoints;
    private static int[] octants;
    private int dx;
    private float perspectiveFactor;
    private static final Vector3f[] unitVectors;
    private static final Point3f[] unitAxisPoints;

    public EllipsoidsRenderer() {
        int n;
        for (n = 0; n < this.points.length; ++n) {
            this.points[n] = new Point3f();
        }
        for (n = 0; n < this.screens.length; ++n) {
            this.screens[n] = new Point3i();
        }
    }

    protected void render() {
        Object object;
        this.ellipsoids = (Ellipsoids)this.shape;
        if (this.ellipsoids.mads == null && !this.ellipsoids.haveEllipsoids) {
            return;
        }
        this.wireframeOnly = this.viewer.getWireframeRotation() && this.viewer.getInMotion();
        this.drawAxes = this.viewer.getBooleanProperty("ellipsoidAxes");
        this.drawArcs = this.viewer.getBooleanProperty("ellipsoidArcs");
        this.drawBall = this.viewer.getBooleanProperty("ellipsoidBall") && !this.wireframeOnly;
        this.drawDots = this.viewer.getBooleanProperty("ellipsoidDots") && !this.wireframeOnly;
        this.drawFill = this.viewer.getBooleanProperty("ellipsoidFill") && !this.wireframeOnly;
        this.diameter0 = (int)(((Float)this.viewer.getParameter("ellipsoidAxisDiameter")).floatValue() * 1000.0f);
        if (this.drawBall) {
            this.drawDots = false;
        }
        if (!(this.drawDots || this.drawArcs || this.drawBall)) {
            this.drawAxes = true;
        }
        if (this.drawDots) {
            this.drawArcs = false;
            this.drawFill = false;
        }
        if (this.drawDots) {
            this.dotCount = (Integer)this.viewer.getParameter("ellipsoidDotCount");
            if (this.coords == null || this.coords.length != this.dotCount * 3) {
                this.coords = new int[this.dotCount * 3];
            }
        }
        Matrix4f matrix4f = this.viewer.getMatrixtransform();
        this.mat.setRow(0, matrix4f.m00, matrix4f.m01, matrix4f.m02);
        this.mat.setRow(1, matrix4f.m10, matrix4f.m11, matrix4f.m12);
        this.mat.setRow(2, matrix4f.m20, matrix4f.m21, matrix4f.m22);
        this.matScreenToCartesian.invert(this.mat);
        Atom[] atomArray = this.modelSet.atoms;
        int n = this.modelSet.getAtomCount();
        while (--n >= 0) {
            Object[] objectArray;
            object = atomArray[n];
            if (!object.isShapeVisible(this.myVisibilityFlag) || this.modelSet.isAtomHidden(n) || object.screenZ <= 1 || (objectArray = object.getEllipsoid()) == null) continue;
            this.colix = Shape.getColix((short[])this.ellipsoids.colixes, (int)n, (Atom)object);
            if (!this.g3d.setColix(this.colix)) continue;
            this.render1((Atom)object, objectArray);
        }
        if (this.ellipsoids.haveEllipsoids) {
            Enumeration enumeration = this.ellipsoids.htEllipsoids.elements();
            while (enumeration.hasMoreElements()) {
                object = (Ellipsoids.Ellipsoid)enumeration.nextElement();
                if (!object.visible || !object.isValid) continue;
                this.renderEllipsoid((Ellipsoids.Ellipsoid)object);
            }
        }
        this.coords = null;
    }

    private void render1(Atom atom, Object[] objectArray) {
        this.s0.set(atom.screenX, atom.screenY, atom.screenZ);
        float[] fArray = (float[])objectArray[1];
        boolean bl = true;
        int n = 3;
        while (--n >= 0) {
            this.factoredLengths[n] = fArray[n + 3];
            if (!Float.isNaN(this.factoredLengths[n])) continue;
            bl = false;
        }
        this.axes = (Vector3f[])objectArray[0];
        if (this.axes == null) {
            this.axes = unitVectors;
        }
        this.setMatrices();
        this.setAxes((Point3f)atom, 1.0f);
        if (this.g3d.isClippedXY(this.dx + this.dx, atom.screenX, atom.screenY)) {
            return;
        }
        this.diameter = this.viewer.scaleToScreen(atom.screenZ, this.wireframeOnly ? 1 : this.diameter0);
        if (!bl || this.drawBall) {
            this.renderBall();
            if (!bl) {
                return;
            }
            if (this.drawArcs || this.drawAxes) {
                this.g3d.setColix(this.viewer.getColixBackgroundContrast());
                if (this.drawAxes) {
                    this.renderAxes();
                }
                if (this.drawArcs) {
                    this.renderArcs((Point3f)atom);
                }
                this.g3d.setColix(this.colix);
            }
        } else {
            if (this.drawAxes) {
                this.renderAxes();
            }
            if (this.drawArcs) {
                this.renderArcs((Point3f)atom);
            }
        }
        if (this.drawDots) {
            this.renderDots((Point3f)atom);
        }
    }

    private void setMatrices() {
        Quadric.setEllipsoidMatrix((Vector3f[])this.axes, (float[])this.factoredLengths, (Vector3f)this.v1, (Matrix3f)this.mat);
        this.matScreenToEllipsoid.mul(this.mat, this.matScreenToCartesian);
        this.matEllipsoidToScreen.invert(this.matScreenToEllipsoid);
        this.perspectiveFactor = this.viewer.scaleToPerspective(this.s0.z, 1.0f);
        this.matScreenToEllipsoid.mul(1.0f / this.perspectiveFactor);
    }

    private void setAxes(Point3f point3f, float f) {
        for (int i = 0; i < 6; ++i) {
            int n = axisPoints[i];
            int n2 = Math.abs(n) - 1;
            this.points[i].scaleAdd(f * this.factoredLengths[n2] * (float)(n < 0 ? -1 : 1), (Tuple3f)this.axes[n2], (Tuple3f)point3f);
            this.pt1.set((Tuple3f)unitAxisPoints[i]);
            this.pt1.scale(f);
            this.matEllipsoidToScreen.transform((Tuple3f)this.pt1);
            this.screens[i].set((int)((float)this.s0.x + this.pt1.x * this.perspectiveFactor), (int)((float)this.s0.y + this.pt1.y * this.perspectiveFactor), (int)(this.pt1.z + (float)this.s0.z));
        }
        this.dx = 2 + this.viewer.scaleToScreen(this.s0.z, (int)((double)f * (Float.isNaN(this.factoredLengths[2]) ? 1.0 : (double)this.factoredLengths[2]) * 1000.0));
    }

    private void renderAxes() {
        if (this.drawBall && this.drawFill) {
            this.g3d.fillCylinder((byte)2, this.diameter, this.s0, this.selectedPoints[0]);
            this.g3d.fillCylinder((byte)2, this.diameter, this.s0, this.selectedPoints[1]);
            this.g3d.fillCylinder((byte)2, this.diameter, this.s0, this.selectedPoints[2]);
            return;
        }
        if (Logger.debugging) {
            this.g3d.setColix((short)10);
            this.g3d.fillCylinder((byte)2, this.diameter, this.screens[0], this.screens[1]);
            this.g3d.setColix((short)11);
            this.g3d.fillCylinder((byte)2, this.diameter, this.screens[2], this.screens[3]);
            this.g3d.setColix((short)7);
            this.g3d.fillCylinder((byte)2, this.diameter, this.screens[4], this.screens[5]);
            this.g3d.setColix(this.colix);
        } else {
            this.g3d.fillCylinder((byte)2, this.diameter, this.screens[0], this.screens[1]);
            this.g3d.fillCylinder((byte)2, this.diameter, this.screens[2], this.screens[3]);
            this.g3d.fillCylinder((byte)2, this.diameter, this.screens[4], this.screens[5]);
        }
    }

    private void renderDots(Point3f point3f) {
        int n = 0;
        while (n < this.coords.length) {
            float f;
            float f2 = (float)Math.random();
            float f3 = (float)Math.random();
            if (Float.isNaN(f = (float)Math.sqrt(1.0f - (f2 *= (float)(Math.random() > 0.5 ? -1 : 1)) * f2 - (f3 *= (float)(Math.random() > 0.5 ? -1 : 1)) * f3))) continue;
            f = (float)(Math.random() > 0.5 ? -1 : 1) * f;
            this.pt1.scaleAdd(f2 * this.factoredLengths[0], (Tuple3f)this.axes[0], (Tuple3f)point3f);
            this.pt1.scaleAdd(f3 * this.factoredLengths[1], (Tuple3f)this.axes[1], (Tuple3f)this.pt1);
            this.pt1.scaleAdd(f * this.factoredLengths[2], (Tuple3f)this.axes[2], (Tuple3f)this.pt1);
            this.viewer.transformPoint(this.pt1, this.s1);
            this.coords[n++] = this.s1.x;
            this.coords[n++] = this.s1.y;
            this.coords[n++] = this.s1.z;
        }
        this.g3d.drawPoints(this.dotCount, this.coords);
    }

    private void renderArcs(Point3f point3f) {
        for (int i = 1; i < 8; i += 2) {
            int n = i * 3;
            this.renderArc(point3f, octants[n], octants[n + 1]);
            this.renderArc(point3f, octants[n + 1], octants[n + 2]);
            this.renderArc(point3f, octants[n + 2], octants[n]);
        }
    }

    private void renderArc(Point3f point3f, int n, int n2) {
        this.v1.set((Tuple3f)this.points[n]);
        this.v1.sub((Tuple3f)point3f);
        this.v2.set((Tuple3f)this.points[n2]);
        this.v2.sub((Tuple3f)point3f);
        float f = this.v1.length();
        float f2 = this.v2.length();
        this.v1.normalize();
        this.v2.normalize();
        this.v3.cross(this.v1, this.v2);
        this.pt1.set((Tuple3f)this.points[n]);
        this.s1.set((Tuple3i)this.screens[n]);
        boolean bl = this.drawFill && !this.drawBall;
        short s = ((Shape)this.ellipsoids).g3d.get2SidedNormix(this.v3);
        if (!bl && !this.wireframeOnly) {
            this.screens[6].set((Tuple3i)this.s1);
        }
        int n3 = 0;
        int n4 = 0;
        while (n3 < 18) {
            this.pt2.scaleAdd(cossin[n4] * f, (Tuple3f)this.v1, (Tuple3f)point3f);
            this.pt2.scaleAdd(cossin[n4 + 1] * f2, (Tuple3f)this.v2, (Tuple3f)this.pt2);
            this.viewer.transformPoint(this.pt2, this.s2);
            if (bl) {
                this.g3d.fillTriangle(this.s0, this.colix, s, this.s1, this.colix, s, this.s2, this.colix, s);
            } else if (this.wireframeOnly) {
                this.g3d.fillCylinder((byte)2, this.diameter, this.s1, this.s2);
            } else {
                this.screens[n3 + 7].set((Tuple3i)this.s2);
            }
            this.pt1.set((Tuple3f)this.pt2);
            this.s1.set((Tuple3i)this.s2);
            ++n3;
            n4 += 2;
        }
        if (!bl && !this.wireframeOnly) {
            for (n3 = 0; n3 < 18; ++n3) {
                this.g3d.fillHermite(5, this.diameter, this.diameter, this.diameter, this.screens[n3 == 0 ? n3 + 6 : n3 + 5], this.screens[n3 + 6], this.screens[n3 + 7], this.screens[n3 == 17 ? n3 + 7 : n3 + 8]);
            }
        }
    }

    private void renderEllipsoid(Ellipsoids.Ellipsoid ellipsoid) {
        this.axes = ellipsoid.axes;
        for (int i = 0; i < 3; ++i) {
            this.factoredLengths[i] = ellipsoid.lengths[i];
        }
        this.viewer.transformPoint(ellipsoid.center, this.s0);
        this.setMatrices();
        this.setAxes(ellipsoid.center, 1.0f);
        this.colix = ellipsoid.colix;
        if (!this.g3d.setColix(this.colix)) {
            return;
        }
        this.renderBall();
    }

    private void renderBall() {
        this.setSelectedOctant();
        Quadric.getEquationForQuadricWithCenter((float)this.s0.x, (float)this.s0.y, (float)this.s0.z, (Matrix3f)this.matScreenToEllipsoid, (Vector3f)this.v1, (Matrix3f)this.mTemp, (double[])this.coef, (Matrix4f)this.mDeriv);
        this.g3d.renderEllipsoid(this.s0.x, this.s0.y, this.s0.z, this.dx + this.dx, this.matScreenToEllipsoid, this.coef, this.mDeriv, this.selectedOctant, this.selectedOctant >= 0 ? this.selectedPoints : null);
    }

    private void setSelectedOctant() {
        int n = Integer.MAX_VALUE;
        this.selectedOctant = -1;
        this.iCutout = -1;
        if (this.drawFill) {
            for (int i = 0; i < 8; ++i) {
                int n2 = octants[i * 3];
                int n3 = octants[i * 3 + 1];
                int n4 = octants[i * 3 + 2];
                int n5 = this.screens[n2].z + this.screens[n3].z + this.screens[n4].z;
                if (n5 >= n) continue;
                n = n5;
                this.iCutout = i;
            }
            this.selectedPoints[0] = this.screens[octants[this.iCutout * 3]];
            this.s1.set((Tuple3i)this.selectedPoints[0]);
            this.selectedPoints[1] = this.screens[octants[this.iCutout * 3 + 1]];
            this.s1.add((Tuple3i)this.selectedPoints[1]);
            this.selectedPoints[2] = this.screens[octants[this.iCutout * 3 + 2]];
            this.s1.add((Tuple3i)this.selectedPoints[2]);
            this.s1.scaleAdd(-3, (Tuple3i)this.s0, (Tuple3i)this.s1);
            this.pt1.set((float)this.s1.x, (float)this.s1.y, (float)this.s1.z);
            this.matScreenToEllipsoid.transform((Tuple3f)this.pt1);
            this.selectedOctant = Quadric.getOctant((Point3f)this.pt1);
        }
    }

    static {
        int n = 0;
        for (int i = 5; i <= 90; i += 5) {
            EllipsoidsRenderer.cossin[n++] = (float)Math.cos((float)i * ((float)Math.PI / 180));
            EllipsoidsRenderer.cossin[n++] = (float)Math.sin((float)i * ((float)Math.PI / 180));
        }
        axisPoints = new int[]{-1, 1, -2, 2, -3, 3};
        octants = new int[]{5, 0, 3, 5, 2, 0, 4, 0, 2, 4, 3, 0, 5, 2, 1, 5, 1, 3, 4, 3, 1, 4, 1, 2};
        unitVectors = new Vector3f[]{new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f)};
        unitAxisPoints = new Point3f[]{new Point3f(-1.0f, 0.0f, 0.0f), new Point3f(1.0f, 0.0f, 0.0f), new Point3f(0.0f, -1.0f, 0.0f), new Point3f(0.0f, 1.0f, 0.0f), new Point3f(0.0f, 0.0f, -1.0f), new Point3f(0.0f, 0.0f, 1.0f)};
    }
}

