/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.shape.Mesh;
import org.jmol.shape.MeshCollection;
import org.jmol.shape.Shape;
import org.jmol.shapespecial.DrawMesh;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.Token;

public class Draw
extends MeshCollection {
    DrawMesh[] dmeshes = new DrawMesh[4];
    DrawMesh thisMesh;
    private Point3f[] ptList;
    private Vector3f offset = new Vector3f();
    private int nPoints;
    private int diameter;
    private float width;
    private float newScale;
    private float length;
    private boolean isCurve;
    private boolean isArc;
    private boolean isArrow;
    private boolean isVector;
    private boolean isCircle;
    private boolean isVisible;
    private boolean isPerpendicular;
    private boolean isCylinder;
    private boolean isVertices;
    private boolean isPlane;
    private boolean isReversed;
    private boolean isRotated45;
    private boolean isCrossed;
    private boolean isValid;
    private boolean noHead;
    private int indicatedModelIndex = -1;
    private int[] modelInfo;
    private boolean makePoints;
    private int nidentifiers;
    private int nbitsets;
    private Point4f plane;
    private BitSet bsAllModels;
    private Vector vData;
    private static final int PT_COORD = 1;
    private static final int PT_IDENTIFIER = 2;
    private static final int PT_BITSET = 3;
    private static final int PT_MODEL_INDEX = 4;
    private static final int PT_MODEL_BASED_POINTS = 5;
    private final Vector3f vAB = new Vector3f();
    private final Vector3f vAC = new Vector3f();
    private static final int MAX_OBJECT_CLICK_DISTANCE_SQUARED = 100;
    private DrawMesh pickedMesh = null;
    private int pickedModel;
    private int pickedVertex;
    private final Point3i ptXY = new Point3i();

    public void allocMesh(String string) {
        this.dmeshes = (DrawMesh[])ArrayUtil.ensureLength((Object)this.dmeshes, (int)(this.meshCount + 1));
        this.meshes = this.dmeshes;
        DrawMesh drawMesh = new DrawMesh(string, ((Shape)this).g3d, this.colix);
        this.dmeshes[this.meshCount++] = drawMesh;
        this.thisMesh = drawMesh;
        this.currentMesh = drawMesh;
    }

    void setPropertySuper(String string, Object object, BitSet bitSet) {
        this.currentMesh = this.thisMesh;
        super.setProperty(string, object, bitSet);
        this.thisMesh = (DrawMesh)this.currentMesh;
    }

    public void initShape() {
        super.initShape();
        this.myType = "draw";
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        if (Logger.debugging) {
            Logger.debug((String)("draw " + string + " " + object));
        }
        if ("init" == string) {
            this.colix = (short)5;
            this.newScale = 0.0f;
            this.noHead = false;
            this.isCrossed = false;
            this.isRotated45 = false;
            this.isReversed = false;
            this.isFixed = false;
            this.isCylinder = false;
            this.isCircle = false;
            this.isPlane = false;
            this.isArrow = false;
            this.isArc = false;
            this.isCurve = false;
            this.isVector = false;
            this.isPerpendicular = false;
            this.isVertices = false;
            this.isValid = true;
            this.isVisible = true;
            this.length = Float.MAX_VALUE;
            this.diameter = 0;
            this.width = 0.0f;
            this.indicatedModelIndex = -1;
            this.offset = null;
            this.plane = null;
            this.nbitsets = 0;
            this.nidentifiers = 0;
            this.vData = new Vector();
            this.modelCount = ((Shape)this).viewer.getModelCount();
            this.bsAllModels = null;
            this.setPropertySuper("thisID", "+PREVIOUS_MESH+", null);
            this.setPropertySuper("init", object, bitSet);
            return;
        }
        if ("length" == string) {
            this.length = ((Float)object).floatValue();
            return;
        }
        if ("fixed" == string) {
            this.isFixed = (Boolean)object;
            return;
        }
        if ("modelIndex" == string) {
            this.indicatedModelIndex = (Integer)object;
            if (this.indicatedModelIndex < 0 || this.indicatedModelIndex >= this.modelCount) {
                return;
            }
            Object[] objectArray = new Object[2];
            objectArray[0] = new Integer(4);
            this.modelInfo = new int[]{this.indicatedModelIndex, 0};
            objectArray[1] = this.modelInfo;
            this.vData.add(objectArray);
            return;
        }
        if ("planedef" == string) {
            this.plane = (Point4f)object;
            return;
        }
        if ("perp" == string) {
            this.isPerpendicular = true;
            return;
        }
        if ("cylinder" == string) {
            this.isCylinder = true;
            return;
        }
        if ("plane" == string) {
            this.isPlane = true;
            return;
        }
        if ("curve" == string) {
            this.isCurve = true;
            return;
        }
        if ("arrow" == string) {
            this.isArrow = true;
            return;
        }
        if ("arc" == string) {
            this.isCurve = true;
            this.isArc = true;
            if (this.isArrow) {
                this.isArrow = false;
                this.isVector = true;
            }
            return;
        }
        if ("circle" == string) {
            this.isCircle = true;
            return;
        }
        if ("vector" == string) {
            this.isArrow = true;
            this.isVector = true;
            return;
        }
        if ("vertices" == string) {
            this.isVertices = true;
            return;
        }
        if ("reverse" == string) {
            this.isReversed = true;
            return;
        }
        if ("nohead" == string) {
            this.noHead = true;
            return;
        }
        if ("rotate45" == string) {
            this.isRotated45 = true;
            return;
        }
        if ("crossed" == string) {
            this.isCrossed = true;
            return;
        }
        if ("points" == string) {
            this.newScale = ((Integer)object).floatValue() / 100.0f;
            if (this.newScale == 0.0f) {
                this.newScale = 1.0f;
            }
            return;
        }
        if ("scale" == string) {
            this.newScale = ((Integer)object).floatValue() / 100.0f;
            if (this.newScale == 0.0f) {
                this.newScale = 0.01f;
            }
            if (this.thisMesh != null) {
                Draw.scaleDrawing(this.thisMesh, this.newScale);
                this.thisMesh.initialize(2);
            }
            return;
        }
        if ("diameter" == string) {
            this.diameter = ((Float)object).intValue();
            return;
        }
        if ("width" == string) {
            this.width = ((Float)object).floatValue();
            return;
        }
        if ("identifier" == string) {
            String string2 = (String)object;
            int n = this.getIndexFromName(string2);
            if (n >= 0) {
                this.vData.add(new Object[]{new Integer(2), new int[]{n, this.isReversed ? 1 : 0, this.isVertices ? 1 : 0}});
                this.isVertices = false;
                this.isReversed = false;
                ++this.nidentifiers;
            } else {
                Logger.error((String)("draw identifier " + object + " not found"));
                this.isValid = false;
            }
            return;
        }
        if ("coord" == string) {
            this.vData.add(new Object[]{new Integer(1), object});
            if (this.indicatedModelIndex >= 0) {
                this.modelInfo[1] = this.modelInfo[1] + 1;
            }
            return;
        }
        if ("offset" == string) {
            this.offset = new Vector3f((Tuple3f)((Point3f)object));
            if (this.thisMesh != null) {
                this.thisMesh.offset(this.offset);
            }
            return;
        }
        if ("atomSet" == string) {
            if (BitSetUtil.cardinalityOf((BitSet)((BitSet)object)) == 0) {
                return;
            }
            bitSet = (BitSet)object;
            this.vData.add(new Object[]{new Integer(3), bitSet});
            ++this.nbitsets;
            if (this.isCircle && this.diameter == 0 && this.width == 0.0f) {
                this.width = ((Shape)this).viewer.calcRotationRadius(bitSet) * 2.0f;
            }
            return;
        }
        if ("modelBasedPoints" == string) {
            this.vData.add(new Object[]{new Integer(5), object});
            return;
        }
        if ("set" == string) {
            if (this.thisMesh == null) {
                this.allocMesh(null);
                this.thisMesh.colix = this.colix;
            }
            boolean bl = this.thisMesh.isValid = this.isValid ? this.setDrawing() : false;
            if (this.thisMesh.isValid) {
                if (this.thisMesh.vertexCount > 2 && this.length != Float.MAX_VALUE && this.newScale == 1.0f) {
                    this.newScale = this.length;
                }
                Draw.scaleDrawing(this.thisMesh, this.newScale);
                this.thisMesh.initialize(2);
                Draw.setAxes(this.thisMesh);
                this.thisMesh.title = this.title;
                this.thisMesh.visible = this.isVisible;
            }
            this.nPoints = -1;
            this.vData = null;
            return;
        }
        if ("off" == string) {
            this.isVisible = false;
        }
        if ("translucency" == string) {
            // empty if block
        }
        if (string == "deleteModelAtoms") {
            int n = ((int[])((Object[])object)[2])[0];
            int n2 = this.meshCount;
            while (--n2 >= 0) {
                if (this.meshes[n2] == null) continue;
                if (this.dmeshes[n2].modelFlags != null) {
                    this.dmeshes[n2].deleteAtoms(n);
                    continue;
                }
                if (this.meshes[n2].modelIndex == n) {
                    --this.meshCount;
                    if (this.meshes[n2] == this.currentMesh) {
                        this.thisMesh = null;
                        this.currentMesh = null;
                    }
                    this.dmeshes = (DrawMesh[])ArrayUtil.deleteElements((Object)this.meshes, (int)n2, (int)1);
                    this.meshes = this.dmeshes;
                    continue;
                }
                if (this.meshes[n2].modelIndex <= n) continue;
                --this.meshes[n2].modelIndex;
            }
            return;
        }
        this.setPropertySuper(string, object, bitSet);
    }

    public Object getProperty(String string, int n) {
        if (string == "command") {
            return this.getDrawCommand(this.thisMesh);
        }
        if (string == "vertices") {
            return this.getPath(this.thisMesh);
        }
        if (string == "type") {
            return new Integer(this.thisMesh == null ? 0 : this.thisMesh.drawType);
        }
        if (string.indexOf("getSpinCenter:") == 0) {
            return this.getSpinCenter(string.substring(14), n);
        }
        if (string.indexOf("getSpinAxis:") == 0) {
            return this.getSpinAxis(string.substring(12), n);
        }
        return super.getProperty(string, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Point3f getSpinCenter(String string, int n) {
        int n2;
        String string2;
        int n3 = -1;
        int n4 = string.indexOf("[");
        if (n4 > 0) {
            string2 = string.substring(0, n4);
            int n5 = string.lastIndexOf("]");
            if (n5 < n4) {
                n5 = string.length();
            }
            try {
                n3 = Integer.parseInt(string.substring(n4 + 1, n5)) - 1;
            }
            catch (Exception exception) {}
        } else {
            string2 = string;
            n3 = -1;
        }
        if ((n2 = this.getIndexFromName(string2)) < 0) return null;
        DrawMesh drawMesh = this.dmeshes[n2];
        if (drawMesh.vertices == null) return null;
        if (drawMesh.vertexCount <= n3) {
            return null;
        }
        Point3f point3f = n3 >= 0 ? drawMesh.vertices[n3] : (drawMesh.ptCenters == null || n < 0 ? drawMesh.ptCenter : drawMesh.ptCenters[n]);
        return point3f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Vector3f getSpinAxis(String string, int n) {
        int n2 = this.getIndexFromName(string);
        if (n2 < 0) return null;
        DrawMesh drawMesh = this.dmeshes[n2];
        if (drawMesh.vertices == null) {
            return null;
        }
        Vector3f vector3f = drawMesh.ptCenters == null || n < 0 ? drawMesh.axis : drawMesh.axes[n];
        return vector3f;
    }

    private Object getPath(Mesh mesh) {
        if (mesh == null) {
            return null;
        }
        return mesh.vertices;
    }

    private boolean setDrawing() {
        if (this.thisMesh == null) {
            this.allocMesh(null);
        }
        this.thisMesh.clear("draw");
        int n = this.vData.size();
        if (n == 0) {
            return false;
        }
        if (this.indicatedModelIndex < 0 && (this.isFixed || this.isArrow || this.isCurve || this.isCircle || this.isCylinder || this.modelCount == 1)) {
            this.thisMesh.isFixed = this.isFixed;
            this.thisMesh.modelIndex = ((Shape)this).viewer.getDisplayModelIndex();
            if (this.thisMesh.modelIndex < 0) {
                this.thisMesh.modelIndex = 0;
            }
            if (this.isFixed && !this.isArrow && !this.isCurve && this.modelCount > 1) {
                this.thisMesh.modelIndex = -1;
            }
            this.thisMesh.setPolygonCount(1);
            this.thisMesh.ptCenters = null;
            this.thisMesh.modelFlags = null;
            this.thisMesh.drawTypes = null;
            this.thisMesh.drawVertexCounts = null;
            if (this.setPoints(-1, -1)) {
                this.setPoints(-1, this.nPoints);
            }
            this.setPolygon(0);
        } else {
            this.thisMesh.modelIndex = -1;
            this.thisMesh.setPolygonCount(this.modelCount);
            this.thisMesh.ptCenters = new Point3f[this.modelCount];
            this.thisMesh.modelFlags = new BitSet();
            this.thisMesh.drawTypes = new int[this.modelCount];
            this.thisMesh.drawVertexCounts = new int[this.modelCount];
            this.thisMesh.vertexCount = 0;
            if (this.indicatedModelIndex >= 0) {
                this.setPoints(-1, 0);
                this.thisMesh.drawType = -1;
                this.thisMesh.drawVertexCount = -1;
                this.indicatedModelIndex = -1;
            } else {
                for (int i = 0; i < this.modelCount; ++i) {
                    if (this.setPoints(i, -1)) {
                        this.setPoints(i, this.nPoints);
                        this.setPolygon(i);
                        this.thisMesh.setCenter(i);
                        this.thisMesh.drawTypes[i] = this.thisMesh.drawType;
                        this.thisMesh.drawVertexCounts[i] = this.thisMesh.drawVertexCount;
                        this.thisMesh.drawType = -1;
                        this.thisMesh.drawVertexCount = -1;
                        continue;
                    }
                    this.thisMesh.drawTypes[i] = 0;
                    this.thisMesh.polygonIndexes[i] = new int[0];
                }
            }
        }
        this.thisMesh.diameter = this.diameter;
        this.thisMesh.isVector = this.isVector;
        this.thisMesh.nohead = this.noHead;
        this.thisMesh.width = this.thisMesh.drawType == 5 ? -Math.abs(this.width) : this.width;
        this.thisMesh.setCenter(-1);
        if (this.offset != null) {
            this.thisMesh.offset(this.offset);
        }
        if (this.thisMesh.thisID == null) {
            this.thisMesh.thisID = JmolConstants.getDrawTypeName((int)this.thisMesh.drawType) + ++this.nUnnamed;
        }
        return true;
    }

    private void addPoint(Point3f point3f, int n) {
        boolean bl;
        boolean bl2 = bl = n < 0 || this.bsAllModels.get(n);
        if (this.makePoints) {
            if (!bl) {
                return;
            }
            this.ptList[this.nPoints] = new Point3f(point3f);
            if (point3f.z == Float.MAX_VALUE || point3f.z == -3.4028235E38f) {
                this.thisMesh.haveXyPoints = true;
            }
        } else if (n >= 0) {
            this.bsAllModels.set(n);
        }
        ++this.nPoints;
    }

    private boolean setPoints(int n, int n2) {
        boolean bl = this.makePoints = n2 >= 0;
        if (this.makePoints) {
            this.ptList = new Point3f[Math.max(5, n2)];
            if (this.bsAllModels == null) {
                this.bsAllModels = ((Shape)this).viewer.getVisibleFramesBitSet();
            }
        }
        this.nPoints = 0;
        int n3 = this.vData.size();
        int n4 = 0;
        BitSet bitSet = n < 0 ? null : ((Shape)this).viewer.getModelAtomBitSet(n, false);
        block11: for (int i = 0; i < n3; ++i) {
            Object[] objectArray = (Object[])this.vData.elementAt(i);
            switch ((Integer)objectArray[0]) {
                case 4: {
                    int n5;
                    int[] nArray = (int[])objectArray[1];
                    n4 = nArray[0];
                    this.nPoints = nArray[1];
                    int n6 = Math.max(this.nPoints, 3);
                    int n7 = this.thisMesh.vertexCount;
                    if (this.nPoints <= 0) continue block11;
                    this.thisMesh.polygonIndexes[n4] = new int[n6];
                    int[] nArray2 = this.thisMesh.polygonIndexes[n4];
                    for (n5 = 0; n5 < this.nPoints; ++n5) {
                        objectArray = (Object[])this.vData.elementAt(++i);
                        nArray2[n5] = this.thisMesh.addVertexCopy((Point3f)objectArray[1]);
                    }
                    for (n5 = this.nPoints; n5 < 3; ++n5) {
                        nArray2[n5] = n7 + this.nPoints - 1;
                    }
                    this.thisMesh.drawTypes[n4] = this.thisMesh.drawVertexCounts[n4] = this.nPoints;
                    continue block11;
                }
                case 1: {
                    this.addPoint((Point3f)objectArray[1], this.makePoints ? n : -1);
                    continue block11;
                }
                case 3: {
                    BitSet bitSet2 = BitSetUtil.copy((BitSet)((BitSet)objectArray[1]));
                    if (bitSet != null) {
                        bitSet2.and(bitSet);
                    }
                    if (BitSetUtil.firstSetBit((BitSet)bitSet2) < 0) continue block11;
                    this.addPoint(((Shape)this).viewer.getAtomSetCenter(bitSet2), this.makePoints ? n : -1);
                    continue block11;
                }
                case 2: {
                    boolean bl2;
                    int[] nArray2 = (int[])objectArray[1];
                    DrawMesh drawMesh = this.dmeshes[nArray2[0]];
                    boolean bl3 = nArray2[1] == 1;
                    boolean bl4 = bl2 = nArray2[2] == 1;
                    if (drawMesh.modelIndex > 0 && drawMesh.modelIndex != n) {
                        return false;
                    }
                    if (this.bsAllModels == null) {
                        this.bsAllModels = new BitSet();
                    }
                    if (this.isPlane && !this.isCircle || this.isPerpendicular || bl2) {
                        if (bl3) {
                            if (n < 0 || n >= drawMesh.polygonCount) {
                                int n8 = drawMesh.drawVertexCount;
                                while (--n8 >= 0) {
                                    this.addPoint(drawMesh.vertices[n8], n);
                                }
                                continue block11;
                            }
                            if (drawMesh.polygonIndexes[n] == null) continue block11;
                            int n9 = drawMesh.drawVertexCounts[n];
                            while (--n9 >= 0) {
                                this.addPoint(drawMesh.vertices[drawMesh.polygonIndexes[n][n9]], n);
                            }
                            continue block11;
                        }
                        if (n < 0 || n >= drawMesh.polygonCount) {
                            for (int j = 0; j < drawMesh.drawVertexCount; ++j) {
                                this.addPoint(drawMesh.vertices[j], n);
                            }
                            continue block11;
                        }
                        if (drawMesh.polygonIndexes[n] == null) continue block11;
                        int n10 = drawMesh.drawVertexCounts[n];
                        while (--n10 >= 0) {
                            this.addPoint(drawMesh.vertices[drawMesh.polygonIndexes[n][n10]], n);
                        }
                        continue block11;
                    }
                    if (n < 0 || drawMesh.ptCenters == null || drawMesh.ptCenters[n] == null) {
                        this.addPoint(drawMesh.ptCenter, n);
                        continue block11;
                    }
                    this.addPoint(drawMesh.ptCenters[n], n);
                    continue block11;
                }
                case 5: {
                    BitSet bitSet2;
                    String[] stringArray = (String[])objectArray[1];
                    if (this.bsAllModels == null) {
                        this.bsAllModels = new BitSet();
                    }
                    block18: for (int j = 0; j < stringArray.length; ++j) {
                        Object object;
                        if (n >= 0 && j != n || !((object = Token.unescapePointOrBitsetAsToken((String)stringArray[j])) instanceof Token)) continue;
                        this.bsAllModels.set(j);
                        switch (((Token)object).tok) {
                            case 7: {
                                this.addPoint((Point3f)((Token)object).value, j);
                                continue block18;
                            }
                            case 0x4000007: {
                                bitSet2 = (BitSet)((Token)object).value;
                                if (bitSet != null) {
                                    bitSet2.and(bitSet);
                                }
                                if (BitSetUtil.firstSetBit((BitSet)bitSet2) < 0) continue block18;
                                this.addPoint(((Shape)this).viewer.getAtomSetCenter(bitSet2), j);
                                continue block18;
                            }
                        }
                    }
                    continue block11;
                }
            }
        }
        if (this.makePoints && this.isCrossed && this.nPoints == 4) {
            Point3f point3f = this.ptList[1];
            this.ptList[1] = this.ptList[2];
            this.ptList[2] = point3f;
        }
        return this.nPoints > 0;
    }

    private void setPolygon(int n) {
        int n2;
        int n3 = this.nPoints;
        int n4 = 1;
        if (this.isArc) {
            if (n3 == 4) {
                n4 = 19;
            } else {
                this.isArc = false;
                this.isVector = false;
                this.isCurve = false;
                this.isArrow = true;
            }
        }
        if (this.isCircle) {
            n4 = this.isPlane ? 18 : 16;
        } else if ((this.isCurve || this.isArrow) && n3 >= 2 && !this.isArc) {
            int n5 = n4 = this.isCurve ? 17 : 15;
        }
        if (this.isVector && !this.isArc) {
            if (n3 > 2) {
                n3 = 2;
            } else if (this.plane == null && n3 != 2) {
                this.isVector = false;
            }
        }
        if (this.thisMesh.haveXyPoints) {
            this.isPerpendicular = false;
            if (n3 == 3 && this.isPlane) {
                this.isPlane = false;
            }
            this.length = Float.MAX_VALUE;
            this.thisMesh.diameter = 0;
        } else if (n3 == 2 && this.isVector) {
            this.ptList[1].add((Tuple3f)this.ptList[0]);
        }
        if (n4 == 1) {
            Point3f point3f;
            float f;
            Point3f point3f2 = new Point3f();
            Vector3f vector3f = new Vector3f();
            if (n3 == 1 && this.plane != null) {
                f = Graphics3D.distanceToPlane((Point4f)this.plane, (Point3f)this.ptList[0]);
                this.vAC.set(this.plane.x, this.plane.y, this.plane.z);
                this.vAC.normalize();
                this.vAC.scale(-f);
                this.vAC.add((Tuple3f)this.ptList[0]);
                this.ptList[1] = new Point3f((Tuple3f)this.vAC);
                n3 = -2;
                if (this.isArrow) {
                    n4 = 15;
                }
            } else if (n3 == 3 && this.isPlane && !this.isPerpendicular) {
                point3f = new Point3f(this.ptList[1]);
                point3f.sub((Tuple3f)this.ptList[0]);
                point3f.scale(0.5f);
                this.ptList[3] = new Point3f(this.ptList[2]);
                this.ptList[2].add((Tuple3f)point3f);
                this.ptList[3].sub((Tuple3f)point3f);
                n3 = 4;
            } else if (n3 >= 3 && !this.isPlane && this.isPerpendicular) {
                Graphics3D.calcNormalizedNormal((Point3f)this.ptList[0], (Point3f)this.ptList[1], (Point3f)this.ptList[2], (Vector3f)vector3f, (Vector3f)this.vAB, (Vector3f)this.vAC);
                point3f2 = new Point3f();
                Graphics3D.calcAveragePointN((Point3f[])this.ptList, (int)n3, (Point3f)point3f2);
                f = this.length == Float.MAX_VALUE ? this.ptList[0].distance(point3f2) : this.length;
                vector3f.scale(f);
                this.ptList[0].set((Tuple3f)point3f2);
                this.ptList[1].set((Tuple3f)point3f2);
                this.ptList[1].add((Tuple3f)vector3f);
                n3 = 2;
            } else if (n3 == 2 && this.isPerpendicular) {
                Graphics3D.calcAveragePoint((Point3f)this.ptList[0], (Point3f)this.ptList[1], (Point3f)point3f2);
                float f2 = f = this.length == Float.MAX_VALUE ? this.ptList[0].distance(point3f2) : this.length;
                if (this.isPlane && this.length != Float.MAX_VALUE) {
                    f /= 2.0f;
                }
                if (this.isPlane && this.isRotated45) {
                    f *= 1.4142f;
                }
                ((Shape)this).g3d.calcXYNormalToLine(this.ptList[0], this.ptList[1], vector3f);
                vector3f.scale(f);
                if (this.isPlane) {
                    this.ptList[2] = new Point3f(point3f2);
                    this.ptList[2].sub((Tuple3f)vector3f);
                    point3f = new Point3f(point3f2);
                    point3f.add((Tuple3f)vector3f);
                    Graphics3D.calcNormalizedNormal((Point3f)this.ptList[0], (Point3f)this.ptList[1], (Point3f)this.ptList[2], (Vector3f)vector3f, (Vector3f)this.vAB, (Vector3f)this.vAC);
                    vector3f.scale(f);
                    this.ptList[3] = new Point3f(point3f2);
                    this.ptList[3].add((Tuple3f)vector3f);
                    this.ptList[1].set((Tuple3f)point3f2);
                    this.ptList[1].sub((Tuple3f)vector3f);
                    this.ptList[0].set((Tuple3f)point3f);
                    if (this.isRotated45) {
                        Graphics3D.calcAveragePoint((Point3f)this.ptList[0], (Point3f)this.ptList[1], (Point3f)this.ptList[0]);
                        Graphics3D.calcAveragePoint((Point3f)this.ptList[1], (Point3f)this.ptList[2], (Point3f)this.ptList[1]);
                        Graphics3D.calcAveragePoint((Point3f)this.ptList[2], (Point3f)this.ptList[3], (Point3f)this.ptList[2]);
                        Graphics3D.calcAveragePoint((Point3f)this.ptList[3], (Point3f)point3f, (Point3f)this.ptList[3]);
                    }
                    n3 = 4;
                } else {
                    this.ptList[0].set((Tuple3f)point3f2);
                    this.ptList[1].set((Tuple3f)point3f2);
                    this.ptList[0].sub((Tuple3f)vector3f);
                    this.ptList[1].add((Tuple3f)vector3f);
                }
                if (this.isArrow && n3 != -2) {
                    this.isArrow = false;
                }
            } else if (n3 == 2 && this.length != Float.MAX_VALUE) {
                Graphics3D.calcAveragePoint((Point3f)this.ptList[0], (Point3f)this.ptList[1], (Point3f)point3f2);
                vector3f.set((Tuple3f)this.ptList[1]);
                vector3f.sub((Tuple3f)point3f2);
                vector3f.scale(0.5f / vector3f.length() * this.length);
                this.ptList[0].set((Tuple3f)point3f2);
                this.ptList[1].set((Tuple3f)point3f2);
                this.ptList[0].sub((Tuple3f)vector3f);
                this.ptList[1].add((Tuple3f)vector3f);
            }
            if (n3 > 4) {
                n3 = 4;
            }
            switch (n3) {
                case -2: {
                    n3 = 2;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    n4 = this.isCylinder ? 5 : 2;
                    break;
                }
                default: {
                    n4 = 4;
                }
            }
        }
        this.thisMesh.drawType = n4;
        this.thisMesh.drawVertexCount = n3;
        if (n3 == 0) {
            return;
        }
        int n6 = this.thisMesh.vertexCount;
        for (n2 = 0; n2 < n3; ++n2) {
            this.thisMesh.addVertexCopy(this.ptList[n2]);
        }
        n2 = n3 < 3 ? 3 : n3;
        this.thisMesh.setPolygonCount(n + 1);
        this.thisMesh.polygonIndexes[n] = new int[n2];
        for (int i = 0; i < n2; ++i) {
            this.thisMesh.polygonIndexes[n][i] = n6 + (i < n3 ? i : n3 - 1);
        }
    }

    private static void scaleDrawing(DrawMesh drawMesh, float f) {
        if (f == 0.0f || drawMesh.vertexCount == 0 || drawMesh.scale == f) {
            return;
        }
        float f2 = f / drawMesh.scale;
        drawMesh.scale = f;
        if (drawMesh.haveXyPoints || drawMesh.drawType == 19) {
            return;
        }
        Vector3f vector3f = new Vector3f();
        int n = -1;
        int n2 = 0;
        int n3 = drawMesh.polygonCount;
        while (--n3 >= 0) {
            Point3f point3f;
            Point3f point3f2 = drawMesh.isVector ? drawMesh.vertices[0] : (point3f = drawMesh.ptCenters == null ? drawMesh.ptCenter : drawMesh.ptCenters[n3]);
            if (point3f == null) {
                return;
            }
            if (drawMesh.polygonIndexes[n3] == null) continue;
            n = -1;
            int n4 = drawMesh.polygonIndexes[n3].length;
            while (--n4 >= 0) {
                n2 = drawMesh.polygonIndexes[n3][n4];
                if (n2 == n) continue;
                n = n2;
                vector3f.sub((Tuple3f)drawMesh.vertices[n2], (Tuple3f)point3f);
                vector3f.scale(f2);
                vector3f.add((Tuple3f)point3f);
                drawMesh.vertices[n2].set((Tuple3f)vector3f);
            }
        }
    }

    private static final void setAxes(DrawMesh drawMesh) {
        drawMesh.axis = new Vector3f(0.0f, 0.0f, 0.0f);
        drawMesh.axes = new Vector3f[drawMesh.polygonCount > 0 ? drawMesh.polygonCount : 1];
        if (drawMesh.vertices == null) {
            return;
        }
        int n = 0;
        int n2 = drawMesh.polygonCount;
        while (--n2 >= 0) {
            int[] nArray = drawMesh.polygonIndexes[n2];
            drawMesh.axes[n2] = new Vector3f();
            if (nArray != null && nArray.length != 0) {
                if (drawMesh.drawVertexCount == 2 || drawMesh.drawVertexCount < 0 && drawMesh.drawVertexCounts[n2] == 2) {
                    drawMesh.axes[n2].sub((Tuple3f)drawMesh.vertices[nArray[0]], (Tuple3f)drawMesh.vertices[nArray[1]]);
                    ++n;
                } else {
                    Graphics3D.calcNormalizedNormal((Point3f)drawMesh.vertices[nArray[0]], (Point3f)drawMesh.vertices[nArray[1]], (Point3f)drawMesh.vertices[nArray[2]], (Vector3f)drawMesh.axes[n2], (Vector3f)drawMesh.vAB, (Vector3f)drawMesh.vAC);
                    ++n;
                }
            }
            drawMesh.axis.add((Tuple3f)drawMesh.axes[n2]);
        }
        if (n == 0) {
            return;
        }
        drawMesh.axis.scale(1.0f / (float)n);
    }

    public void setVisibilityFlags(BitSet bitSet) {
        for (int i = 0; i < this.meshCount; ++i) {
            DrawMesh drawMesh = this.dmeshes[i];
            int n = drawMesh.visibilityFlags = drawMesh.isValid && drawMesh.visible ? ((Shape)this).myVisibilityFlag : 0;
            if (drawMesh.modelIndex >= 0 && !bitSet.get(drawMesh.modelIndex)) {
                drawMesh.visibilityFlags = 0;
                continue;
            }
            if (drawMesh.modelFlags == null) continue;
            int n2 = this.modelCount;
            while (--n2 >= 0) {
                drawMesh.modelFlags.set(n2, bitSet.get(n2));
            }
        }
    }

    public Point3f checkObjectClicked(int n, int n2, int n3, BitSet bitSet) {
        boolean bl = ((Shape)this).viewer.getPickingMode() == 4;
        boolean bl2 = ((Shape)this).viewer.getPickingMode() == 5;
        boolean bl3 = ((Shape)this).viewer.getDrawPicking();
        if (!(bl || bl3 || bl2)) {
            return null;
        }
        if (!this.findPickedObject(n, n2, false, bitSet)) {
            return null;
        }
        Point3f point3f = this.pickedMesh.vertices[this.pickedMesh.polygonIndexes[this.pickedModel][this.pickedVertex]];
        if (bl3 && !bl) {
            if (n3 != 0) {
                ((Shape)this).viewer.setStatusAtomPicked(-2, "[\"draw\",\"" + this.pickedMesh.thisID + "\"," + this.pickedModel + "," + this.pickedVertex + "," + point3f.x + "," + point3f.y + "," + point3f.z + "]" + (this.pickedMesh.title == null ? "" : "\"" + this.pickedMesh.title[this.pickedModel] + "\""));
            }
            return point3f;
        }
        if (n3 == 0 || this.pickedMesh.polygonIndexes[this.pickedModel][0] == this.pickedMesh.polygonIndexes[this.pickedModel][1]) {
            return n3 == 0 ? point3f : null;
        }
        if (this.pickedVertex == 0) {
            ((Shape)this).viewer.startSpinningAxis(this.pickedMesh.vertices[this.pickedMesh.polygonIndexes[this.pickedModel][0]], this.pickedMesh.vertices[this.pickedMesh.polygonIndexes[this.pickedModel][1]], (n3 & 1) != 0);
        } else {
            ((Shape)this).viewer.startSpinningAxis(this.pickedMesh.vertices[this.pickedMesh.polygonIndexes[this.pickedModel][1]], this.pickedMesh.vertices[this.pickedMesh.polygonIndexes[this.pickedModel][0]], (n3 & 1) != 0);
        }
        return null;
    }

    public boolean checkObjectHovered(int n, int n2, BitSet bitSet) {
        String string;
        if (!this.findPickedObject(n, n2, false, bitSet)) {
            return false;
        }
        if (((Shape)this).g3d.isDisplayAntialiased()) {
            n <<= 1;
            n2 <<= 1;
        }
        String string2 = string = this.pickedMesh.title == null ? this.pickedMesh.thisID : this.pickedMesh.title[0];
        if (string.length() > 1 && string.charAt(0) == '>') {
            string = string.substring(1);
        }
        ((Shape)this).viewer.hoverOn(n, n2, string);
        return true;
    }

    public synchronized boolean checkObjectDragged(int n, int n2, int n3, int n4, int n5, BitSet bitSet) {
        if (((Shape)this).viewer.getPickingMode() != 4) {
            return false;
        }
        if (!this.findPickedObject(n, n2, true, bitSet)) {
            return false;
        }
        boolean bl = false;
        switch (n5 & 0x1F) {
            case 17: {
                bl = true;
            }
            case 24: {
                this.move2D(this.pickedMesh, this.pickedMesh.polygonIndexes[this.pickedModel], this.pickedVertex, n + n3, n2 + n4, bl);
                this.thisMesh = this.pickedMesh;
                break;
            }
            case 25: {
                return false;
            }
        }
        return true;
    }

    private void move2D(DrawMesh drawMesh, int[] nArray, int n, int n2, int n3, boolean bl) {
        int n4;
        if (nArray == null || nArray.length == 0) {
            return;
        }
        if (((Shape)this).g3d.isAntialiased()) {
            n2 <<= 1;
            n3 <<= 1;
        }
        Point3f point3f = new Point3f();
        Point3f point3f2 = new Point3f(drawMesh.vertices[nArray[n]]);
        Point3f point3f3 = new Point3f();
        Vector3f vector3f = new Vector3f();
        ((Shape)this).viewer.transformPoint(point3f2, point3f);
        point3f.x = n2;
        point3f.y = n3;
        ((Shape)this).viewer.unTransformPoint(point3f, point3f3);
        vector3f.set((Tuple3f)point3f3);
        vector3f.sub((Tuple3f)point3f2);
        int n5 = -1;
        int n6 = n4 = bl ? 0 : n;
        while (n4 < nArray.length) {
            if (bl || n4 == n) {
                int n7 = nArray[n4];
                if (n7 == n5) break;
                drawMesh.vertices[n7].add((Tuple3f)vector3f);
                if (!bl) break;
                n5 = n7;
            }
            ++n4;
        }
        if (drawMesh.ptCenters == null) {
            drawMesh.setCenter(-1);
        } else {
            n4 = drawMesh.ptCenters.length;
            while (--n4 >= 0) {
                drawMesh.setCenter(n4);
            }
        }
        if (Logger.debugging) {
            Logger.debug((String)this.getDrawCommand(drawMesh));
        }
        ((Shape)this).viewer.refresh(0, "draw");
    }

    private boolean findPickedObject(int n, int n2, boolean bl, BitSet bitSet) {
        int n3 = 100;
        if (((Shape)this).g3d.isAntialiased()) {
            n <<= 1;
            n2 <<= 1;
            n3 <<= 1;
        }
        this.pickedModel = 0;
        this.pickedVertex = 0;
        this.pickedMesh = null;
        for (int i = 0; i < this.meshCount; ++i) {
            int n4;
            DrawMesh drawMesh = this.dmeshes[i];
            if (drawMesh.visibilityFlags == 0) continue;
            int n5 = n4 = drawMesh.modelFlags == null ? 1 : this.modelCount;
            while (--n5 >= 0) {
                if (drawMesh.modelFlags != null && !drawMesh.modelFlags.get(n5) || drawMesh.polygonIndexes == null || n5 >= drawMesh.polygonIndexes.length || drawMesh.polygonIndexes[n5] == null) continue;
                int n6 = drawMesh.polygonIndexes[n5].length;
                while (--n6 >= 0) {
                    Point3f point3f = new Point3f();
                    point3f.set((Tuple3f)drawMesh.vertices[drawMesh.polygonIndexes[n5][n6]]);
                    int n7 = this.coordinateInRange(n, n2, point3f, n3);
                    if (n7 < 0) continue;
                    this.pickedMesh = drawMesh;
                    n3 = n7;
                    this.pickedModel = n5;
                    this.pickedVertex = n6;
                }
            }
        }
        return this.pickedMesh != null;
    }

    private int coordinateInRange(int n, int n2, Point3f point3f, int n3) {
        int n4 = n3;
        ((Shape)this).viewer.transformPoint(point3f, this.ptXY);
        n4 = (n - this.ptXY.x) * (n - this.ptXY.x) + (n2 - this.ptXY.y) * (n2 - this.ptXY.y);
        return n4 < n3 ? n4 : -1;
    }

    private String getDrawCommand(DrawMesh drawMesh) {
        if (drawMesh == null) {
            return "no current draw object";
        }
        this.modelCount = ((Shape)this).viewer.getModelCount();
        return this.getDrawCommand(drawMesh, drawMesh.modelIndex);
    }

    private String getDrawCommand(DrawMesh drawMesh, int n) {
        if (drawMesh.drawType == 0 || drawMesh.drawVertexCount == 0 && drawMesh.drawVertexCounts == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!drawMesh.isFixed && n >= 0 && this.modelCount > 1) {
            Shape.appendCmd((StringBuffer)stringBuffer, (String)("frame " + ((Shape)this).viewer.getModelNumberDotted(n)));
        }
        stringBuffer.append("  draw ID ").append(drawMesh.thisID);
        if (drawMesh.isFixed) {
            stringBuffer.append(" fixed");
        }
        if (n < 0) {
            n = 0;
        }
        if (drawMesh.nohead) {
            stringBuffer.append(" hoHead");
        }
        if (drawMesh.width != 0.0f) {
            stringBuffer.append(" diameter ").append(drawMesh.drawType == 5 ? Math.abs(drawMesh.width) : drawMesh.width);
        } else if (drawMesh.diameter > 0) {
            stringBuffer.append(" diameter ").append(drawMesh.diameter);
        }
        int n2 = drawMesh.drawVertexCount > 0 ? drawMesh.drawVertexCount : drawMesh.drawVertexCounts[n >= 0 ? n : 0];
        switch (drawMesh.drawTypes == null ? drawMesh.drawType : drawMesh.drawTypes[n]) {
            case 19: {
                stringBuffer.append(drawMesh.isVector ? " ARROW ARC" : " ARC");
                break;
            }
            case 15: {
                stringBuffer.append(drawMesh.isVector ? " VECTOR" : " ARROW");
                break;
            }
            case 16: {
                stringBuffer.append(" CIRCLE");
                break;
            }
            case 18: {
                stringBuffer.append(" CIRCLE PLANE");
                break;
            }
            case 17: {
                stringBuffer.append(" CURVE");
                break;
            }
            case 5: {
                stringBuffer.append(" CYLINDER");
                break;
            }
            case 1: {
                n2 = 1;
                break;
            }
            case 2: {
                n2 = 2;
            }
        }
        if (drawMesh.modelIndex < 0 && !drawMesh.isFixed) {
            for (int i = 0; i < this.modelCount; ++i) {
                if (!Draw.isPolygonDisplayable(drawMesh, i)) continue;
                if (n2 == 0) {
                    n2 = drawMesh.drawVertexCounts[i];
                }
                stringBuffer.append(" [ " + i);
                stringBuffer.append(Draw.getVertexList(drawMesh, i, n2));
                stringBuffer.append(" ] ");
            }
        } else {
            stringBuffer.append(Draw.getVertexList(drawMesh, n, n2));
        }
        if (drawMesh.title != null) {
            String string = "";
            for (int i = 0; i < drawMesh.title.length; ++i) {
                string = string + "|" + drawMesh.title[i];
            }
            stringBuffer.append(Escape.escape((String)string.substring(1)));
        }
        stringBuffer.append(";\n");
        Shape.appendCmd((StringBuffer)stringBuffer, (String)drawMesh.getState("draw"));
        Shape.appendCmd((StringBuffer)stringBuffer, (String)this.getColorCommand("draw", drawMesh.colix));
        return stringBuffer.toString();
    }

    static boolean isPolygonDisplayable(Mesh mesh, int n) {
        return n < mesh.polygonIndexes.length && mesh.polygonIndexes[n] != null && mesh.polygonIndexes[n].length > 0;
    }

    private static String getVertexList(DrawMesh drawMesh, int n, int n2) {
        String string = "";
        try {
            if (n >= drawMesh.polygonIndexes.length) {
                n = 0;
            }
            boolean bl = drawMesh.isVector && drawMesh.drawType != 19;
            for (int i = 0; i < n2; ++i) {
                Point3f point3f = drawMesh.vertices[drawMesh.polygonIndexes[n][i]];
                if (point3f.z == Float.MAX_VALUE || point3f.z == -3.4028235E38f) {
                    string = string + (i == 0 ? " " : " ,") + "[" + (int)point3f.x + " " + (int)point3f.y + (point3f.z < 0.0f ? " %]" : "]");
                    continue;
                }
                if (bl && i == 1) {
                    Point3f point3f2 = new Point3f(point3f);
                    point3f2.sub((Tuple3f)drawMesh.vertices[drawMesh.polygonIndexes[n][0]]);
                    string = string + " " + Escape.escape((Tuple3f)point3f2);
                    continue;
                }
                string = string + " " + Escape.escape((Tuple3f)point3f);
            }
        }
        catch (Exception exception) {
            Logger.error((String)"Unexpected error in Draw.getVertexList");
        }
        return string;
    }

    public Vector getShapeDetail() {
        Vector vector = new Vector();
        for (int i = 0; i < this.meshCount; ++i) {
            int n;
            Vector vector2;
            DrawMesh drawMesh = this.dmeshes[i];
            if (drawMesh.vertexCount == 0) continue;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("fixed", drawMesh.ptCenters == null ? Boolean.TRUE : Boolean.FALSE);
            hashtable.put("ID", drawMesh.thisID == null ? "<noid>" : drawMesh.thisID);
            hashtable.put("drawType", JmolConstants.getDrawTypeName((int)drawMesh.drawType));
            if (drawMesh.diameter > 0) {
                hashtable.put("diameter", new Integer(drawMesh.diameter));
            }
            if (drawMesh.width != 0.0f) {
                hashtable.put("width", new Float(drawMesh.width));
            }
            hashtable.put("scale", new Float(drawMesh.scale));
            if (drawMesh.drawType == -1) {
                vector2 = new Vector();
                this.modelCount = ((Shape)this).viewer.getModelCount();
                for (n = 0; n < this.modelCount; ++n) {
                    if (drawMesh.ptCenters[n] == null) continue;
                    Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
                    hashtable2.put("modelIndex", new Integer(n));
                    hashtable2.put("command", this.getDrawCommand(drawMesh, n));
                    hashtable2.put("center", drawMesh.ptCenters[n]);
                    int n2 = drawMesh.drawVertexCounts[n];
                    hashtable2.put("vertexCount", new Integer(n2));
                    if (n2 > 1) {
                        hashtable2.put("axis", drawMesh.axes[n]);
                    }
                    Vector<Point3f> vector3 = new Vector<Point3f>();
                    for (int j = 0; j < n2; ++j) {
                        vector3.addElement(drawMesh.vertices[drawMesh.polygonIndexes[n][j]]);
                    }
                    hashtable2.put("vertices", vector3);
                    if (drawMesh.drawTypes[n] == 2) {
                        float f = drawMesh.vertices[drawMesh.polygonIndexes[n][0]].distance(drawMesh.vertices[drawMesh.polygonIndexes[n][1]]);
                        hashtable2.put("length_Ang", new Float(f));
                    }
                    vector2.addElement(hashtable2);
                }
                hashtable.put("models", vector2);
            } else {
                hashtable.put("command", this.getDrawCommand(drawMesh));
                hashtable.put("center", drawMesh.ptCenter);
                if (drawMesh.drawVertexCount > 1) {
                    hashtable.put("axis", drawMesh.axis);
                }
                vector2 = new Vector();
                for (n = 0; n < drawMesh.vertexCount; ++n) {
                    vector2.addElement(drawMesh.vertices[n]);
                }
                hashtable.put("vertices", vector2);
                if (drawMesh.drawType == 2) {
                    hashtable.put("length_Ang", new Float(drawMesh.vertices[0].distance(drawMesh.vertices[1])));
                }
            }
            vector.addElement(hashtable);
        }
        return vector;
    }

    public String getShapeState() {
        StringBuffer stringBuffer = new StringBuffer("\n");
        Shape.appendCmd((StringBuffer)stringBuffer, (String)"draw delete");
        this.modelCount = ((Shape)this).viewer.getModelCount();
        for (int i = 0; i < this.meshCount; ++i) {
            DrawMesh drawMesh = this.dmeshes[i];
            if (drawMesh.vertexCount == 0) continue;
            stringBuffer.append(this.getDrawCommand(drawMesh, drawMesh.modelIndex));
            if (drawMesh.visible) continue;
            stringBuffer.append("draw off;\n");
        }
        return stringBuffer.toString();
    }
}

